/*
 *  Copyright (C) 1998  Mark Hessling <M.Hessling@qut.edu.au>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#else
# include "defines.h"
#endif

#include <stdio.h>

#ifdef HAVE_CTYPE_H
# include <ctype.h>
#endif

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

#ifdef HAVE_STRING_H
# include <string.h>
#endif

#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif

#ifdef HAVE_ASSERT_H
# include <assert.h>
#endif

#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#ifdef HAVE_DIRENT_H
# include <dirent.h>
#endif

#ifdef HAVE_MALLOC_H
# include <malloc.h>
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#define INCL_RXSHV      /* Shared variable support */
#define INCL_RXFUNC     /* External functions support */
#define INCL_RXSYSEXIT  /* System exit routines */

#if defined(OS2)
# include <os2.h>
#endif

#include "rxdef.h"

#define RETBUFLEN 250

#if defined(DYNAMIC)
# define DYNAMIC_LIBRARY 1
#endif

#ifndef TRUE
# define TRUE   1
# define FALSE  0
#endif

/* 
 * Run time modes 
 */
#define MODE_DEBUG      1
#define MODE_VERBOSE    2

#define REXX_FAIL      1

#define RXSTRCAT(dst,dstlen,src,srclen) (memcpy((dst)+(dstlen),(src),(srclen)),(dstlen)+=(srclen),*((dst)+(dstlen))='\0')
#define RXSTRCPY(dst,dstlen,src,srclen) (memcpy((dst),(src),(srclen)),(dstlen)=(srclen),*((dst)+(dstlen))='\0')

#if !defined(max)
# define max(a,b)        (((a) > (b)) ? (a) : (b))
#endif

#if !defined(min)
# define min(a,b)        (((a) < (b)) ? (a) : (b))
#endif

#if !defined(MAX_PATH)
# if defined(NAME_MAX)
#  define MAX_PATH NAME_MAX
# elif defined(MAXNAMLEN)
#  define MAX_PATH MAXNAMLEN
# else
#  define MAX_PATH 255
# endif
#endif

#define RXPACKAGE_MAGIC_NUMBER 78678932

#ifdef USE_REXX6000
typedef USHORT RexxFunctionHandler(PSZ, ULONG, PRXSTRING, PSZ, PRXSTRING) ;
#endif

/*-----------------------------------------------------------------------------
 * Definition of an external function
 *----------------------------------------------------------------------------*/
typedef struct {
   RRFD_ARG0_TYPE      ExternalName;
   RRFE_ARG1_TYPE      EntryPoint; 
   RRFD_ARG2_TYPE      InternalName;
   int                 DllLoad;
} RexxFunction;

extern char *RxPackageName;

/*
 * The following structure contains all "global" data common to all
 * external function packages.  A similar structure should exists
 * for package-specific data.
 */
typedef struct 
{
   int RxRunFlags;                    /* debug/verbose flags */
   char FName[100];                   /* current function name */
   FILE *RxTraceFilePointer;          /* file pointer for all output */
   char RxTraceFileName[MAX_PATH];    /* filename of output file */
   ULONG RxPackageInitialised;        /* needed ?? */
} RxPackageGlobalDataDef;

#ifdef HAVE_PROTO
void FunctionPrologue( char *, ULONG, RXSTRING * );
void InternalFunctionPrologue( char *, ... );
int InitRxPackage( RxPackageGlobalDataDef * );
int TermRxPackage( char *, int );
int InitialisePackage( void );
int TerminatePackage( void );
int RegisterRxFunctions( void );
int QueryRxFunction( char * );
int DeregisterRxFunctions( void );
char *make_upper( char * );
char *AllocString( char *, int );
char *MkAsciz( char *, int, char *, int );
int SetRexxVariable( char *, int, char *, int );
RXSTRING *GetRexxVariable(char *, RXSTRING *, int );
int StrToInt( RXSTRING *, ULONG * );
int StrToBool( RXSTRING *, ULONG * );
int RxSetTraceFile( char * );
char *RxGetTraceFile( void );
void RxSetRunFlags( int );
int RxGetRunFlags( void );
int RxReturn( RXSTRING * );
int RxReturnString( RXSTRING *, char * );
int RxReturnNumber( RXSTRING *, long );
int memcmpi( char *, char *, int );
int my_checkparam(int, int, int);
#else
void FunctionPrologue( );
void InternalFunctionPrologue( );
int InitRxPackage( );
int TermRxPackage( );
int InitialisePackage( );
int TerminatePackage( );
int RegisterRxFunctions( );
int QueryRxFunction( );
int DeregisterRxFunctions( );
char *make_upper ( );
char *AllocString( );
char *MkAsciz( );
int SetRexxVariable( );
RXSTRING *GetRexxVariable( );
int StrToInt( );
int StrToBool( );
int RxSetTraceFile( );
char *RxGetTraceFile( );
void RxSetRunFlags( );
int RxGetRunFlags( );
int RxReturn( );
int RxReturnString( );
int RxReturnNumber( );
int memcmpi( );
int my_checkparam( );
#endif

