dnl ---------------------------------------------------------------------------
dnl Check if C compiler supports -c -o file.ooo
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_CC_O],
[
AC_MSG_CHECKING(whether $CC understand -c and -o together)
set dummy $CC; ac_cc="`echo [$]2 |
changequote(, )dnl
		       sed -e 's/[^a-zA-Z0-9_]/_/g' -e 's/^[0-9]/_/'`"
changequote([, ])dnl
AC_CACHE_VAL(ac_cv_prog_cc_${ac_cc}_c_o,
[echo 'foo(){}' > conftest.c
# We do the test twice because some compilers refuse to overwrite an
# existing .o file with -o, though they will create one.
eval ac_cv_prog_cc_${ac_cc}_c_o=no
ac_try='${CC-cc} -c conftest.c -o conftest.ooo 1>&AC_FD_CC'
if AC_TRY_EVAL(ac_try) && test -f conftest.ooo && AC_TRY_EVAL(ac_try);
then
  ac_try='${CC-cc} -c conftest.c -o conftest.ooo 1>&AC_FD_CC'
  if AC_TRY_EVAL(ac_try) && test -f conftest.ooo && AC_TRY_EVAL(ac_try);
  then
    eval ac_cv_prog_cc_${ac_cc}_c_o=yes
  fi
fi
rm -f conftest*
])dnl
if eval "test \"`echo '$ac_cv_prog_cc_'${ac_cc}_c_o`\" = yes"; then
	O2SHO=""
	O2SAVE=""
	SAVE2O=""
	CC2O="-o $"'@'
	AC_MSG_RESULT(yes)
else
	O2SHO="-mv \`basename "$'@'" .sho\`.o "$'@'
	O2SAVE="-mv \`basename "$'@'" .sho\`.o \`basename "$'@'" .sho\`.o.save"
	SAVE2O="-mv \`basename "$'@'" .sho\`.o.save \`basename "$'@'" .sho\`.o"
	CC2O=""
	AC_MSG_RESULT(no)
fi
])

dnl ---------------------------------------------------------------------------
dnl Work out how to create a dynamically loaded module
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_HOWTO_DYN_LINK],
[
mh_compile='${CC-cc} -c $DYN_COMP conftest.$ac_ext 1>&AC_FD_CC'
cat > conftest.$ac_ext <<EOF
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
int foo()
{
return(0);
}
EOF
if AC_TRY_EVAL(mh_compile) && test -s conftest.o; then
	mh_dyn_link='ld -shared -o conftest.rxlib conftest.o -lc 1>&AC_FD_CC'
	if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.rxlib; then
		LD_RXLIB1="ld -shared"
		RXLIBPRE="lib"
		RXLIBPST=".so"
	else
		mh_dyn_link='ld -G -o conftest.rxlib conftest.o 1>&AC_FD_CC'
		if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.rxlib; then
			LD_RXLIB1="ld -G"
			RXLIBPRE="lib"
			RXLIBPST=".so"
		else
			LD_RXLIB1=""
			RXLIBPRE=""
			RXLIBPST=""
		fi
	fi
fi
rm -f conftest*
])dnl

dnl ---------------------------------------------------------------------------
dnl Work out how to create a shared library
dnl ---------------------------------------------------------------------------
AC_DEFUN(MH_HOWTO_SHARED_LIBRARY,
[
AC_MSG_CHECKING(how to create a shared library)
mh_compile='${CC-cc} -c $DYN_COMP conftest.$ac_ext 1>&AC_FD_CC'
cat > conftest.$ac_ext <<EOF
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
int foo()
{
return(0);
}
EOF
if AC_TRY_EVAL(mh_compile) && test -s conftest.o; then
	mh_dyn_link='ld -shared -o conftest.so.1.0 conftest.o -lc 1>&AC_FD_CC'
	if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
		SHL_LD="ld -shared -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'" -lc"
	else
		mh_dyn_link='ld -G -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
		if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
			SHL_LD="ld -G -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
		else
			mh_dyn_link='ld -o conftest.so.1.0 -shared -no_archive conftest.o  -lc 1>&AC_FD_CC'
			if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
				SHL_LD="ld -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" -shared -no_archive "'$('SHOFILES')'" -lc"
			else
				mh_dyn_link='ld -b -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
				if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
					SHL_LD="ld -b -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
				else
					mh_dyn_link='ld -Bshareable -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
					if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
						SHL_LD="ld -Bshareable -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
					else
						mh_dyn_link='ld -assert pure-text -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
						if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
							SHL_LD="ld -assert pure-text -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
						else
							SHL_LD=""
						fi
					fi
				fi
			fi
		fi
	fi
fi
if test "$SHL_LD" = ""; then
	AC_MSG_RESULT(unknown)
else
	AC_MSG_RESULT(found)
fi
rm -f conftest*
])

dnl ---------------------------------------------------------------------------
dnl Check for presence of various libraries
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_LIB],
[
MH_EXTRA_LIBS=''
for mh_lib in $1; do
	AC_CHECK_LIB($mh_lib,main,mh_lib_found=yes,mh_lib_found=no)
	if test "$mh_lib_found" = yes; then
		MH_EXTRA_LIBS="${MH_EXTRA_LIBS} -l${mh_lib}"
	fi
done
])dnl

dnl ---------------------------------------------------------------------------
dnl Determine how to build shared libraries etc..
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_SHARED_LIBRARY],
[
dnl
dnl If compiler is gcc, then flags should be the same for all platforms
dnl (just guessing on this)
dnl
OSAVE=".o.save"
OBJ="o"
EXE=""
GETOPT=""
STATIC_LDFLAGS=""
AIX_DYN="no"
SHLFILE="$1"

AC_REQUIRE([AC_CANONICAL_SYSTEM])
case "$target" in
	*hp-hpux10*)
		SYS_DEFS="-D_HPUX_SOURCE"
		;;
	*hp-hpux*) 
		SYS_DEFS="-D_HPUX_SOURCE"
		;;
	*ibm-aix4.2*)
		SYS_DEFS="-D_ALL_SOURCE -DAIX"
		AIX_DYN="yes"
		DYN_COMP="-DDYNAMIC"
		;;
	*ibm-aix4.3*)
		SYS_DEFS="-D_ALL_SOURCE -DAIX"
		AIX_DYN="yes"
		DYN_COMP="-DDYNAMIC"
		;;
	*ibm-aix*)
		SYS_DEFS="-D_ALL_SOURCE -DAIX"
		AIX_DYN="yes"
		DYN_COMP="-DDYNAMIC"
		;;
	*dec-osf*)
		SYS_DEFS="-D_POSIX_SOURCE -D_XOPEN_SOURCE -Olimit 800"
		;;
	*sequent-dynix*)
		;;
	*solaris*)
		;;
	*esix*)
		;;
	sparc*sunos*)
		SYS_DEFS="-DSUNOS -DSUNOS_STRTOD_BUG"
		;;
	*linux*)
		SYS_DEFS="-D__USE_BSD"
		;;
esac

dnl
dnl set variables for compiling if we don't already have it
dnl
if test "$DYN_COMP" = ""; then
AC_MSG_CHECKING(compiler flags for a dynamic object)

cat > conftest.$ac_ext <<EOF
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
int a=0
EOF

	DYN_COMP=""
	mh_cv_stop=no
	save_cflags="$CFLAGS"
	mh_cv_flags="-fPIC -KPIC +Z"
	for a in $mh_cv_flags; do
		CFLAGS="-c $a"

		mh_compile='${CC-cc} -c $CFLAGS conftest.$ac_ext > conftest.tmp 2>&1'
		if AC_TRY_EVAL(mh_compile); then
			DYN_COMP=""
		else
			slash="\\"
			mh_dyncomp="`egrep -c $slash$a conftest.tmp`"
			if test "$mh_dyncomp" = "0"; then
				DYN_COMP="$a -DDYNAMIC"
				AC_MSG_RESULT($a)
				break
			else
				DYN_COMP=""
			fi
		fi
	done
	if test "$DYN_COMP" = ""; then
		AC_MSG_RESULT(none of $mh_cv_flags supported)
	fi
	CFLAGS=$save_cflags
	rm -f conftest.*
fi

if test "$with_rexx6000" = yes; then
	mh_entry="-eInitFunc"
else
	mh_entry="-bnoentry"
fi

dnl
dnl set variables for linking
dnl
RXPACKEXPORTS=""
case "$target" in
	*hp-hpux*) 
		EEXTRA="-Wl,-E"
		LD_RXLIB1="ld -b -q -n"
		RXLIBPRE="lib"
		RXLIBPST=".sl"
		;;
#	*ibm-aix4.2*)
#		STATIC_LDFLAGS="-bnso -bI:/lib/syscalls.exp"
#		LD_RXLIB1="ld -G"
#		RXLIBPRE="lib"
#		RXLIBPST=".so"
#		RXPACKEXPORTS="-bE:$SHLFILE.exp"
#		RXPACKEXP="$SHLFILE.exp"
#		;;
	*ibm-aix3*)
		STATIC_LDFLAGS="-bnso -bI:/lib/syscalls.exp"
		LD_RXLIB1="ld $mh_entry -bM:SRE -bT:512 -bH:512 -bI:regina.exp"
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXPACKEXPORTS="-bE:$SHLFILE.exp"
		RXPACKEXP="$SHLFILE.exp"
		;;
	*ibm-aix4*)
		STATIC_LDFLAGS="-bnso -bI:/lib/syscalls.exp"
		LD_RXLIB1="ld $mh_entry -bM:SRE"
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXPACKEXPORTS="-bE:$SHLFILE.exp"
		RXPACKEXP="$SHLFILE.exp"
		;;
	*dec-osf*)
		LD_RXLIB1="ld -shared"
		RXLIBPRE="lib"
		RXLIBPST=".so"
		;;
	*esix*)
		LD_RXLIB1="ld -G"
		DYNAMIC_LDFLAGS=""
		RXLIBPRE="lib"
		RXLIBPST=".so"
		;;
	*dgux*)
		LD_RXLIB1="ld -G"
		DYNAMIC_LDFLAGS=""
		RXLIBPRE="lib"
		RXLIBPST=".so"
		;;
	*solaris*)
		LD_RXLIB1="ld -G"
		DYNAMIC_LDFLAGS=""
		RXLIBPRE="lib"
		RXLIBPST=".so"
		;;
	sparc*sunos*)
		LD_RXLIB1="ld"
		RXLIBPRE="lib"
		RXLIBPST=".so"
		;;
	*freebsd*)
		LD_RXLIB1="ld -Bdynamic -Bshareable"
		RXLIBPRE="lib"
		RXLIBPST=".so"
		;;
	*linux*)
		LD_RXLIB1="ld -shared"
		RXLIBPRE="lib"
		RXLIBPST=".so"
		;;
	*qnx*)
		LD_RXLIB1=""
		RXLIBPRE=""
		RXLIBPST=".lib"
		EEXTRA="-mf -N0x20000 -Q"
		;;
	*)
		MH_HOWTO_DYN_LINK()
		;;
esac

if test "$ac_cv_header_dl_h" = "yes" -o "$ac_cv_header_dlfcn_h" = "yes" -o "$AIX_DYN" = "yes"; then
	if test "$with_regina" = yes -o "$with_orexx" = "yes" -o "$with_rexx6000" = "yes"; then
		SHL_TARGETS="${RXLIBPRE}${SHLFILE}${RXLIBPST}"
	else
		SHL_TARGETS=""
	fi
else
	SHL_TARGETS=""
fi

AC_SUBST(EEXTRA)
AC_SUBST(CEXTRA)
AC_SUBST(OSAVE)
AC_SUBST(OBJ)
AC_SUBST(EXE)
AC_SUBST(GETOPT)
AC_SUBST(DYN_COMP)
AC_SUBST(LIBS)
AC_SUBST(SHLIBS)
AC_SUBST(LD_RXLIB1)
AC_SUBST(RXLIBPRE)
AC_SUBST(RXLIBPST)
AC_SUBST(DYNAMIC_LDFLAGS)
AC_SUBST(STATIC_LDFLAGS)
AC_SUBST(SHL_TARGETS)
AC_SUBST(O2SAVE)
AC_SUBST(O2SHO)
AC_SUBST(CC2O)
AC_SUBST(SAVE2O)
AC_SUBST(RXPACKEXPORTS)
AC_SUBST(RXPACKEXP)
])dnl

dnl ---------------------------------------------------------------------------
dnl Check REXX library and header files
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_REXX],
[
if test "$with_regina" = yes; then
	AC_DEFINE(USE_REGINA)
	rexx_h="rexxsaa.h"
	rexx_l="regina"
	extra_libs=""
else
	if test "$with_rexximc" = yes; then
		AC_DEFINE(USE_REXXIMC)
		rexx_h="rexxsaa.h"
		rexx_l="rexx"
		extra_libs=""
	else
		if test "$with_rexx6000" = yes; then
			AC_DEFINE(USE_REXX6000)
			rexx_h="rexxtype.h"
			rexx_l="rexx"
			extra_libs=""
		else
			if test "$with_orexx" = yes; then
				AC_DEFINE(USE_OREXX)
				rexx_h="rexx.h"
				rexx_l="rexx"
				extra_libs="-lrexxapi -lpthreads"
			else
				if test "$with_unirexx" = yes; then
					AC_DEFINE(USE_UNIREXX)
					rexx_h="rexxsaa.h"
					rexx_l="rx"
					extra_libs=""
				else
					AC_DEFINE(NOREXX)
					AC_MSG_ERROR(No Rexx interpreter specified)
				fi
			fi
		fi
	fi
fi

dnl look for REXX header and library, exit if not found

if test "xx$rexx_h" = "xx" ; then
	MH_REXX_LIB=""
	MH_REXX_INC=""
	AC_SUBST(MH_REXX_INC)
	AC_SUBST(MH_REXX_LIB)
else
dnl look for REXX header and library, exit if not found
	AC_MSG_CHECKING(for location of REXX header file)
	mh_rexx_inc_dir=""
	mh_inc_dirs="\
	    ${HOME}/include           \
	    /usr/local/include        \
	    /usr/contrib/include      \
	    /opt/include              \
	    /usr/include              \
	    /usr/local/orexx          \
	    /usr/unsupported/include"
dnl
dnl Provide for user supplying directory
dnl
	if test "$with_rexxincdir" != no ; then
		mh_inc_dirs="$with_rexxincdir $mh_inc_dirs"
	fi
dnl
dnl Try to determine the directory containing REXX header
dnl
	for ac_dir in $mh_inc_dirs ; do
	  if test -r $ac_dir/$rexx_h; then
	    mh_rexx_inc_dir=$ac_dir
	    break
	  fi
	done
	if test "x$mh_rexx_inc_dir" != "x" ; then
		MH_REXX_INC="-I$mh_rexx_inc_dir"
		AC_MSG_RESULT(found in $mh_rexx_inc_dir)
		AC_SUBST(MH_REXX_INC)
	else
		AC_MSG_ERROR(Cannot find REXX header file: $rexx_h; Rexx/Curses cannot be configured)
	fi
	AC_MSG_CHECKING(for location of REXX library file)
	mh_rexx_lib_dir=""
	mh_lib_dirs="\
	    ${HOME}/lib               \
	    /usr/local/lib            \
	    /usr/contrib/lib          \
	    /opt/lib                  \
	    /usr/lib                  \
	    /usr/local/orexx/lib      \
	    /usr/unsupported/lib"
dnl
dnl Provide for user supplying directory
dnl
	if test "$with_rexxlibdir" != no ; then
		mh_lib_dirs="$with_rexxlibdir $mh_lib_dirs"
	fi
dnl
dnl Try to determine the directory containing REXX library
dnl
	for ac_dir in $mh_lib_dirs ; do
		for mh_ext in lib${rexx_l}.a lib${rexx_l}.so lib${rexx_l}.sl ${rexx_l}.lib ; do
		  if test -r $ac_dir/$mh_ext; then
		     mh_rexx_lib_dir=$ac_dir
		     break 2
		  fi
		done
	done
	if test "x$mh_rexx_lib_dir" != "x" ; then
		MH_REXX_LIB="-L$mh_rexx_lib_dir -l$rexx_l $extra_libs"
		AC_MSG_RESULT(found in $mh_rexx_lib_dir)
		AC_SUBST(MH_REXX_LIB)
	else
		AC_MSG_ERROR(Cannot find REXX library file: $rexx_l; RxSock cannot be configured)
	fi
fi
])dnl

dnl ---------------------------------------------------------------------------
dnl Check curses library and header files
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_CURSES],
[
case "$target" in
	*hpux1*)
			mh_curses_colr=yes
			mh_pre_curses_h_include="stdarg"
		;;
	*aix*4.2*)
			mh_curses_colr=no
			mh_pre_curses_h_include="stdarg"
		;;
	*)
			mh_curses_colr=no
			mh_pre_curses_h_include=""
esac

if test "$with_xcurses" = yes; then
	AC_DEFINE(USE_XCURSES)
	curses_h="xcurses.h"
	curses_l="XCurses"
else
	if test "$with_ncurses" = yes; then
		AC_DEFINE(USE_NCURSES)
		curses_h="ncurses.h"
		curses_l="ncurses"
	else
		if test "$with_extcurses" = yes; then
			AC_DEFINE(USE_EXTCURSES)
			curses_h="cur00.h"
			curses_l="cur"
		else
			if test "$mh_curses_colr" = yes; then
				curses_h="curses.h"
				curses_l="cur_colr"
			else
				curses_h="curses.h"
				curses_l="curses"
			fi
		fi
	fi
fi

dnl look for curses header and library, exit if not found
AC_MSG_CHECKING(for location of $curses_h header file)
mh_curses_inc_dir=""
mh_inc_dirs="\
    ${mh_sysv_incdir}         \
    ${exec_prefix}/include    \
    ${HOME}/include           \
    /usr/local/include        \
    /usr/contrib/include      \
    /usr/include/curses_colr  \
    /opt/include              \
    /usr/include              \
    /usr/ucbinclude           \
    /usr/ucbinc               \
    /usr/unsupported/include"
dnl
dnl Provide for user supplying directory
dnl
if test "$with_cursesincdir" != no ; then
	mh_inc_dirs="$with_cursesincdir $mh_inc_dirs"
fi
dnl
dnl Try to determine the directory containing curses header
dnl
for ac_dir in $mh_inc_dirs ; do
  if test -r $ac_dir/$curses_h; then
    mh_curses_inc_dir=$ac_dir
    break
  fi
done
if test "x$mh_curses_inc_dir" != "x" ; then
	AC_MSG_RESULT(found in $mh_curses_inc_dir)
	MH_CURSES_INC="-I$mh_curses_inc_dir"
dnl
dnl If using gcc under Solaris 2, don't use -I/usr/include
dnl
case "$target" in
	*solaris*)
		if test "$ac_cv_prog_gcc" = yes ; then
			if test "x$mh_curses_inc_dir" = "x/usr/include" ; then
			MH_CURSES_INC=""
			fi
		fi
		;;
esac
	AC_SUBST(MH_CURSES_INC)
else
	AC_MSG_ERROR(Cannot find curses header file: $curses_h; Rexx/Curses cannot be configured)
fi

AC_MSG_CHECKING(for location of $curses_l library file)
mh_curses_lib_dir=""
mh_lib_dirs="\
    ${mh_sysv_libdir}         \
    ${exec_prefix}/lib        \
    ${HOME}/lib               \
    /usr/local/lib            \
    /usr/contrib/lib          \
    /opt/lib                  \
    /usr/lib                  \
    /usr/ccs/lib              \
    /usr/ucblib               \
    /usr/unsupported/lib"
dnl
dnl Provide for user supplying directory
dnl
if test "$with_curseslibdir" != no ; then
	mh_lib_dirs="$with_curseslibdir $mh_lib_dirs"
fi
dnl
dnl Try to determine the directory containing curses library
dnl
for ac_dir in $mh_lib_dirs ; do
	for mh_ext in lib${curses_l}.a lib${curses_l}.so lib${curses_l}.sl; do
	  if test -r $ac_dir/$mh_ext; then
	     mh_curses_lib_dir=$ac_dir
	     break 2
	  fi
	done
done
if test "x$mh_curses_lib_dir" != "x" ; then
	MH_CURSES_LIB="-L$mh_curses_lib_dir -l$curses_l"
	AC_MSG_RESULT(found in $mh_curses_lib_dir)
	AC_SUBST(MH_CURSES_LIB)
else
	AC_MSG_ERROR(Cannot find curses library file: $curses_l; Rexx/Curses cannot be configured)
fi
])dnl

dnl ---------------------------------------------------------------------------
dnl Check for broken SYSVR4 curses implementations
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_BROKEN_SYSVR4_CURSES],
[
AC_MSG_CHECKING(if $curses_l is a broken SYSVR4 curses)
dnl
dnl Known platform is Solaris 2.5+
dnl
case "$target" in
	*solaris2.5*)
		if test "$curses_l" = "curses" ; then
			mh_broken_sysvr4_curses=yes
		else
			mh_broken_sysvr4_curses=no
		fi
		;;
	*solaris2.6*)
		if test "$curses_l" = "curses" ; then
			mh_broken_sysvr4_curses=yes
		else
			mh_broken_sysvr4_curses=no
		fi
		;;
	*)mh_broken_sysvr4_curses=no
esac
if test "$mh_broken_sysvr4_curses" = yes ; then
	AC_DEFINE(HAVE_BROKEN_SYSVR4_CURSES)
fi
AC_MSG_RESULT($mh_broken_sysvr4_curses)
])dnl

dnl ---------------------------------------------------------------------------
dnl Check for where yywrap lives
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_LEX],
[
MHLEXLIB=""
for mh_lib in $1; do
	AC_CHECK_LIB($mh_lib,yywrap,mh_lib_found=yes,mh_lib_found=no)
	if test "$mh_lib_found" = yes; then
		MHLEXLIB="-l$mh_lib"
		break
	fi
done
if test "$MHLEXLIB" = ""; then
	AC_MSG_ERROR(Cannot find a library that contains yywrap; unable to build Rexx/Curses with Regina)
fi
])dnl

dnl ---------------------------------------------------------------------------
dnl Determine if curses library supports various functions
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CURSES_FUNCS],
[
dnl
dnl Ensure that when compiling with XCurses, we have set the
dnl required extern for program name.
dnl
cat > xxxxx.h <<EOF
#ifdef XCURSES
	char *XCursesProgramName="test";
#endif
EOF
dnl
dnl Include before curses.h any include files required. This is
dnl often stdarg.h
dnl
for incfile in $mh_pre_curses_h_include ; do
	echo "#include <$incfile.h>" >> xxxxx.h
done

mh_save_libs="$LIBS"
mh_save_cflags="$CFLAGS"

if test "$curses_l" = "XCurses"; then
	CFLAGS="-DXCURSES $MH_CURSES_INC"
	LIBS="$LIBS $MH_CURSES_LIB $MH_XLIBS"
else
	CFLAGS="$MH_CURSES_INC"
	LIBS="$LIBS $MH_CURSES_LIB"
fi

AC_MSG_CHECKING(for System V curses)
AC_CACHE_VAL(
[mh_cv_sysv_curses],
[
AC_TRY_COMPILE(
[#include "xxxxx.h"]
[#include <$curses_h>],
[long xxx=(long)A_NORMAL],
[mh_cv_sysv_curses=yes],
[mh_cv_sysv_curses=no]
)
])dnl
AC_MSG_RESULT($mh_cv_sysv_curses)
if test "$mh_cv_sysv_curses" = no ; then
	AC_DEFINE(HAVE_BSD_CURSES)
fi

if test "$mh_cv_sysv_curses" = no ; then
	if test "$with_extcurses" = no ; then
		MH_CURSES_LIB="$MH_CURSES_LIB -ltermcap"
		LIBS="$LIBS -ltermcap"
	fi
fi

dnl
dnl If HAVE_BSD_CURSES, define BSD_STANDOUT as one of:
dnl _STANDOUT, __WSTANDOUT or __STANDOUT
dnl
if test "$mh_cv_sysv_curses" = no ; then
	bsd_standouts="_STANDOUT __WSTANDOUT __STANDOUT"
	for sout in $bsd_standouts ; do
AC_TRY_COMPILE(
[#include <$curses_h>],
[int xxx=$sout],
	[mh_bsd_sout=yes],
	[mh_bsd_sout=no]
	)
		if test "$mh_bsd_sout" = yes ; then
			AC_DEFINE_UNQUOTED(BSD_STANDOUT,$sout)
			break 2
		fi
	done
fi

AC_MSG_CHECKING(for wattrset in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_wattrset],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[wattrset(stdscr,0)],
	[mh_cv_func_wattrset=yes],
	[mh_cv_func_wattrset=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_wattrset)
if test "$mh_cv_func_wattrset" = yes ; then
	AC_DEFINE(HAVE_WATTRSET)
fi

AC_MSG_CHECKING(for keyname in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_keyname],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[(void)keyname(0)],
	[mh_cv_func_keyname=yes],
	[mh_cv_func_keyname=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_keyname)
if test "$mh_cv_func_keyname" = yes ; then
	AC_DEFINE(HAVE_KEYNAME)
fi

AC_MSG_CHECKING(for keypad in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_keypad],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[keypad(stdscr,TRUE)],
	[mh_cv_func_keypad=yes],
	[mh_cv_func_keypad=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_keypad)
if test "$mh_cv_func_keypad" = yes ; then
	AC_DEFINE(HAVE_KEYPAD)
fi

AC_MSG_CHECKING(for beep in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_beep],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[beep()],
	[mh_cv_func_beep=yes],
	[mh_cv_func_beep=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_beep)
if test "$mh_cv_func_beep" = yes ; then
	AC_DEFINE(HAVE_BEEP)
fi

AC_MSG_CHECKING(for napms in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_napms],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[napms(10)],
	[mh_cv_func_napms=yes],
	[mh_cv_func_napms=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_napms)
if test "$mh_cv_func_napms" = yes ; then
	AC_DEFINE(HAVE_NAPMS)
fi

AC_MSG_CHECKING(for curs_set in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_curs_set],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[curs_set(0)],
	[mh_cv_func_curs_set=yes],
	[mh_cv_func_curs_set=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_curs_set)
if test "$mh_cv_func_curs_set" = yes ; then
	AC_DEFINE(HAVE_CURS_SET)
fi

AC_MSG_CHECKING(for touchline in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_touchline],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[touchline(stdscr,1,1)],
	[mh_cv_func_touchline=yes],
	[mh_cv_func_touchline=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_touchline)
if test "$mh_cv_func_touchline" = yes ; then
	AC_DEFINE(HAVE_TOUCHLINE)
fi

AC_MSG_CHECKING(for typeahead in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_typeahead],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[typeahead(1)],
	[mh_cv_func_typeahead=yes],
	[mh_cv_func_typeahead=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_typeahead)
if test "$mh_cv_func_typeahead" = yes ; then
	AC_DEFINE(HAVE_TYPEAHEAD)
fi

AC_MSG_CHECKING(for notimeout in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_notimeout],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[notimeout(stdscr,TRUE)],
	[mh_cv_func_notimeout=yes],
	[mh_cv_func_notimeout=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_notimeout)
if test "$mh_cv_func_notimeout" = yes ; then
	AC_DEFINE(HAVE_NOTIMEOUT)
fi

AC_MSG_CHECKING(for nodelay in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_nodelay],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[nodelay(stdscr,TRUE)],
	[mh_cv_func_nodelay=yes],
	[mh_cv_func_nodelay=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_nodelay)
if test "$mh_cv_func_nodelay" = yes ; then
	AC_DEFINE(HAVE_NODELAY)
fi

AC_MSG_CHECKING(for raw in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_raw],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[raw()],
	[mh_cv_func_raw=yes],
	[mh_cv_func_raw=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_raw)
if test "$mh_cv_func_raw" = yes ; then
	AC_DEFINE(HAVE_RAW)
fi

AC_MSG_CHECKING(for cbreak in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_cbreak],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[cbreak()],
	[mh_cv_func_cbreak=yes],
	[mh_cv_func_cbreak=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_cbreak)
if test "$mh_cv_func_cbreak" = yes ; then
	AC_DEFINE(HAVE_CBREAK)
fi

AC_MSG_CHECKING(for nocbreak in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_nocbreak],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[nocbreak()],
	[mh_cv_func_nocbreak=yes],
	[mh_cv_func_nocbreak=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_nocbreak)
if test "$mh_cv_func_nocbreak" = yes ; then
	AC_DEFINE(HAVE_NOCBREAK)
fi

AC_MSG_CHECKING(for wnoutrefresh in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_wnoutrefresh],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[wnoutrefresh(stdscr)],
	[mh_cv_func_wnoutrefresh=yes],
	[mh_cv_func_wnoutrefresh=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_wnoutrefresh)
if test "$mh_cv_func_wnoutrefresh" = yes ; then
	AC_DEFINE(HAVE_WNOUTREFRESH)
fi

AC_MSG_CHECKING(for doupdate in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_doupdate],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[doupdate()],
	[mh_cv_func_doupdate=yes],
	[mh_cv_func_doupdate=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_doupdate)
if test "$mh_cv_func_doupdate" = yes ; then
	AC_DEFINE(HAVE_DOUPDATE)
fi

AC_MSG_CHECKING(for reset_shell_mode in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_reset_shell_mode],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[reset_shell_mode()],
	[mh_cv_func_reset_shell_mode=yes],
	[mh_cv_func_reset_shell_mode=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_reset_shell_mode)
if test "$mh_cv_func_reset_shell_mode" = yes ; then
	AC_DEFINE(HAVE_RESET_SHELL_MODE)
fi

AC_MSG_CHECKING(for reset_prog_mode in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_reset_prog_mode],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[reset_prog_mode()],
	[mh_cv_func_reset_prog_mode=yes],
	[mh_cv_func_reset_prog_mode=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_reset_prog_mode)
if test "$mh_cv_func_reset_prog_mode" = yes ; then
	AC_DEFINE(HAVE_RESET_PROG_MODE)
fi

AC_MSG_CHECKING(for slk_init in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_slk_init],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[slk_init(0)],
	[mh_cv_func_slk_init=yes],
	[mh_cv_func_slk_init=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_slk_init)
if test "$mh_cv_func_slk_init" = yes ; then
	AC_DEFINE(HAVE_SLK_INIT)
fi

AC_MSG_CHECKING(for slk_attrset in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_slk_attrset],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[slk_attrset(0)],
	[mh_cv_func_slk_attrset=yes],
	[mh_cv_func_slk_attrset=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_slk_attrset)
if test "$mh_cv_func_slk_attrset" = yes ; then
	AC_DEFINE(HAVE_SLK_INIT)
fi

AC_MSG_CHECKING(for sb_init in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_sb_init],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[sb_init()],
	[mh_cv_func_sb_init=yes],
	[mh_cv_func_sb_init=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_sb_init)
if test "$mh_cv_func_sb_init" = yes ; then
	AC_DEFINE(HAVE_SB_INIT)
fi

AC_MSG_CHECKING(for resize_term in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_resize_term],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[resize_term(0,0)],
	[mh_cv_func_resize_term=yes],
	[mh_cv_func_resize_term=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_resize_term)
if test "$mh_cv_func_resize_term" = yes ; then
	AC_DEFINE(HAVE_RESIZE_TERM)
fi

AC_MSG_CHECKING(for wvline in $curses_l library)
AC_CACHE_VAL(
[mh_cv_func_wvline],
[
	AC_TRY_LINK(
[#include "xxxxx.h"]
[#include <$curses_h>],
[wvline(stdscr,0,1)],
	[mh_cv_func_wvline=yes],
	[mh_cv_func_wvline=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_wvline)
if test "$mh_cv_func_wvline" = yes ; then
	AC_DEFINE(HAVE_WVLINE)
fi

rm -f xxxxx.h
LIBS="$mh_save_libs"
CFLAGS="$mh_save_cflags"
])dnl

dnl ---------------------------------------------------------------------------
dnl Determine if curses defines "chtype"
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_CHTYPE],
[
mh_save_libs="$LIBS"
mh_save_cflags="$CFLAGS"

cat > xxxxx.h <<EOF
#ifdef XCURSES
	char *XCursesProgramName="test";
#endif
EOF
dnl
dnl Include before curses.h any include files required. This is
dnl often stdarg.h
dnl
for incfile in $mh_pre_curses_h_include ; do
	echo "#include <$incfile.h>" >> xxxxx.h
done

if test "$curses_l" = "xcurses"; then
	CFLAGS="-DXCURSES $MH_CURSES_INC"
	LIBS="$LIBS $MH_CURSES_LIB $MH_XLIBS"
else
	CFLAGS="$MH_CURSES_INC"
	LIBS="$LIBS $MH_CURSES_LIB"
fi

AC_MSG_CHECKING(if $curses_h defines "chtype")
AC_TRY_COMPILE(
[#include "xxxxx.h"]
[#include <$curses_h>],
[chtype xxx],
[mh_have_chtype=yes],
[mh_have_chtype=no;AC_DEFINE(chtype,int)]
)
rm -f xxxxx.h
AC_MSG_RESULT($mh_have_chtype)
LIBS="$mh_save_libs"
CFLAGS="$mh_save_cflags"
])dnl
