/* REXX */
/* -------------------------------------------------------- */
/* Procedure to call Alpha Paging system with message       */
/* Author: John Manus 75777,2144                            */
/* Date  : 09/08/95                                         */
/*                                                          */
/*              * * * * N O T E * * * *                     */
/*                                                          */
/*  * The strings that your pager service sends may not     */
/*    match those that I've used here. Look at the statement*/
/*    starting on line 117 to see if they meet your needs.  */
/*    your needs.                                           */
/*                                                          */
/*  * Modem initialization strings can be found on line 52  */
/*                                                          */
/*              * * * * N O T E * * * *                     */
/*                                                          */
/* -------------------------------------------------------- */

TRACE E

arg Message
call InitDefaults
call ProcessPage
call ClosePort

return



InitDefaults:

   DefaultSpeed       = "1200"
   DefaultCOM         = "COM2"
   DefaultPhone       = "0,0-000-000-0000"    /* Phone For Pager Service */
   DefaultConnectWait = 55                    /* Timeout Value           */
   DefaultPagerID     = "000-0000"            /* Your Pager ID           */


   RetryIfBusy   = 3

   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call sysloadfuncs

   /* Set default ARGS */

   ComPort = DefaultCOM
   Phone = DefaultPhone

   State = STREAM(ComPort,"C","OPEN")
   "@MODE" ComPort":"DefaultSpeed",E,7,1 > NUL"
   StartTime = time('E')

   /* MODEM INITIALIZATION */
   CALL LINEOUT ComPort, "ATZ"
   ReturnStuff = " "
   do until pos("OK",ReturnStuff) <> 0
      ReturnStuff = ReturnStuff||CHARIN(ComPort)
      if ((time('E') - StartTime) > DefaultConnectWait) then do
        CALL LINEOUT ComPort,"ATH"                /* Hang Up */
        State = STREAM(ComPort,"C","CLOSE")
        Say "Sorry, Timeout... OK"
        return
        end
   end

   CALL LINEOUT ComPort, "ATM0L0S11=50"

   ReturnStuff = " "
   do until pos("OK",ReturnStuff) <> 0
      ReturnStuff = ReturnStuff||CHARIN(ComPort)
      if ((time('E') - StartTime) > DefaultConnectWait) then do
        CALL LINEOUT ComPort,"ATH"                /* Hang Up */
        State = STREAM(ComPort,"C","CLOSE")
        Say "Sorry, Timeout... OK"
        return
        end
   end
   ReturnStuff = " "
   /* say "Completed Modem Init" /* debug code */ */
return



ProcessPage:
   say "Message-"message
   ReturnStuff = " "
   CALL LINEOUT ComPort, "ATDT"Phone
   z = 0
   call charout ,"Dialing"
   do until pos("CONNECT",ReturnStuff) <> 0
      ReturnStuff = ReturnStuff||CHARIN(ComPort)
      z = z + 1
      remainder = z // 10
      if remainder = 0
         then do
            call charout ,"."
         end
      if ((time('E') - StartTime) > DefaultConnectWait) then do
        CALL LINEOUT ComPort,"ATH"                /* Hang Up */
        State = STREAM(ComPort,"C","CLOSE")
        Say "Sorry, Timeout... CONNECT"
        return
        end
   end
   say "Connected"

   ReturnStuff = " "
   PosStart = 1
   part1 = 0
   part2 = 0
   part3 = 0
   part4 = 0

   DO until part1 & part2 & part3 & part4
     ReturnStuff = ReturnStuff||CHARIN(ComPort)
     if (pos('BUSY',ReturnStuff) <> 0) then do    /* Check for Busy */
        CALL LINEOUT ComPort,"ATH"                /* Hang Up */
        State = STREAM(ComPort,"C","CLOSE")
        Say "Line Busy, Please Try Again..."
        return
        end

      select
         when pos("ID=",ReturnStuff) <> 0
            then do
               call syssleep 1
               call lineout ComPort,"M"
               part1 = 1
               returnstuff = " "
               /* say "ID=...matched" /* debug code */ */
            end
         when pos("Pager ID, then RETURN.",ReturnStuff) <> 0
            then do
               call syssleep 1
               call lineout ComPort,DefaultPagerID
               part2 = 1
               returnstuff = " "
               /* say "Pager ID...matched" /* debug code */ */
            end
         when pos("Enter the Message, then RETURN.",ReturnStuff) <> 0
            then do
               call syssleep 1
               call lineout ComPort,Message
               part3 = 1
               returnstuff = " "
               /* say "Message...matched" /* debug code */ */
            end
         when pos("Thank You.",ReturnStuff) <> 0
            then do
               call syssleep 1
               part4 = 1
              "@MODE" ComPort":dtr=on > NUL"
               /* say "Thank You...matched" /* debug code */ */
               returnstuff = " "
            end
         otherwise nop
      end
      /* Check for timeout */
      if ((time('E') - StartTime) > DefaultConnectWait) then do
        CALL LINEOUT ComPort,"+++ATH"                /* Hang Up */
        State = STREAM(ComPort,"C","CLOSE")
        Say "Sorry, Timeout..."
        return
        end
   END
return


ClosePort:
   /* TRACE E */
   CALL LINEOUT ComPort,"ATH"             /* Hang Up */
   State = STREAM(ComPort,"C","CLOSE")
   Say "Page Complete!"
return

