/* REXX-PROGRAMM kmpl.CMD      */
   Call RxFuncAdd 'SysLoadFuncs', RexxUtil, 'SysLoadFuncs'
   Call SysLoadFuncs
   Call SysCls


 /* Bei Bettigung der Tasten-Kombination  Strg+C  wird kmpl.CMD beendet.  */
   signal on halt name PgmEnd

 /* Mit den folgenden Zeilen wird, wenn das Verzeichnis, in dem sich diese */
 /* Datei  kmpl.CMD  befindet, im Pfad steht, sichergestellt, da auch die */
 /* Datei  kmpl.INF  bei Fehlern von kmpl.CMD angezeigt werden kann,       */
 /* wenn   kmpl.CMD  nicht aus diesem Verzeichnis aufgerufen wird.         */
   Pfd=SysSearchPath("PATH", "kmpl.cmd")
   lp=LastPos("\", Pfd)
   Pfd=DelStr(Pfd, 1+lp)
   
Anf:  
   call Locate 02,14
   call Charout,"Elementare Rechenoperationen mit zwei komplexen Zahlen"; say
   call Locate 03,15
   call Charout,"mit deren Komponenten "
   call CsrAttrib "High";  call Color "white"; call Charout,"Re1"
   call CsrAttrib "Normal";                    call Charout," und "
   call CsrAttrib "High";  call Color "white"; call Charout,"Im1"
   call CsrAttrib "Normal";                    call Charout," sowie "
   call CsrAttrib "High";  call Color "white"; call Charout,"Re2"
   call CsrAttrib "Normal";                    call Charout," und "
   call CsrAttrib "High";  call Color "white"; call Charout,"Re2"
   call CsrAttrib "Normal";                    call Charout,","
   call Locate 04,03
   call Charout,"sowie Berechnung von Funktionswerten der Ergebnisse"
   call Charout," dieser Rechenoperationen."
   sch=0                          
   
lRe1:  
   call Locate 06,09
   call Charout,"                                                                 "
   call Locate 06,09
   call Charout,"(1) "
   call CsrAttrib "High";                        call Charout,"Re1"
   call CsrAttrib "Normal";                      call Charout," = " 
   Re1=strip(EditStr(54))
   if DataType(Re1, 'N')<>1 then
   do    
     Call Quatsch
     Call Loesch
     Call SysCurState ON
     signal lRe1
   end    
   call Locate 06,19;                                            
   call CsrAttrib "High";                        call Charout,Re1
   call CsrAttrib "Normal"
   if sch==1 then signal sel
   sch=0
   
lIm1:
   call Locate 07,09
   call Charout,"                                                                 "
   call Locate 07,09
   call Charout,"(2) "
   call CsrAttrib "High";                        call Charout,"Im1"
   call CsrAttrib "Normal";                      call Charout," = "
   Im1=strip(EditStr(54))
   if DataType(Im1, 'N')<>1 then
   do    
     Call Quatsch
     Call Loesch
     Call SysCurState ON
     signal lIm1
   end    
   call Locate 07,19;                                            
   call CsrAttrib "High";                        call Charout,Im1
   call CsrAttrib "Normal"
   if sch==1 then Signal sel 
   sch=0 

lRe2:   
   call Locate 09,09
   call Charout,"                                                                 "
   call Locate 09,09
   call Charout,"(3) "             
   call CsrAttrib "High";                        call Charout,"Re2"
   call CsrAttrib "Normal";                      call Charout," = "
   Re2=strip(EditStr(54))
   if DataType(Re2, 'N')<>1 then
   do    
     Call Quatsch
     Call Loesch
     Call SysCurState ON
     signal lRe2
   end 
   call Locate 09,19; 
   call CsrAttrib "High";                        call Charout,Re2
   call CsrAttrib "Normal"
   if sch==1 then signal sel
   sch=0
   
lIm2:   
   call Locate 10,09
   call Charout,"                                                                 "
   call Locate 10,09
   call Charout,"(4) "
   call CsrAttrib "High";                        call Charout,"Im2"
   call CsrAttrib "Normal";                      call Charout," = "
   Im2=strip(EditStr(54))
   if DataType(Im2, 'N')<>1 then
   do    
     Call Quatsch
     Call Loesch
     Call SysCurState ON
     signal lIm2
   end    
   call Locate 10,19; 
   call CsrAttrib "High";                        call Charout,Im2
   call CsrAttrib "Normal"
   if sch==1 then Signal sel 
   sch=0 
        
lop:    
   call Locate 12,09
   call Charout,"                                               "
   call Locate 12,09
   call Charout,"(5) Operator (+,-,*,/ oder # fr ^) : "
   op=EditStr(1)
   
   if op<>"+" & op<>"-" & op<>"*" & op<>"/" & op<>"#" then
   do
     Beep(250, 200)
     Signal lop
   end
   call Locate 12,47
   if op=="#" then op="^"
   call Locate 12,47
   call CsrAttrib "High";   call Color "Cyan";   call Charout,op
   call CsrAttrib "Normal"
   if sch==1 then Signal sel

lnd:
   call Locate 13,09
   call Charout,"                                           "
   call Locate 13,09
   call Charout,"(6) Wieviel Dezimalstellen (ND<=54) : "
   ND=EditStr(2)
   if ND<4 | ND>54 then
   do    
     Beep(250, 200)
     Signal lnd
   end
   call Locate 13,47
   call CsrAttrib "High";   call Color "Cyan";   call Charout,ND
   call CsrAttrib "Normal"
   if sch==1 then Signal sel

   
   Numeric Digits ND+15
   /* Mathematische Konstanten */
   pi=3.1415926535897932384626433832795028841971693993751058209749445923078
   /* ln10 = ln(10) */
   ln10=2.3025850929940456840179914546843642076011014886287729760333279009675
   /*  m10 = 1/ln(10) */
   m10=0.434294481903251827651128918916605082294397005803666566114453783165
   
sel:   
   call Locate 15,04 
   call Charout,"Bei nderungswunsch (1,2,3,4,5,6), sonst nur Eingabetaste " 
   call Locate 15,62 
   call Charout,"  "
   call Locate 15,62 
   ent=EditStr(1)
 
   select 
      when ent=='1' then do; sch=1; Signal lRe1; end
      when ent=='2' then do; sch=1; Signal lIm1; end
      when ent=='3' then do; sch=1; Signal lRe2; end
      when ent=='4' then do; sch=1; Signal lIm2; end
      when ent=='5' then do; sch=1; Signal lop;  end
      when ent=='6' then do; sch=1; Signal lnd;  end
      when ent==' '  then do; sch=1; Signal we1;  end
      otherwise 
      do
        Call SysCurState OFF
        Beep(250, 200)
        Call SysCurState ON
        Signal sel
      end
   end
we1:   
                  
   if op=='+' then
   do
     Re=Re1+Re2; Im=Im1+Im2
     signal Ausdr
   end

   if op=='-' then
   do
     Re=Re1-Re2; Im=Im1-Im2
     signal Ausdr
   end

   if op=='*' then
   do
     Re=Re1*Re2-Im1*Im2; Im=Re1*Im2+Re2*Im1
     signal Ausdr
   end
                               
   if op=='/' then
   do
     nen=Re2**2+Im2**2  
     if nen==0 then
     do   
       call nenNull 
       call Loesch
       Call SysCurState ON
       call SysCls
       signal Anf
     end
     Re=(Re1*Re2+Im1*Im2)/nen
     Im=(Im1*Re2-Re1*Im2)/nen
     signal Ausdr
   end
   
   if op=='^' then
   do
    
     if Re1==0 & Im1==0 & Re2==0 & Im2==0 then call Unbestimmt
     if Re1==0 & Im1==0 then
     do
       Re=0
       Im=0
       signal Ausdr
     end 
                   
     /* Berechnung des Betrages btr1  */
     btr1qdrt=Re1**2+Im1**2
     if btr1qdrt==0 then Signal ueb1  
     if btr1qdrt<=1.0E-10000 && btr1qdrt>=1.0E+10000 then Call Unzul sqrt, btr1qdrt, "238"
     ueb1:
     btr1=0_sqrt(btr1qdrt, ND)
     /* Berechnung des Winkels phi1   */
     if Re1>0 & Im1==0 then 
     do   
       phi1=0
       signal ww1
     end
   
     if Re1<0 & Im1==0 then 
     do   
       phi1=pi
       signal ww1
     end
   
     if Re1==0 & Im1>0 then 
     do   
       phi1=Pi/2
       signal ww1
     end
   
     if Re1==0 & Im1<0 then 
     do   
       phi1=-Pi/2
       signal ww1
     end
   
     if Re1<>0 then
     do
       d=0_arctan(Im1/Re1, ND)
       /* Zuordnung des ArcusTangens-Wertes in den Quadranten */ 
       if Re1>0 & Im1>0 then do; phi1=d;    Signal ww1; end 
       if Re1<0 & Im1>0 then do; phi1=d+pi; Signal ww1; end 
       if Re1<0 & Im1<0 then do; phi1=d-pi; Signal ww1; end 
       if Re1>0 & Im1<0 then do; phi1=d;    Signal ww1; end 
     end
     ww1: 
     if Re1==0 & Im1>0  then phi1=+pi/2
     if Re1==0 & Im1<0  then phi1=-pi/2
     if Re1==0 & Im1==0 then phi1=0

     ln_btr1=0_ln(btr1,ND)
     exp_Re=Re2*ln_btr1-Im2*phi1
     exp_Im=Im2*ln_btr1+Re2*phi1
     if abs(exp_Re)>=9.9E+7 then Call Unzul exp, exp_Re, "283"
     if abs(exp_Im)>=9.9E+7 then Call Unzul exp, exp_Im, "284"
     u =  0_exp(exp_Re,ND)
     Re=u*0_cos(exp_Im,ND)
     Im=u*0_sin(exp_Im,ND)
     signal Ausdr
   end                         
                                                    
Ausdr:
   call Locate 17,04
   call CsrAttrib "High";   call Color "white";  call Charout,"("
   call Color "yellow";                          call Charout,"Re"
   call Color "white";                           call Charout," + i*"
   call Color "yellow";                          call Charout,"Im"
   call Color "white";                           call Charout,")"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "White";  call Charout,"(Re1 + i*Im1)"
   call Color "Cyan";                            call Charout,op 
   call Color "White";                           call Charout,"(Re2 + i*Im2)" 
   call Locate 19,04
   call Color "yellow";                          call Charout,"Re = "
   call Color "Green";                           call Charout,Format(Re,,ND,,0)
   call Locate 20,04
   call Color "yellow";                          call Charout,"Im = "
   call Color "Green";                           call Charout,Format(Im,,ND,,0)
   call CsrAttrib "Normal"
ltne:   
   call Locate 22,69
   call Charout,"           "
   call Locate 22,02
   call Charout,"Sollen mit "
   call CsrAttrib "High";   call Color "white";  call Charout,"("
   call Color "yellow";                          call Charout,"Re"
   call Color "white";                           call Charout," + i*"
   call Color "Yellow";                          call Charout,"Im"
   call Color "white";                           call Charout,")"
   call CsrAttrib "Normal"
   call Charout," als komplexes Argument die (F)unktionswerte von einigen"
   call Locate 23,02
   call Charout,"in diesem Programm implementierten Funktionen berechnet,"
   call Charout," oder (a)ndere Werte"
   call Locate 24,02
   call Charout,"Re1, Im1, Re2, Im2 eingegeben, oder das Programm verlassen werden ? (F,a,v) "
   call Locate 24,78
   call Charout," "
   call Locate 24,78
   tne=EditStr(1)
   
   select 
      when tne==' ' | tne=='f' | tne=='F' then do; Signal mehr; end
      when tne=='v' | tne=='V' then 
                               do
                                 call Locate 24,00
                                 Signal PgmEnd
                               end
      when tne=='a' | tne=='A' then do; Call SysCls; Signal Anf; end
      otherwise
      do
        Call SysCurState OFF
        Beep(250, 200)
        Call SysCurState ON
        Signal ltne
      end
   end
                  
mehr:            
   
   Numeric Digits ND+15
            
andere:
/* A N F A N G   der Berechnung von Betrag  btr  und  Winkel  phi         */
/* derjenigen komplexen Zahl  Re + i*Im, die das Ergebnis der Berechnung  */
/* des ersten Teils dieses Programms ist.                                 */
/* Die Gren  btr  und  phi  werden im zweiten Teil dieses Programms bei */
/* der Berechnung von Funktionswerten einiger Funktionen verwendet.       */  
 
  /* Berechnung des Betrages btr, allgemein */
   btrqdrt=Re**2+Im**2
   if btrqdrt==0 then Signal ueb  
   if btrqdrt<=1.0E-10000 && btrqdrt>=1.0E+10000 then Call Unzul sqrt, btrqdrt, "362"
   ueb:
   btr=0_sqrt(btrqdrt, ND)

  /* Berechnung des Winkels phi,  allgemein */
   if Re>0 & Im==0 then 
   do   
     phi=0
     signal ww
   end

   if Re<0 & Im==0 then 
   do   
     phi=pi
     signal ww
   end

   if Re==0 & Im>0 then 
   do   
     phi=Pi/2
     signal ww
   end

   if Re==0 & Im<0 then 
   do   
     phi=-Pi/2
     signal ww
   end

   if Re<>0 then
   do
     argu=Im/Re
     d=0_arctan(argu, ND)
     /* Zuordnung des ArcusTangens-Wertes in den Quadranten */ 
     if Re>0 & Im>0 then do; phi=d;    Signal ww; end 
     if Re<0 & Im>0 then do; phi=d+pi; Signal ww; end 
     if Re<0 & Im<0 then do; phi=d-pi; Signal ww; end 
     if Re>0 & Im<0 then do; phi=d;    Signal ww; end 
   end
   ww: 
   if Re==0 & Im>0  then phi=+pi/2
   if Re==0 & Im<0  then phi=-pi/2
   if Re==0 & Im==0 then phi=0

/* E N D E   der Berechnung von Betrag  btr  und  Winkel  phi             */
/* derjenigen komplexen Zahl  Re + i*Im, die das Ergebnis der Berechnung  */
/* des ersten Teils dieses Programms ist.                                 */
/* Die Gren  btr  und  phi  werden im zweiten Teil dieses Programms bei */
/* der Berechnung von Funktionswerten einiger Funktionen verwendet.       */  

   call SysCls
   call Locate 02,04
   call CsrAttrib "High";   call Color "Yellow"; call Charout,"Re = "
   call Color "Green";                           call Charout,Format(Re,,ND,,0)
   call Locate 03,04
   call Color "Yellow";                          call Charout,"Im = "
   call Color "Green";                           call Charout,Format(Im,,ND,,0)
   call CsrAttrib "Normal"
   
   call Locate 05,03; call Charout,"(1)  z = Betrag von (Re + i*Im)"
   call Locate 06,03; call Charout,"(2)  z = Winkel von (Re + i*Im)"
   call Locate 07,03; call Charout,"(3)  z = (Re + i*Im)^y"
   call Locate 08,03; call Charout,"(4)  z = exp(Re + i*Im)"
   call Locate 09,03; call Charout,"(5)  z =  b^(Re + i*Im)"
   call Locate 10,03; call Charout,"(6)  z =  ln(Re + i*Im)"
   call Locate 11,03; call Charout,"(7)  z = log(Re + i*Im)"
   call Locate 12,03; call Charout,"(8)  z =               "
   call Locate 13,03; call Charout,"(9)  z =               "
   call Locate 14,02; call Charout,"(10)  z =               "
                     
   call Locate 05,42; call Charout,"(11)  z =  sin(Re + i*Im)"
   call Locate 06,42; call Charout,"(12)  z =  cos(Re + i*Im)"
   call Locate 07,42; call Charout,"(13)  z =  tan(Re + i*Im)"
   call Locate 08,42; call Charout,"(14)  z =  cot(Re + i*Im)"
   call Locate 09,42; call Charout,"(15)  z = sinh(Re + i*Im)"
   call Locate 10,42; call Charout,"(16)  z = cosh(Re + i*Im)"
   call Locate 11,42; call Charout,"(17)  z = tanh(Re + i*Im)"
   call Locate 12,42; call Charout,"(18)  z = coth(Re + i*Im)"
   call Locate 13,42; call Charout,"(19)  z =                "
   call Locate 14,42; call Charout,"(20)  Programm verlassen "
                                              
lfu:                                              
   call Locate 16,72
   call Charout,"  "
   call Locate 16,04
   call Charout,"Welche Funktion soll berechnet werden ? Ziffer (1 bis 20)",
                "eingeben:"
   call Locate 16,72
   fu=EditStr(2)

   select
      when fu='1'  then do; Signal Betrl;  end
      when fu='2'  then do; Signal Winl;   end
      when fu='3'  then do; Signal hochl;  end
      when fu='4'  then do; Signal expl;   end
      when fu='5'  then do; Signal hbhl;   end
      when fu='6'  then do; Signal lnlnl;  end
      when fu='7'  then do; Signal logl;   end
      when fu='8'  then do; Signal lab8;   end
      when fu='9'  then do; Signal lab9;   end
      when fu='10' then do; Signal lab10;  end
      when fu='11' then do; Signal sinl;   end
      when fu='12' then do; Signal cosl;   end
      when fu='13' then do; Signal tanl;   end
      when fu='14' then do; Signal cotl;   end
      when fu='15' then do; Signal sinhl;  end
      when fu='16' then do; Signal coshl;  end
      when fu='17' then do; Signal tanhl;  end
      when fu='18' then do; Signal cothl;  end
      when fu='19' then do; Signal lab19;  end
      when fu='20' then do; Signal PgmEnd; end
      otherwise                               
      do                                      
        Call SysCurState OFF
        Beep(250, 200)
        Call SysCurState ON
        Signal lfu
      end                                     
   end     

Betrl:   
   call SysCls
   call Locate 02,04
   call Charout,"Berechnung des Betrages der komplexen Zahl "
   call Farb "(Re + i*Im)"
   call Locate 04,04
   call CsrAttrib "High";   call Color "yellow"; call Charout,"Re"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Re,,ND,,0)
   call Locate 05,04
   call Color "yellow";                          call Charout,"Im"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Im,,ND,,0)
   call CsrAttrib "Normal"
   call Locate 08,04
   call CsrAttrib "Normal"
   call Charout,"Der Betrag der komplexen Zahl "
   call Locate 10,04
   call Farb "(Re + i*Im)"
   call Locate 12,04
   call Charout,"ist = " 
   call CsrAttrib "High";  call Color "cyan";    call Charout,Format(btr,,ND,,0)
   call Locate 17,04
   call CsrAttrib "Normal"
   call Charout,"========================================================="
   call Locate 19,04
   call Charout,"Soll von der komplexen Zahl " 
   call CsrAttrib "High";                        call Charout,"("
   call Color "yellow";                          call Charout,"Re"
   call Color "white";                           call Charout," + i*"
   call Color "yellow";                          call Charout,"Im" 
   call Color "white";                           call Charout,")"
   call CsrAttrib "Normal";                      call Charout," mit den Komponenten" 
   call Locate 21,04
   call CsrAttrib "High";   call Color "yellow"; call Charout,"Re"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Re,,ND,,0)
   call Locate 22,04
   call Color "yellow";                          call Charout,"Im"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Im,,ND,,0)
   call CsrAttrib "Normal"
   call Auswahl
   signal PgmEnd
  
Winl:   
   call SysCls
   call Locate 02,04
   call Charout,"Berechnung des Winkels der komplexen Zahl "
   call Farb "(Re + i*Im)"
   call Locate 04,04
   call CsrAttrib "High";   call Color "yellow"; call Charout,"Re"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Re,,ND,,0)
   call Locate 05,04
   call Color "yellow";                          call Charout,"Im"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Im,,ND,,0)
   call CsrAttrib "Normal"
   call Locate 08,04
   call Charout,"Der Winkel "
   call CsrAttrib "High";  call Color "cyan";    call Charout,""
   call CsrAttrib "Normal"  
   call Charout," der komplexen Zahl ";          call Farb "(Re + i*Im)"
   call Charout,","
   call Locate 10,04
   call Charout,"gemessen im Bogenma, ist"
   call Locate 12,04
   call CsrAttrib "High";  call Color "cyan";    call Charout,""
   call CsrAttrib "Normal"  
   call Charout," = "
   call CsrAttrib "High";  call Color "cyan";    call Charout,Format(phi,,ND,,0)
   call Locate 17,04
   call CsrAttrib "Normal"
   call Charout,"========================================================="
   call Locate 19,04
   call Charout,"Soll von der komplexen Zahl " 
   call CsrAttrib "High";                        call Charout,"("
   call Color "yellow";                          call Charout,"Re"
   call Color "white";                           call Charout," + i*"
   call Color "yellow";                          call Charout,"Im" 
   call Color "white";                           call Charout,")"
   call CsrAttrib "Normal";                      call Charout," mit den Komponenten" 
   call Locate 21,04
   call CsrAttrib "High";   call Color "yellow"; call Charout,"Re"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Re,,ND,,0)
   call Locate 22,04
   call Color "yellow";                          call Charout,"Im"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Im,,ND,,0)
   call CsrAttrib "Normal"
   
   call Auswahl
   signal PgmEnd

hochl:
   call SysCls
   call Locate 02,04
   call Charout,"Berechnung der Funktion "
   call Farb "(Re + i*Im)^(y)"
   call Locate 04,04
   call CsrAttrib "High";   call Color "yellow"; call Charout,"Re"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Re,,ND,,0)
   call Locate 05,04
   call Color "yellow";                          call Charout,"Im"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Im,,ND,,0)
   call CsrAttrib "Normal"
neuExp:   
   Call SysCurState ON
   call Locate 06,04
   call Charout,"Exponent  y  : "; yy=EditStr(60)                            
   call Charout,copies(" ",length(yy))
   /* Der folgende Befehl verhindert das Herumtanzen des Corsors */
   /* nach der Eingabe von yy=EditStr(60).       Stelle q30      */
   Call SysCurState OFF
   signal on syntax name NVMsg1 
   st="y="strip(yy)
   interpret st
   if DataType(y, 'N')<>1 then
   do
     call Quatsch
     call Loesch 
     Call SysCurState ON
     signal neuexp
   end
  
  /* Berechnung des Betrages */
   if btr==0 & y==0 then Call Unbestimmt 
   if btr==0 then
   do
     Re3Erg=0
     Im3Erg=0
     signal we3
   end
   
   uu=y*0_ln(btr,ND)
   if    abs(uu)>=9.9E+7 then Call Unzul exp, uu,    "621"
   if abs(y*phi)>=9.9E+7 then Call Unzul exp, y*phi, "622"
       u=0_exp(uu,ND) 
  /* Berechnung der Winkelfunktionen */
   Recos=0_cos(y*phi,ND)
   IMsin=0_sin(y*phi,ND)
  /* Berechnung der Komponenten */
   Re3Erg=u*Recos   
   Im3Erg=u*Imsin   
   we3:
   /* Der folgende Befehl ist wichtig, um den Corsor wieder einzuschalten, */
   /* nachdem er an der Stelle  q30  ausgeschaltet wurde.                  */
   Call SysCurState ON
   call Ergebnis "(Re + i*Im)^("strip(yy)")", Re3Erg, Im3Erg, ND 
   call Auswahl
   signal PgmEnd
                                
expl:
  /* Berechnung des Betrages */
   if abs(Re)>=9.9E+7 then Call Unzul exp, Re, "640"
   if abs(Im)>=9.9E+7 then Call Unzul exp, Im, "641"
       u=0_exp(Re,ND)
  /* Berechnung der Winkelfunktionen */
   Recos=0_cos(Im,ND)
   IMsin=0_sin(Im,ND)
  /* Berechnung von Real- und Imaginrteil */
   Re4Erg=u*Recos  
   Im4Erg=u*Imsin  
  
   call VorAnz   "exp(Re + i*Im)", Re,     Im,     ND  
   call Ergebnis "exp(Re + i*Im)", Re4Erg, Im4Erg, ND 
   call Auswahl
   signal PgmEnd
  
hbhl:
   call SysCls
   call Locate 02,04;                            
   call Charout,"Berechnung der Funktion "
   call Farb "b^(Re + i*Im)"
   call Locate 04,04
   call CsrAttrib "High";   call Color "yellow"; call Charout,"Re"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Re,,ND,,0)
   call Locate 05,04
   call Color "yellow";                          call Charout,"Im"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Im,,ND,,0)
   call CsrAttrib "Normal"
neuhbhl:   
   Call SysCurState ON
   call Locate 06,04
   call Charout,"                                                        "
   call Locate 06,04
   call Charout,"Basis  b  : "; bb=EditStr(60)
   call Charout,copies(" ",length(bb))
   /* Der folgende Befehl verhindert das Herumtanzen des Corsors */
   /* nach der Eingabe von bb=EditStr(60).       Stelle q50      */
   Call SysCurState OFF
   signal on syntax name NVMsg2 
   st="b="bb
   interpret st
   if DataType(b, 'N')<>1 then
   do
     call Quatsch
     call Loesch 
     Call SysCurState ON
     signal neuhbhl
   end 
  
   if b>0 then
   do
     ReRe=Re*0_ln(b,ND)
     ImIm=Im*0_ln(b,ND)
     signal w51
   end
   
   if b<0 then
   do
     b=abs(b)
     ReRe=Re*0_ln(b,ND)-Im*pi
     ImIm=Re*pi +Im*0_ln(b,ND)
     signal w51
   end
   
   if b==0 then
   do
     Re5Erg=0
     Im5Erg=0
     signal w52
   end
              
w51:                   
  /* Berechnung des Betrages */
   if abs(ReRe)>=9.9E+7 then Call Unzul exp, ReRe, "714"
   if abs(ImIm)>=9.9E+7 then Call Unzul exp, ImIm, "715"
       u=0_exp(ReRe,ND)
  /* Berechnung der Winkelfunktionen */
   Recos=0_cos(ImIm,ND)
   IMsin=0_sin(ImIm,ND)
  /* Berechnung von Real- und Imaginrteil */
   Re5Erg=u*Recos   
   Im5Erg=u*Imsin   
w52:      
   /* Der folgende Befehl ist wichtig, um den Corsor wieder einzuschalten, */
   /* nachdem er an der Stelle  q50  ausgeschaltet wurde.                  */
   Call SysCurState ON
   call Ergebnis "("strip(bb)")^(Re + i*Im)", Re5Erg, Im5Erg, ND 
   call Auswahl
   signal PgmEnd
   
lnlnl:
  /* Berechnung des Betrages */
   u=0_ln(btr, ND)
  /* Berechnung der Komponenten */
   Re6Erg=u   
   Im6Erg=phi   
  
   call VorAnz   "ln(Re + i*Im)", Re,     Im,     ND  
   call Ergebnis "ln(Re + i*Im)", Re6Erg, Im6Erg, ND 
   call Auswahl
   signal PgmEnd
   
logl:
  /* Berechnung des Betrages */
   u=0_ln(btr, ND)
  /* Berechnung der Komponenten */
   Re7Erg=u*m10   
   Im7Erg=phi*m10   
  
   call VorAnz   "log(Re + i*Im)", Re,     Im,     ND  
   call Ergebnis "log(Re + i*Im)", Re7Erg, Im7Erg, ND 
   call Auswahl
   signal PgmEnd
   
lab8:   
   call NochNicht
   call Loesch
   signal lfu
   
lab9:     
   call NochNicht
   call Loesch
   signal lfu
     
lab10:     
   call NochNicht
   call Loesch
   signal lfu
     
sinl:                                              
  /* Berechnung der Komponenten */
   Re11Erg=0_sin(Re,ND)*0_cosh(Im,ND)   
   Im11Erg=0_cos(Re,ND)*0_sinh(Im,ND)   
  
   call VorAnz   "sin(Re + i*Im)", Re,      Im,      ND  
   call Ergebnis "sin(Re + i*Im)", Re11Erg, Im11Erg, ND 
   call Auswahl
   signal PgmEnd
   
cosl:   
  /* Berechnung der Komponenten */
   Re12Erg=+0_cos(Re,ND)*0_cosh(Im,ND)   
   Im12Erg=-0_sin(Re,ND)*0_sinh(Im,ND)   
  
   call VorAnz   "cos(Re + i*Im)", Re,      Im,      ND  
   call Ergebnis "cos(Re + i*Im)", Re12Erg, Im12Erg, ND 
   call Auswahl
   signal PgmEnd
       
tanl:                
  /* Berechnung der Komponenten */
   Nen13=0_cos(2*Re,ND)+0_cosh(2*Im,ND)
   if Nen13==0 then
   do   
     call nenNull
     call Loesch
     Call SysCurState ON
     call SysCls
     signal Anf
   end
   Re13Erg=0_sin(2*Re,ND)/Nen13   
   Im13Erg=0_sinh(2*Im,ND)/Nen13   
  
   call VorAnz   "tan(Re + i*Im)", Re,      Im,      ND  
   call Ergebnis "tan(Re + i*Im)", Re13Erg, Im13Erg, ND 
   call Auswahl
   signal PgmEnd

cotl:
  /* Berechnung der Komponenten */
   Nen14=0_cosh(2*Im,ND)-0_cos(2*Re,ND)
   if Nen14==0 then
   do   
     call nenNull
     call Loesch
     Call SysCurState ON
     call SysCls
     signal Anf
   end
   Re14Erg=+0_sin(2*Re,ND)/Nen14   
   Im14Erg=-0_sinh(2*Im,ND)/Nen14   
  
   call VorAnz   "cot(Re + i*Im)", Re,      Im,      ND  
   call Ergebnis "cot(Re + i*Im)", Re14Erg, Im14Erg, ND 
   call Auswahl
   signal PgmEnd
   
sinhl:
  /* Berechnung der Komponenten */
   Re15Erg=0_sinh(Re,ND)*0_cos(Im,ND) 
   Im15Erg=0_cosh(Re,ND)*0_sin(Im,ND)   
  
   call VorAnz   "sinh(Re + i*Im)", Re,      Im,      ND  
   call Ergebnis "sinh(Re + i*Im)", Re15Erg, Im15Erg, ND 
   call Auswahl
   signal PgmEnd
                                        
coshl:                
  /* Berechnung der Komponenten */
   Re16Erg=0_cosh(Re,ND)*0_cos(Im,ND)   
   Im16Erg=0_sinh(Re,ND)*0_sin(Im,ND)   
  
   call VorAnz   "cosh(Re + i*Im)", Re,      Im,      ND  
   call Ergebnis "cosh(Re + i*Im)", Re16Erg, Im16Erg, ND 
   call Auswahl
   signal PgmEnd
   
tanhl:                
  /* Berechnung der Komponenten */
   Nen17=0_cosh(2*Re,ND)+0_cos(2*Im,ND)
   if Nen17==0 then
   do   
     call nenNull
     call Loesch
     Call SysCurState ON
     call SysCls
     signal Anf
   end
   Re17Erg=0_sinh(2*Re,ND)/Nen17   
   Im17Erg=0_sin(2*Im,ND)/Nen17   
  
   call VorAnz   "tanh(Re + i*Im)", Re,      Im,      ND  
   call Ergebnis "tanh(Re + i*Im)", Re17Erg, Im17Erg, ND 
   call Auswahl
   signal PgmEnd
   
cothl:      
  /* Berechnung der Komponenten */
   Nen18=0_cosh(2*Re,ND)-0_cos(2*Im,ND)
   if Nen18==0 then
   do   
     call nenNull
     call Loesch
     Call SysCurState ON
     call SysCls
     signal Anf
   end
   Re18Erg=+0_sinh(2*Re,ND)/Nen18   
   Im18Erg=-0_sin(2*Im,ND)/Nen18   
  
   call VorAnz   "coth(Re + i*Im)", Re,      Im,      ND  
   call Ergebnis "coth(Re + i*Im)", Re18Erg, Im18Erg, ND 
   call Auswahl
   signal PgmEnd
      
lab19:      
   call NochNicht
   call Loesch                                      
   signal lfu
      
PgmEnd:
   Call CsrAttrib "Normal"
   call SysCls
EXIT

/******************* Eigene Prozeduren und Funktionen **********************/

  
EditStr:
  Procedure
  /* ImGegensatz zur ANSI-Prozedur "call Locate y,x", deren Variable */
  /* y fr Zeile und x fr Spalte mit 1 beginnen, beginnen die       */
  /* Variablen fr Zeile und Spalte der Funktion                     */
  /* "parse value SysCurPos with Zeile Spalte" mit dem Wert 0  !!!!  */
  "@ echo off"
  /* Ausgangs-Koordinaten PosY und PosX ermitteln */
  anf="47"; bckspc="08"; ende="4F";   enter="0D"; entf="53" 
  esc="1B"; links="4B";  rechts="4D"; tab="09"
  parse value SysCurPos() with PosY PosX

  parse arg l

AnfEditStr:
  call SysCurPos PosY, PosX
  if l>=0 then call Charout,copies(" ",l)
  call SysCurPos PosY, PosX
  done=0; k=1; i=1; si=""
  k0=0
  do while done<>1
    
    /* Einlese-Befehl */
    ch=SysGetKey("noecho")

    /* Eingabetaste schliet die Eingabe ab. */
    if c2x(ch)==enter then done=1

    /* Escapetaste leert das Eingabefeld. */
    if c2x(ch)==esc & l>0 then Signal AnfEditStr

    /* Sondertasten, deren Tastencode zwei Symbole zurckliefert. */
    if c2x(ch)=="00" | c2x(ch)=="E0" then
    do
      /* andere Variable hc unbedingt erforderlich ! */
      hc=SysGetKey("noecho") 
      /* 1. Cursor nach links */
      if c2x(hc)==links & k>1 then
      do
        call SysCurPos PosY, PosX+k-2
        hc=""; ch=""
        k=k-1
      end
      /* 2. Cursor nach rechts */
      if c2x(hc)==rechts & k<l then
      do
        call SysCurPos PosY, PosX+k
        hc=""; ch=""
        k=k+1
      end
      /* 3. Cursor an den Anfang */
      if c2x(hc)==anf & k<=l+1 then
      do
        call SysCurPos PosY, PosX
        hc=""; ch=""
        k=1
      end
      /* 4. Cursor an das Ende */
      if c2x(hc)==ende & k<=l then
      do
        call SysCurPos PosY, PosX+l
        hc=""; ch=""
        k=l+1
      end
      /* 5. Entf-Taste einrichten */
      if c2x(hc)==entf & k<=l+1 then
      do
        call SysCurPos PosY, PosX
        call Charout,copies(" ",l)
        call SysCurPos PosY, PosX
        sa=DelStr(si, k)
        se=SubStr(si, k+1)
        call Charout,sa||se
        call SysCurPos PosY, PosX+k-1
      end
      /* 6. Fast alle Sondertasten werden ignoriert.     */
      k=k-1
      ch=""; hc="" 
    end /* Sondertasten, deren Tastencode zwei Symbole zurckliefert. */

    /* Tabtaste wird ignoriert */
    if c2x(ch)==tab then
    do
      ch=""
      k=k-1
    end

    /* Backspace-Taste einrichten. */
    if c2x(ch)==bckspc & k>1 then
    do
      lsi=Length(strip(si))
      lsik=lsi-k                     
        call SysCurPos PosY, PosX
        call Charout,copies(" ",l)
        call SysCurPos PosY, PosX    
        sil=Left(strip(si),k-2)
        sir=Right(strip(si),lsi-k+1)
        si=strip(sil||sir) 
        call Charout,si
        call SysCurPos PosY, PosX+k-2 
        k=k-1
    end

    /* Es werden nur erlaubte Zeichen eingelesen. */
    if k<=l & c2x(ch)<>bckspc then
    do
      call Charout,ch
      si=si||ch
      /* String vom Bildschirm einlesen und in der Variablen si speichern. */
      si=SysTextScreenRead(posY,PosX,l)
      if c2x(ch)==enter then leave
      k=k+1
    end

  end /* do while */

  /* Ausgabe-Vorbereitung */
  call SysCurPos PosY, PosX
  call CsrAttrib "High"
  if l>=0 then call Charout,copies(" ",l)
  call SysCurPos PosY, PosX
  call Charout,si
  call CsrAttrib "Normal"
  /* Die folgenden zwei Zeilen sind unbedingt erforderlich, weil in        */
  /* dieser Funktion "EditStr" beim Abschlu der Eingabe mit "Enter" das   */
  /* hexadezimale Zeichen 0D (dezimal: 13) angehngt wird.                 */
  /* (Eine Ausnahme liegt dann vor, wenn genau soviele Zeichen eingegeben  */
  /* werden, wie es die zulssige Lnge des Eingabestrings erlaubt.)       */
  /* Da dieses Zeichen zu den ASCII-Steuerzeichen gehrt und somit von     */
  /* einem Editor nicht in einen Quelltext eingefgt werden kann, mu fr  */
  /* REXX-Funktion "Pos" das Zeichen 0D mit Hilfe der REXX-Funktion x2c()  */
  /* dargestellt werden, also mit  x2c(0D).                                */
  q0D=Pos(x2c(0D), si)
  if q0D>0 then si=DelStr(si,q0D)
  return(si) /* EditStr */
                                                       
 
Farb:
   arg str
   /* parse value str with bernimmt immer groe Buchstaben */
   parse value str with s1'RE's2'IM's3
   kl="abcdefghijklmnopqrstuvwxyz";  gr="ABCDEFGHIJKLMNOPQRSTUVWXYZ"
   s1=translate(s1, kl, gr)
   s2=translate(s2, kl, gr)  
   s3=translate(s3, kl, gr) 
   
   call CsrAttrib "High";  call Color "white";      call Charout,s1
   call Color "yellow";                             call Charout,"Re"
   call Color "white";                              call Charout,s2
   call Color "yellow";                             call Charout,"Im"
   call Color "white";                              call Charout,s3
   call CsrAttrib "Normal" 
   return

 
VorAnz:
   call SysCls
   parse arg st1,intRe,IntIm,ND
   call Locate 02,04
   call Charout,"Berechnung der Funktion "
   call Farb st1
   call Locate 04,04
   call CsrAttrib "High";   call Color "yellow"; call Charout,"Re"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(intRe,,ND,,0)
   call Locate 05,04
   call Color "yellow";                          call Charout,"Im"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(intIm,,ND,,0)
   call CsrAttrib "Normal"
   return

 
Quatsch:  
   Call SysCurState OFF
   call CsrAttrib "High";   call Color "cyan","cyan"
   call Locate 20,03
   say"ͻ"
   call Locate 21,03
   say"                                                                         "
   call Locate 22,03
   say"                                                                         "
   call Locate 23,03
   say"                                                                         "
   call Locate 24,03
   say"ͼ"
   call Locate 22,12
   call Charout,"!! Der eingegebene String ist keine gltige REXX-Zahl !!"                              
   call Locate 24,24
   call Color "Green","green"
   call Charout," Zurck mit der Eingabetaste "
   call CsrAttrib "Normal"
   Beep(250, 200)
   q=EditStr(0)
   Call SysCurState ON
   return                              
 
                                
Quatsch0:  
   Call SysCurState OFF
   call CsrAttrib "High";   call Color "cyan","cyan"
   call Locate 20,03
   say"ͻ"
   call Locate 21,03
   say"                                                                         "
   call Locate 22,03
   say"                                                                         "
   call Locate 23,03
   say"                                                                         "
   call Locate 24,03
   say"ͼ"
   call Locate 22,16
   call Charout,"!! Man darf doch nicht durch Null dividieren !!"                              
   call Locate 24,24
   call Color "Green","Green"
   call Charout," Zurck mit der Eingabetaste "
   call CsrAttrib "Normal"
   Beep(250, 200)
   q=EditStr(0)
   Call SysCurState ON
   return                              
 
   
nenNull:  
   Call SysCurState OFF
   call CsrAttrib "High";   call Color "cyan","cyan"
   call Locate 19,03
   say"ͻ"
   call Locate 20,03
   say"                                                                         "
   call Locate 21,03
   say"                                                                         "
   call Locate 22,03
   say"                                                                         "
   call Locate 23,03
   say"                                                                         "
   call Locate 24,03
   say"ͼ"
   call Locate 21,14
   call Charout,"!! Im Verlauf der Berechnung eines Funktionswertes !!"
   call Locate 22,20
   call Charout,"!! ist ein Nenner gleich Null gewesen !!"
   call Locate 24,24
   call Color "Green","Green"
   call Charout," Zurck mit der Eingabetaste "
   call CsrAttrib "Normal"
   Beep(250, 200)
   q=EditStr(0)
   return                              
  
    
Unbestimmt:  
   Call SysCurState OFF
   call CsrAttrib "High";   call Color "cyan","cyan"
   call Locate 20,03
   say"ͻ"
   call Locate 21,03
   say"                                                                         "
   call Locate 22,03
   say"                                                                         "
   call Locate 23,03
   say"                                                                         "
   call Locate 24,03
   say"ͼ"
   call Locate 22,10
   call Charout,"!! Diesen Aufgabenstellung hat ein unbestimmtes Ergebnis !!"
   call Locate 24,24
   call Color "Green","Green"
   call Charout," Zurck mit der Eingabetaste "
   call CsrAttrib "Normal"
   Beep(250, 200)
   q=EditStr(0)
   Call SysCls
   Call SysCurState ON
   Signal Anf
   return
    
    
                                
NochNicht:  
   Call SysCurState OFF
   call CsrAttrib "High";   call Color "cyan","cyan"
   call Locate 20,03
   say"ͻ"
   call Locate 21,03
   say"                                                                         "
   call Locate 22,03
   say"                                                                         "
   call Locate 23,03
   say"                                                                         "
   call Locate 24,03
   say"ͼ"
   call Locate 22,16
   call Charout,"!! Hier ist noch keine Funktion implementiert !!"
   call Locate 24,24
   call Color "Green","Green"
   call Charout," Zurck mit der Eingabetaste "
   call CsrAttrib "Normal"
   Beep(250, 200)
   q=EditStr(0)
   Call SysCurState ON
   return
 
                     
Loesch:  
   call Locate 19,03
   call Locate 20,03
   say"                                                                           "
   call Locate 21,03
   say"                                                                           "
   call Locate 22,03
   say"                                                                           "
   call Locate 23,03
   say"                                                                           "
   call Locate 24,03
   say"                                                                           "
   call Locate 22,12
   return                              
 
   
Ergebnis: /* Diese Prozedur kann fast alle Ergebnisse ausgeben. */
          /* Ausnahmen sind die Funktionen 1 und 2.             */
   parse arg st1,ReErg,ImErg,ND
   call Locate 08,04
   call Charout,"Die Komponenten "
   call CsrAttrib "High";                       call Charout,"ErgRe"
   call CsrAttrib "Normal";                     call Charout," und "
   call CsrAttrib "High";                       call Charout,"ErgIm"
   call CsrAttrib "Normal";
   call Charout," der berechneten komplexen Zahl"
   call Locate 10,04
   call Farb st1
   call Locate 12,04
   call Charout,"sind:"
   call Locate 14,04
   call CsrAttrib "High";                        call Charout,"ErgRe"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";  call Color "cyan";    call Charout,Format(ReErg,,ND,,0)
   call Locate 15,04       
   call Color "white";                           call Charout,"ErgIm"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";  call Color "cyan";    call Charout,Format(ImErg,,ND,,0)
   call Locate 17,04
   call CsrAttrib "Normal"
   call Charout,"========================================================="
   call Locate 19,04
   call Charout,"Soll von der komplexen Zahl " 
   call CsrAttrib "High";                        call Charout,"("
   call Color "yellow";                          call Charout,"Re"
   call Color "white";                           call Charout," + i*"
   call Color "yellow";                          call Charout,"Im" 
   call Color "white";                           call Charout,")"
   call CsrAttrib "Normal"
   call Charout," mit den Komponenten" 
   call Locate 21,04
   call CsrAttrib "High";   call Color "yellow"; call Charout,"Re"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Re,,ND,,0)
   call Locate 22,04
   call Color "yellow";                          call Charout,"Im"
   call CsrAttrib "Normal";                      call Charout," = "
   call CsrAttrib "High";   call Color "green";  call Charout,Format(Im,,ND,,0)
   call CsrAttrib "Normal"
   return

 
Auswahl:
q3q:   
   call Locate 24,50
   call Charout,"                           "   
   call Locate 24,04
   call Charout,"eine andere Funktion berechnet werden ? (J,n) "   
   call Locate 24,50; qqq=EditStr(1) 
                 
   select
      when qqq==' ' | qqq=='j' | qqq=='J' then do; Signal andere; end
      when qqq=='n' | qqq=='N' then do; Signal PgmEnd; end
      otherwise
      do
        Call SysCurState OFF
        Beep(250, 200)
        Call SysCurState ON
        signal q3q
      end
   end
   return                             
 
                           
Unzul:
   parse arg fnkt, st, zeile
   Call SysCurState OFF
   call CsrAttrib "High";   call Color "cyan","cyan"
   call Locate 04,02
   say"ͻ"
   call Locate 05,02
   say"                                                                            "
   call Locate 06,02
   say"                                                                            "
   call Locate 07,02
   say"                                                                            "
   call Locate 08,02
   say"                                                                            "
   call Locate 09,02
   say"                                                                            "
   call Locate 10,02
   say"                                                                            "
   call Locate 11,02
   say"                                                                            "
   call Locate 12,02
   say"                                                                            "
   call Locate 13,02
   say"                                                                            "
   call Locate 14,02
   say"                                                                            "
   call Locate 15,02
   say"                                                                            "
   call Locate 16,02
   say"                                                                            "
   call Locate 17,02
   say"                                                                            "
   call Locate 18,02
   say"                                                                            "
   call Locate 19,02
   say"                                                                            "
   call Locate 20,02
   say"                                                                            "
   call Locate 21,02
   say"                                                                            "
   call Locate 22,02
   say"                                                                            "
   call Locate 23,02
   say"                                                                            "
   call Locate 24,02
   say"ͼ"
   call Locate 06,06
   call Charout,"Quelltext-Zeile: "
   call Locate 06,26
   call Color "white"
   call Charout,zeile
   call Locate 10,06
   call Color "cyan"
   call Charout,"Im Verlauf einer Berechnung ist das Funktionsargument "
   call Locate 12,06
   call Color "white"
   call Charout,st
   call Color "cyan"
   call Locate 14,06
   call Charout,"der Funktion "
   call Locate 16,06
   call Color "white"
   call Charout,fnkt"("st")"
   call Color "cyan"
   call Locate 19,06
   call Charout,"auerhalb des zulssigen Bereichs gewesen."
   call Locate 20,06
   call Charout,"Angaben ber die zulssigen Bereichsgrenzen von Variablen"
   call Locate 21,06
   call Charout,"als Funktionsargumente finden Sie in der Datei kmpl.INF !"
   call Locate 24,24
   call Color "Green","Green"
   call Charout," Weiter mit der Eingabetaste "
   call CsrAttrib "Normal"
   Beep(250, 200)
   q=EditStr(0)
   Call SysCurState ON
   call SysCls
/*   "start /PM /Max C:\OS2\VIEW.EXE "pfd"KMPL.INF"*/
   signal Anf
   return     
 
 
nvMsg1: 
   Call SysCurState OFF
   Beep(250, 200)
   signal neuexp
 
 
nvMsg2: 
   Call SysCurState OFF
   Beep(250, 200)
   signal neuhbhl
 
 
   
                            
/*---------------------------- ANSI-Prozeduren ----------------------------*/
/* Ansi Procedures for moving the cursor */
Locate: Procedure   /*  Call Locate Row,Col */
Row = arg(1)
Col = Arg(2)
Rc = Charout(,D2C(27)"["Row";"col"H")
return ""

CsrUp: Procedure  /* CsrUp(Rows) */
Arg u
Rc = Charout(,D2C(27)"["u"A")
return ""

CsrDown: Procedure /* CsrDn(Rows) */
Arg d
Rc = Charout(,D2C(27)"["d"B")
return ""

CsrRight: Procedure  /* CsrRight(Cols) */
arg r
Rc = Charout(,D2C(27)"["r"C")
Return ""

CsrLeft: procedure  /* CsrLeft(Cols) */
arg l
Rc = Charout(,D2C(27)"["l"D")
Return ""


/*
A------------------------------------------------------------:*
SaveCsr and PutCsr are meant to be used together for saving  :*
and restoring the cursor location. Do not confuse            :*
with Locate, CsrRow, CsrCol, these are different routines.   :*
SaveCsr Returns a string that PutCsr can use.                :*
A:*/
SaveCsr: procedure  /* cursor_location = SaveCsr() (for PutCsr(x))*/
Rc = Charout(,D2C(27)"[6n")
Pull Q
Call CsrUp
return Q

PutCsr: procedure  /* Call PutCsr <Previous_Location>  (From SaveCsr() ) */
Where = arg(1)
Rc = Charout(,substr(Where,1,7)"H")
return ""
/*
A:*/
/* clear screen :*/
Cls: Procedure      /* cls() Call Cls */
Rc = CharOut(,D2C(27)"[2J")
return ""

    /* get cursors Line */
CsrRow: Procedure      /* Row = CsrRow()*/
Rc = Charout(,D2C(27)"[6n")
Pull Q
Return substr(Q,3,2)

   /* get cursors column */
CsrCol: Procedure          /*  Col = CsrCol()  */
Rc = Charout(,D2C(27)"[6n")
Pull Q
return Substr(Q,6,2)

/* procedure to color screen
A:--------------------------------------------------------------*
accepts colors: BLACK RED GREEN YELLOW BLUE MAGENTA CYAN WHITE  *
*/
Color: Procedure /* Call Color <ForeGround>,<BackGround> */
arg F,B
Colors = "BLACK RED GREEN YELLOW BLUE MAGENTA CYAN WHITE"
return CHAROUT(,D2C(27)"["WORDPOS(F,COLORS)+29";"WORDPOS(B,COLORS)+39";m")

/*  change screen attributes
A:---------------------------------------------------------------*
attributes: NORMAL HIGH LOW ITALIC UNDERLINE BLINK RAPID REVERSE *
*/
CsrAttrib: Procedure  /* call CsrAttrib <Attrib> */
Arg A
attr = "NORMAL HIGH LOW ITALIC UNDERLINE BLINK RAPID REVERSE"
return CHAROUT(,D2C(27)"["WORDPOS(A,ATTR) - 1";m")

EndAll:
Call Color "White","Black"
CALL CsrAttrib "Normal"
