/*-------------------------------------------------------------------------
 *	REXX program skeleton that uses the GetOpt option parser
 *
 *	To use, make a copy of this file, and put your code between
 *	the Begin main program/End main program comments.
 *
 *	Copyright (c) 1994 Lawrence R Buchanan.  ALL RIGHTS RESERVED.
 *
 *	This program is free software; you are free to do whatever you 
 *	want with it.  The only requirement is that if you use these 
 *	subroutines in code that you distribute, that you leave the 
 *	copyright messages that appear in the headers of the GetOpt and 
 *	SetupArg subroutines.
 *	
 *	This program is distributed in the hope that it will be useful, 
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * ------------------- R E V I S I O N   H I S T O R Y -------------------
 *
 *	See end of file.
 *
 -------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------
	Setup GetOpt. stem variable for GetOpt subroutine.

	These two statements MUST appear at the beginning of any program
	that uses GetOpt.
 -------------------------------------------------------------------------*/
parse arg args
call SetupArg args


/* Begin Main program */



exit
/* End of Main */



/*-------------------------------------------------------------------------
	GetOpt - parse options from REXX program command line

	Copyright (c) 1994 Lawrence R Buchanan.  ALL RIGHTS RESERVED.
 -------------------------------------------------------------------------*/
GetOpt: procedure expose GetOpt.
	parse arg optstr

	i = GetOpt._optind
	if GetOpt._sp = 1 then do
		if GetOpt._optind > GetOpt.0 | ,
		   substr(GetOpt.i, 1, 1, '00'x) <> '-' | ,
		   substr(GetOpt.i, 2, 1, '00'x) = '00'x then
			return -1
		else 
			if GetOpt.i =  '--' then do
				GetOpt._optind = GetOpt._optind + 1
				return -1
			end
	end

	c = substr(GetOpt.i, GetOpt._sp+1, 1, '00'x)
	GetOpt._optopt = c
	cp = pos(c, optstr)

	if c = ':' | cp = 0 then do
		if GetOpt._opterr = 1 then 
			say GetOpt._program ': illegal option --' c
		GetOpt._sp = GetOpt._sp + 1
		if substr(GetOpt.i, GetOpt._sp+1, 1, '00'x) = '00'x then do
			GetOpt._optind = GetOpt._optind + 1
			GetOpt._sp = 1
		end
		return '?'
	end

	cp = cp + 1
	if substr(optstr, cp, 1, '00'x) = ':' then do
		if substr(GetOpt.i, GetOpt._sp+2, 1, '00'x) <> '00'x then do
			GetOpt._optarg = substr(GetOpt.i, GetOpt._sp+2)
			GetOpt._optind = GetOpt._optind + 1
		end
		else do
			GetOpt._optind = GetOpt._optind + 1
			i = GetOpt._optind
			if GetOpt._optind > GetOpt.0 then do
				if GetOpt._opterr = 1 then 
					say GetOpt._program ': option requires an argument --' c
				GetOpt._sp = 1
				return '?'
			end
			else do
				GetOpt._optarg = GetOpt.i
				GetOpt._optind = GetOpt._optind + 1
			end
		end

		GetOpt._sp = 1
	end
	else do
		GetOpt._sp = GetOpt._sp + 1
		if substr(GetOpt.i, GetOpt._sp+1, 1, '00'x) = '00'x then do
			GetOpt._sp = 1
			GetOpt._optind = GetOpt._optind + 1
		end

		GetOpt._optarg = ''
	end

return c
/* End of GetOpt */


/*-------------------------------------------------------------------------
	SetupArg - Parse command-line arguments and store in stem GetOpt.

	Copyright (c) 1994 Lawrence R Buchanan.  ALL RIGHTS RESERVED.
 -------------------------------------------------------------------------*/
SetupArg: procedure expose GetOpt.
	parse arg arglist

	/* Initialize variables used in GetOpt subroutine. */
	GetOpt. = ''
	GetOpt._opterr = 1
	GetOpt._optind = 1
	GetOpt._sp   = 1

	/* Place program name in GetOpt._program. */
	parse source os . GetOpt._program .
	if os = 'OS/2' then do
		GetOpt._program = filespec('N', GetOpt._program)
		GetOpt._program = delstr(GetOpt._program, lastpos('.', GetOpt._program))
	end

	/* Make sure the command-line contains an even number of 
		quotation characters.  If it doesn't, I can't continue. */
	if __SetupArg_CntQuo(arglist) // 2 then do
		say GetOpt._program ': Unbalanced quotation marks in command-line'
		exit 255
	end

	i = 0
	/* Load command-line options into GetOpt.1 through GetOpt.n. */	
	do while arglist <> ''
		i = i + 1
		parse var arglist GetOpt.i arglist

		/* If quoted argument, make sure we get it all from command-line. */
		if pos('"', GetOpt.i) > 0 then do
			cnt = __SetupArg_CntQuo(GetOpt.i)
			parse var GetOpt.i opt '"' tmparg
			GetOpt.i = opt || strip(tmparg, 'T', '"')
			if cnt = 1 then do
				parse var arglist remarg '"' arglist
				GetOpt.i = GetOpt.i remarg
			end
		end
	end
	GetOpt.0 = i

return GetOpt.0
/* End of SetupArg */


/*-------------------------------------------------------------------------
	__SetupArg_CntQuo - Count number of occurrences of '"' in str

	Copyright (c) 1994 Lawrence R Buchanan.  ALL RIGHTS RESERVED.
 -------------------------------------------------------------------------*/
__SetupArg_CntQuo: procedure
	parse arg str
	
	cnt = 0
	pos = pos('"', str)
	do while pos > 0
		cnt = cnt + 1
		pos = pos('"', str, pos+1)
	end

return cnt
/* End of __SetupArg_CntQuo */



/*-------------------- R E V I S I O N   H I S T O R Y --------------------
 *
 * $Log:   D:\u\src\rexx\getopt\vcs\getopt.cmv  $
 * 
 *    Rev 1.2   20 Apr 1994 16:14:28   rodb
 * CHG: Renamed stem names by prepending a '_' (underscore), in an attempt to
 *      protect them from inadvertent use.  (i.e., GetOpt.program is now 
 *      GetOpt._program.)
 * 
 *    Rev 1.1   20 Apr 1994 12:08:52   rodb
 * CHG: Major changes to GetOpt. stem variable.  Done to make code more 
 *      "in tune" with standard REXX stem variable behavior.
 * 
 *    Rev 1.0   16 Mar 1994 09:21:06   rodb
 * Initial revision.
 *
 -------------------------------------------------------------------------*/
