/*-------------------------------------------------------------------------
 *	Demo - Demonstration of GetOpt/SetupArg subroutines
 *
 *	This program demonsrates the usage of the GetOpt subroutine when 
 *	called from another subroutine.
 *
 *	Copyright (c) 1994 Lawrence R Buchanan.  ALL RIGHTS RESERVED.
 *
 *	This program is free software; you are free to do whatever you 
 *	want with it.  The only requirement is that if you use these 
 *	subroutines in code that you distribute, that you leave the 
 *	copyright messages that appear in the headers of the GetOpt and 
 *	SetupArg subroutines.
 *	
 *	This program is distributed in the hope that it will be useful, 
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	Usage: demo [-dFnt] [-h header] [-l lines] [-w width] file ...
 -------------------------------------------------------------------------*/


/* Check for uninitialized variables. */
signal on NOVALUE name SIG_NoValue


/*-------------------------------------------------------------------------
	Setup GetOpt. stem variable for GetOpt subroutine.

	These two statements MUST appear at the beginning of any program
	that uses GetOpt.
 -------------------------------------------------------------------------*/
parse arg args
call SetupArg args

/* If no parameters issue usage message and exit. */
if GetOpt.0 = 0 then do
	call Usage
	exit 1
end


/* Begin main program */

/* Initialize option character flags. */
length = 66
width  = 72
custom_header = ''
dflg = 0
Fflg = 0
hflg = 0
nflg = 0
tflg = 0


/* Get the option flags and arguments and set up the program environment. */
errflag = 0
optstr = 'Fdh:l:ntw:'
c = GetOpt(optstr)
do while c <> -1
	select
		when c = 'F' then
			Fflg = 1
		when c = 'd' then
			dflg = 1
		when c = 'h' then do
			hflg = 1
			custom_header = GetOpt._optarg
			end
		when c = 'l' then
			if datatype(GetOpt._optarg, 'N') then
				length = trunc(GetOpt._optarg)
			else
				errflag = 1
		when c = 'n' then 
			nflg = 1
		when c = 't' then 
			tflg = 1
		when c = 'w' then 
			if datatype(GetOpt._optarg, 'N') then
				width = trunc(GetOpt._optarg)
			else
				errflag = 1
		otherwise 
			do
				call Usage
				exit 2
			end
	end

	if errflag then do
		say GetOpt._program ': Invalid argument for option' c 
		exit 2
	end
	c = GetOpt(optstr)
end


say 'Contents of GetOpt.'
do i = 0 to GetOpt.0
	say '    GetOpt.' || i '=' GetOpt.i
end

say
call PrintParms
say
say 'GetOpt._optind =' GetOpt._optind
say

say 'Remaining parameters are:'
do i = GetOpt._optind to GetOpt.0
	say '    GetOpt.' || i '=' GetOpt.i
end

exit
/* End of main program */



/*-------------------------------------------------------------------------
	Print program parameters
 -------------------------------------------------------------------------*/
PrintParms:
	say 'Program status:    Before GetOpt       After Getopt'
	say '   Page length:          66           ' center( length, 12 )
	say '   Page width:           72           ' center( width, 12 )
	say '   Flags (dFhnt):      00000          ',
		center( dflg||Fflg||hflg||nflg||tflg, 12 )
	say '   Header:                            ' custom_header

return
/* End of PrintParms */


/*-------------------------------------------------------------------------
	Usage - Print usage message.
 -------------------------------------------------------------------------*/
Usage:
	say 'Usage:' ,
	    GetOpt._program '[-dFnt] [-h header] [-l lines] [-w width] file ...'
return
/* End of Usage */



/*-------------------------------------------------------------------------
	GetOpt - parse options from REXX program command line

	Copyright (c) 1994 Lawrence R Buchanan.  ALL RIGHTS RESERVED.
 -------------------------------------------------------------------------*/
GetOpt: procedure expose GetOpt.
	parse arg optstr

	i = GetOpt._optind
	if GetOpt._sp = 1 then do
		if GetOpt._optind > GetOpt.0 | ,
		   substr(GetOpt.i, 1, 1, '00'x) <> '-' | ,
		   substr(GetOpt.i, 2, 1, '00'x) = '00'x then
			return -1
		else 
			if GetOpt.i =  '--' then do
				GetOpt._optind = GetOpt._optind + 1
				return -1
			end
	end

	c = substr(GetOpt.i, GetOpt._sp+1, 1, '00'x)
	GetOpt._optopt = c
	cp = pos(c, optstr)

	if c = ':' | cp = 0 then do
		if GetOpt._opterr = 1 then 
			say GetOpt._program ': illegal option --' c
		GetOpt._sp = GetOpt._sp + 1
		if substr(GetOpt.i, GetOpt._sp+1, 1, '00'x) = '00'x then do
			GetOpt._optind = GetOpt._optind + 1
			GetOpt._sp = 1
		end
		return '?'
	end

	cp = cp + 1
	if substr(optstr, cp, 1, '00'x) = ':' then do
		if substr(GetOpt.i, GetOpt._sp+2, 1, '00'x) <> '00'x then do
			GetOpt._optarg = substr(GetOpt.i, GetOpt._sp+2)
			GetOpt._optind = GetOpt._optind + 1
		end
		else do
			GetOpt._optind = GetOpt._optind + 1
			i = GetOpt._optind
			if GetOpt._optind > GetOpt.0 then do
				if GetOpt._opterr = 1 then 
					say GetOpt._program ': option requires an argument --' c
				GetOpt._sp = 1
				return '?'
			end
			else do
				GetOpt._optarg = GetOpt.i
				GetOpt._optind = GetOpt._optind + 1
			end
		end

		GetOpt._sp = 1
	end
	else do
		GetOpt._sp = GetOpt._sp + 1
		if substr(GetOpt.i, GetOpt._sp+1, 1, '00'x) = '00'x then do
			GetOpt._sp = 1
			GetOpt._optind = GetOpt._optind + 1
		end

		GetOpt._optarg = ''
	end

return c
/* End of GetOpt */


/*-------------------------------------------------------------------------
	SetupArg - Parse command-line arguments and store in stem GetOpt.

	Copyright (c) 1994 Lawrence R Buchanan.  ALL RIGHTS RESERVED.
 -------------------------------------------------------------------------*/
SetupArg: procedure expose GetOpt.
	parse arg arglist

	/* Initialize variables used in GetOpt subroutine. */
	GetOpt. = ''
	GetOpt._opterr = 1
	GetOpt._optind = 1
	GetOpt._sp   = 1

	/* Place program name in GetOpt._program. */
	parse source os . GetOpt._program .
	if os = 'OS/2' then do
		GetOpt._program = filespec('N', GetOpt._program)
		GetOpt._program = delstr(GetOpt._program, lastpos('.', GetOpt._program))
	end

	/* Make sure the command-line contains an even number of 
		quotation characters.  If it doesn't, I can't continue. */
	if __SetupArg_CntQuo(arglist) // 2 then do
		say GetOpt._program ': Unbalanced quotation marks in command-line'
		exit 255
	end

	i = 0
	/* Load command-line options into GetOpt.1 through GetOpt.n. */	
	do while arglist <> ''
		i = i + 1
		parse var arglist GetOpt.i arglist

		/* If quoted argument, make sure we get it all from command-line. */
		if pos('"', GetOpt.i) > 0 then do
			cnt = __SetupArg_CntQuo(GetOpt.i)
			parse var GetOpt.i opt '"' tmparg
			GetOpt.i = opt || strip(tmparg, 'T', '"')
			if cnt = 1 then do
				parse var arglist remarg '"' arglist
				GetOpt.i = GetOpt.i remarg
			end
		end
	end
	GetOpt.0 = i

return GetOpt.0
/* End of SetupArg */


/*-------------------------------------------------------------------------
	__SetupArg_CntQuo - Count number of occurrences of '"' in str

	Copyright (c) 1994 Lawrence R Buchanan.  ALL RIGHTS RESERVED.
 -------------------------------------------------------------------------*/
__SetupArg_CntQuo: procedure
	parse arg str
	
	cnt = 0
	pos = pos('"', str)
	do while pos > 0
		cnt = cnt + 1
		pos = pos('"', str, pos+1)
	end

return cnt
/* End of __SetupArg_CntQuo */



/*-------------------------------------------------------------------------
	This subroutine, in conjunction with a SIGNAL ON NOVALUE statement, 
	will display an error message (in sort-of Microsoft format) if the 
	program encounters an uninitialized variable.
 -------------------------------------------------------------------------*/
SIG_NoValue:
	parse source . . source_file .
	say GetOpt._program '(' || sigl || '): Error: Variable' condition('D'),
		'was not initialized prior to use'

	exit
