/*****************************************************************************/
/* Lotus 1-2-3 For OS/2 sample macro command.                                */
/*                                                                           */
/* {REXXR "REXXDIAG",range}                                                  */
/*                                                                           */
/* Moves the values of the cells on the left top - right bottom diagonal of  */
/* a range to the other diagonal, across the horizontal axis.  The range is  */
/* defined by its left top corner only.  The diagonal is traversed until an  */
/* empty, ERR or N/A cell is reached.                                        */
/*                                                                           */
/* {REXXR "REXXDIAG logFileName",range}                                      */
/*                                                                           */
/* Writes any TRACE or SAY output to a log file named 'logFileName'.         */
/*                                                                           */
/* Copyright (c) 1991 Lotus Development Corporation.  This code is supplied  */
/* on an 'as is' basis as an example only.  This code has only received      */
/* informal testing by Lotus.  Permission is granted  to copy and modify     */
/* this code to your heart's content.  No warrenties expressed or implied.   */
/* Remember, your mileage may vary.  Let us know if you find support of REXX */
/* by 1-2-3 useful.                                                          */
/*****************************************************************************/

ARG theRange
IF theRange <> "RANGE1" THEN DO                   /* this should ever happen */
   CALL Display123Error "First argument to REXXADD.CMD is not a range."
   RETURN
   END
sheet = 1
col = 0; row = 0
DO i = 1 BY 1 UNTIL value.i = ""    /* walk the diagonal up to an empty cell */
   col = col + 1; row = row + 1
   value.i = Get123Cell(theRange, sheet, col, row)
   SAY value.i
   CALL Set123Cell theRange, sheet, col, row, "EMPTY", 0  /* set it to empty */
   END
num = i - 1                               /* number of cells in the diagonal */
col = 0
DO i = 1 TO num      /* walk the other diagonal, writing out the cell values */
   col = col + 1; row = row - 1
   IF Datatype(value.i) = "NUM" THEN type = "NUMBER"
   ELSE type = "STRING"
   CALL Set123Cell theRange, sheet, col, row, type, value.i
   END
RETURN
