/******************************************************************* CONFIG.H
 *                                                                          *
 *                     Configure Dialog definitions                         *
 *                                                                          *
 ****************************************************************************/

#ifndef CONFIG_H
#define CONFIG_H

#include "Profile.h"

enum {
   CORNER_BL,
   CORNER_BR,
   CORNER_TL,
   CORNER_TR
} ;

enum { 
   SHOWK_NEVER, 
   SHOWK_ABOVE512, 
   SHOWK_ALWAYS 
} ;

typedef struct {

  BOOL   HideControls ;
  BOOL   Float ;
  BOOL   Animate ;
  BOOL   TableFormat ;
  BOOL   Chime ;
  BOOL   ShowRemoteDrives ;
  BOOL   ShowFileSystemNames ;
  BOOL   ShowDiskLabels ;
  BOOL   ShowSeconds ;
  BOOL   Hour24 ;
  USHORT ShowK ;
  USHORT ShowTrueK ;
  USHORT ShowM ;
  ULONG  MonitorPriority ;
  ULONG  TimerInterval ;
  USHORT AnchorCorner ;
  COLOR  NormalBackground, NormalForeground ;
  COLOR  WarningBackground, WarningForeground ;
  COLOR  ErrorBackground, ErrorForeground ;

  USHORT ItemCount ;
  BOOL   ItemFlags [ ITEM_BASE_COUNT + MAX_DRIVES ] ;
  char   DefaultLabels [ ITEM_BASE_COUNT + MAX_DRIVES ] [ 80 ] ;
  char   CurrentLabels [ ITEM_BASE_COUNT + MAX_DRIVES ] [ 80 ] ;
  ULONG  DefaultLevels [ ITEM_BASE_COUNT + MAX_DRIVES ] [ 2 ] ;
  ULONG  WarningLevel [ ITEM_BASE_COUNT + MAX_DRIVES ] ;
  ULONG  ErrorLevel [ ITEM_BASE_COUNT + MAX_DRIVES ] ;
  int    LevelSense [ ITEM_BASE_COUNT + MAX_DRIVES ] ;
  ULONG  MinLevel [ ITEM_BASE_COUNT + MAX_DRIVES ] ;
  ULONG  MaxLevel [ ITEM_BASE_COUNT + MAX_DRIVES ] ;

  // State information.
  int    Ready ;
  int    MostRecentSelection ;
  HWND   MainWindow ;

} CONFIG_PARMS, *PCONFIG_PARMS ;

extern FNWP ConfigureProcessor ;

#endif
