/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998, 1999  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    PMB # 181
    11900 Metric Blvd Ste. J
    Austin Tx 78758-3117
    pelliott@io.com
*/
#include "LtProf.hpp"

#include <iapp.hpp>
#include <iexcbase.hpp>
#include <iexcept.hpp>


#include <string.h>
#include <stdlib.h>

// constructor for profile storage. create an application profile.
// and store the Key.
ProfStorage::ProfStorage(const IString& app_name,
                         const IString& user_file_id,const IString& id ) :
profile( app_name, user_file_id ),
key(id)
{
};

// Read raw data from the profile.
void ProfStorage::read ( char * buf,int count)
{
    IString str= profile.elementWithKey(key);

    // if data found is wrong length, throw exception.
    IASSERTPARM( str.length() == count);

    // move the bytes to user.
    memmove(buf,(char*)str,count);

};

// write raw data to the profile.
void ProfStorage::write (const char * buf,int count)
{

    // form a string from the raw data.
    IString str(buf,count);

    // and write the string to the profile.
    profile.addOrReplaceElementWithKey(key,str);
};
