/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1996, 1999  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    PMB # 181
    11900 Metric Blvd Ste. J
    Austin Tx 78758-3117
    pelliott@io.com
*/
#ifndef GLBSIZE
#define GLBSIZE
#include <ipoint.hpp>

#include "Ltper.hpp"
#include "LtProf.hpp"

// Size structure (LONG values).

// typedef struct _SIZEL {
// LONG   cx;  /*  Width. */
// LONG   cy;  /*  Height. */
//  } SIZEL;
//
// typedef SIZEL *PSIZEL;

// raw struct holding info of ISize, can be bytewise copied
// and not reference to outside world such as pointers/

struct _SIZEL {
long   cx;  /*  Width. */
long   cy;  /*  Height. */
};

// This constructor is declared but not defined
// in Open class library.
//ISize::ISize( const _SIZEL& raw_size)
//{
//    setHeight(raw_size.cx);
//    setWidth(raw_size.cy);
//};

// SIZEL is the essance of a PSize.
// One can create an ISize from a PSize.


class PSize : private SIZEL
{
  public:

    // can consturct a PSize from raw SIZEL.
    PSize(const SIZEL& size) : SIZEL(size)  {};

    // conversion operator yeilds raw SIZEL.
    operator SIZEL& ()
    {
        return *(SIZEL *) this;
    };

    // get constant SIZEL from a const PSize.
    operator const SIZEL& () const
    {
        return *(const SIZEL *) this;
    };

    // can convert to an ISize.
    operator ISize() const
    {

       return ISize(cx,cy);
    };

    // can be constructed from a ISize.
    PSize( const ISize& size) : SIZEL(size.asSIZEL() ) {};
};

// a source of PSizes.
// Can create PSize from a stored Sizel.
typedef ExternalExistance<PSize,SIZEL> ExternalSize;

// a source of PSizes from application profiles.

class SizeStore
{
     private:
        ProfStorage storage;                  // Profile source.
        ExternalSize size_existance;          // ExternalExistance from profile.
     public:

        // constuctor. Profile from application name, user ini file.key=frame_size.
        SizeStore() :
          storage("listpm","application_ini","frame_size"),
          // external existance from profile.
          size_existance(storage)
          {};

        // returns true when key exists in profile.
        Boolean sizeExternal(void) { return size_existance.ExistsExternally(); };

        // get ISize stored externally.
        operator ISize()
        {
           ExternalSize::Created created(size_existance);
           return created.operator ISize();

        };

        // Store ISize in profile.
        SizeStore& operator<<(const ISize& size)
        {
           PSize psize(size);
           size_existance << psize;
           return *this;
        };
};
#endif // GLBSIZE
