/* ClckInst - Install / UnInstall for World Clock */

PARSE ARG action
IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL RxFuncAdd  'FastIniStart','FastIni','FastIniStart'
CALL RxFuncAdd  'FastIniEnd','FastIni','FastIniEnd'

CALL SysCls
action = TRANSLATE(LEFT(action,1))
SELECT
    WHEN action = 'I' THEN CALL InstallMe
    WHEN action = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL WhatAction
END
Exit

/* End of ClckInst.cmd */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY 'Please enter installation parameter (I=Install, U=UnInstall, other=Exit):'
PARSE PULL action
SELECT
    WHEN TRANSLATE(LEFT(action,1)) = 'I' THEN CALL InstallMe
    WHEN TRANSLATE(LEFT(action,1)) = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL NoAction 'Installation failed.'
END
RETURN

/* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

CALL SysCls
PARSE ARG noinstmsg
SAY noinstmsg
SAY 'Press Enter to exit ...'
PULL answer
CALL SysCls
Exit

/* End of NoAction */

/* InstallMe - install World Clock */

InstallMe:  PROCEDURE

prgname = 'World Clock 1.2.1'
cfgfiles = 'Clock.exe CITIES.DAT Clkbmp32.dll ENGLISH.INI'
IF RIGHT(Directory(),2) = ':\' THEN DO
    SAY 'Problem! '||prgname||' can not be installed in root directory.'
    SAY 'Create directory for '||prgname||', copy files: '||cfgfiles||' there and start this procedure again.'
    SAY 'Press Enter to exit ...'
    PULL answer
    Exit
END

CALL SysCls
SAY 'Welcome to '||prgname||' Installation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will:'
SAY '- Create Folder "World Clock Version 1.2.1" on your Desktop,'
SAY '- Create Program objects for '||prgname||','
SAY '- Add '||prgname||' specific entries in OS2.INI file, in App ToolsByGoran.'
SAY 'Press "Y" (and Enter) to start Installation, Enter to exit...'
PARSE PULL answer

IF TRANSLATE(LEFT(answer,1)) <> "Y" THEN DO
    CALL NoAction 'Installation aborted'
END

SAY ' '
SAY 'Checking files:'
DO i = 1 TO WORDS(cfgfiles)
    CALL SysFiletree Directory()||'\'||WORD(cfgfiles,i), 'chkfile', 'FO'
    SELECT
    WHEN chkfile.0 = 1 THEN SAY '- '||LEFT(WORD(cfgfiles,i),12)||' - OK'
    OTHERWISE CALL NoAction LEFT(WORD(cfgfiles,i),12)||' - Missing file. Installation failed!'
    END
END

SAY ' '
SAY 'Writing entries to OS2.INI'
dummy = SysIni('USER','ToolsByGoran','WorldClockWorkDir',Directory())
SAY 'Working directory - '||Rc1(dummy)
dummy = SysIni('USER','ToolsByGoran','WorldClockINIfile',Directory()||'\CLOCK.INI')
SAY 'INI file - '||Rc1(dummy)

SAY ' '
iniRc = FastIniStart('CLOCK.INI',"IniHandle")
SAY 'Writing default values to CLOCK.INI'
SAY '- Settings'
CALL SysIni 'CLOCK.INI','Settings','CurrLang','ENGLISH'
CALL SysIni 'CLOCK.INI','Settings','Universal','0 1 0 0'
CALL SysIni 'CLOCK.INI','Settings','Style','W'
CALL SysIni 'CLOCK.INI','Settings','Clock','1 2 2 9 200 50'
CALL SysIni 'CLOCK.INI','Settings','Banner','1 0'
CALL SysIni 'CLOCK.INI','Settings','Minimized','1'
CALL SysIni 'CLOCK.INI','Settings','Free','0 0 0 0'
CALL SysIni 'CLOCK.INI','Settings','Font','9.WarpSans'
CALL SysIni 'CLOCK.INI','Settings','Date','1 1 1 1 1 1'
CALL SysIni 'CLOCK.INI','Settings','Time','1 1 0 1 1'
CALL SysIni 'CLOCK.INI','Settings','CalDay','1'
CALL SysIni 'CLOCK.INI','Settings','CalNote','480 960 1'
CALL SysIni 'CLOCK.INI','Settings','Country','1_default'
CALL SysIni 'CLOCK.INI','Settings','CurrWorldMap','World0.met'
CALL SysIni 'CLOCK.INI','Settings','WorldTime','1 1 1 0'
CALL SysIni 'CLOCK.INI','Settings','Messages','1 1 1 1 1 1 1'
CALL SysIni 'CLOCK.INI','Settings','Stopwatch','1 10'
CALL SysIni 'CLOCK.INI','Settings','Misc','0 1 0 1 1 1'
SAY '- Language support'
CALL SysIni 'CLOCK.INI','Language','ENGLISH','English.inf'
CALL SysIni 'CLOCK.INI','Language','CROATIAN','English.inf'
CALL SysIni 'CLOCK.INI','Language','DUTCH','English.inf'
CALL SysIni 'CLOCK.INI','Language','GERMAN','English.inf'
CALL SysIni 'CLOCK.INI','Language','POLISH','English.inf'
CALL SysIni 'CLOCK.INI','Language','SERBIAN','English.inf'
CALL SysIni 'CLOCK.INI','Language','SERBIANC','English.inf'
CALL SysIni 'CLOCK.INI','Language','SLOVENIA','English.inf'
CALL SysIni 'CLOCK.INI','Language','SPANISH','English.inf'
CALL SysIni 'CLOCK.INI','Language','SWEDISH','Swedish.inf'
SAY '- World maps'
CALL SysIni 'CLOCK.INI','WorldMap','World0.met','Default World map'
CALL SysIni 'CLOCK.INI','WorldMap','World1.met','Political World map'
CALL SysIni 'CLOCK.INI','WorldMap','World2.met','Relief World map'
CALL SysIni 'CLOCK.INI','WorldMap','World3.met','World map made from satellite photos (without clouds)'
SAY '- Selected cities'
DO i = 1 TO 9
    IF SysIni('CLOCK.INI','SelCity',i) = 'ERROR:' THEN DO
    CALL SysIni 'CLOCK.INI','SelCity',i,'UTC, Coordinated Universal Time'
    END
END
iniRc = FastIniEnd("IniHandle")

SAY ' '
InstallDir = Directory()
WorkDir = Directory()

FoldTitle='World Clock'||'^Version 1.2.1'
Icon1=Directory()||'\Folder1.ico'
Icon2=Directory()||'\Folder2.ico'
Icon='ICONFILE='Icon1||';ICONNFILE=1,'||Icon2
Setup='OBJECTID=<WORLDCLOCK_FOLD>;'||Icon||''
Action = 'U'
dummy = SysCreateObject('WPFolder',FoldTitle,'<WP_DESKTOP>',Setup,Action)
SAY 'Creating '||FoldTitle||' Folder - '||Rc2(dummy)

FoldTitle='Help'
Setup='OBJECTID=<WORLDCLOCK_HELP>'
Action = 'U'
dummy = SysCreateObject('WPFolder',FoldTitle,'<WORLDCLOCK_FOLD>',Setup,Action)
SAY 'Creating '||FoldTitle||' Folder - '||Rc2(dummy)

ProgTitle = prgname
EXE = 'Clock.exe'
ICO = 'Clock.ico'
Setup = 'OBJECTID=<WORLDCLOCK_PROG>;EXENAME='InstallDir'\'EXE';ICONFILE='InstallDir'\'ICO';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WORLDCLOCK_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' Program object - '||Rc2(dummy)

ProgTitle = prgname||'^English manual'
EXE = 'View.exe'
INF = 'English.inf'
Setup = 'OBJECTID=<WORLDCLOCK_HENG>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WORLDCLOCK_HELP>',Setup,Action)
SAY 'Creating '||prgname||' English manual - '||Rc2(dummy)

ProgTitle = prgname||'^Swedish manual'
EXE = 'View.exe'
INF = 'Swedish.inf'
Setup = 'OBJECTID=<WORLDCLOCK_HSWE>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WORLDCLOCK_HELP>',Setup,Action)
SAY 'Creating '||prgname||' Swedish manual - '||Rc2(dummy)

ProgTitle = 'Read me 1st'||'^English'
EXE = 'E.exe'
INF = 'ReadEng.1st'
Setup = 'OBJECTID=<WORLDCLOCK_1STENG>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WORLDCLOCK_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' ReadMe.1st - English - '||Rc2(dummy)

ProgTitle = 'Read me 1st'||'^Dutch'
EXE = 'E.exe'
INF = 'ReadDut.1st'
Setup = 'OBJECTID=<WORLDCLOCK_1STDUT>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WORLDCLOCK_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' ReadMe.1st - Dutch - '||Rc2(dummy)

ProgTitle = 'Read me 1st'||'^Swedish'
EXE = 'E.exe'
INF = 'ReadSwe.1st'
Setup = 'OBJECTID=<WORLDCLOCK_1STSWE>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WORLDCLOCK_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' ReadMe.1st - Swedish - '||Rc2(dummy)

ProgTitle = prgname||'^History - English'
EXE = 'E.exe'
INF = 'HistEng.txt'
Setup = 'OBJECTID=<WORLDCLOCK_HISTENG>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WORLDCLOCK_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' History - English - '||Rc2(dummy)

ProgTitle = prgname||'^History - Dutch'
EXE = 'E.exe'
INF = 'HistDut.txt'
Setup = 'OBJECTID=<WORLDCLOCK_HISTDUT>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WORLDCLOCK_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' History - Dutch - '||Rc2(dummy)

ProgTitle = prgname||'^History - Swedish'
EXE = 'E.exe'
INF = 'HistSwe.txt'
Setup = 'OBJECTID=<WORLDCLOCK_HISTSWE>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WORLDCLOCK_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' History - Swedish - '||Rc2(dummy)

SAY ' '
SAY 'Installation finished! Press Enter to exit ...'
PULL answer
CALL SysCls
RETURN

/* End of InstallMe */

/* UnInstallMe - uninstall World Clock */

UnInstallMe: PROCEDURE

prgname = 'World Clock 1.2.1'
CALL SysCls
SAY 'This is '||prgname||' UnInstallation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will:'
SAY '- Remove '||prgname||' specific entries in OS2.INI file, App ToolsByGoran.'
SAY '- Destroy '||prgname||' Program object'
SAY 'Press "Y" (and Enter) to start UnInstall, any other key to exit...'
PULL answer
IF answer <> "Y" THEN DO
    CALL NoAction 'UnInstall terminated.'
END
SAY ' '
SAY 'Removing entries from OS2.INI'
CALL SysIni 'USER','ToolsByGoran','WorldClockWorkDir','DELETE:'
CALL SysIni 'USER','ToolsByGoran','WorldClockINIfile','DELETE:'
SAY ' '
SAY 'Destroying Program objects and Folder'
CALL SysDestroyObject '<WORLDCLOCK_HISTENG>'
CALL SysDestroyObject '<WORLDCLOCK_HISTDUT>'
CALL SysDestroyObject '<WORLDCLOCK_HISTSWE>'
CALL SysDestroyObject '<WORLDCLOCK_1STENG>'
CALL SysDestroyObject '<WORLDCLOCK_1STDUT>'
CALL SysDestroyObject '<WORLDCLOCK_1STSWE>'
CALL SysDestroyObject '<WORLDCLOCK_HENG>'
CALL SysDestroyObject '<WORLDCLOCK_HSWE>'
CALL SysDestroyObject '<WORLDCLOCK_PROG>'
CALL SysDestroyObject '<WORLDCLOCK_FOLD>'
SAY ' '
SAY 'UnInstallation complete.'
SAY 'You can delete files in directory '||Directory()
SAY 'To install '||prgname||' again, start ClckInst I. Press Enter to exit...'
PULL answer
RETURN

/* End of UnInstallMe */

/* Rc1 - return code - SysIni */

Rc1:        PROCEDURE

PARSE ARG rcSysIni
SELECT
    WHEN rcSysIni = 'ERROR:' THEN rc1 = 'Error writing to INI file!'
    OTHERWISE rc1 = 'OK'
END
RETURN rc1

/* End of Rc1 */

/* Rc2 - return code - SysCreateObject */

Rc2:        PROCEDURE

PARSE ARG rcSysCreateObject
SELECT
    WHEN rcSysCreateObject = 0 THEN rc2 = 'Error'
    OTHERWISE rc2 = 'OK'
END
RETURN rc2

/* End of Rc2 */