/*
 * $Id: pmclip.c,v 1.4 1995/01/08 14:10:16 gruendel Rel $
 *
 * $Log: pmclip.c,v $
 * Revision 1.4  1995/01/08 14:10:16  gruendel
 * Use OS/2 header files of emx instead of those from the Toolkit so we
 * don't depend on the Toolkit.
 *
 * Revision 1.3  1994/12/17 17:47:42  gruendel
 * Prepend RCS header.
 * Apply some cosmetic changes to simplify working with TAGS.
 *
 * Revision 1.2  1994/10/10 16:52:37  gruendel
 * Switch from assert to pmassert so we'll see if an assertion failed and
 * where it happened.
 * Close clipboard after reading it; the missing call didn't matter with
 * OS/2 2.x, but it produced some strange results with Warp Beta II.
 *
 * Revision 1.1  1993/10/24 16:33:20  gruendel
 * Initial revision
 *
 */

#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#define INCL_WINCLIPBOARD
#include <os2.h>
#include <pmassert.h>

#include <stdio.h>
#include <stdlib.h>
#include "common.h"


BOOL  fClipbrdOpen = FALSE;

HAB   hab          = NULLHANDLE;

HMQ   hmq          = NULLHANDLE;


VOID
APIENTRY exitfunc (VOID)
{
  if (fClipbrdOpen)
  {
    pmassert (hab != NULLHANDLE);
    WinCloseClipbrd (hab);
  }
  if (hmq != NULLHANDLE)
    WinDestroyMsgQueue (hmq);
  if (hab != NULLHANDLE)
    WinTerminate (hab);

  DosExitList (EXLST_EXIT, (PFNEXITLIST) exitfunc);
}


int
main (int argc, char* argv [])
{
  HFILE  hfWrite;

  PVOID  pClipbrdBuf, pShareBuf;

  ULONG  ulFormat = 0,		       /* WinQueryClipbrdFmtInfo seems to */
				       /* return a USHORT, so we'd better */
				       /* initialise it to 0              */
	 ulClipbrdSize,
	 ulActual;

  if (2 != argc                                                       ||
      2 != sscanf (argv [1], ARG_FORMAT, (unsigned long*) &pShareBuf,
		   &hfWrite)                                          ||
      NO_ERROR != DosExitList (EXLST_ADD | ROUTINE_ORDER,
			       (PFNEXITLIST) exitfunc)                ||
      NULLHANDLE == (hab = WinInitialize (0))                         ||
      NULLHANDLE == (hmq = WinCreateMsgQueue (hab, 0))                ||
      !WinQueryClipbrdFmtInfo (hab, CF_TEXT, &ulFormat)               ||
      !(fClipbrdOpen = WinOpenClipbrd (hab)))
  {
    exit (EXIT_FAILURE);
  }
  pmassert (ulFormat == CFI_POINTER);

  pClipbrdBuf = (PVOID) WinQueryClipbrdData (hab, CF_TEXT);
  ulClipbrdSize = strlen (pClipbrdBuf) + 1; /* including end-zero */

  if (NO_ERROR !=
      DosGetSharedMem (pShareBuf, PAG_READ | PAG_WRITE)             ||
      NO_ERROR !=
      DosSetMem (pShareBuf, ulClipbrdSize, PAG_COMMIT | PAG_DEFAULT))
  {
    WinCloseClipbrd (hab);
    exit (EXIT_FAILURE);
  }
  memcpy (pShareBuf, pClipbrdBuf, ulClipbrdSize);
  WinCloseClipbrd (hab);

  if (NO_ERROR !=
      DosWrite (hfWrite, &ulClipbrdSize, sizeof (ulClipbrdSize), &ulActual))
  {
    exit (EXIT_FAILURE);
  }
  pmassert (ulActual == sizeof (ulClipbrdSize));

  return EXIT_SUCCESS;
}
