# $Id: makefile.mk,v 1.3 1995/01/08 15:32:10 gruendel Rel $
#
# $Log: makefile.mk,v $
# Revision 1.3  1995/01/08 15:32:10  gruendel
# Prepend RCS header.
# Additionally create Warp-only executables with new `/exepack:2' linker
# switch resulting in smaller executables.
# Rewrite rules for creating executables.
# Add target `dist' to simplify creating an archive for distribution.
#
# Revision 1.2  1994/10/10 16:57:54  gruendel
# Delete the `-T 0x10000' linker switch as emxomfld uses it as default.
# Add `-Zlinker /align:16 -Zlinker /exepack' linker switches for
# optimisation purposes.  (So I've read :-)
# Compile clipbrd.exe with `-O2' too now.  This broke the executable
# with emx 0.8g but it works with 0.8h.
# Compile the executables with '-Zmtd'.  This results in smaller
# executables, but now emxlibc.dll is required too.
#
# Revision 1.1  1993/10/24 16:35:29  gruendel
# Initial revision
#

EMXFLAGS = -Zmtd -Zomf
CFLAGS   = $(EMXFLAGS) -DNDEBUG -O2 -Wall
LDFLAGS  = $(EMXFLAGS) -s -Zlinker /align:16 -Zlinker /exepack

all : clipbrd.exe pmclip.exe warp/clipbrd.exe warp/pmclip.exe

%.exe : %.obj
	gcc -o $@ $< $(@:b).def $(LDFLAGS)

warp/%.exe : %.obj
	gcc -o $@ $< $(@:b).def $(LDFLAGS:s/exepack/exepack:2)

clipbrd.exe warp/clipbrd.exe : clipbrd.def

pmclip.exe warp/pmclip.exe : pmclip.def

%.obj : %.c
	gcc -c -o $@ $< $(CFLAGS)

clipbrd.obj pmclip.obj : common.h

dist :: clipbrd.c clipbrd.def clipbrd.exe common.h /emx/dll/emx.dll \
        /emx/dll/emxlibcm.dll makefile.mk /emx/usr/lib/pmassert.c   \
        /emx/usr/include/pmassert.h pmclip.c pmclip.def pmclip.exe readme
	zip -jo9 clipbrd.zip $<

dist :: warp/clipbrd.exe warp/pmclip.exe
	zip -o9 clipbrd.zip $<
