/* BinSuk.cmd */

  '@echo off'
  version = '1.71'

/*----------------------------------------------------------------------------*
 * process commandline parameters                                             *
 *----------------------------------------------------------------------------*/
  parse arg server group minsize maxCount sound logFileName

  if logFileName = 'NONE' then logFileName = ''
  if logFileName = "LOGFILENAME" then logFileName = ''

  rc=log(logFilename,'BinSuk - '||version||' startup')

  '@icontalk BinSuk '||version||' - starting...'

/* draw the cool ansi screen on the local console */

  rc=drawBoarder(version)

/*----------------------------------------------------------------------------*
 * Miscellaneous variables                                                    *
 *----------------------------------------------------------------------------*/
  beginread       = 0
  DuplicateCount  = 0
  duplicateLogDir ='DuplicateLogs'
  groupLogDir     ='GroupLogs'
  InBoundDir      ='InBound'
  processedcount  = 0
  startLine       = 9
  trashedFileCount=0

/*----------------------------------------------------------------------------*
 * load add-on function libraries and assume it all went well...              *
 *----------------------------------------------------------------------------*/

  rc=loadLibraries()

/*----------------------------------------------------------------------------*
 * determine if user specified server parameter is a named server or a        *
 * dotted named server                                                        *
 *----------------------------------------------------------------------------*/

  parse var server bit0 '.' bit1 '.' bit2 '.' bit3

  serverType=(datatype(bit0)='NUM' & datatype(bit1)='NUM' & datatype(bit2)='NUM' & datatype(bit3)='NUM')

  if serverType=0 then do     /* is a named server */
    nameServer=server
    rc=BSGetHostByName(server)
    server=rc
    end /* if serverType */

  if serverType=1 then do     /* is a dotted server */
    rc=BSGetHostByAddr(server)
    nameServer=rc
    end /* if serverType */

/*----------------------------------------------------------------------------*
 * If rc returns a zero, then an error occured and terminate the BS process   *
 * Gotta' clean this one up some day to terminate cleanly!@                   *
 *----------------------------------------------------------------------------*/

  if (rc = 0) then do
    rc=errorSound(1)
    text="Unable to resolve server name: "server
    say text
    rc=log(logFileName,text)
    exit
    end /* if rc */

/*----------------------------------------------------------------------------*
 * Open socket and return the actual socket numnber.                          *
 *----------------------------------------------------------------------------*/

  rc=BSSockSocket()

  if (rc = -1) then do
    rc=errorSound(1)
    text="Error opening socket: "errno
    say text
    rc=log(logFileName,text)
    exit
    end /* if rc */

  sock=rc

/* configure the socket we just opened */

  rc=BSSockSetSockOpt(sock)

  if (rc = 0) then do
    rc=tickSound(1)
    end /* if rc */

/* connect the socket and start the "conversation" */

  rc=BSSockConnect(sock,server)

  if (rc = -1) then do
    rc=errorSound(1)
    text='Error connecting socket:' errno
    say text
    rc=log(logFileName,text)
    exit
    end

  rc=getResponse(sock)

  text='Connected to server: 'nameServer' ('server')'
  rc=log(logFileName,text)

  rc = syscurpos(2,3)
  say text

  rc = syscurpos(2,71)
  say'(   )'

/*----------------------------------------------------------------------------*
 * ask for group information from server                                      *
 *----------------------------------------------------------------------------*/
  rc=SendMessage(sock,'group '||group)
  rc=getResponse(sock)

/*----------------------------------------------------------------------------*
 * parse response to group command                                            *
 *----------------------------------------------------------------------------*/
  parse var line.1 code total begin end1 .

  rc=SendMessage(sock,'mode reader')
  rc=getResponse(sock)

  parse var line.1 code .

/*----------------------------------------------------------------------------*
 * code 411 - this was a BAD group command!                                   *
 *----------------------------------------------------------------------------*/

  if code = 411 then do
    rc=errorSound(sound)

    rc=syscurpos(startline+3,3)
    say'                                                                          '

    rc=syscurpos(startline+3,3)

    text='No such group as: 'group
    say text
    rc=log(logFileName,text)
    exit

    end /* if code */

/*----------------------------------------------------------------------------*
 * read in group.log information                                              *
 *----------------------------------------------------------------------------*/

  rc=groupLogFunctions(group,groupLogDir,,'read')
  lastRead=rc

  if lastRead = '' then lastRead = 0

  if lastRead < begin then lastRead = begin

  beginRead = lastRead

  rc = syscurpos(4,3)
  say'Processing newsgroup: 'group

  rc = syscurpos(5,3)
  say'Last message number read: 'lastRead

  newMessageCount = end1-lastRead

  rc = syscurpos(6,3)
  say'Newest message number on server: 'end1' (number of new messages: 'newMessageCount')'

  rc=syscurpos(8,3)
  say'                                                                          '

  rc=syscurpos(8,3)
  say'Minimum message length: 'minsize'    Sound: 'sound'    maxCount: 'maxCount

  if lastRead > end1 then do
    say''
    text='No new messages in: 'group
    say text
    rc=log(logFileName,text)
    exit
  end

  BadArticle = 0
  DuplicateCount = 0
  ExtractedBinaryCount = 0

  rc=clearScreen(startLine)
  rc=clearTotals(startLine)

/*----------------------------------------------------------------------------*
 * here's the main work loop                                                  *
 *----------------------------------------------------------------------------*/
  do messageNumber = beginread to end1

    signal on halt

    rc=clearScreen(startLine)

    rc=syscurpos(startline+1,3)
    say'                                                                          '

    rc=syscurpos(startline+1,3)
    say'Getting header number: 'messageNumber
    '@icontalk BinSuk getting header: 'messageNumber' - '

    rc=SendMessage(sock,'head '||messageNumber)
    rc=getResponse(sock)

    parse var line.1 code number .

/*----------------------------------------------------------------------------*
 * code 421 - no more messages                                                *
 *----------------------------------------------------------------------------*/

    if code = 421 then do
      rc=clearScreen(startLine)
      rc=syscurpos(startline+1,3)
      say'                                                                          '

      rc=bloopSound(sound)

      rc=syscurpos(startline+1,3)
      text='All Done!'
      say text
      rc=log(logFileName,text)

      exit
      end /* if code */

/*----------------------------------------------------------------------------*
 * code 423 - this was a BAD message!                                         *
 *----------------------------------------------------------------------------*/

    if code = 423 then do
      rc=syscurpos(startline+8,3)
      say'Bad article count: '

      rc=bloopSound(sound)
      BadArticle = BadArticle + 1

      rc=syscurpos(startline+8,3)
      say'Bad article count: 'BadArticle

/* update group log file, so we can keep track of the LAST processed message */

      rc=groupLogFunctions(group,groupLogDir,messageNumber,'write')

      rc=CheckForKey()
      if rc=1 then halt()

      iterate

      end /* if code */

    do i = 1 to line.0
      parse var line.i name lineCount .

     if name = "Lines:" then leave
     end /* do i */

    do i = 1 to line.0
      parse var line.i subj subject

      if subj = "Subject:" then leave
      end /* do i */

/*----------------------------------------------------------------------------*
 * extract file suffix from subject line - not case sensitive                 *
 * Set lines var to 0 if a nondesired file - original code by Rob Chandler    *
 *----------------------------------------------------------------------------*/

    capSubject=translate(subject)
    longSubject=capSubject

    rc=CheckForFetch(longSubject)
    RJCNameEnd=rc

    if RJCNameEnd > 0 then do
      RJCNameEnd = 3 + RJCNameEnd
      RJCNameStart = 1 + lastpos(' ',subject, RJCNameEnd)
      RJCNameLength = 1 + RJCNameEnd - RJCNameStart
      tempSubject = substr(subject, RJCNameStart, RJCNameLength-4)
      subject = translate(tempSubject)
      end /* RJCNameEnd */

    if RJCNameEnd < 1 then do
      lineCount = 0
      end /* if RJCNameEnd */

    rc=CheckForTrash(longSubject)

    if rc=1 then do
      rc=syscurpos(startline+4,3)
      say'Skipping filename: 'subject
      rc=bloopSound(sound)
      TrashedFileCount=TrashedFileCount+1

      rc=syscurpos(startline+11,3)
      say'                                                                      '

      rc=syscurpos(startline+11,3)
      say'Trashed article count: 'TrashedFileCount

      iterate
      end /* if rc=1 */

    if rc=0 then do

      if lineCount > MINSIZE then do

        rc=CheckForDupes(startLine,duplicateLogDir,subject,longSubject)
        if rc = 0 then do

          '@icontalk BinSuk getting header: 'messageNumber' - "'subject'"'

          rc=syscurpos(startline+2,3)
          say'                                                                          '

          rc=syscurpos(startline+2,3)
          say subject' is not a duplicate...'

          rc=syscurpos(startline+3,3)
          say'                                                                          '

          rc=syscurpos(startline+3,3)
          say'Reading 'lineCount' lines from message number: 'number
          '@icontalk BinSuk reading 'linecount' lines from Msg# 'messageNumber

          rc=SendMessage(sock,'body '||number)

          readingMessage = 1
          rc=getResponse(sock)
          readingMessage = 0

          filename = systempfilename('temporary.?????','?')

          rc=syscurpos(startline+4,3)
          say'                                                                          '

          rc=syscurpos(startline+4,3)
          say'Writing 'lineCount' lines to: 'filename
          '@icontalk BinSuk writing 'linecount' to file'

          do i = 1 to line.0
            call lineout filename,line.i
            end /* do i */

          rc=stream(filename,'c','close')

          rc=syscurpos(startline+5,3)
          say'                                                                          '

          rc=syscurpos(startline+5,3)
          say'Extracting binary from :'filename
          '@icontalk BinSuk extracting binary...'

/*----------------------------------------------------------------------------*
 * check for inbound directory and create it if it doesn't exist!             *
 *----------------------------------------------------------------------------*/

          rc=sysMkDir(InBoundDir)
          if rc=0 then do
            text='Created a new InBound directory decoded binaries!'
            rc=log(logFileName, text)
            end /* if rc */

/*----------------------------------------------------------------------------*
 * extract .jpg file from mime using the uudeview program                     *
 *----------------------------------------------------------------------------*/

          '@uudeview.exe -i -f -o -p InBound 'filename' 1>nul 2>nul'

/*----------------------------------------------------------------------------*
 * update log file with extracted binary name                                 *
 *----------------------------------------------------------------------------*/

          filesize=stream(filename,'c','query size')
          rc=log(logFileName, 'The file "'subject'.JPG" in not a duplicate - 'filesize' bytes.')

          '@del 'filename' 1>nul 2>nul'

          rc=syscurpos(startline+5,3)
          say'                                                                          '

          rc=syscurpos(startline+5,3)
          say'Extracted!'

/*----------------------------------------------------------------------------*
 * update duplicate log file with extracted binary name                       *
 *----------------------------------------------------------------------------*/
          rc=updateDuplicateLog(startline,duplicateLogDir,subject)

          ExtractedBinaryCount = ExtractedBinaryCount + 1
          rc=syscurpos(startline+9,3)
          say'                                                                          '

          rc=syscurpos(startline+9,3)
          say'Extracted binaries: 'ExtractedBinaryCount

        end /* if rc checkfordupes */

        if rc=1 then rc=log(logFileName,'The file "'subject'.JPG" was a duplicate in the group "'group'"!')

      end /* if lineCount > MINSIZE */

    end /* if rc checkfortrash */

    rc=groupLogFunctions(group,groupLogDir,messageNumber,'write')

    rc=syscurpos(startline-4,29)
    say'                                  '

    rc=syscurpos(startline-4,29)
    say number

    processedcount = processedcount + 1

    rc=syscurpos(startline+12,3)
    say'Processed message count: 'processedcount

    if extractedBinaryCount > (maxCount - 1) then leave

    rc=CheckForKey()
    if rc=1 then halt()

    newMessageCount = newMessageCount -1

    if newMessageCount < 1 then newMessageCount = 0

    rc=syscurpos(6,3)
    say'                                                                          '

    rc = syscurpos(6,3)
    say'Newest message number on server: 'end1' (number of new messages: 'newMessageCount')'

  end /* do messageNumber */

/*----------------------------------------------------------------------------*
 * at end of main loop - all done                                             *
 *----------------------------------------------------------------------------*/

  rc=syscurpos(22,3)
  text='Finished processing newsgroup "'group'"'
  say text
  rc=log(logFileName,text)

  rc=SendMessage(sock,'quit')

  rc = SockSoclose(sock)

  rc=doneSound(sound)

  rc=log(logFileName, 'BinSuk - finished without errors')

  call syssleep 10

  exit

/*----------------------------------------------------------------------------*
 * close socket (and catch signals)                                           *
 *----------------------------------------------------------------------------*/

halt:

  rc=clearScreen(startLine)
  rc=clearTotals(startLine)

  rc=SendMessage(sock,'quit')

  rc = SockSoClose(sock)

  if (rc = -1) then do
    say''
    text='Error on SockSoClose: 'errno
    say text
    rc=log(logFileName,text)
    exit
    end

  exit

/*----------------------------------------------------------------------------*
 * get a line from the server                                                 *
 *----------------------------------------------------------------------------*/

GetResponseLine: procedure expose !.

  sock = arg(1)

  crlf = d2c(13)||d2c(10)

  if (symbol('!.buff') = "LIT") then !.buff = ""

  do while (pos(crlf,!.buff) = 0)
    rc = SockRecv(sock,"data",8192)
    !.buff = !.buff||data
  end /* do while */

  p = pos(crlf,!.buff)

  line = substr(!.buff,1,p-1)
  !.buff = substr(!.buff,p+2)

  return line

/*----------------------------------------------------------------------------*
 * get a response from the server                                             *
 *----------------------------------------------------------------------------*/

GetResponse: procedure expose !. line. readingMessage lineCount

  sock=arg(1)

  moreids = "100 215 220 221 222 223 230 231"

  line.0 = 1
  line.1 = GetResponseLine(sock)

  parse var line.1 rid msg

  if rid = 400 then do
    say'The server has closed the connection!'
    exit
  end /* if rid */

  if (wordpos(rid,moreids) = 0) then return ''

  blink = 0
  o = 0

  do forever

    o = line.0 + 1
    line.o = GetResponseLine(sock)

    if (line.o == ".") then return ''

    line.0 = o

    if readingMessage = 1 then do

      blink = blink + 1

      if blink > 5 then do
        rc=syscurpos(2,72)
        say format((( line.0 / lineCount) * 100),3,0)
        rc=syscurpos(2,72)
        blink = 0
        end /* if blink */

      end /* if readingMessage */

  end /* do forever */

  return ''


/*----------------------------------------------------------------------------*
 * send a string to the server, after adding the cr/lf pair                   *
 *----------------------------------------------------------------------------*/

SendMessage: procedure

  sock = arg(1)
  data = arg(2)||d2c(13)||d2c(10)

  len = length(data)

  do while (len > 0)

    i = SockSend(sock,data);

    if (errno <> 0) then do
      text='Error sending data to server!'
      say text
      rc=log(logFileName,text)
      exit
      end /* if */

    if (i <= 0) then do
      text='Server closed the connection!'
      say text
      rc=log(logFileName,text)
      exit
      end /* if */

    data = substr(data,len+1)
    len  = length(data)

  end /* do while */

  return 0

/*----------------------------------------------------------------------------*
 * check for duplicate messages                                               *
 *----------------------------------------------------------------------------*/

CheckForDupes: procedure expose duplicateCount

  startLine      =arg(1)
  duplicateLogDir=arg(2)
  subject        =arg(3)
  longSubject    =arg(4)

/* check for dupebase directory */

  do forever
    rc=sysMkDir(duplicateLogDir)
    if rc=5 then leave
  end

  IsADuplicate = 0

  rc=syscurpos(startline+2,3)
  say'                                                                          '

  rc=syscurpos(startline+2,3)
  say 'Waiting for duplicates file to be free...'

  prefix='\'||left(subject,1)

  do while stream(duplicateLogDir||prefix||'.log','c','open') <> 'READY:'
    call syssleep 2
    end /* do while */

  rc=syscurpos(startline+2,3)
  say'                                                                          '

  rc=syscurpos(startline+2,3)
  say'Checking 'subject' for duplicate status...'

  do while lines(duplicateLogDir||prefix||'.log')

    text=linein(duplicateLogDir||prefix||'.log')

    parse var text dupSubj'/'dupdate

      if subject = dupsubj then do
        rc=syscurpos(startline+2,3)
        say'                                                                          '

        rc=syscurpos(startline+2,3)
        say'====>Duplicate Subject - Ignoring Message<===='

        rc=syscurpos(startline+12,3)
        say'                                                                          '

        DuplicateCount = DuplicateCount + 1

        rc=syscurpos(startline+10,3)
        say'Duplicate article count: 'DuplicateCount

        rc=errorSound(sound)

        IsADuplicate = 1

        end /* if subject */

    rc=CheckForKey()
    if rc=1 then halt()

  end /* do while */

  call stream duplicateLogDir||prefix||'.log','c','close'

  return isADuplicate

tickSound: procedure

  SOUND=arg(1)

  if SOUND = 1 then do
    call beep 1500, 1
    call beep 1600, 1
    end /* if sound */

  return 0

bloopSound: procedure

  SOUND=arg(1)

  if SOUND = 1 then do
    call beep 1400, 1
    call beep 1500, 1
    end /* if sound */

  return 0

errorSound: procedure

  SOUND=arg(1)

  if SOUND = 1 then do
    call beep 400, 25
    call beep 500, 25
    end /* if sound */

    return 0

doneSound: procedure

  SOUND=arg(1)

  if Sound = 1 then do
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100

    end /* if sound */

  return 0

updateDuplicateLog: procedure

  startline=arg(1)
  duplicateLogDir=arg(2)
  subject=arg(3)

  rc=syscurpos(startline+6,3)
  say'                                                                          '

  rc=syscurpos(startline+6,3)
  say 'Waiting for duplicate log to be free...'

  prefix='\'||left(subject,1)

  do while stream(duplicateLogDir||prefix||'.log','c','open') <> 'READY:'
    call syssleep 2
    end /* do while */

  rc=syscurpos(startline+6,3)
  say'                                                                          '

  rc=syscurpos(startline+6,3)
  say'Updating duplicate list with new entry!'

  call stream  duplicateLogDir||prefix||'.log','c','seek <' 0
  call lineout duplicateLogDir||prefix||'.log', subject||'/'||date('b')
  call stream  duplicateLogDir||prefix||'.log','c','close'

  rc=syscurpos(startline+6,3)
  say'                                                                          '

  rc=syscurpos(startline+6,3)
  say'Updated duplicate log with new entry!'

  return 0

Log: procedure

  logFilename=arg(1)
  text       =arg(2)

  if logFileName = '' then return 1

  do while stream(logFileName,'c','open') <> 'READY:'
    call syssleep 2
    end /* do while */

  call stream  logfilename,'c','seek <' 0
  call lineout logfilename, date()||' '||time()||' 'text
  call stream  logfilename,'c','close'

  return 0

clearScreen: procedure

  startline = arg(1)

  rc=syscurpos(startline+1,3)
  say'-                                                                        '

  rc=syscurpos(startline+2,3)
  say'-                                                                        '

  rc=syscurpos(startline+3,3)
  say'-                                                                        '

  rc=syscurpos(startline+4,3)
  say'-                                                                        '

  rc=syscurpos(startline+5,3)
  say'-                                                                        '

  rc=syscurpos(startline+6,3)
  say'-                                                                        '

  rc=syscurpos(2,72)
  say'   '

  return 0

clearTotals: procedure

  startline=arg(1)

  rc=syscurpos(startline+8,3)
  say'Bad article count: 0                                                     '

  rc=syscurpos(startline+9,3)
  say'Extracted binaries: 0                                                    '

  rc=syscurpos(startline+10,3)
  say'Duplicate article count: 0                                               '

  rc=syscurpos(startline+11,3)
  say'Trashed article count: 0                                                 '

  rc=syscurpos(startline+12,3)
  say'Processed message count: 0                                               '

  return 0

/*----------------------------------------------------------------------------*
 * The following routine checks for possible waiting key strokes,             *
 * indicating that the user wishes to terminate this run of BinSuk            *
 *----------------------------------------------------------------------------*/

CheckForKey: procedure

  rc=0

  if chars() then key = SysGetKey('noecho')
  if key = ' ' then rc=1

  return rc

/*----------------------------------------------------------------------------*
 * The following routine draws a boarder around the console. Designed and     *
 * generated using THEDRAW for DOS                                            *
 *----------------------------------------------------------------------------*/

drawBoarder: procedure expose version

  version = arg(1)

  say'[?7h[40m[2J[0;1m<> BinSuk 'version' - mcbrides@erols.com <>Ŀ'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say''

  return 0

loadLibraries: procedure

/*----------------------------------------------------------------------------*
 * load the rexx utility package if not already in memory                     *
 *----------------------------------------------------------------------------*/
  if RxFuncQuery('SysLoadFuncs') then do
    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    call SysLoadFuncs
    end /* if */

/*----------------------------------------------------------------------------*
 * load the rxsock package if not already in memory                           *
 *----------------------------------------------------------------------------*/
  if RxFuncQuery('SockLoadFuncs') then do
    call RxFuncAdd 'SockLoadFuncs','RxSock','SockLoadFuncs'
    call SockLoadFuncs('Quiet')
    end /* if */

  return 0


/*----------------------------------------------------------------------------*
 * get address of server : rc=0 error, rc=1 ok                                *
 *----------------------------------------------------------------------------*/

BSgetHostByName: procedure

  server=arg(1)

  rc = SockGetHostByName(server,"host.!")

/*  server = host.!addr */

  if rc = 0 then host.!addr=0

  return host.!addr

/*----------------------------------------------------------------------------*
 * get name of server : rc=0 error, rc=1 ok                                   *
 *----------------------------------------------------------------------------*/

BSgetHostByAddr: procedure

  server=arg(1)

  rc = SockGetHostByAddr(server,"host.!")

/*  server = host.!addr */

  if rc = 0 then host.!name=0

  return host.!name

/*----------------------------------------------------------------------------*
 * open socket                                                                *
 *----------------------------------------------------------------------------*/

BSSockSocket: procedure

 sock = SockSocket("AF_INET","SOCK_STREAM",0)

 return sock

/*----------------------------------------------------------------------------*
 * configure socket for large buffers:                                        *
 * on some test machines, buffers larger than 16k caused this setting to be   *
 * ignored.                                                                   *
 *----------------------------------------------------------------------------*/

BSSockSetSockOpt: procedure

  sock=arg(1)

  rc = SockSetSockOpt(sock, 'SOL_SOCKET', 'SO_RCVBUF', 16384)

  return rc

/*----------------------------------------------------------------------------*
 * connect socket                                                             *
 *----------------------------------------------------------------------------*/

BSSockConnect: procedure

  sock=arg(1)
  server=arg(2)

  server.!family = "AF_INET"
  server.!port   = 119
  server.!addr   = server

  rc = SockConnect(sock,"server.!")

  return rc

/*----------------------------------------------------------------------------*
 * check for unwanted junk 0=okay to keep, 1=trash it!                        *
 *----------------------------------------------------------------------------*/

CheckForTrash: procedure

  rc=0

  testText=arg(1)

  BinSukTrash='BinSuk.trash'

  if stream(BinSukTrash,'c','query exists') ='' then return rc

  do while stream(BinSukTrash,'c','open') <> 'READY:'
    call syssleep 2
    end /* do while */

  do while lines(BinSukTrash)

    text=strip(translate(linein(BinSukTrash)))
      if pos('#',text)\=1 then do
        if text\='' then do
          if pos(text,testText) > 0 then do
            rc=1
           end /* if pos(test */
        end /* if text */
      end /* if pos( */
  end /* do while */

  call stream  BinSukTrash,'c','close'

  return rc

/*----------------------------------------------------------------------------*
 * check for wanted messages 0=skip it, 1=fetch it!                           *
 *----------------------------------------------------------------------------*/

CheckForFetch: procedure

  testText=arg(1)
  BinSukFetch='BinSuk.fetch'

  match=0

  if stream(BinSukFetch,'c','query exists') ='' then do
    match=pos('.JPG',testText)
    return match
    end /* if stream */

  do while stream(BinSukFetch,'c','open') <> 'READY:'
    call syssleep 2
    end /* do while */

  do while lines(BinSukFetch)

    text=strip(translate(linein(BinSukFetch)))
    if pos('#',text)=1 then iterate
    if text='' then iterate

    match=pos(text,testText)
    if match>0 then leave

  end /* do while */

  call stream  BinSukFetch,'c','close'

  return match

/*----------------------------------------------------------------------------*
 * update the group log with the last message number processed                *
 *                                                                            *
 * organized for easy porting to java                                         *
 *----------------------------------------------------------------------------*/

groupLogFunctions: procedure

  group        =arg(1)
  groupLogDir  =arg(2)
  groupData    =arg(3)
  groupFunction=arg(4)

  lastRead=0

  rc=sysMkDir(groupLogDir)

  if groupFunction='read' then do
    lastRead = linein(groupLogDir||'\'||group||'.log')
    call stream groupLogDir||'\'||group||'.log','c','close'
    return lastRead
    end /* read */

  if groupFunction='write' then do
    call lineout groupLogDir||'\'||group||'.log', groupData, 1
    call stream groupLogDir||'\'||group||'.log','c','close'
    return 0
    end /* write */

  return 0

