/* AgeDuplicates.cmd - Used to purge old duplicate log file entries */

  duplicateLogDir='DuplicateLogs'
  totalSaved=0
  totalKilled=0

/* check for dupebase directory */

  rc=sysFileTree(duplicateLogDir,'dir.','d')

  if dir.0=0 then do
    say"Sorry, I can't fing the duplicate logfile directory: "duplicateLogDir
    say''
    rc=errorSound(1)
    exit
    end /* if rc */

  parse arg days .

  if datatype(days) \= 'NUM' then do
    say'Sorry, you must specify a number!'
    say
    rc=errorSound(1)
    exit
    end

  say'Aging the log files by "'days'" days...'
  say''

  rc=SysFileTree(duplicateLogDir||'\*.log','Log.','f')

  if rc \='0' then do
    say'Sorry, an error occured!'
    say
    exit
    end /* if rc */

  say'I found 'log.0' log file(s) to age...'
  say

  do i = 1 to log.0

    rc=sysFileDelete(duplicateLogDir||'\'||temp.log)
    parse var log.i logFileDate logFileTime logFileSize logFileAttributes logFileName

    logFileName=strip(logFileName)

    say'Processing the log file at: 'logFileName

    saved=0
    killed=0

    do while lines(logFileName)

      text=linein(logFileName)

      parse var text fileStub'/'fileDate

      if fileDate\='' then do
        age=date('b')-fileDate
        if age <= days then do
          rc=lineout(duplicateLogDir||'\'||'temp.log',text)
          saved=saved+1
          end /* if age */
        if age >=days+1 then killed=killed+1
        end /* if fileDate */

      end /* do while */

    rc=stream(duplicateLogDir||'\'||'temp.log','c','close')
    rc=stream(logFileName,'c','close')

    totalSaved=totalSaved+saved
    totalKilled=totalKilled+killed

    '@copy 'duplicateLogDir||'\'||'temp.log '||logFileName||' 1>nul 2>nul'
    rc=sysFileDelete(duplicateLogDir||'\'||'temp.log')
    if saved=0 then rc=sysFileDelete(logFileName)

  end /* do i= */

  rc=doneSound(1)

  say'Finished aging the log files'
  say''

  say'Total log entries saved: 'totalSaved
  say'Total log entries killed: 'totalKilled
  say

  exit

errorSound: procedure

  SOUND=arg(1)

  if SOUND = 1 then do
    call beep 400, 25
    call beep 500, 25
    end /* if sound */

    return 0

doneSound: procedure

  SOUND=arg(1)

  if Sound = 1 then do
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100

    end /* if sound */

  return 0



