/* 
* rbsmtp.c
*
* (c) Paul Vixie <paul@vix.com>
* 
* Ported to OS/2 and hacked to be useful for UUPC/Extended and IBM sendmail 
* by Jochen Friedrich <jochen@audio.ruessel.sub.org>.
* Please send bug reports for this port to me, not to the original author.
*
*/ 

/* sbsmtp - bsmtp sender
 * vix 28mar91 [written]
 * jof 28sep94 [ported to OS/2]
 */

/* purpose: takes mail on stdin, destination machine and receivers on command
 *      line. spawns "catbat SBSMTPDIR/DESTMACHINE", and feed catbat the bsmtp
 *	script without the HELO and QUIT lines.  we are separate from catbat
 *	because this way, only we need to know what bsmtp is, while catbat
 *	could be used, say, for input nntp batching.
 */

/* portability: none. this is intensely OS/2-specific, will not run on DOS. */

#define INCL_DOSFILEMGR
#define INCL_DOSQUEUES
#include <os2.h>

#include <direct.h>
#include <process.h>
#include <io.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include "sysexits.h"

#ifndef CATBAT
#define	CATBAT		"catbat.exe"
#endif

#define LONGEST_LINE	1024

int rmkdir(char *);
void make_fat(char *);
int strncasecmp(register unsigned char *, register unsigned char *,
		register unsigned int);

main(argc, argv, envp)
	int argc;
	char *argv[], *envp[];
{
	char	line[LONGEST_LINE], spooldir[LONGEST_LINE];
        char    fromaddr[LONGEST_LINE], *args[10], *ptr, *host;
	unsigned long 	pdes[2], i, tempfd, child, status;
	FILE	*fp;
	int	w, c_flag;

	c_flag = 0;
	ptr=argv[0];
	argc--;
	argv++;

	if (!strcmp(argv[0],"-c")) {
		c_flag=1;
		argc--;
		argv++;
	}

	if (argc < 3) {
		fprintf(stderr, "usage:  %s [-c] spooldir host recipients\n",
                        ptr);
		exit(EX_USAGE);
	}

	host = strdup(argv[1]);
	make_fat(host);

	if (c_flag) 		
		sprintf(spooldir, "%s\\%s\\bsmtp",argv[0],host);
	else
		sprintf(spooldir, "%s\\%s",argv[0],host);
	if (rmkdir(spooldir) < 0) {
		perror(spooldir);
		exit(EX_CANTCREAT);
	}

        fgets(line, LONGEST_LINE, stdin);
	if (strncmp(line, "From ", 5)) {
		perror("From ");
		exit(EX_USAGE);
        }
	ptr=line+5;
	while (*ptr && (*ptr != ' ') && (*ptr != '\n')) ptr++;
	*ptr=0;
	ptr=line+5;
	strcpy(fromaddr,ptr);

	/* what's the OS/2 version of popen() ? */

	args[0] = CATBAT;
	args[1] = spooldir;
	args[2] = NULL;

	if (DosCreatePipe(&(pdes[0]),&(pdes[1]),4096) < 0) {
                perror("popen");
		exit(EX_OSERR);
        }
        i=DosQueryFHState(pdes[1],&status);
        status |= OPEN_FLAGS_NOINHERIT;
        status &= 0x7f88;
	i=DosSetFHState(pdes[1],status);
	tempfd=dup(0);
	if (pdes[0] != 0) {
		dup2(pdes[0], 0);
	}
        close(pdes[0]);
	child=spawnvp(P_NOWAIT,CATBAT, args);
	dup2(tempfd, 0);
        close(tempfd);
	if ((fp = fdopen(pdes[1], "wb")) == NULL) {
		perror("fdopen");
		exit(EX_OSERR);
	}
        sprintf(line,"MAIL FROM: <%s>\n",fromaddr);
        fputs(line,fp);
        for (i=2;i<argc;i++) {
        	sprintf(line,"RCPT TO: <%s>\n",argv[i]);
	        fputs(line,fp);
        }
        strcpy(line,"DATA\n");
        fputs(line,fp);
	while (fgets(line, LONGEST_LINE, stdin)) {
		fputs(line, fp);
	}
        strcpy(line,".\n");
        fputs(line,fp);
	fclose(fp);
	/* reuse our argc */
	if (child != wait(&w)) {
		perror("wait");
		exit(EX_OSERR);
	}
	exit(WEXITSTATUS(w));
}

int strncasecmp(register unsigned char *s1, register unsigned char *s2,
		register unsigned int n)
{
	register unsigned char c1 = 0, c2 = 0;

	while (n--) {
		if (c1 = *s1++, isupper(c1)) c1 = tolower(c1);
		if (c2 = *s2++, isupper(c2)) c2 = tolower(c2);
		if (c1 != c2) break;
	}
	return c1 - c2;
}

void make_fat(char *host)
{
	char *ptr1, *ptr2;
	int i;

	ptr1=host;
	ptr2=host;
	i=0;
	while ((i<8)&&(*ptr1)&&(*ptr1!='.')) {
		ptr1++;
		ptr2++;
		i++;
	}
	while ((*ptr1)&&(*ptr1!='.')) ptr1++;
	if (*ptr1) *ptr2++='.';
	while ((*ptr1)&&(*ptr1=='.')) ptr1++;
	i=0;
	while ((i<3)&&(*ptr1)&&(*ptr1!='.')) {
		*ptr2++ = *ptr1++;
		i++;
	}
	*ptr2=0;
}

int rmkdir(char *d)
{
	register char *p = d;
	register int r;

	while (*p) {
		if (*p=='/') *p='\\';
		p++;
	}

	p=d;

	while ((*p) && !(*p=='\\')) p++;

	while (*++p) {
		register char *q = strchr(p, '\\');
		if (q) { *q = '\0'; }
		r = mkdir(d);
		if (q) { *q = '\\'; p = q; }
		if (r < 0 && errno != EACCESS) {
			perror(d);
			break;
		}
		r = 0;
	} 
	return r;
}
