/* 
* rsmtp.c
* 
* Ported to OS/2 and hacked to be useful for UUPC/Extended and IBM sendmail 
* by Jochen Friedrich <jochen@audio.ruessel.sub.org>.
* Please send bug reports for this port to me, not to the original author.
*
*/ 

/*
 * RSMTP -- UUCP mail server.
 *
 */

#include <process.h>
#include <ctype.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <sys\stat.h>
#include "getopt.h"
#include "pipe.h"

void err(int, const char *, ...);
void usage(void);
void parse_addr(char **, char *, int);

int main(int argc, char *argv[])
{
	extern char *optarg;
	extern int errno, optind;
	FILE *fp;
	size_t fplen, fptlen, len;
	off_t offset;
	int ch, debug, i, j,pid, data, stat, recipients;
        unsigned long pdes[2], tempfd;
	char *addrp, *protocol, *p, *t;
	char *from_sys, *from_user;
	char *args[100], *recipient[100], buf[2048], lbuf[2048];

	debug = 0;
	protocol = "bsmtp";
	while ((ch = getopt(argc, argv, "P:T")) != EOF)
		switch (ch) {
		case 'T':
			debug = 1;
			break;
		case 'P':
			protocol = optarg;
			break;
		case '?':
		default:
			usage();
		}
	argc -= optind;
	argv += optind;

	if (argc)
		usage();

	from_sys = NULL;

	/* Get and nul-terminate the line. */
	if (fgets(lbuf, sizeof(lbuf), stdin) == NULL)
		exit (2);
	if ((p = strchr(lbuf, '\n')) == NULL)
		err(2, "line too long");
	*p = '\0';

	if (!strncmp(lbuf, "HELO ", 5))
		addrp = lbuf + 5;
	else err(2, "no BSMTP file");

	parse_addr(&from_sys,addrp,0);
	data = 0;
	recipients = 0;
	from_user = NULL;

	do {
		if (fgets(lbuf, sizeof(lbuf), stdin) == NULL)
			exit (2);
		if ((p = strchr(lbuf, '\n')) == NULL)
			err(2, "line too long");
		*p=0;
		if (data) {
			if (lbuf[0]=='.') {
				addrp=lbuf+1;
				if (!(*addrp)) {
					if (fclose(fp))
						err(5, NULL);

					if ((_cwait(&stat, pid, WAIT_CHILD)) == -1)
						err(5, "%s", "sendmail.exe");

					if ((stat&0xff))
						err(5, "%s: did not terminate normally", "sendmail.exe");

					if ((stat&0xff00))
						err(stat, "%s: terminated with %d (non-zero) status",
						    "sendmail.exe", (stat&0xff00)>>8);

					for (i=0;i<recipients;i++) free(recipient[recipients]);
					recipients=0;

					free(from_user);
					from_user=NULL;

					data=0;
				} else
					fprintf(fp, "%s\n", addrp);
			} else
				fprintf(fp, "%s\n", lbuf);
		} else {

			if (!strncmp(lbuf, "MAIL ", 5)) {
				if (from_user)
					err(2, "double FROM:");
				addrp = lbuf + 5;
				while (*addrp == ' ') addrp++;
				if (strncmp(addrp, "FROM:", 5))
					err(2, "syntax error");
				addrp +=5;
				parse_addr(&from_user,addrp,1);
			}
			if (!strncmp(lbuf, "RCPT ", 5)) {
				addrp = lbuf + 5;
				while (*addrp == ' ') addrp++;
				if (strncmp(addrp, "TO:", 3))
					err(2, "syntax error");
				addrp +=3;
				parse_addr(&recipient[recipients++],addrp,1);
			}
			if (!strncmp(lbuf, "DATA",4)) {
				data=1;
				i = 0;
				args[i++] = "sendmail.exe"; 

#ifdef OM_FLAG

				(void)sprintf(buf,"-oMs%s", from_sys);
				if ((args[i++] = strdup(buf)) == NULL) err(3, NULL);

				(void)sprintf(buf, "-oMr%s", protocol);
				if ((args[i++] = strdup(buf)) == NULL) err(3, NULL);
#endif

				(void)sprintf(buf, "-f %s", from_user);
				if ((args[i++] = strdup(buf)) == NULL) err(3, NULL);

				for (j=0;j<recipients;j++)
					args[i++] = recipient[j];
				args[i] = NULL;

				if (debug) {
					(void)fprintf(stderr, "Sendmail arguments:\n");
					for (i = 0; args[i]; i++)
						(void)fprintf(stderr, "\t%s\n", args[i]);
				}

				if (pipe(pdes) < 0)
					err(5, NULL);
				tempfd=dup(0);
				if (pdes[0] != 0) {
					dup2(pdes[0], 0);
				}
			        close(pdes[0]);
				pid=spawnvp(P_NOWAIT,"sendmail.exe", args);
				dup2(tempfd, 0);
		        	close(tempfd);
				if ((fp = fdopen(pdes[1], "w")) == NULL)
					err(5, NULL);
			}
			if (!strncmp(lbuf, "QUIT",4)) exit(0);
		}
	} while (1);
}

void parse_addr(char **buffer, char *string, int brackets)
{
	char *ptr, *ptr2;
	int  level;

	level = 1;
	ptr=string;
	while (*ptr == ' ') ptr++;
	if (*ptr=='<') ptr++;
	ptr2=ptr;
	while ((*ptr2)&&level) {
		if (*ptr2=='<') level++;
		if (*ptr2=='>') level--;
		if (level) ptr2++;
	}
	*ptr2=0;
	if (brackets) {
		*buffer=malloc(strlen(ptr)+3);
		sprintf(*buffer,"<%s>",ptr);
	} else {
		*buffer=strdup(ptr);
	}
}

void usage(void)
{
	(void)fprintf(stderr, "usage: rsmtp [-T] [-P protocol]\n");
	exit(4);
}

void err(int eval, const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	(void)fprintf(stderr, "rsmtp: ");
	(void)vfprintf(stderr, fmt, ap);
	va_end(ap);
	(void)fprintf(stderr, "\n");
	exit(eval);
}
