/*
*Ŀ
* 
* Matthias Schorer 
* 333/464 Bangna Place, Sanpawuth Road 
* Prakanong, Bangkok 10260 
* THAILAND 
* 
* DESCRIPTION: e-mail notifier with animated gif 
* 
* Copyright (c) 1997: Matthias Schorer matze@inorbit.com 
* 
* Permission to use, copy, modify, and distribute this software and 
* its documentation for commercial or non-commercial purposes 
* is hereby granted provided that this copyright notice 
* appears in all copies. 
*
*/

/**
* @(#)version 1.04 20-Sep-1997
* @(#)packet popnote.java
* @author Matthias Schorer
* <a href="mailto:matze@inorbit.com>matze@inorbit.com</a>
*
* @modified 09/12/1997 Matthias Schorer : 1.00 First Idea
* @modified 09/17/1997 Matthias Schorer : 1.01 Eliminate Quirk when used in 95
* @modified 09/17/1997 Matthias Schorer : 1.02 Use a semaphore to smoothen display
* @modified 09/18/1997 Matthias Schorer : 1.03 Start the checker thread even initial connection failed.
* Beep when mail arrives.
* @modified 09/20/1997 Matthias Schorer : 1.04 Redo the semaphore handling. Redo Mail check logic
*/


/* Standard includes */
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.* ;
import java.net.* ;
import java.io.* ;

/* Other includes */
import cimco.dialog.* ; // For the dialog classes
import jthomas.pop.* ; // For the POP3 classes


/**
 * This class does everything, it includes quite a few inner classes
 * to keep the program neat together. It was not intended for subclassing.
 *
 * This is my second java program and probably still more complicated
 * than it really had to be, but it works...
 */
public class PopNote extends Applet
       implements ActionListener, Runnable
{
   private Image e[] ; // Array for the GIF images
   private int NumPics = 36 ; // Number of GIFs
   private int PicIndex = 0 ; // Number of current picture
   private Window Display ; // The container for the animation
   private Image workspace = null ; // Used for double buffering
   private Graphics offscreen ; // Used for double buffering
   private Thread Runner = null ; // The thread which animates the picture
   private Thread Checker = null ; // The thread which checks for mail

   private pop3 PopServer = new pop3() ; // The pop client
   private static PopNote Pop ; // The main program
   private IniDialog IniDlg = null ; // The Setup dialog box
   private MailHeaderDisplay MailDlg ; // The Mail Dialog
   private MessageDisplay MsgDsp ; // The Message Display Window
   private PopupMenu Popup ; // The popup menu
   private AboutDialog AboutDlg ; // The about dialog box

   private popStatus PopStatus = new popStatus() ; // Error messages
   private MailCheck MChk = new MailCheck() ; // The Mail check method
   private int NumMsg = 0 ; // Number of received messages

   private Dimension ScreenBounds = new Dimension() ; // Stores the size of the screen


   private SystemInit SysIni = new SystemInit() ; // The structure which holds the saved information
   private RandomAccessFile IniFile = null ; // The ponote.ini file
   private static boolean Config = false ; // Configuration flag
   private Frame DummyFrame ; // The invisible dummy frame
   private Color Colors[] = new Color[16] ; // Array for the 17 system colors


   private int IniFileVersion = 2 ; // The format version of the INI file
   private String Version = "1.04" ; // The Program version number
   private boolean Sem = false ; // Semaphore to check paint state
                                     // it will make sure that the picture is completely painted
                                     // before the next image is drawn

   /**
    * The main routine checks for the command line
    * parameters. In fact there is only one and that's
    * -c = configuration
    * Then it calls init() .
    */
   public static void main(String args[])
   {
       Pop = new PopNote() ;

       if ( args.length == 1 ){
          if ( args[0].toLowerCase().compareTo("-c") == 0 ){
             Config = true ;
          } /* End If */
       } /* End If */

       Pop.init() ;
   } /* End Method */

   /**
    * This method does all the tricky work for the program
    */
   public void init()
   {
       boolean IniError = false ; // Was there an error reading the ini file
       int FileVersion ; // Storage for the file version

       DummyFrame = new Frame() ; // Create the dummy frame
                                  // We need something to contain
                                  // the component which displays
                                  // the pictures, and we we need
                                  // it for the message boxes.
                                  // But it is never made visible.


       ML ml = new ML() ; // Create the Mouse Listener (mouse adapter)
       WL wl = new WL() ; // Create the window listener (adapter)

       Rectangle DisplayBounds = new Rectangle() ; // Prepare the storage for sceen bounds
       Rectangle MessageBounds = new Rectangle() ; // prepare the storage for the message window

       DisplayBounds.width = 250 ; // That's how big we want the window
       DisplayBounds.height = 250 ;

       MessageBounds.width = 300 ; // That's the size of our message box
       MessageBounds.height = 40 ;

       e = new Image[NumPics] ; // Initialize the buffer for our pictures

       // Other variables get their initialization
       PicIndex = 0 ;
       Runner = null ;
       workspace = null ;
       offscreen = null ;
       e[0] = null ;

       // Load the pictures from the local directory
       for ( int x = 1; x <= NumPics; x ++
        ){ e[x-1]= getToolkit().getImage("e"+x+".gif") ;
       } /* End For */

       // Preset the color table
       Colors[0] = Color.black ;
       Colors[1] = Color.blue ;
       Colors[2] = Color.cyan ;
       Colors[3] = Color.darkGray ;
       Colors[4] = Color.gray ;
       Colors[5] = Color.green ;
       Colors[6] = Color.lightGray ;
       Colors[7] = Color.magenta ;
       Colors[8] = Color.orange ;
       Colors[9] = Color.pink ;
       Colors[10] = Color.red ;
       Colors[11] = Color.white ;
       Colors[12] = Color.yellow ;
       Colors[13] = SystemColor.desktop ;
       Colors[14] = SystemColor.window ;
       Colors[15] = SystemColor.desktop ; // should actually be transparent....

       // Create the checker thread
       Checker = new Thread(MChk) ;

       // Get the screen size
       ScreenBounds = getToolkit().getScreenSize() ;

       // Calculate the center for the display
       DisplayBounds.x = (ScreenBounds.width / 2) - (DisplayBounds.width / 2) ;
       DisplayBounds.y = (ScreenBounds.height / 2) - (DisplayBounds.height / 2);

       // Create the popup menu
       Popup = new PopupMenu("Disclosure Options") ;

       // Prepare the display window
       Display = new Window(DummyFrame) ;
       Display.addWindowListener(wl) ;
       Display.addMouseListener(ml) ;
       Display.setBounds(DisplayBounds) ;
       Display.setBackground(Colors[SysIni.Background]) ;
       Display.add(Popup) ;

       // Calculate the center for the dialog box
       MessageBounds.x = (ScreenBounds.width / 2) - (MessageBounds.width / 2) ;
       MessageBounds.y = (DisplayBounds.y + DisplayBounds.height + 10 );

       // Create the message box
       MsgDsp = new MessageDisplay(DummyFrame) ;
       MsgDsp.setBounds(MessageBounds) ;

       // Create the mail header display box
       MailDlg = new MailHeaderDisplay() ;
       MailDlg.addActionListener(this) ;

       // Create the About Dialog
       AboutDlg = new AboutDialog(DummyFrame) ;
       AboutDlg.addActionListener(this) ;

       // Initialize the popup menu
       Popup.add("hide animation") ;
       Popup.add("view message headers") ;
       Popup.addSeparator() ;
       Popup.add("configure") ;
       Popup.add("about") ;
       Popup.addSeparator() ;
       Popup.add("shutdown") ;
       Popup.addActionListener(this) ;

       // Open the INI file
       try { IniFile = new RandomAccessFile("popnote.ini", "r") ; }
       catch ( IOException e
          ){ IniError = true ;
       } /* End Catch*/ 

       // if it doesn't exist, display the setup dialog
       if ( IniError == true ){
          Config = true ;
          IniDlg = new IniDialog(DummyFrame) ;
          IniDlg.addActionListener(this) ;
          IniDlg.setVisible(true) ;
       } else {
           // read the parameters
           try {
             FileVersion = IniFile.readInt() ;
             SysIni.PopAddress = IniFile.readUTF() ;
             SysIni.PopPort = IniFile.readInt() ;
             SysIni.UserName = IniFile.readUTF() ;
             SysIni.Password = IniFile.readUTF() ;
             SysIni.MailProg = IniFile.readUTF() ;
             SysIni.SleepTime = IniFile.readInt() ;
             SysIni.Animation = IniFile.readInt() ;

             // in case someone uses version 1.00 and the
             // old ini file type, then force setup dialog
             // so that the background color, which was
             // added in version 1.01, is set to default.
             if ( FileVersion == 2 ){
                SysIni.Background = IniFile.readInt() ;
             } else {
                Config = true; // someone uses am old ini file, so run setup !
             } /* End If */

             IniFile.close() ;
           }
           catch ( IOException e
              ){ System.out.println("Could not read from popnote.ini, aborting !") ;
                 System.exit(0) ;
           } /* End Catch*/ 

           // This is true either when the program was called
           // with the -c option, or when the ini file has
           // old format, or when the ini file does not
           // exist.
           if ( Config == true ){
              IniDlg = new IniDialog(DummyFrame) ;
              IniDlg.addActionListener(this) ;
              IniDlg.setVisible(true) ;
           } /* End If */
       } /* End If */

       // From here on we try to connect.....
       System.out.println("\"Disclosure\" POP3 Notifier Version: " + Version + " by Matthias Schorer 1997") ;

       System.out.println("Trying to connect, please wait....") ;

       if ( PopServer != null ){
          PopStatus = PopServer.connect(SysIni.PopAddress, SysIni.PopPort) ;

          if ( PopStatus.OK() == true ){
             PopStatus = PopServer.login(SysIni.UserName, SysIni.Password) ;

             if ( PopStatus.OK() == true ){
                System.out.println("Connected to POP3 server at: " + SysIni.PopAddress +":"+SysIni.PopPort) ;
                PopServer.quit() ;
                Checker.start() ;
             } else {
                System.out.println("POP Server did not accept username / password") ;
                System.exit(0) ;
             } /* End If */
          } else {
             System.out.println("Could not connect to POP Server at: "+ SysIni.PopAddress + ":" + SysIni.PopPort + " trying later again") ;
             // but we start the checker thread anyway, maybe the system goes on-line later
             Checker.start() ;
          } /* End If */
       } else {
          System.out.println("Could not Initialize PopRequester") ;
          System.exit(0) ;
       } /* End If */
   } /* End Method */

   /**
    * This is the standard paint method, but I
    * made it synchronized so that the thread
    * does not call the method before the picture is
    * fully painted !
    */
   public  synchronized void paint(Graphics g)
   {
          // Check the semaphore
          if ( Sem == true ){
             return ;
          } else {
             Sem = true ;
          } /* End If */

          try {
             // Check the init() was ok
             if ( workspace != null && (e[0] != null) ){

                // This is the double buffering trick
                // Paint into a virtual screen first
                // and the display all
                offscreen.setColor(Colors[SysIni.Background]) ;
                offscreen.fillRect(0, 0, Display.getBounds().width, Display.getBounds().height) ;
                offscreen.drawImage(e[PicIndex], 30, 10, null) ;
                g.drawImage(workspace, 0, 0, Display) ;
             } /* End If */
          }
          catch ( NullPointerException n ){ } /* End Catch*/  ;

          // OK done, reset semaphore
          Sem = false ;
   } /* End Method */

   /**
    * This is the Thread which updates the
    * pictures
    */
   public  void run()
   {
         while(true
         ){
           // Free some processor time and sleep
           try { Thread.sleep(90); }
           catch ( InterruptedException e ){ } /* End Catch*/ 

           paint(Display.getGraphics()) ;

           // Get the index for a new picture
           // depending what animation speed the
           // user has choses we advance 1, 2,
           // or 3 pictures
           PicIndex = PicIndex + SysIni.Animation;

           if ( PicIndex > (NumPics - 1) ){
              PicIndex = 0 ;
           } /* End If */
         } /* End For */
   } /* End Method */

   public  void hideAnimation()
   {
          if ( Runner != null ){
             Runner.stop() ;
             Runner = null ;
          } /* End If */
          Display.setVisible(false) ;

          Sem = false;
   } /* End Method */

   /**
    * Standard actionListener method. Called
    * whenever an action (button, menu) etc
    * has been called
    */
   public  void actionPerformed(ActionEvent e)
   {
          // This handles all the pop menu stuff
          if ( e.getSource() == Popup ){
             String Cmd = new String() ;
             Cmd = e.getActionCommand() ;

             if ( Cmd.equals("hide animation") ){
                hideAnimation() ;
             } /* End If */

             if ( Cmd.equals("view message headers") ){
                hideAnimation() ;

                MailDlg.read() ;
                MailDlg.setVisible(true) ;
             } /* End If */

             if ( Cmd.equals("configure") ){
                hideAnimation() ;

                IniDlg = new IniDialog(DummyFrame) ;
                IniDlg.addActionListener(this) ;
                IniDlg.setVisible(true) ;
             } /* End If */

             if ( Cmd.equals("about") ){
                hideAnimation() ;

                AboutDlg.setVisible(true) ;
             } /* End If */

             if ( Cmd.equals("shutdown") ){
                hideAnimation() ;

                if ( Checker != null ){
                   Checker.stop() ;
                   Checker = null ;
                } /* End If */

                System.exit(0) ;
             } /* End If */
          } /* End If */

          // This handles the setup dialog
          if ( IniDlg != null ){
             if ( e.getSource() == IniDlg.Esc ){
                IniDlg.setVisible(false) ;
                IniDlg.dispose() ;
                if ( Config == true ){
                   System.exit(0) ;
                } /* End If */
             } /* End If */

             if ( e.getSource() == IniDlg.Save ){
                IniDlg.setVisible(false) ;
                IniDlg.dispose() ;

                // If the ini file does not exist, create one
                if ( new File("popnote.ini").exists() == false ){
                   try { new BufferedOutputStream(new FileOutputStream("popnote.ini")); }
                   catch ( IOException IOe
                      ){ System.out.println("Could not create file popnote.ini !") ;
                         System.exit(0) ;
                   } /* End Catch*/ 
                } /* End If */

                try { IniFile = new RandomAccessFile("popnote.ini", "rw") ; }
                catch ( IOException IOe
                   ){ System.out.println("Could not open popnote.ini for writing !") ;
                      System.exit(0) ;
                } /* End Catch*/ 

                // Write info into ini file
                try {
                   IniFile.writeInt(IniFileVersion) ;
                   IniFile.writeUTF(SysIni.PopAddress) ;
                   IniFile.writeInt(SysIni.PopPort) ;
                   IniFile.writeUTF(SysIni.UserName) ;
                   IniFile.writeUTF(SysIni.Password) ; // attention password ! encrypted !
                   IniFile.writeUTF(SysIni.MailProg) ;
                   IniFile.writeInt(SysIni.SleepTime) ;
                   IniFile.writeInt(SysIni.Animation) ;
                   IniFile.writeInt(SysIni.Background) ;
                   IniFile.close() ;
                }
                catch ( IOException IOe
                   ){ System.out.println("Could not write to popnote.ini, aborting !") ;
                      System.exit(0) ;
                } /* End Catch*/ 
             } /* End If */
          } /* End If */

          // this handles the Mail Header display
          if ( MailDlg != null ){
             if ( e.getSource() == MailDlg.Ok ){
                MailDlg.setVisible(false) ;
             } /* End If */

             if ( e.getSource() == MailDlg.Launch ){
                MailDlg.setVisible(false) ;
                LaunchReader() ;
             } /* End If */
          } /* End If */

          // This handles the about dialog
          if ( e.getSource() == AboutDlg.Ok ){
             AboutDlg.setVisible(false) ;
          } /* End If */
   } /* End Method */

   /**
    * This method launches the mail reader
    * There is a quirk which I found in the
    * OS/2 java. When you try to run a CMD file
    * exec() wants to call xxx.cmd.exe and this
    * of cause fails. In windows you can call
    * batch files with exec().....
    */
   private  void LaunchReader()
   {
           if ( SysIni.MailProg.length() > 0 ){
              if ( new File(SysIni.MailProg).exists() == true ){
                 Runtime Rt = Runtime.getRuntime() ;
                 try { Rt.exec(SysIni.MailProg) ; }
                 catch ( IOException IOe ){ } /* End Catch*/  ;
              } /* End If */
           } /* End If */
   } /* End Method */

   /**
    * This listenes to all which happens to the window
    */
   private class WL extends WindowAdapter
   {

       public  void windowOpened(WindowEvent e)
       {
           // On first opening initialize
           if ( offscreen == null ){
              workspace = Display.createImage(Display.getBounds().width, Display.getBounds().height) ;
              offscreen = workspace.getGraphics() ;

              PicIndex = 0 ;
           } /* End If */

           if ( Runner == null ){
              Runner = new Thread(Pop) ;
              Runner.start() ;
           } /* End If */
       } /* End Method */


       public  void windowClosing(WindowEvent e)
       {

              // When the program is shut down, stop everyting
              hideAnimation() ;

              if ( Checker != null ){
                 Checker.stop() ;
              } /* End If */
       } /* End Method */
   } /* End Class */

   /**
    * This listenes to all mouse events
    */
   private class ML extends MouseAdapter
   {
           public  void mouseReleased(MouseEvent e)
           {
                  // Right button pressed ?
                  // launch the popup menu
                  if ( e.isPopupTrigger() ){
                     Button bDummy = new Button() ;
                     Display.add(bDummy) ;
                     Popup.show(bDummy, e.getX(), e.getY()) ;
                     Display.remove(bDummy) ;
                  } else {
                     // Left button, just launch the mail reader
                     Pop.hideAnimation() ;
                     Pop.LaunchReader() ;
                  } /* End If */
           } /* End Method */


           public  void mouseEntered(MouseEvent e)
           {
                  // Display the number of messages
                  MsgDsp.setVisible(true) ;
                  MsgDsp.toFront() ;
           } /* End Method */


           public  void mouseExited(MouseEvent e)
           {
                  // speakes for itself ...
                  MsgDsp.setVisible(false) ;
           } /* End Method */
   } /* End Class */


   /**
    * This is the thread which checks for the mail
    * in an user defined interval
    */
   private class MailCheck
           implements Runnable
   {
           int NewNumMsg ;

           public  void run()
           {

              while(true
              ){
                try { Thread.sleep(SysIni.SleepTime * 1000); }
                catch ( InterruptedException e ){ } /* End Catch*/ 

                PopStatus = PopServer.connect(SysIni.PopAddress, SysIni.PopPort) ;

                if ( PopStatus.OK() == true ){
                   PopStatus = PopServer.login(SysIni.UserName, SysIni.Password) ;

                   if ( PopStatus.OK() == true ){
                      NewNumMsg = PopServer.get_TotalMsgs() ;
                   } else {
                      System.out.println("Username / Password not accepted ") ;
                   } /* End If */
                } /* End If */


                if ( NewNumMsg > 0 ){
                   // Only when new messages arrive, pop up again
                   if ( NewNumMsg > NumMsg ){
                      MsgDsp.setNumMsg(NewNumMsg) ;
                      DummyFrame.getToolkit().beep();
                      DummyFrame.toFront() ;
                      Display.setVisible(true) ;
                      Display.toFront() ;
                      Display.requestFocus() ;

                      if ( Runner == null ){
                         Runner = new Thread(Pop) ;
                         Runner.start() ;
                      } /* End If */

                      NumMsg = NewNumMsg ; // Remember the current number of messages
                   } /* End If */
                } else {
                   NumMsg = 0 ;
                } /* End If */

                if ( PopStatus.OK() == true ){
                   PopServer.quit() ;
                } /* End If */
              } /* End For */
           } /* End Method */
   } /* End Class */

   /**
    * This class displays the number of messages received
    */
   private class MessageDisplay extends Window
   {
           Label NumberString = new Label("", Label.CENTER) ;
           int Length ;

           // Constructor
           public  MessageDisplay(Frame f)
           {
                  super(f) ;

                  Font ft= new Font("Helvetica", Font.ITALIC, 20);
                  setFont(ft) ;
                  setBackground(Color.lightGray) ;
                  add(NumberString) ;
           } /* End Method */

           // This is called by the checker thread
           // to update the number of messages
           public  void setNumMsg(int NumMsg)
           {
                  if ( NumMsg > 1 ){
                     NumberString.setText("You have " + NumMsg + " new messages") ;
                  } else {
                     NumberString.setText("You have " + NumMsg + " new message") ;
                  } /* End If */
           } /* End Method */
   } /* End Class */

   /**
    * This class is the structure for the system variables
    */
   private class SystemInit
   {
           public String PopAddress ; // Hmmm, how to describe it better ?
           public int PopPort = 110 ;
           public String UserName ;
           public String Password ;
           public String MailProg ; // The program to launch
           public int SleepTime = 60 ; // Check interval in seconds
           public int Animation = 1 ; // Animation resolution
           public int Background = 6 ; // lightGray ;
   } /* End Class */

   /**
    * This class creates the setup dialog box
    * which pops up when the ini file does not
    * exist or when the user wants it to pop up
    */
   private class IniDialog extends Dialog
           implements ActionListener
   {
           private Font StandardFont = null ;
           public Button Save = new Button("Save") ;
           public Button Esc = new Button("Escape") ;
           public Button Credits = new Button("Credits") ;
           public Button Browse = new Button("Browse") ;
           private ActionListener AL = null ;
           private Label L1 = new Label("Server Address", Label.LEFT) ;
           private Label L2 = new Label("Port Number", Label.LEFT) ;
           private Label L3 = new Label("User Name", Label.LEFT) ;
           private Label L4 = new Label("Password", Label.LEFT) ;
           private Label L5 = new Label("POP mail program", Label.LEFT) ;
           private Label L6 = new Label("Check Interval (sec)", Label.LEFT) ;
           private Label L7 = new Label("Animation", Label.LEFT) ;
           private Label L8 = new Label("Background", Label.LEFT) ;
           private TextField T[] = new TextField[5] ;
           private Choice C1 = new Choice() ; // Check interva;
           private Choice C2 = new Choice() ; // Animation
           private Choice C3 = new Choice() ; // Color
           private MessageDialog MsgDlg ; // Error Message Box
           private FileDialog FD ; // Standard File Dialog Box

           public  IniDialog(Frame DummyFrame)
           {
                  super(DummyFrame, "\"Disclosure\" POP notifier setup", true) ;

                  Rectangle Bounds = new Rectangle() ;

                  setBounds(ScreenBounds.width/2 - 225, ScreenBounds.height / 2 - 125, 450, 250) ;

                  FD = new FileDialog(DummyFrame, "Browse for e-mail reader", FileDialog.LOAD) ;
                  Bounds = FD.getBounds() ;
                  FD.setBounds(ScreenBounds.width/2 - 100, ScreenBounds.height /2 - 100, Bounds.width, Bounds.height) ;

                  setLayout(null) ;
                  StandardFont = getFont() ;

                  setFont(new Font("Helvetica", Font.PLAIN, 12));

                  Save.setBounds(5, 220, 60 ,25) ;
                  Save.addActionListener(this) ;
                  Save.setFont(StandardFont) ;

                  Esc.setBounds(75, 220, 60 ,25) ;
                  Esc.addActionListener(this) ;
                  Esc.setFont(StandardFont) ;

                  Credits.setBounds(145, 220, 60 ,25) ;
                  Credits.addActionListener(this) ;
                  Credits.setFont(StandardFont) ;

                  Browse.setBounds(250, 180, 60 ,25) ;
                  Browse.addActionListener(this) ;
                  Browse.setFont(StandardFont) ;

                  L1.setBounds(5, 40, 110, 25) ;
                  L2.setBounds(5, 75, 110, 25) ;
                  L3.setBounds(5, 110, 110, 25) ;
                  L4.setBounds(5, 145, 110, 25) ;
                  L5.setBounds(5, 180, 110, 25) ;

                  L6.setBounds(250, 40, 120, 25) ;
                  L7.setBounds(250, 75, 100, 25) ;
                  L8.setBounds(250, 110, 100, 25) ;

                  for ( int x = 0 ; x <= 4; x ++
                   ){ T[x] = new TextField() ;
                  } /* End For */

                  T[0].setBounds(130, 40, 110, 25) ;
                  T[1].setBounds(130, 75, 110, 25) ;
                  T[2].setBounds(130, 110, 110, 25) ;
                  T[3].setBounds(130, 145, 110, 25) ;
                  T[4].setBounds(130, 180, 110, 25) ;

                  T[0].setText(SysIni.PopAddress) ;
                  T[1].setText(new String().valueOf(SysIni.PopPort)) ;
                  T[2].setText(SysIni.UserName) ;
                  T[3].setText(SysIni.Password) ;
                  T[4].setText(SysIni.MailProg) ;

                  C1.setBounds(380, 40, 60, 25) ;
                  for ( int x = 1; x <= 480; x ++
                   ){ C1.add(new String().valueOf(x)) ;
                  } /* End For */

                  C2.setBounds(350, 75, 90, 25) ;
                  C2.add("smooth") ;
                  C2.add("medium") ;
                  C2.add("coarse") ;

                  C3.setBounds(350, 110, 90, 25) ;
                  C3.add("black") ;
                  C3.add("blue") ;
                  C3.add("cyan") ;
                  C3.add("dark gray") ;
                  C3.add("gray") ;
                  C3.add("green") ;
                  C3.add("light gray") ;
                  C3.add("magenta") ;
                  C3.add("orange") ;
                  C3.add("pink") ;
                  C3.add("red") ;
                  C3.add("white") ;
                  C3.add("yellow") ;
                  C3.add("desktop") ;
                  C3.add("window") ;
                  C3.add("transparent") ;

                  C1.select(SysIni.SleepTime - 1) ;
                  C2.select(SysIni.Animation - 1) ;
                  C3.select(SysIni.Background) ;

                  // Add all the labels
                  add(L1) ; add(L2) ; add(L3) ; add(L4) ; add(L5) ;
                  add(L6); add(L7) ; add(L8) ;

                  // Add all the text fields
                  add(T[0]) ; add(T[1]) ; add(T[2]) ; add(T[3]) ; add(T[4]) ;
                  add(Browse) ;

                  add(C1) ;
                  add(C2) ;
                  add(C3) ;

                  // Add all the Buttons;
                  add(Save) ; add(Esc) ; add(Credits) ;

                  MsgDlg = new MessageDialog(DummyFrame, "Input Error", "") ;
                  MsgDlg.addActionListener(this) ;

                  Bounds = MsgDlg.getBounds() ;

                  MsgDlg.setBounds(ScreenBounds.width/2 - Bounds.width/2, ScreenBounds.height / 2 - Bounds.height/2, Bounds.width, Bounds.height) ;
           } /* End Method */

           /**
            * Here the action Listener performs the task
            * oh checking the input fields when the
            * Save button is pressed
            */
           public  void actionPerformed(ActionEvent e)
           {
                  int Error = -1 ;
                  String Tmp ;

                  // Just close the dialog box, no save
                  if ( e.getSource() == MsgDlg.Ok ){
                     MsgDlg.setVisible(false) ;
                     return ;
                  } /* End If */

                  // Save Button pressed, check entries
                  if ( e.getSource() == Save ){

                     Error = testFields(); // This method does the cheking
                                           // -1 = no error
                                           // any other number == index of input field

                     if ( Error != -1 ){
                        T[Error].requestFocus() ;
                     } else {
                        // Ok, everything milli vanilli, go ahead and
                        // save the ini file
                        SysIni.PopAddress = T[0].getText() ;

                        try { SysIni.PopPort = new Integer(T[1].getText()).intValue() ; }
                        catch ( NumberFormatException dummy ){ } /* End Catch*/  ;

                        SysIni.UserName = T[2].getText() ;
                        SysIni.Password = T[3].getText() ;
                        SysIni.MailProg = T[4].getText() ;

                        SysIni.SleepTime = C1.getSelectedIndex() + 1 ;
                        SysIni.Animation = C2.getSelectedIndex() + 1 ;
                        SysIni.Background = C3.getSelectedIndex() ;

                        // Convey the message to the calling program
                        // in this case to main, the actual save
                        // is done there !
                        if ( (AL != null) ){
                           AL.actionPerformed(e) ;
                        } /* End If */
                     } /* End If */
                  } /* End If */

                  if ( e.getSource() == Esc ){
                     // The the main program to close the box
                     // and don't fo anything
                     if ( AL != null ){
                        AL.actionPerformed(e) ;
                     } /* End If */
                  } /* End If */

                  // Popup the file dialog
                  if ( e.getSource() == Browse ){
                     FD.setVisible(true) ;
                     T[4].setText(FD.getDirectory() + FD.getFile()) ;
                  } /* End If */

                  // Show the about dialog box
                  if ( e.getSource() == Credits ){
                     AboutDlg.setVisible(true) ;
                  } /* End If */
           } /* End Method */


           /**
            * Stores the action listener of the calling program
            */
           public  void addActionListener(ActionListener a)
           {
                  if ( AL == null ){
                     AL = a ;
                  } /* End If */
           } /* End Method */

           /**
            * Removes it again
            */
           public  void removeActionListener()
           {
                  if ( AL != null ){
                     AL = null ;
                  } /* End If */
           } /* End Method */

           /**
            * Test all the input fields for validity
            */
           private  int testFields()
           {
                   String Tmp ; // Just some helper variables
                   char Char ;
                   int iTmp ;
                   int RetVal = -1 ;
                   int DotCount = 0 ;

                   // Perform basic tests on the address
                   // Is it ot blank ? Does it have three dots
                   // (xx.xxx.xxx.xxx) and does it only contain
                   // numbers
                   Tmp = T[0].getText().trim() ;
                   if ( Tmp.length() == 0 ){
                      MsgDlg.setText("POP server IP address must be entered in the format xxx.xxx.xxx.xxx") ;
                      MsgDlg.setVisible(true) ;
                      return 0 ;
                   } else {
                      for ( int x = 0; x < Tmp.length(); x ++
                       ){ Char = Tmp.charAt(x) ;
                          if ( (Character.isDigit(Char) == false) && (Char != '.') ){
                             MsgDlg.setText("This seems not to be a proper IP address. Please enter address in the format xxx.xxx.xxx.xxx") ;
                             MsgDlg.setVisible(true) ;
                             return 0 ;
                          } else {
                             if ( Char == '.' ){
                                ++ DotCount ;
                             } /* End If */
                          } /* End If */
                      } /* End For */

                      if ( DotCount != 3 ){
                         MsgDlg.setText("This seems not to be a proper IP address. Please enter address in the format xxx.xxx.xxx.xxx") ;
                         MsgDlg.setVisible(true) ;
                         return 0 ;
                      } /* End If */
                   } /* End If */

                   // Test the port number
                   Tmp = T[1].getText().trim() ;
                   if ( Tmp.length() == 0 ){
                      MsgDlg.setText("Port must be entered. The default port for POP in most systems is 110") ;
                      MsgDlg.setVisible(true) ;
                      T[1].setText("110") ;
                      return 1 ;
                   } else {
                      // Ooops, alphabet entered ?
                      try { iTmp = new Integer(T[1].getText()).intValue() ; }
                      catch ( NumberFormatException dummy
                         ){ MsgDlg.setText("Only values between 1 to 65535 are allowed !") ;
                            MsgDlg.setVisible(true);
                            return 1 ;
                      } /* End Catch*/ 

                      // Too big, too small ?
                      if ( iTmp < 1 || iTmp > 65535 ){
                         MsgDlg.setText("Only values between 1 to 65535 are allowed !") ;
                         MsgDlg.setVisible(true);
                         return 1 ;
                      } /* End If */
                   } /* End If */

                   // Test the username
                   Tmp = T[2].getText().trim() ;
                   if ( Tmp.length() == 0 ){
                      MsgDlg.setText("Your POP username must be entered") ;
                      MsgDlg.setVisible(true) ;
                      return 2 ;
                   } /* End If */

                   // Test the password
                   Tmp = T[3].getText().trim() ;
                   if ( Tmp.length() == 0 ){
                      MsgDlg.setText("Your password must be entered") ;
                      MsgDlg.setVisible(true) ;
                      return 3 ;
                   } /* End If */

                   // Test the mail program
                   Tmp = T[4].getText().trim() ;
                   if ( Tmp.length() > 0 ){
                      // check for file existence
                      if ( new File(Tmp).exists() == false ){
                         MsgDlg.setText("The program " + Tmp + " does not exist !") ;
                         MsgDlg.setVisible(true) ;
                        return 4 ;
                      } /* End If */
                   } /* End If */

                   return RetVal ;
           } /* End Method */
   } /* End Class */

   /**
    * This class Reads the messages, and then
    * displays sender and subject. Another
    * java quirk here. First it extended a dialog
    * which works fine under OS/2, but under
    * WIN NT and 95 the list box wouldn't display
    * any scroll bars, so I changed in to extend a frame.
    * No big dealm but ya have to know about it ....
    */
   private class MailHeaderDisplay extends Frame
           implements WindowListener
   {
           public Button Ok = new Button("Ok") ;
           public Button Launch = new Button("Launch Mail Reader") ;
           private List Mail = new List(10) ;
           private ActionListener AL = null ;

           // Constructor
           public  MailHeaderDisplay()
           {
                  super("View mail headers") ;

                  Rectangle Bounds = new Rectangle() ;
                  setBounds(0, 0, 500, 350) ;
                  setLayout(null) ;
                  setResizable(true) ;
                  setBackground(Color.lightGray) ;

                  Ok.setBounds(5, 320, 60, 25) ;
                  Launch.setBounds(80, 320, 150, 25) ;

                  Mail.setBounds(5, 30, 490, 280) ;

                  addWindowListener(this) ;
                  add(Ok) ;
                  add(Launch) ;
                  add(Mail) ;
           } /* End Method */

           /**
            * Do the repaint bit when the window is resized
            * This makes sure that the components are getting
            * sized as well (except for the buttons....)
            */
           public  void repaint()
           {
                  Rectangle Bounds = new Rectangle() ;

                  Bounds = getBounds() ;

                  Mail.setBounds(5, 30, Bounds.width - 10, Bounds.height - 70) ;

                  Ok.setBounds(5, Bounds.height-30, 60, 25) ;
                  Launch.setBounds(80, Bounds.height - 30, 150, 25) ;

                  super.repaint() ;
           } /* End Method */

           /**
            * Reads the mail. In fact J. Thomas' POP3 class
            * provides a method top(x,n) to read only
            * the n upper lines of a mail x, but it did
            * not work with our mail server (NT with FTGATE)
            * so I decided to read the whole mail. I tested
            * it with a 900 KByte attachement and it
            * worked without hickup....
            */
           public synchronized  void read()
           {
                  int NumMsg ; // Number of messages
                  String MessageLine[] ; // Message Buffer
                  String Tmp = "" ;
                  MessageDialog WaitMsg = new MessageDialog(this, "INFORMATION", "Please wait, reading messages from server. This could take a while...") ;

                  // Displays the "wait" dialog
                  WaitMsg.setModal(false) ;
                  WaitMsg.setVisible(true) ;

                  // Clear the listbox everytime
                  if ( Mail.getItemCount() > 0 ){
                     Mail.removeAll() ;
                  } /* End If */

                  // The usual game ....
                  PopStatus = PopServer.connect(SysIni.PopAddress, SysIni.PopPort) ;

                  if ( PopStatus.OK() == true ){
                     PopStatus = PopServer.login(SysIni.UserName, SysIni.Password) ;
                     if ( PopStatus.OK() == true ){
                        NumMsg = PopServer.get_TotalMsgs() ;

                        // Read all messages, and assemble the
                        // line with FROM and SUBJECT field
                        for ( int x = 1; x <= NumMsg; x ++
                         ){ PopStatus = PopServer.retr(x) ;
                            if ( PopStatus.OK() == true ){
                               MessageLine = PopStatus.Responses() ;

                               for ( int y = 0 ; y < MessageLine.length; y ++
                                ){ if ( MessageLine[y].startsWith("From:") ){
                                      Tmp = MessageLine[y] + "  " ;
                                   } /* End If */

                                   if ( MessageLine[y].startsWith("Subject:") ){
                                      Tmp = Tmp + MessageLine[y] ;
                                      Mail.add(Tmp) ;
                                      break ;
                                   } /* End If */
                               } /* End For */
                            } else {
                               // In case reading fails, show the error
                               // in the listbox as well
                               Mail.add(PopStatus.Response()) ;
                            } /* End If */
                        } /* End For */
                     } /* End If */
                  } /* End If */
                  // Always try
                  PopServer.quit() ;

                  // Close the wait dialog
                  WaitMsg.setVisible(false) ;
                  WaitMsg.dispose() ;
           } /* End Method */

           /**
            * Adds the action Listener for this dialog box
            * and connects it directly to the buttons
            */
           public  void addActionListener(ActionListener a)
           {
                  if ( AL == null ){
                     AL = a ;
                     Ok.addActionListener(AL) ;
                     Launch.addActionListener(AL) ;
                  } /* End If */
           } /* End Method */

           /**
            * gues what ...
            */
           public  void removeActionListener()
           {
                  if ( AL != null ){
                     Ok.removeActionListener(AL) ;
                     Launch.removeActionListener(AL) ;
                     AL = null ;
                  } /* End If */
           } /* End Method */

           public  void windowActivated(WindowEvent e)
           {
           } /* End Method */

           public  void windowClosed(WindowEvent e)
           {
           } /* End Method */

           /**
            * If someone presses the X (close) button on the window
            * or chooses close from the standard menu, then tell
            * the calling program that Ok was pressed....
            */
           public  void windowClosing(WindowEvent e)
           {
                  ActionEvent newEvent = new ActionEvent(this.Ok, ActionEvent.ACTION_PERFORMED, "Ok", 0) ;
                  if ( AL != null ){
                     AL.actionPerformed(newEvent) ;
                  } /* End If */
           } /* End Method */

           public  void windowDeactivated(WindowEvent e)
           {
           } /* End Method */

           public  void windowDeiconified(WindowEvent e)
           {
           } /* End Method */

           public  void windowIconified(WindowEvent e)
           {
           } /* End Method */

           public  void windowOpened(WindowEvent e)
           {
           } /* End Method */

   } /* End Class */

   /**
    * This class provides the odd about box
    * But to make it a bit more interesting
    * the text is read from a text file (popnote.txt)
    */
   private class AboutDialog extends CenterDialog
   {
           private TextArea Msg = new TextArea("", 40, 30, TextArea.SCROLLBARS_VERTICAL_ONLY) ;
           public Button Ok = new Button("Ok") ;
           private ActionListener AL ;
           private String MessageText ;
           private boolean IOErr = false ;
           private RandomAccessFile TxtFile = null ;
           private String Tmp ;

           // Constructor
           public  AboutDialog(Frame Parent)
           {
                  super(Parent, "", true, 350, 420) ;
                  setBounds(ScreenBounds.width/2 - 175, 100, 350, 420) ;
                  setTitle("The \"disclosure\" POP watcher Version: " + Version);

                  setLayout(null) ;
                  setResizable(false) ;

                  Msg.setBounds(5, 30, 340, 350) ;

                  Ok.setBounds(5, 385, 60, 25) ;

                  add(Msg) ;
                  add(Ok) ;

                  // Try to open the Text file
                  try { TxtFile = new RandomAccessFile("popnote.txt", "r") ; }
                  catch ( IOException e
                     ){ IOErr = true ;
                  } /* End Catch*/ 

                  if ( IOErr == false ){
                     MessageText = "" ;
                     try {
                        while(true
                            ){ Tmp = TxtFile.readLine() ; // Read until finished
                               if ( Tmp != null ){
                                  MessageText = MessageText + Tmp ;
                               } else {
                                  break ;
                               } /* End If */
                        } /* End For */
                     }
                     catch ( IOException e
                        ){ ;
                     } /* End Catch*/ 

                     try { TxtFile.close() ; }
                     catch ( IOException e ){ ; } /* End Catch*/ 
                  } /* End If */

                  // set the text of the TextArea
                  Msg.setText(MessageText) ;
           } /* End Method */

           /**
            * ..... oh yeah, again ....
            */
           public  void addActionListener(ActionListener a)
           {
                  if ( AL == null ){
                     AL = a ;
                     Ok.addActionListener(AL) ;
                  } /* End If */
           } /* End Method */

           /**
            * .... mhhhmmm ....
            */
           public  void removeActionListener()
           {
                  if ( AL != null ){
                     Ok.removeActionListener(AL) ;
                     AL = null ;
                  } /* End If */
           } /* End Method */
  } /* End Class */
} /* End Class */

