/*
 * Decompiled with CFR 0.152.
 */
package sunw.html;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import sunw.html.DTD;
import sunw.html.DTDConstants;

public final class Entity
implements DTDConstants {
    String name;
    int type;
    char[] data;
    static Hashtable entityTypes = new Hashtable();

    Entity(String string, int n, char[] cArray) {
        this.name = string;
        this.type = n;
        this.data = cArray;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type & 0xFFFF;
    }

    public boolean isParameter() {
        return (this.type & 0x40000) != 0;
    }

    public boolean isGeneral() {
        return (this.type & 0x10000) != 0;
    }

    public char[] getData() {
        return this.data;
    }

    public String getString() {
        return new String(this.data, 0, this.data.length);
    }

    public Reader getInputReader() throws IOException {
        if ((this.type & 0xA) != 0) {
            InputStream inputStream = DTD.mapping.get(this.getString()).openStream();
            return new InputStreamReader(inputStream);
        }
        if ((this.type & 0x11) != 0) {
            InputStream inputStream = new URL(DTD.mapping.base, this.getString()).openStream();
            return new InputStreamReader(inputStream);
        }
        return new CharArrayReader(this.data);
    }

    public void print() {
        if (this.isParameter()) {
            return;
        }
        System.out.print("<!ENTITY ");
        System.out.print(this.name);
        switch (this.getType()) {
            case 10: {
                System.out.print(" PUBLIC");
                break;
            }
            case 1: {
                System.out.print(" CDATA");
                break;
            }
            case 11: {
                System.out.print(" SDATA");
                break;
            }
            case 12: {
                System.out.print(" PI");
                break;
            }
            case 13: {
                System.out.print(" STARTTAG");
                break;
            }
            case 14: {
                System.out.print(" ENDTAG");
                break;
            }
            case 15: {
                System.out.print(" MS");
                break;
            }
            case 16: {
                System.out.print(" MD");
                break;
            }
        }
        System.out.print(" \"" + this.getString() + "\"");
        System.out.println(">");
    }

    static int name2type(String string) {
        Integer n = (Integer)entityTypes.get(string);
        if (n == null) {
            return 1;
        }
        return n;
    }

    static {
        entityTypes.put("PUBLIC", new Integer(10));
        entityTypes.put("CDATA", new Integer(1));
        entityTypes.put("SDATA", new Integer(11));
        entityTypes.put("PI", new Integer(12));
        entityTypes.put("STARTTAG", new Integer(13));
        entityTypes.put("ENDTAG", new Integer(14));
        entityTypes.put("MS", new Integer(15));
        entityTypes.put("MD", new Integer(16));
        entityTypes.put("SYSTEM", new Integer(17));
    }
}

