/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.awt.FontMetrics;

public class ScalingFontMetrics
extends FontMetrics {
    private double scaleFactor;
    private FontMetrics target;

    public ScalingFontMetrics(FontMetrics fontMetrics, double d) {
        super(fontMetrics.getFont());
        this.target = fontMetrics;
        this.scaleFactor = d;
    }

    public int getLeading() {
        return this.scale(this.target.getLeading());
    }

    public int getAscent() {
        return this.scale(this.target.getAscent());
    }

    public int getDescent() {
        return this.scale(this.target.getDescent());
    }

    public int getHeight() {
        return this.scale(this.target.getHeight());
    }

    public int getMaxAscent() {
        return this.scale(this.target.getMaxAscent());
    }

    public int getMaxDescent() {
        return this.scale(this.target.getMaxDescent());
    }

    public int getMaxAdvance() {
        int n = this.target.getMaxAdvance();
        if (n == -1) {
            return n;
        }
        return this.scale(n);
    }

    public int charWidth(int n) {
        return this.scale(this.target.charWidth(n));
    }

    public int charWidth(char c) {
        return this.scale(this.target.charWidth(c));
    }

    public int stringWidth(String string) {
        return this.scale(this.target.stringWidth(string));
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        return this.scale(this.target.charsWidth(cArray, n, n2));
    }

    public int bytesWidth(byte[] byArray, int n, int n2) {
        return this.scale(this.target.bytesWidth(byArray, n, n2));
    }

    public int[] getWidths() {
        return this.scaleArray(this.target.getWidths());
    }

    public String toString() {
        return String.valueOf(this.target.toString()) + ", scale factor: " + this.scaleFactor;
    }

    private int scale(int n) {
        return (int)((double)n * this.scaleFactor + 0.5);
    }

    private int[] scaleArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = this.scale(nArray[n]);
            ++n;
        }
        return nArray2;
    }
}

