/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCheckComm;
import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPUrl;
import netscape.ldap.LDAPv3;
import netscape.ldap.client.JDAPAVA;
import netscape.ldap.client.JDAPMessage;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPAddRequest;
import netscape.ldap.client.opers.JDAPBindRequest;
import netscape.ldap.client.opers.JDAPCompareRequest;
import netscape.ldap.client.opers.JDAPDeleteRequest;
import netscape.ldap.client.opers.JDAPExtendedRequest;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNRequest;
import netscape.ldap.client.opers.JDAPModifyRequest;
import netscape.ldap.client.opers.JDAPResult;
import netscape.ldap.client.opers.JDAPSearchRequest;
import netscape.ldap.controls.LDAPPersistentSearchControl;

public class LDAPConnection
implements LDAPv3,
Cloneable {
    public static final int LDAP_VERSION = 2;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";
    private static final String defaultFilter = "(objectClass=*)";
    private static final LDAPSearchConstraints readConstraints = new LDAPSearchConstraints();
    private transient LDAPSearchConstraints defaultConstraints = new LDAPSearchConstraints();
    private transient Vector responseListeners;
    private transient Vector searchListeners;
    private transient boolean bound;
    private transient String host;
    private transient String[] m_hostList;
    private transient int port = -1;
    private transient int[] m_portList;
    private transient int m_defaultPort;
    private transient String boundDN;
    private transient String boundPasswd;
    private transient int protocolVersion = 2;
    private transient LDAPSocketFactory m_factory;
    private transient LDAPConnThread th;
    private transient Vector m_attachedList = new Vector();
    private transient Hashtable m_responseControlTable = new Hashtable();
    private static final Float SdkVersion = new Float(3.01f);
    private static final Float ProtocolVersion = new Float(3.0f);
    private static final String SecurityVersion = new String("none,simple");
    private static final Float MajorVersion = new Float(0.9f);
    private static final Float MinorVersion = new Float(0.1f);
    private static boolean isCommunicator = LDAPConnection.checkCommunicator();
    private static final boolean debug = false;

    public LDAPConnection() {
        this.m_factory = null;
    }

    public LDAPConnection(LDAPSocketFactory lDAPSocketFactory) {
        this.m_factory = lDAPSocketFactory;
    }

    public void finalize() throws LDAPException {
        if (this.th != null) {
            this.disconnect();
        }
    }

    public Object getProperty(String string) throws LDAPException {
        if (string.equals(LDAP_PROPERTY_SDK)) {
            return SdkVersion;
        }
        if (string.equals(LDAP_PROPERTY_PROTOCOL)) {
            return ProtocolVersion;
        }
        if (string.equals(LDAP_PROPERTY_SECURITY)) {
            return SecurityVersion;
        }
        if (string.equals("version.major")) {
            return MajorVersion;
        }
        if (string.equals("version.minor")) {
            return MinorVersion;
        }
        return null;
    }

    void setProperty(String string, Object object) throws LDAPException {
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthenticationDN() {
        return this.boundDN;
    }

    public String getAuthenticationPassword() {
        return this.boundPasswd;
    }

    public boolean isConnected() {
        return this.th != null;
    }

    public boolean isAuthenticated() {
        return this.bound;
    }

    public void connect(String string, int n) throws LDAPException {
        this.connect(string, n, null, null);
    }

    public void connect(String string, int n, String string2, String string3) throws LDAPException {
        Object object;
        if (this.th != null) {
            this.disconnect();
        }
        if (string == null) {
            throw new LDAPException("no host for connection", 89);
        }
        this.m_defaultPort = n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.m_hostList = new String[stringTokenizer.countTokens()];
        this.m_portList = new int[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n3 = ((String)object).indexOf(58);
            if (n3 > 0) {
                this.m_hostList[n2] = ((String)object).substring(0, n3);
                this.m_portList[n2] = Integer.parseInt(((String)object).substring(n3 + 1));
            } else {
                this.m_hostList[n2] = object;
                this.m_portList[n2] = this.m_defaultPort;
            }
            ++n2;
        }
        object = null;
        n2 = 0;
        while (n2 < this.m_hostList.length) {
            try {
                this.host = this.m_hostList[n2];
                this.port = this.m_portList[n2];
                this.connect();
                object = null;
                break;
            }
            catch (LDAPException lDAPException) {
                object = lDAPException;
                ++n2;
            }
        }
        if (object != null) {
            this.host = this.m_hostList[0];
            this.port = this.m_defaultPort;
            throw object;
        }
        if (string2 != null && string3 != null) {
            this.authenticate(string2, string3);
        }
    }

    private synchronized void connect() throws LDAPException {
        if (this.th != null) {
            return;
        }
        if (this.host == null || this.port < 0) {
            throw new LDAPException("no connection parameters", 89);
        }
        try {
            this.th = new LDAPConnThread(this.host, this.port, this.m_factory);
            this.th.register(this);
            return;
        }
        catch (Exception exception) {
            throw new LDAPException("unable to establish connection", 52);
        }
    }

    public void abandon(LDAPSearchResults lDAPSearchResults) throws LDAPException {
        if (this.th == null || lDAPSearchResults == null) {
            return;
        }
        lDAPSearchResults.abandon();
        int n = lDAPSearchResults.getID();
        this.th.abandon(n);
        this.th.sendRequest(new JDAPAbandonRequest(n), null, this.defaultConstraints);
    }

    public void authenticate(String string, String string2) throws LDAPException {
        this.authenticate(2, string, string2);
    }

    public void authenticate(int n, String string, String string2) throws LDAPException {
        if (this.th == null) {
            this.connect();
        }
        this.boundDN = string;
        this.boundPasswd = string2;
        this.bind(n);
    }

    private void bind(int n) throws LDAPException {
        if (this.th == null) {
            this.connect();
        }
        if (this.bound) {
            this.disconnect();
            this.connect();
        }
        this.protocolVersion = n;
        if (this.boundDN == null || this.boundPasswd == null) {
            this.bound = false;
            return;
        }
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            this.th.sendRequest(new JDAPBindRequest(this.protocolVersion, this.boundDN, this.boundPasswd), lDAPResponseListener, this.defaultConstraints);
            JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
            this.checkMsg(jDAPMessage);
        }
        finally {
            Object var5_4 = null;
            this.releaseResponseListener(lDAPResponseListener);
        }
        this.bound = true;
    }

    private void bind() throws LDAPException {
        this.bind(2);
    }

    public synchronized void disconnect() throws LDAPException {
        if (this.th == null) {
            throw new LDAPException("unable to disconnect() without connecting", 80);
        }
        this.deregisterConnection();
    }

    synchronized void deregisterConnection() {
        this.th.deregister(this);
        this.th = null;
        this.bound = false;
    }

    public LDAPEntry read(String string) throws LDAPException {
        return this.read(string, null);
    }

    public LDAPEntry read(String string, String[] stringArray) throws LDAPException {
        return this.read(string, stringArray, this.defaultConstraints);
    }

    private LDAPEntry read(String string, String[] stringArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = this.search(string, 0, defaultFilter, stringArray, false, lDAPSearchConstraints);
        if (lDAPSearchResults == null) {
            return null;
        }
        return lDAPSearchResults.next();
    }

    public static LDAPEntry read(LDAPUrl lDAPUrl) throws LDAPException {
        String string = lDAPUrl.getHost();
        int n = lDAPUrl.getPort();
        if (string == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] stringArray = lDAPUrl.getAttributeArray();
        String string2 = lDAPUrl.getDN();
        LDAPConnection lDAPConnection = new LDAPConnection();
        lDAPConnection.connect(string, n);
        LDAPEntry lDAPEntry = lDAPConnection.read(string2, stringArray);
        lDAPConnection.disconnect();
        return lDAPEntry;
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl) throws LDAPException {
        return LDAPConnection.search(lDAPUrl, null);
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        String string = lDAPUrl.getHost();
        int n = lDAPUrl.getPort();
        if (string == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] stringArray = lDAPUrl.getAttributeArray();
        String string2 = lDAPUrl.getDN();
        String string3 = lDAPUrl.getFilter();
        if (string3 == null) {
            string3 = defaultFilter;
        }
        int n2 = lDAPUrl.getScope();
        LDAPConnection lDAPConnection = new LDAPConnection();
        lDAPConnection.connect(string, n);
        LDAPSearchResults lDAPSearchResults = lDAPSearchConstraints != null ? lDAPConnection.search(string2, n2, string3, stringArray, false, lDAPSearchConstraints) : lDAPConnection.search(string2, n2, string3, stringArray, false);
        lDAPSearchResults.closeOnCompletion(lDAPConnection);
        return lDAPSearchResults;
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl) throws LDAPException {
        return this.search(string, n, string2, stringArray, bl, this.defaultConstraints);
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (this.th == null) {
            this.connect();
        }
        if (!this.bound) {
            this.bind(2);
        }
        LDAPSearchListener lDAPSearchListener = this.getSearchListener();
        LDAPSearchResults lDAPSearchResults = new LDAPSearchResults();
        int n2 = lDAPSearchConstraints.getDereference();
        JDAPSearchRequest jDAPSearchRequest = new JDAPSearchRequest(string, n, n2, lDAPSearchConstraints.getMaxResults(), lDAPSearchConstraints.getTimeLimit(), bl, string2, stringArray);
        this.th.sendRequest(jDAPSearchRequest, lDAPSearchListener, lDAPSearchConstraints);
        if (lDAPSearchConstraints.getBatchSize() == 0) {
            try {
                try {
                    JDAPMessage jDAPMessage = lDAPSearchListener.getResponse();
                    Enumeration enumeration = lDAPSearchListener.getSearchResults();
                    if (!enumeration.hasMoreElements()) {
                        this.checkMsg(jDAPMessage);
                    }
                    while (enumeration.hasMoreElements()) {
                        lDAPSearchResults.add(((JDAPMessage)enumeration.nextElement()).getProtocolOp());
                    }
                }
                catch (LDAPReferralException lDAPReferralException) {
                    LDAPSearchResults[] lDAPSearchResultsArray = new LDAPSearchResults[1];
                    this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 3, string, n, string2, stringArray, bl, null, null, null, lDAPSearchResultsArray, null);
                    LDAPSearchResults lDAPSearchResults2 = lDAPSearchResultsArray[0];
                    Object var13_23 = null;
                    this.releaseSearchListener(lDAPSearchListener);
                    return lDAPSearchResults2;
                }
                catch (LDAPException lDAPException) {
                    throw lDAPException;
                }
                Object var13_24 = null;
                this.releaseSearchListener(lDAPSearchListener);
            }
            catch (Throwable throwable) {
                Object var13_25 = null;
                this.releaseSearchListener(lDAPSearchListener);
                throw throwable;
            }
        }
        JDAPMessage jDAPMessage = lDAPSearchListener.nextResult();
        if (jDAPMessage == null) {
            jDAPMessage = lDAPSearchListener.getResponse();
            try {
                try {
                    this.checkMsg(jDAPMessage);
                }
                catch (LDAPReferralException lDAPReferralException) {
                    LDAPSearchResults[] lDAPSearchResultsArray = new LDAPSearchResults[1];
                    this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 3, string, n, string2, stringArray, bl, null, null, null, lDAPSearchResultsArray, null);
                    LDAPSearchResults lDAPSearchResults3 = lDAPSearchResultsArray[0];
                    Object var14_14 = null;
                    this.releaseSearchListener(lDAPSearchListener);
                    return lDAPSearchResults3;
                }
                catch (LDAPException lDAPException) {
                    throw lDAPException;
                }
                Object var14_15 = null;
                this.releaseSearchListener(lDAPSearchListener);
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                this.releaseSearchListener(lDAPSearchListener);
                throw throwable;
            }
        }
        lDAPSearchResults.add(jDAPMessage.getProtocolOp());
        LDAPControl[] lDAPControlArray = (LDAPControl[])LDAPConnection.getOption(12, lDAPSearchConstraints);
        if (lDAPControlArray != null && lDAPControlArray.length > 0) {
            int n3 = 0;
            while (n3 < lDAPControlArray.length) {
                if (lDAPControlArray[n3] instanceof LDAPPersistentSearchControl) {
                    lDAPSearchResults.associatePersistentSearch(lDAPSearchListener);
                    return lDAPSearchResults;
                }
                ++n3;
            }
        }
        lDAPSearchResults.associate(lDAPSearchListener);
        return lDAPSearchResults;
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute) throws LDAPException {
        return this.compare(string, lDAPAttribute, this.defaultConstraints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean compare(String string, LDAPAttribute lDAPAttribute, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPResponseListener lDAPResponseListener;
        block11: {
            boolean bl;
            block10: {
                if (this.th == null) {
                    this.connect();
                }
                if (!this.bound) {
                    this.bind(2);
                }
                lDAPResponseListener = this.getResponseListener();
                Enumeration enumeration = lDAPAttribute.getByteValues();
                byte[] byArray = (byte[])enumeration.nextElement();
                String string2 = "";
                try {
                    string2 = new String(byArray, "UTF8");
                }
                catch (Throwable throwable) {}
                JDAPAVA jDAPAVA = new JDAPAVA(lDAPAttribute.getName(), string2);
                try {
                    try {
                        this.th.sendRequest(new JDAPCompareRequest(string, jDAPAVA), lDAPResponseListener, lDAPSearchConstraints);
                        JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
                        int n = ((JDAPResult)((Object)jDAPMessage.getProtocolOp())).getResultCode();
                        if (n == 5) {
                            boolean bl2 = false;
                            Object var12_15 = null;
                            this.releaseResponseListener(lDAPResponseListener);
                            return bl2;
                        }
                        if (n == 6) {
                            bl = true;
                            break block10;
                        }
                        this.checkMsg(jDAPMessage);
                        break block11;
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                        boolean[] blArray = new boolean[1];
                        this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 14, string, 0, null, null, false, null, null, lDAPAttribute, null, blArray);
                        boolean bl3 = blArray[0];
                        Object var12_17 = null;
                        this.releaseResponseListener(lDAPResponseListener);
                        return bl3;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    this.releaseResponseListener(lDAPResponseListener);
                    throw throwable;
                }
            }
            Object var12_16 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return bl;
        }
        Object var12_18 = null;
        this.releaseResponseListener(lDAPResponseListener);
        return false;
    }

    public void add(LDAPEntry lDAPEntry) throws LDAPException {
        this.add(lDAPEntry, this.defaultConstraints);
    }

    private void add(LDAPEntry lDAPEntry, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (this.th == null) {
            this.connect();
        }
        if (!this.bound) {
            this.bind(2);
        }
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[lDAPAttributeSet.size()];
        int n = 0;
        while (n < lDAPAttributeSet.size()) {
            lDAPAttributeArray[n] = lDAPAttributeSet.elementAt(n);
            ++n;
        }
        try {
            try {
                this.th.sendRequest(new JDAPAddRequest(lDAPEntry.getDN(), lDAPAttributeArray), lDAPResponseListener, lDAPSearchConstraints);
                JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 8, null, 0, null, null, false, null, lDAPEntry, null, null, null);
            }
            Object var9_9 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        String string;
        if (this.th == null) {
            this.connect();
        }
        if (!this.bound) {
            this.bind(2);
        }
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        JDAPMessage jDAPMessage = null;
        byte[] byArray = null;
        LDAPSearchConstraints lDAPSearchConstraints = this.defaultConstraints;
        try {
            try {
                this.th.sendRequest(new JDAPExtendedRequest(lDAPExtendedOperation.getID(), lDAPExtendedOperation.getValue()), lDAPResponseListener, lDAPSearchConstraints);
                jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
                JDAPExtendedResponse jDAPExtendedResponse = (JDAPExtendedResponse)jDAPMessage.getProtocolOp();
                byArray = jDAPExtendedResponse.getValue();
                string = jDAPExtendedResponse.getID();
            }
            catch (LDAPReferralException lDAPReferralException) {
                LDAPExtendedOperation lDAPExtendedOperation2 = this.performExtendedReferrals(lDAPReferralException, lDAPSearchConstraints, lDAPExtendedOperation);
                Object var9_10 = null;
                this.releaseResponseListener(lDAPResponseListener);
                return lDAPExtendedOperation2;
            }
            Object var9_11 = null;
            this.releaseResponseListener(lDAPResponseListener);
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
        return new LDAPExtendedOperation(string, byArray);
    }

    public void modify(String string, LDAPModification lDAPModification) throws LDAPException {
        this.modify(string, lDAPModification, this.defaultConstraints);
    }

    private void modify(String string, LDAPModification lDAPModification, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPModification[] lDAPModificationArray = new LDAPModification[]{lDAPModification};
        this.modify(string, lDAPModificationArray, lDAPSearchConstraints);
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet) throws LDAPException {
        this.modify(string, lDAPModificationSet, this.defaultConstraints);
    }

    private void modify(String string, LDAPModificationSet lDAPModificationSet, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPModification[] lDAPModificationArray = new LDAPModification[lDAPModificationSet.size()];
        int n = 0;
        while (n < lDAPModificationSet.size()) {
            lDAPModificationArray[n] = lDAPModificationSet.elementAt(n);
            ++n;
        }
        this.modify(string, lDAPModificationArray, lDAPSearchConstraints);
    }

    private void modify(String string, LDAPModification[] lDAPModificationArray) throws LDAPException {
        this.modify(string, lDAPModificationArray, this.defaultConstraints);
    }

    private void modify(String string, LDAPModification[] lDAPModificationArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (this.th == null) {
            this.connect();
        }
        if (!this.bound) {
            this.bind(2);
        }
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        JDAPMessage jDAPMessage = null;
        try {
            try {
                this.th.sendRequest(new JDAPModifyRequest(string, lDAPModificationArray), lDAPResponseListener, lDAPSearchConstraints);
                jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 6, string, 0, null, null, false, lDAPModificationArray, null, null, null, null);
            }
            Object var7_7 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public void delete(String string) throws LDAPException {
        this.delete(string, this.defaultConstraints);
    }

    private void delete(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (this.th == null) {
            this.connect();
        }
        if (!this.bound) {
            this.bind(2);
        }
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            try {
                this.th.sendRequest(new JDAPDeleteRequest(string), lDAPResponseListener, lDAPSearchConstraints);
                JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 10, string, 0, null, null, false, null, null, null, null, null);
            }
            Object var6_6 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public void rename(String string, String string2, boolean bl) throws LDAPException {
        this.rename(string, string2, null, bl);
    }

    public void rename(String string, String string2, String string3, boolean bl) throws LDAPException {
        this.rename(string, string2, string3, bl, this.defaultConstraints);
    }

    private void rename(String string, String string2, String string3, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (this.th == null) {
            this.connect();
        }
        if (!this.bound) {
            this.bind(2);
        }
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            try {
                JDAPModifyRDNRequest jDAPModifyRDNRequest = null;
                jDAPModifyRDNRequest = string3 != null ? new JDAPModifyRDNRequest(string, string2, bl, string3) : new JDAPModifyRDNRequest(string, string2, bl);
                this.th.sendRequest(jDAPModifyRDNRequest, lDAPResponseListener, lDAPSearchConstraints);
                JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 12, string, 0, string2, null, bl, null, null, null, null, null);
            }
            Object var9_10 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public Object getOption(int n) throws LDAPException {
        return LDAPConnection.getOption(n, this.defaultConstraints);
    }

    private static Object getOption(int n, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        switch (n) {
            case 2: {
                return new Integer(lDAPSearchConstraints.getDereference());
            }
            case 3: {
                return new Integer(lDAPSearchConstraints.getMaxResults());
            }
            case 4: {
                return new Integer(lDAPSearchConstraints.getTimeLimit());
            }
            case 8: {
                return new Boolean(lDAPSearchConstraints.getReferrals());
            }
            case 9: {
                return lDAPSearchConstraints.getRebindProc();
            }
            case 10: {
                return new Integer(lDAPSearchConstraints.getHopLimit());
            }
            case 20: {
                return new Integer(lDAPSearchConstraints.getBatchSize());
            }
            case 11: {
                return lDAPSearchConstraints.getClientControls();
            }
            case 12: {
                return lDAPSearchConstraints.getServerControls();
            }
        }
        throw new LDAPException("invalid option", 89);
    }

    public void setOption(int n, Object object) throws LDAPException {
        LDAPConnection.setOption(n, object, this.defaultConstraints);
    }

    private static void setOption(int n, Object object, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            switch (n) {
                case 2: {
                    lDAPSearchConstraints.setDereference((Integer)object);
                    return;
                }
                case 3: {
                    lDAPSearchConstraints.setMaxResults((Integer)object);
                    return;
                }
                case 4: {
                    lDAPSearchConstraints.setTimeLimit((Integer)object);
                    return;
                }
                case 8: {
                    lDAPSearchConstraints.setReferrals((Boolean)object);
                    return;
                }
                case 9: {
                    lDAPSearchConstraints.setRebindProc((LDAPRebind)object);
                    return;
                }
                case 10: {
                    lDAPSearchConstraints.setHopLimit((Integer)object);
                    return;
                }
                case 20: {
                    lDAPSearchConstraints.setBatchSize((Integer)object);
                    return;
                }
                case 11: {
                    if (object instanceof LDAPControl) {
                        lDAPSearchConstraints.setClientControls((LDAPControl)object);
                        return;
                    }
                    if (object instanceof LDAPControl[]) {
                        lDAPSearchConstraints.setClientControls((LDAPControl[])object);
                        return;
                    }
                    throw new LDAPException("invalid LDAPControl", 89);
                }
                case 12: {
                    if (object instanceof LDAPControl) {
                        lDAPSearchConstraints.setServerControls((LDAPControl)object);
                        return;
                    }
                    if (object instanceof LDAPControl[]) {
                        lDAPSearchConstraints.setServerControls((LDAPControl[])object);
                        return;
                    }
                    throw new LDAPException("invalid LDAPControl", 89);
                }
            }
            throw new LDAPException("invalid option", 89);
        }
        catch (ClassCastException classCastException) {
            throw new LDAPException("invalid option value", 89);
        }
    }

    public LDAPControl[] getResponseControls() {
        LDAPControl[] lDAPControlArray;
        LDAPControl[] lDAPControlArray2 = null;
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            lDAPControlArray = (LDAPControl[])this.m_responseControlTable.get(Thread.currentThread());
        }
        if (lDAPControlArray != null && lDAPControlArray.length > 0) {
            lDAPControlArray2 = new LDAPControl[lDAPControlArray.length];
            int n = 0;
            while (n < lDAPControlArray.length) {
                lDAPControlArray2[n] = (LDAPControl)lDAPControlArray[n].clone();
                ++n;
            }
        }
        return lDAPControlArray2;
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return this.defaultConstraints;
    }

    private synchronized LDAPResponseListener getResponseListener() {
        LDAPResponseListener lDAPResponseListener;
        if (this.responseListeners == null) {
            this.responseListeners = new Vector(5);
        }
        if (this.responseListeners.size() < 1) {
            lDAPResponseListener = new LDAPResponseListener(this);
        } else {
            lDAPResponseListener = (LDAPResponseListener)this.responseListeners.elementAt(0);
            this.responseListeners.removeElementAt(0);
        }
        lDAPResponseListener.setThread();
        return lDAPResponseListener;
    }

    private synchronized LDAPSearchListener getSearchListener() {
        LDAPSearchListener lDAPSearchListener;
        if (this.searchListeners == null) {
            this.searchListeners = new Vector(5);
        }
        if (this.searchListeners.size() < 1) {
            lDAPSearchListener = new LDAPSearchListener(this);
        } else {
            lDAPSearchListener = (LDAPSearchListener)this.searchListeners.elementAt(0);
            this.searchListeners.removeElementAt(0);
        }
        lDAPSearchListener.setThread();
        return lDAPSearchListener;
    }

    private synchronized void releaseResponseListener(LDAPResponseListener lDAPResponseListener) {
        if (this.responseListeners == null) {
            this.responseListeners = new Vector(5);
        }
        lDAPResponseListener.reset();
        this.responseListeners.addElement(lDAPResponseListener);
    }

    private synchronized void releaseSearchListener(LDAPSearchListener lDAPSearchListener) {
        if (this.searchListeners == null) {
            this.searchListeners = new Vector(5);
        }
        lDAPSearchListener.reset();
        this.searchListeners.addElement(lDAPSearchListener);
    }

    private void checkMsg(JDAPMessage jDAPMessage) throws LDAPException {
        if (!(jDAPMessage.getProtocolOp() instanceof JDAPResult)) {
            return;
        }
        JDAPResult jDAPResult = (JDAPResult)((Object)jDAPMessage.getProtocolOp());
        int n = jDAPResult.getResultCode();
        if (n == 0) {
            return;
        }
        if (n == 10) {
            throw new LDAPReferralException("referral", jDAPResult.getResultCode(), jDAPResult.getReferrals());
        }
        if (n == 9) {
            throw new LDAPReferralException("referral", jDAPResult.getResultCode(), jDAPResult.getErrorMessage());
        }
        throw new LDAPException("error result", jDAPResult.getResultCode(), jDAPResult.getErrorMessage(), jDAPResult.getMatchedDN());
    }

    void setResponseControls(Thread thread, LDAPControl[] lDAPControlArray) {
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            if (lDAPControlArray != null) {
                this.m_responseControlTable.put(thread, lDAPControlArray);
            } else {
                this.m_responseControlTable.remove(thread);
            }
            Enumeration enumeration = this.m_attachedList.elements();
            while (enumeration.hasMoreElements()) {
                Thread thread2 = (Thread)enumeration.nextElement();
                if (thread2.isAlive()) continue;
                this.m_responseControlTable.remove(thread2);
                this.m_attachedList.removeElement(thread2);
            }
        }
        if (this.m_attachedList.indexOf(thread) < 0) {
            this.m_attachedList.addElement(thread);
        }
    }

    private LDAPConnection prepareReferral(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPConnection lDAPConnection = new LDAPConnection();
        lDAPConnection.setOption(8, new Boolean(true));
        lDAPConnection.setOption(9, lDAPSearchConstraints.getRebindProc());
        lDAPConnection.setOption(10, new Integer(lDAPSearchConstraints.getHopLimit() - 1));
        lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
        if (lDAPSearchConstraints.getRebindProc() == null) {
            lDAPConnection.authenticate(null, null);
        } else {
            LDAPRebindAuth lDAPRebindAuth = lDAPSearchConstraints.getRebindProc().getRebindAuthentication(lDAPUrl.getHost(), lDAPUrl.getPort());
            lDAPConnection.authenticate(lDAPRebindAuth.getDN(), lDAPRebindAuth.getPassword());
        }
        return lDAPConnection;
    }

    private void performReferrals(LDAPReferralException lDAPReferralException, LDAPSearchConstraints lDAPSearchConstraints, int n, String string, int n2, String string2, String[] stringArray, boolean bl, LDAPModification[] lDAPModificationArray, LDAPEntry lDAPEntry, LDAPAttribute lDAPAttribute, LDAPSearchResults[] lDAPSearchResultsArray, boolean[] blArray) throws LDAPException {
        if (lDAPSearchConstraints.getHopLimit() < 0) {
            throw new LDAPReferralException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
        }
        if (!lDAPSearchConstraints.getReferrals()) {
            throw lDAPReferralException;
        }
        LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
        if (lDAPUrlArray == null) {
            return;
        }
        int n3 = 0;
        while (n3 < lDAPUrlArray.length) {
            try {
                LDAPConnection lDAPConnection = this.prepareReferral(lDAPUrlArray[n3], lDAPSearchConstraints);
                switch (n) {
                    case 3: {
                        LDAPSearchConstraints lDAPSearchConstraints2 = (LDAPSearchConstraints)lDAPSearchConstraints.clone();
                        lDAPSearchConstraints2.setHopLimit(lDAPSearchConstraints.getHopLimit() - 1);
                        lDAPSearchResultsArray[0] = lDAPConnection.search(string, n2, string2, stringArray, bl, lDAPSearchConstraints2);
                        if (lDAPSearchResultsArray[0] != null) {
                            lDAPSearchResultsArray[0].closeOnCompletion(lDAPConnection);
                        }
                        return;
                    }
                    case 6: {
                        lDAPConnection.modify(string, lDAPModificationArray, lDAPConnection.defaultConstraints);
                        break;
                    }
                    case 8: {
                        lDAPConnection.add(lDAPEntry);
                        break;
                    }
                    case 10: {
                        lDAPConnection.delete(string);
                        break;
                    }
                    case 12: {
                        lDAPConnection.rename(string, string2, bl);
                        break;
                    }
                    case 14: {
                        blArray[0] = lDAPConnection.compare(string, lDAPAttribute);
                    }
                }
                lDAPConnection.disconnect();
                return;
            }
            catch (LDAPException lDAPException) {
                ++n3;
            }
        }
    }

    private LDAPExtendedOperation performExtendedReferrals(LDAPReferralException lDAPReferralException, LDAPSearchConstraints lDAPSearchConstraints, LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        if (lDAPSearchConstraints.getHopLimit() < 0) {
            throw new LDAPReferralException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
        }
        if (!lDAPSearchConstraints.getReferrals()) {
            throw lDAPReferralException;
        }
        LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
        if (lDAPUrlArray == null) {
            return null;
        }
        int n = 0;
        while (n < lDAPUrlArray.length) {
            try {
                LDAPConnection lDAPConnection = this.prepareReferral(lDAPUrlArray[n], lDAPSearchConstraints);
                LDAPExtendedOperation lDAPExtendedOperation2 = lDAPConnection.extendedOperation(lDAPExtendedOperation);
                lDAPConnection.disconnect();
                return lDAPExtendedOperation2;
            }
            catch (LDAPException lDAPException) {
                ++n;
            }
        }
        return null;
    }

    public synchronized Object clone() {
        try {
            LDAPConnection lDAPConnection = (LDAPConnection)super.clone();
            lDAPConnection.defaultConstraints = (LDAPSearchConstraints)this.defaultConstraints.clone();
            lDAPConnection.responseListeners = null;
            lDAPConnection.searchListeners = null;
            lDAPConnection.bound = this.bound;
            lDAPConnection.host = this.host;
            lDAPConnection.port = this.port;
            lDAPConnection.boundDN = this.boundDN;
            lDAPConnection.boundPasswd = this.boundPasswd;
            lDAPConnection.m_factory = this.m_factory;
            lDAPConnection.th = this.th;
            lDAPConnection.th.register(lDAPConnection);
            return lDAPConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean checkCommunicator() {
        try {
            Method method = LDAPCheckComm.getMethod("netscape.security.PrivilegeManager", "enablePrivilege");
            if (method == null) {
                return false;
            }
            Object[] objectArray = new Object[]{new String("UniversalConnect")};
            method.invoke(null, objectArray);
            return true;
        }
        catch (LDAPException lDAPException) {
            String string = "Exception: " + lDAPException.toString();
        }
        catch (Exception exception) {
            String string = "Exception on invoking enablePrivilege: " + exception.toString();
        }
        return false;
    }

    public static boolean isNetscape() {
        return isCommunicator;
    }

    private static void printDebug(String string) {
    }
}

