/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;

public class LDAPAttributeSet {
    private int current;
    private Vector attrs;
    Hashtable attrHash;

    public LDAPAttributeSet() {
        this.attrs = new Vector();
        this.attrHash = new Hashtable();
        this.current = 0;
    }

    LDAPAttributeSet(LDAPAttribute[] lDAPAttributeArray) {
        this.attrs = new Vector();
        this.attrHash = new Hashtable();
        this.current = 0;
        int n = 0;
        while (n < lDAPAttributeArray.length) {
            this.attrs.addElement(lDAPAttributeArray[n]);
            this.attrHash.put(lDAPAttributeArray[n].getName().toLowerCase(), lDAPAttributeArray[n]);
            ++n;
        }
    }

    protected LDAPAttributeSet(LDAPAttributeSet lDAPAttributeSet) {
        LDAPAttributeSet lDAPAttributeSet2 = this;
        synchronized (lDAPAttributeSet2) {
            this.attrs = (Vector)lDAPAttributeSet.attrs.clone();
        }
        this.attrHash = new Hashtable();
        int n = 0;
        while (n < this.attrs.size()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attrs.elementAt(n);
            this.attrHash.put(lDAPAttribute.getName().toLowerCase(), lDAPAttribute);
            ++n;
        }
        this.current = 0;
    }

    public Enumeration getAttributes() {
        return this.attrs.elements();
    }

    public LDAPAttributeSet getSubset(String string) {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        if (string == null) {
            return lDAPAttributeSet;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() < 1) {
            return lDAPAttributeSet;
        }
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = (String)stringTokenizer.nextElement();
            ++n;
        }
        Enumeration enumeration = this.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            if (!lDAPAttribute.hasSubtypes(stringArray)) continue;
            lDAPAttributeSet.add(new LDAPAttribute(lDAPAttribute));
        }
        return lDAPAttributeSet;
    }

    public LDAPAttribute getAttribute(String string) {
        return (LDAPAttribute)this.attrHash.get(string.toLowerCase());
    }

    public LDAPAttribute getAttribute(String string, String string2) {
        if (string2 == null || string2.length() < 1) {
            return this.getAttribute(string);
        }
        String string3 = string2.toLowerCase();
        if (!string3.substring(0, 5).equals("lang-")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "-");
        stringTokenizer.nextToken();
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        String string4 = LDAPAttribute.getBaseName(string);
        String[] stringArray2 = LDAPAttribute.getSubtypes(string);
        LDAPAttribute lDAPAttribute = null;
        int n2 = 0;
        n = 0;
        while (n < this.attrs.size()) {
            boolean bl = false;
            LDAPAttribute lDAPAttribute2 = (LDAPAttribute)this.attrs.elementAt(n);
            if (lDAPAttribute2.getBaseName().equalsIgnoreCase(string4)) {
                if (stringArray2 == null || stringArray2.length < 1) {
                    bl = true;
                } else if (lDAPAttribute2.hasSubtypes(stringArray2)) {
                    bl = true;
                }
            }
            String string5 = null;
            if (bl) {
                string5 = lDAPAttribute2.getLangSubtype();
                if (string5 == null) {
                    lDAPAttribute = lDAPAttribute2;
                } else {
                    stringTokenizer = new StringTokenizer(string5.toLowerCase(), "-");
                    stringTokenizer.nextToken();
                    if (stringTokenizer.countTokens() <= stringArray.length) {
                        int n3 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            if (!stringArray[n3].equals(stringTokenizer.nextToken())) {
                                n3 = 0;
                                break;
                            }
                            ++n3;
                        }
                        if (n3 > n2) {
                            lDAPAttribute = lDAPAttribute2;
                            n2 = n3;
                        }
                    }
                }
            }
            ++n;
        }
        return lDAPAttribute;
    }

    public LDAPAttribute elementAt(int n) {
        return (LDAPAttribute)this.attrs.elementAt(n);
    }

    public void removeElementAt(int n) {
        this.attrs.removeElementAt(n);
    }

    public int size() {
        return this.attrs.size();
    }

    public synchronized void add(LDAPAttribute lDAPAttribute) {
        this.attrs.addElement(lDAPAttribute);
        this.attrHash.put(lDAPAttribute.getName().toLowerCase(), lDAPAttribute);
    }

    public synchronized void remove(String string) {
        int n = 0;
        while (n < this.attrs.size()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attrs.elementAt(n);
            if (string.equalsIgnoreCase(lDAPAttribute.getName())) {
                this.attrs.removeElementAt(n);
                return;
            }
            ++n;
        }
    }

    public String toString() {
        String string = "LDAPAttributeSet: ";
        if (this.attrs.size() > 0) {
            int n = 0;
            while (n < this.attrs.size()) {
                string = String.valueOf(string) + this.attrs.elementAt(n).toString();
                ++n;
            }
        }
        return string;
    }
}

