/*
 * Decompiled with CFR 0.152.
 */
package jspell.spellchecker;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.TextArea;
import java.io.IOException;
import java.util.Hashtable;
import jspell.spellchecker.JSpellCheck;
import jspell.spellchecker.JSpellChecker;
import jspell.spellchecker.JSpellError;
import jspell.spellchecker.JSpellErrorInfo;
import jspell.spellchecker.JSpellMessage;
import jspell.spellchecker.JSpellMessageInt;
import jspell.spellchecker.JSpellProgress;
import jspell.spellchecker.JSpellProgressInt;
import jspell.spellchecker.SpellIndex;
import jspell.spellchecker.TextInfo;
import jspell.spellchecker.WordBundle;
import jspell.spellchecker.j_util;

public class JSpellToolkit
implements JSpellChecker,
JSpellMessageInt,
JSpellProgressInt {
    private SpellIndex x = new SpellIndex();
    private String[] suggestions;
    private Hashtable ignoreWords = new Hashtable();
    private Hashtable validWords = new Hashtable();
    private Container f;
    private Runnable eh;
    private Runnable ruProg;
    private Thread th = null;
    private Thread thProg;
    private int progxPos;
    private int progyPos;
    private int errxPos;
    private int erryPos;
    private boolean stopped;
    private WordBundle checkWord;
    private TextArea userTextArea;
    private boolean ignoreUpper;
    private int progressFreq;
    private int progressCounter;
    private boolean showProgress;
    private TextInfo textInfo;
    private String nextWord;
    private String nextWordUpper;

    public JSpellToolkit() {
        this.addFrequentWords();
        this.setProgress(true);
        this.setIgnoreUpperCase(true);
        this.ruProg = null;
        this.progressCounter = 0;
        this.progressFreq = 25;
    }

    public final boolean isToolkitReady() {
        return this.x.isIndexReady();
    }

    public final void setErrPos(Point p) {
        this.errxPos = p.x;
        this.erryPos = p.y;
    }

    public final void addLearned(String word) {
        this.x.add(word, j_util.soundex(word), this.x.root);
    }

    public final void addIgnore(String word) {
        this.ignoreWords.put(word, "");
    }

    public final void setProgPos(Point p) {
        this.progxPos = p.x;
        this.progyPos = p.y;
    }

    public final void setStopped(boolean stopValue) {
        this.stopped = stopValue;
    }

    public final void setProgress(boolean progValue) {
        this.showProgress = progValue;
    }

    public final boolean getShowProgValue() {
        return this.showProgress;
    }

    public final void setIgnoreUpperCase(boolean ignoreValue) {
        this.ignoreUpper = ignoreValue;
    }

    public final void buildIndex() {
        this.buildIndex("dict.txt");
    }

    public final void buildIndex(String dictFile) {
        this.x.build(dictFile);
    }

    public final void initRawCheck(String data) {
        this.setStopped(false);
        this.textInfo = new TextInfo(data);
        this.textInfo.setIgnore(this.ignoreUpper);
        this.suggestions = new String[10];
    }

    public final void check(TextArea ta) {
        this.setStopped(false);
        this.textInfo = new TextInfo(ta.getText());
        this.textInfo.setIgnore(this.ignoreUpper);
        this.userTextArea = ta;
        this.initContainer();
        if (this.showProgress) {
            this.ruProg = new JSpellProgress((Frame)this.f, "Checking", 100, this.progxPos, this.progyPos, this);
            this.thProg = new Thread(this.ruProg);
            this.thProg.start();
        }
        this.suggestions = new String[10];
        this.cleanCheck();
    }

    public final void goodCheck(TextArea ta) {
        this.textInfo = new TextInfo(ta.getText());
        this.textInfo.setIgnore(this.ignoreUpper);
        this.userTextArea = ta;
        this.initContainer();
        this.suggestions = new String[10];
        JSpellCheck check = new JSpellCheck((Frame)this.f, this);
    }

    public String getCheckWord() {
        return this.checkWord.word;
    }

    public String[] getSuggestions() {
        return this.suggestions;
    }

    public void updateUserTextArea(String word) {
        int spot = this.textInfo.getCurPos();
        int len = word.length();
        this.userTextArea.setText(this.textInfo.getTextString());
        this.userTextArea.select(spot, spot + len);
    }

    public TextArea getUserTextArea() {
        return this.userTextArea;
    }

    public TextInfo getTextInfo() {
        return this.textInfo;
    }

    public void selectCurrent() {
        int spot = this.checkWord.position;
        int len = this.getCheckWord().length();
        this.userTextArea.select(spot, spot + len);
    }

    public int getErrPos() {
        return this.checkWord.position;
    }

    public boolean checkWords() {
        boolean ret_code = false;
        while (!ret_code && this.textInfo.isWordsToCheck()) {
            this.checkWord = this.textInfo.getNextWord();
            this.nextWord = this.checkWord.getWord();
            if (this.nextWord.equals("") || this.ignoreWords.containsKey(this.nextWord) || this.validWords.containsKey(this.nextWord)) continue;
            this.nextWordUpper = this.checkWord.getUpperWord();
            int z = 0;
            while (z < 10) {
                this.suggestions[z++] = null;
            }
            try {
                if (this.x.search(j_util.soundex(this.nextWordUpper), this.nextWordUpper, this.suggestions)) continue;
                ret_code = true;
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                ioe.printStackTrace();
                break;
            }
        }
        return ret_code;
    }

    public final JSpellErrorInfo rawCheck() {
        try {
            while (this.textInfo.isWordsToCheck() && !this.stopped) {
                this.checkWord = this.textInfo.getNextWord();
                this.nextWord = this.checkWord.getWord();
                if (this.nextWord.equals("") || this.ignoreWords.containsKey(this.nextWord) || this.validWords.containsKey(this.nextWord)) continue;
                this.nextWordUpper = this.checkWord.getUpperWord();
                int z = 0;
                while (z < 10) {
                    this.suggestions[z++] = null;
                }
                if (this.x.search(j_util.soundex(this.nextWordUpper), this.nextWordUpper, this.suggestions)) continue;
                JSpellErrorInfo jSpellErrorInfo = new JSpellErrorInfo(this.checkWord, this.suggestions, this.textInfo);
                return jSpellErrorInfo;
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            System.exit(0);
        }
        return null;
    }

    private final void cleanCheck() {
        try {
            while (this.textInfo.isWordsToCheck() && !this.stopped) {
                this.checkWord = this.textInfo.getNextWord();
                this.nextWord = this.checkWord.getWord();
                if (!(this.nextWord.equals("") || this.ignoreWords.containsKey(this.nextWord) || this.validWords.containsKey(this.nextWord))) {
                    this.nextWordUpper = this.checkWord.getUpperWord();
                    int z = 0;
                    while (z < 10) {
                        this.suggestions[z++] = null;
                    }
                    if (!this.x.search(j_util.soundex(this.nextWordUpper), this.nextWordUpper, this.suggestions)) {
                        this.eh = new JSpellError((Frame)this.f, this.userTextArea, this.checkWord, this.suggestions, this.textInfo, this.errxPos, this.erryPos, this);
                        this.th = new Thread(this.eh);
                        this.th.start();
                        return;
                    }
                }
                if (!this.showProgress || this.progressCounter++ <= this.progressFreq) continue;
                ((JSpellProgress)this.ruProg).setProgress((int)((double)this.textInfo.getCurPos() * 100.0 / (double)this.textInfo.getTextLength()));
                this.progressCounter = 0;
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            System.exit(0);
        }
        if (this.getShowProgValue()) {
            ((JSpellProgress)this.ruProg).setProgress(100);
        }
        if (!this.stopped) {
            // empty if block
        }
    }

    public final void killErrorDialog(Dialog x) {
        x.dispose();
        this.f.requestFocus();
    }

    private final void showErrorDialog(String w, String m) {
        JSpellMessage jsm = new JSpellMessage(w, m, (Frame)this.f, this);
        Thread th = new Thread(jsm);
        th.start();
        this.stopped = true;
        if (this.getShowProgValue() && this.thProg != null) {
            this.thProg.stop();
            this.thProg = null;
            ((JSpellProgress)this.ruProg).dispose();
        }
    }

    public final void resumeChecking() {
        ((JSpellError)this.eh).dispose();
        this.userTextArea.setText(this.textInfo.getTextString());
        this.userTextArea.select(this.textInfo.getCurPos(), this.textInfo.getCurPos());
        this.f.requestFocus();
        try {
            this.th.stop();
            this.th = null;
        }
        catch (Exception ie) {
            ie.printStackTrace();
            System.out.println(String.valueOf("Trying to Stop Thread: ").concat(String.valueOf(ie)));
        }
        try {
            this.cleanCheck();
        }
        catch (Exception e) {
            this.showErrorDialog("Warning", String.valueOf("ERROR: ").concat(String.valueOf(e)));
        }
    }

    public final void replaceSingle(String orig, String repl) {
        StringBuffer newText = new StringBuffer(this.textInfo.getTextString().substring(0, this.textInfo.getCurPos()));
        newText.append(repl);
        newText.append(this.textInfo.getTextString().substring(this.textInfo.getCurPos() + orig.length()));
        this.textInfo.setText(newText);
    }

    public final void replaceAll(String orig, String repl) {
        int lastpos = 0;
        StringBuffer newText = new StringBuffer(this.textInfo.getTextString().substring(0, lastpos));
        int x = this.textInfo.getTextString().indexOf(orig);
        while (x > 0) {
            newText.append(this.textInfo.getTextString().substring(lastpos, x));
            newText.append(repl);
            lastpos = x + orig.length();
            x = this.textInfo.getTextString().indexOf(orig, lastpos + 1);
        }
        newText.append(this.textInfo.getTextString().substring(lastpos));
        this.textInfo.setText(newText);
    }

    private final void initContainer() {
        this.f = this.userTextArea.getParent();
        while (this.f != null && !(this.f instanceof Frame)) {
            this.f = this.f.getParent();
        }
        if (this.f == null) {
            System.out.println("No Frame Container parent could be found.");
            return;
        }
    }

    private final void addFrequentWords() {
        this.validWords.put("able", "");
        this.validWords.put("about", "");
        this.validWords.put("above", "");
        this.validWords.put("according", "");
        this.validWords.put("across", "");
        this.validWords.put("act", "");
        this.validWords.put("added", "");
        this.validWords.put("after", "");
        this.validWords.put("again", "");
        this.validWords.put("against", "");
        this.validWords.put("age", "");
        this.validWords.put("agency", "");
        this.validWords.put("ago", "");
        this.validWords.put("agreed", "");
        this.validWords.put("agreement", "");
        this.validWords.put("air", "");
        this.validWords.put("all", "");
        this.validWords.put("almost", "");
        this.validWords.put("alone", "");
        this.validWords.put("along", "");
        this.validWords.put("already", "");
        this.validWords.put("also", "");
        this.validWords.put("although", "");
        this.validWords.put("always", "");
        this.validWords.put("am", "");
        this.validWords.put("among", "");
        this.validWords.put("an", "");
        this.validWords.put("analyst", "");
        this.validWords.put("and", "");
        this.validWords.put("announced", "");
        this.validWords.put("annual", "");
        this.validWords.put("another", "");
        this.validWords.put("any", "");
        this.validWords.put("anything", "");
        this.validWords.put("are", "");
        this.validWords.put("area", "");
        this.validWords.put("around", "");
        this.validWords.put("art", "");
        this.validWords.put("as", "");
        this.validWords.put("asked", "");
        this.validWords.put("assets", "");
        this.validWords.put("at", "");
        this.validWords.put("august", "");
        this.validWords.put("average", "");
        this.validWords.put("away", "");
        this.validWords.put("back", "");
        this.validWords.put("bank", "");
        this.validWords.put("banks", "");
        this.validWords.put("based", "");
        this.validWords.put("be", "");
        this.validWords.put("became", "");
        this.validWords.put("because", "");
        this.validWords.put("become", "");
        this.validWords.put("been", "");
        this.validWords.put("before", "");
        this.validWords.put("began", "");
        this.validWords.put("behind", "");
        this.validWords.put("being", "");
        this.validWords.put("best", "");
        this.validWords.put("better", "");
        this.validWords.put("between", "");
        this.validWords.put("bid", "");
        this.validWords.put("big", "");
        this.validWords.put("bill", "");
        this.validWords.put("billion", "");
        this.validWords.put("board", "");
        this.validWords.put("body", "");
        this.validWords.put("bond", "");
        this.validWords.put("bonds", "");
        this.validWords.put("book", "");
        this.validWords.put("both", "");
        this.validWords.put("brought", "");
        this.validWords.put("business", "");
        this.validWords.put("but", "");
        this.validWords.put("buy", "");
        this.validWords.put("buying", "");
        this.validWords.put("by", "");
        this.validWords.put("called", "");
        this.validWords.put("came", "");
        this.validWords.put("camera", "");
        this.validWords.put("can", "");
        this.validWords.put("capital", "");
        this.validWords.put("car", "");
        this.validWords.put("case", "");
        this.validWords.put("cases", "");
        this.validWords.put("cash", "");
        this.validWords.put("cent", "");
        this.validWords.put("cents", "");
        this.validWords.put("century", "");
        this.validWords.put("certain", "");
        this.validWords.put("certainly", "");
        this.validWords.put("chairman", "");
        this.validWords.put("change", "");
        this.validWords.put("chief", "");
        this.validWords.put("child", "");
        this.validWords.put("children", "");
        this.validWords.put("clear", "");
        this.validWords.put("client", "");
        this.validWords.put("close", "");
        this.validWords.put("closed", "");
        this.validWords.put("come", "");
        this.validWords.put("comment", "");
        this.validWords.put("committee", "");
        this.validWords.put("common", "");
        this.validWords.put("companies", "");
        this.validWords.put("company", "");
        this.validWords.put("compared", "");
        this.validWords.put("computer", "");
        this.validWords.put("concern", "");
        this.validWords.put("concerned", "");
        this.validWords.put("congress", "");
        this.validWords.put("continue", "");
        this.validWords.put("contract", "");
        this.validWords.put("control", "");
        this.validWords.put("corp", "");
        this.validWords.put("corporate", "");
        this.validWords.put("cost", "");
        this.validWords.put("costs", "");
        this.validWords.put("could", "");
        this.validWords.put("council", "");
        this.validWords.put("countries", "");
        this.validWords.put("country", "");
        this.validWords.put("course", "");
        this.validWords.put("court", "");
        this.validWords.put("credit", "");
        this.validWords.put("current", "");
        this.validWords.put("cut", "");
        this.validWords.put("day", "");
        this.validWords.put("days", "");
        this.validWords.put("death", "");
        this.validWords.put("debt", "");
        this.validWords.put("debug", "");
        this.validWords.put("declined", "");
        this.validWords.put("demand", "");
        this.validWords.put("department", "");
        this.validWords.put("development", "");
        this.validWords.put("did", "");
        this.validWords.put("different", "");
        this.validWords.put("difficult", "");
        this.validWords.put("director", "");
        this.validWords.put("disk", "");
        this.validWords.put("diskette", "");
        this.validWords.put("do", "");
        this.validWords.put("does", "");
        this.validWords.put("doing", "");
        this.validWords.put("dollar", "");
        this.validWords.put("done", "");
        this.validWords.put("door", "");
        this.validWords.put("doubt", "");
        this.validWords.put("dow", "");
        this.validWords.put("down", "");
        this.validWords.put("dr", "");
        this.validWords.put("drive", "");
        this.validWords.put("drug", "");
        this.validWords.put("due", "");
        this.validWords.put("during", "");
        this.validWords.put("each", "");
        this.validWords.put("earlier", "");
        this.validWords.put("early", "");
        this.validWords.put("earnings", "");
        this.validWords.put("economic", "");
        this.validWords.put("economy", "");
        this.validWords.put("education", "");
        this.validWords.put("effect", "");
        this.validWords.put("either", "");
        this.validWords.put("employees", "");
        this.validWords.put("end", "");
        this.validWords.put("ended", "");
        this.validWords.put("england", "");
        this.validWords.put("english", "");
        this.validWords.put("enough", "");
        this.validWords.put("european", "");
        this.validWords.put("even", "");
        this.validWords.put("ever", "");
        this.validWords.put("every", "");
        this.validWords.put("example", "");
        this.validWords.put("except", "");
        this.validWords.put("exchange", "");
        this.validWords.put("executive", "");
        this.validWords.put("expected", "");
        this.validWords.put("expects", "");
        this.validWords.put("experience", "");
        this.validWords.put("eyes", "");
        this.validWords.put("face", "");
        this.validWords.put("fact", "");
        this.validWords.put("family", "");
        this.validWords.put("far", "");
        this.validWords.put("father", "");
        this.validWords.put("federal", "");
        this.validWords.put("feet", "");
        this.validWords.put("fell", "");
        this.validWords.put("felt", "");
        this.validWords.put("few", "");
        this.validWords.put("field", "");
        this.validWords.put("financial", "");
        this.validWords.put("find", "");
        this.validWords.put("firm", "");
        this.validWords.put("firms", "");
        this.validWords.put("first", "");
        this.validWords.put("fiscal", "");
        this.validWords.put("five", "");
        this.validWords.put("floppy", "");
        this.validWords.put("following", "");
        this.validWords.put("food", "");
        this.validWords.put("for", "");
        this.validWords.put("foreign", "");
        this.validWords.put("form", "");
        this.validWords.put("former", "");
        this.validWords.put("forward", "");
        this.validWords.put("found", "");
        this.validWords.put("four", "");
        this.validWords.put("free", "");
        this.validWords.put("french", "");
        this.validWords.put("friday", "");
        this.validWords.put("from", "");
        this.validWords.put("full", "");
        this.validWords.put("funds", "");
        this.validWords.put("further", "");
        this.validWords.put("futures", "");
        this.validWords.put("gains", "");
        this.validWords.put("gave", "");
        this.validWords.put("general", "");
        this.validWords.put("get", "");
        this.validWords.put("girl", "");
        this.validWords.put("give", "");
        this.validWords.put("given", "");
        this.validWords.put("go", "");
        this.validWords.put("going", "");
        this.validWords.put("gone", "");
        this.validWords.put("good", "");
        this.validWords.put("got", "");
        this.validWords.put("government", "");
        this.validWords.put("great", "");
        this.validWords.put("group", "");
        this.validWords.put("growth", "");
        this.validWords.put("had", "");
        this.validWords.put("half", "");
        this.validWords.put("hand", "");
        this.validWords.put("hands", "");
        this.validWords.put("hard", "");
        this.validWords.put("has", "");
        this.validWords.put("have", "");
        this.validWords.put("having", "");
        this.validWords.put("he", "");
        this.validWords.put("head", "");
        this.validWords.put("heard", "");
        this.validWords.put("held", "");
        this.validWords.put("help", "");
        this.validWords.put("her", "");
        this.validWords.put("here", "");
        this.validWords.put("herself", "");
        this.validWords.put("high", "");
        this.validWords.put("higher", "");
        this.validWords.put("him", "");
        this.validWords.put("himself", "");
        this.validWords.put("his", "");
        this.validWords.put("home", "");
        this.validWords.put("hope", "");
        this.validWords.put("house", "");
        this.validWords.put("how", "");
        this.validWords.put("however", "");
        this.validWords.put("human", "");
        this.validWords.put("idea", "");
        this.validWords.put("if", "");
        this.validWords.put("important", "");
        this.validWords.put("in", "");
        this.validWords.put("Inc", "");
        this.validWords.put("including", "");
        this.validWords.put("income", "");
        this.validWords.put("increase", "");
        this.validWords.put("increased", "");
        this.validWords.put("indeed", "");
        this.validWords.put("index", "");
        this.validWords.put("industry", "");
        this.validWords.put("information", "");
        this.validWords.put("insurance", "");
        this.validWords.put("interest", "");
        this.validWords.put("International", "");
        this.validWords.put("internet", "");
        this.validWords.put("into", "");
        this.validWords.put("intranet", "");
        this.validWords.put("investment", "");
        this.validWords.put("investors", "");
        this.validWords.put("is", "");
        this.validWords.put("issue", "");
        this.validWords.put("issues", "");
        this.validWords.put("it", "");
        this.validWords.put("its", "");
        this.validWords.put("itself", "");
        this.validWords.put("japan", "");
        this.validWords.put("japanese", "");
        this.validWords.put("java", "");
        this.validWords.put("john", "");
        this.validWords.put("july", "");
        this.validWords.put("june", "");
        this.validWords.put("just", "");
        this.validWords.put("keep", "");
        this.validWords.put("kind", "");
        this.validWords.put("knew", "");
        this.validWords.put("know", "");
        this.validWords.put("knowledge", "");
        this.validWords.put("known", "");
        this.validWords.put("labour", "");
        this.validWords.put("land", "");
        this.validWords.put("large", "");
        this.validWords.put("largest", "");
        this.validWords.put("last", "");
        this.validWords.put("late", "");
        this.validWords.put("later", "");
        this.validWords.put("law", "");
        this.validWords.put("least", "");
        this.validWords.put("leave", "");
        this.validWords.put("left", "");
        this.validWords.put("less", "");
        this.validWords.put("let", "");
        this.validWords.put("level", "");
        this.validWords.put("life", "");
        this.validWords.put("light", "");
        this.validWords.put("like", "");
        this.validWords.put("likely", "");
        this.validWords.put("line", "");
        this.validWords.put("little", "");
        this.validWords.put("living", "");
        this.validWords.put("loans", "");
        this.validWords.put("local", "");
        this.validWords.put("London", "");
        this.validWords.put("long", "");
        this.validWords.put("look", "");
        this.validWords.put("looked", "");
        this.validWords.put("looking", "");
        this.validWords.put("Lord", "");
        this.validWords.put("loss", "");
        this.validWords.put("love", "");
        this.validWords.put("lower", "");
        this.validWords.put("ltd", "");
        this.validWords.put("made", "");
        this.validWords.put("main", "");
        this.validWords.put("major", "");
        this.validWords.put("make", "");
        this.validWords.put("maker", "");
        this.validWords.put("making", "");
        this.validWords.put("man", "");
        this.validWords.put("management", "");
        this.validWords.put("many", "");
        this.validWords.put("market", "");
        this.validWords.put("markets", "");
        this.validWords.put("matter", "");
        this.validWords.put("may", "");
        this.validWords.put("me", "");
        this.validWords.put("mean", "");
        this.validWords.put("means", "");
        this.validWords.put("meeting", "");
        this.validWords.put("members", "");
        this.validWords.put("men", "");
        this.validWords.put("might", "");
        this.validWords.put("million", "");
        this.validWords.put("mind", "");
        this.validWords.put("miss", "");
        this.validWords.put("modern", "");
        this.validWords.put("moment", "");
        this.validWords.put("money", "");
        this.validWords.put("monitor", "");
        this.validWords.put("month", "");
        this.validWords.put("months", "");
        this.validWords.put("more", "");
        this.validWords.put("morning", "");
        this.validWords.put("most", "");
        this.validWords.put("mother", "");
        this.validWords.put("move", "");
        this.validWords.put("mr", "");
        this.validWords.put("mrs", "");
        this.validWords.put("ms", "");
        this.validWords.put("much", "");
        this.validWords.put("music", "");
        this.validWords.put("must", "");
        this.validWords.put("my", "");
        this.validWords.put("name", "");
        this.validWords.put("named", "");
        this.validWords.put("national", "");
        this.validWords.put("near", "");
        this.validWords.put("necessary", "");
        this.validWords.put("need", "");
        this.validWords.put("net", "");
        this.validWords.put("never", "");
        this.validWords.put("new", "");
        this.validWords.put("news", "");
        this.validWords.put("next", "");
        this.validWords.put("night", "");
        this.validWords.put("no", "");
        this.validWords.put("nor", "");
        this.validWords.put("not", "");
        this.validWords.put("notes", "");
        this.validWords.put("nothing", "");
        this.validWords.put("now", "");
        this.validWords.put("number", "");
        this.validWords.put("oct", "");
        this.validWords.put("october", "");
        this.validWords.put("of", "");
        this.validWords.put("off", "");
        this.validWords.put("offer", "");
        this.validWords.put("offering", "");
        this.validWords.put("office", "");
        this.validWords.put("officer", "");
        this.validWords.put("official", "");
        this.validWords.put("officials", "");
        this.validWords.put("often", "");
        this.validWords.put("oil", "");
        this.validWords.put("old", "");
        this.validWords.put("on", "");
        this.validWords.put("once", "");
        this.validWords.put("one", "");
        this.validWords.put("only", "");
        this.validWords.put("open", "");
        this.validWords.put("operating", "");
        this.validWords.put("operations", "");
        this.validWords.put("or", "");
        this.validWords.put("order", "");
        this.validWords.put("other", "");
        this.validWords.put("others", "");
        this.validWords.put("our", "");
        this.validWords.put("out", "");
        this.validWords.put("outside", "");
        this.validWords.put("over", "");
        this.validWords.put("own", "");
        this.validWords.put("own", "");
        this.validWords.put("part", "");
        this.validWords.put("particular", "");
        this.validWords.put("particularly", "");
        this.validWords.put("party", "");
        this.validWords.put("past", "");
        this.validWords.put("pay", "");
        this.validWords.put("people", "");
        this.validWords.put("per", "");
        this.validWords.put("perhaps", "");
        this.validWords.put("period", "");
        this.validWords.put("place", "");
        this.validWords.put("plan", "");
        this.validWords.put("plans", "");
        this.validWords.put("plant", "");
        this.validWords.put("point", "");
        this.validWords.put("points", "");
        this.validWords.put("policy", "");
        this.validWords.put("political", "");
        this.validWords.put("position", "");
        this.validWords.put("possible", "");
        this.validWords.put("power", "");
        this.validWords.put("present", "");
        this.validWords.put("president", "");
        this.validWords.put("price", "");
        this.validWords.put("prices", "");
        this.validWords.put("probably", "");
        this.validWords.put("problem", "");
        this.validWords.put("problems", "");
        this.validWords.put("product", "");
        this.validWords.put("production", "");
        this.validWords.put("products", "");
        this.validWords.put("profit", "");
        this.validWords.put("program", "");
        this.validWords.put("programming", "");
        this.validWords.put("proposed", "");
        this.validWords.put("public", "");
        this.validWords.put("purchase", "");
        this.validWords.put("put", "");
        this.validWords.put("quarter", "");
        this.validWords.put("question", "");
        this.validWords.put("quite", "");
        this.validWords.put("rate", "");
        this.validWords.put("rates", "");
        this.validWords.put("rather", "");
        this.validWords.put("read", "");
        this.validWords.put("real", "");
        this.validWords.put("really", "");
        this.validWords.put("reason", "");
        this.validWords.put("recent", "");
        this.validWords.put("recently", "");
        this.validWords.put("record", "");
        this.validWords.put("report", "");
        this.validWords.put("reported", "");
        this.validWords.put("research", "");
        this.validWords.put("result", "");
        this.validWords.put("results", "");
        this.validWords.put("revenue", "");
        this.validWords.put("right", "");
        this.validWords.put("rise", "");
        this.validWords.put("robert", "");
        this.validWords.put("room", "");
        this.validWords.put("rose", "");
        this.validWords.put("round", "");
        this.validWords.put("said", "");
        this.validWords.put("sale", "");
        this.validWords.put("sales", "");
        this.validWords.put("same", "");
        this.validWords.put("saw", "");
        this.validWords.put("say", "");
        this.validWords.put("says", "");
        this.validWords.put("school", "");
        this.validWords.put("second", "");
        this.validWords.put("securities", "");
        this.validWords.put("see", "");
        this.validWords.put("seem", "");
        this.validWords.put("seemed", "");
        this.validWords.put("seems", "");
        this.validWords.put("seen", "");
        this.validWords.put("sell", "");
        this.validWords.put("selling", "");
        this.validWords.put("senior", "");
        this.validWords.put("sense", "");
        this.validWords.put("sept", "");
        this.validWords.put("server", "");
        this.validWords.put("service", "");
        this.validWords.put("services", "");
        this.validWords.put("set", "");
        this.validWords.put("several", "");
        this.validWords.put("shall", "");
        this.validWords.put("share", "");
        this.validWords.put("shares", "");
        this.validWords.put("she", "");
        this.validWords.put("short", "");
        this.validWords.put("should", "");
        this.validWords.put("show", "");
        this.validWords.put("shown", "");
        this.validWords.put("side", "");
        this.validWords.put("since", "");
        this.validWords.put("sir", "");
        this.validWords.put("six", "");
        this.validWords.put("small", "");
        this.validWords.put("so", "");
        this.validWords.put("social", "");
        this.validWords.put("society", "");
        this.validWords.put("sold", "");
        this.validWords.put("some", "");
        this.validWords.put("something", "");
        this.validWords.put("sometimes", "");
        this.validWords.put("soon", "");
        this.validWords.put("source", "");
        this.validWords.put("special", "");
        this.validWords.put("spokesman", "");
        this.validWords.put("stage", "");
        this.validWords.put("stake", "");
        this.validWords.put("state", "");
        this.validWords.put("still", "");
        this.validWords.put("stock", "");
        this.validWords.put("stocks", "");
        this.validWords.put("story", "");
        this.validWords.put("strong", "");
        this.validWords.put("such", "");
        this.validWords.put("support", "");
        this.validWords.put("sure", "");
        this.validWords.put("system", "");
        this.validWords.put("table", "");
        this.validWords.put("take", "");
        this.validWords.put("taken", "");
        this.validWords.put("takeover", "");
        this.validWords.put("taking", "");
        this.validWords.put("talk", "");
        this.validWords.put("tax", "");
        this.validWords.put("tell", "");
        this.validWords.put("terms", "");
        this.validWords.put("text", "");
        this.validWords.put("than", "");
        this.validWords.put("that", "");
        this.validWords.put("the", "");
        this.validWords.put("their", "");
        this.validWords.put("them", "");
        this.validWords.put("themselves", "");
        this.validWords.put("then", "");
        this.validWords.put("there", "");
        this.validWords.put("therefore", "");
        this.validWords.put("these", "");
        this.validWords.put("they", "");
        this.validWords.put("thing", "");
        this.validWords.put("things", "");
        this.validWords.put("think", "");
        this.validWords.put("third", "");
        this.validWords.put("this", "");
        this.validWords.put("those", "");
        this.validWords.put("though", "");
        this.validWords.put("thought", "");
        this.validWords.put("three", "");
        this.validWords.put("through", "");
        this.validWords.put("thus", "");
        this.validWords.put("time", "");
        this.validWords.put("times", "");
        this.validWords.put("to", "");
        this.validWords.put("today", "");
        this.validWords.put("together", "");
        this.validWords.put("told", "");
        this.validWords.put("too", "");
        this.validWords.put("took", "");
        this.validWords.put("top", "");
        this.validWords.put("total", "");
        this.validWords.put("towards", "");
        this.validWords.put("town", "");
        this.validWords.put("trade", "");
        this.validWords.put("trading", "");
        this.validWords.put("true", "");
        this.validWords.put("turn", "");
        this.validWords.put("turned", "");
        this.validWords.put("two", "");
        this.validWords.put("type", "");
        this.validWords.put("under", "");
        this.validWords.put("unit", "");
        this.validWords.put("until", "");
        this.validWords.put("up", "");
        this.validWords.put("upon", "");
        this.validWords.put("us", "");
        this.validWords.put("use", "");
        this.validWords.put("used", "");
        this.validWords.put("usually", "");
        this.validWords.put("value", "");
        this.validWords.put("very", "");
        this.validWords.put("vice", "");
        this.validWords.put("view", "");
        this.validWords.put("voice", "");
        this.validWords.put("wall", "");
        this.validWords.put("want", "");
        this.validWords.put("wanted", "");
        this.validWords.put("war", "");
        this.validWords.put("was", "");
        this.validWords.put("washington", "");
        this.validWords.put("water", "");
        this.validWords.put("way", "");
        this.validWords.put("we", "");
        this.validWords.put("week", "");
        this.validWords.put("weeks", "");
        this.validWords.put("well", "");
        this.validWords.put("went", "");
        this.validWords.put("were", "");
        this.validWords.put("west", "");
        this.validWords.put("what", "");
        this.validWords.put("when", "");
        this.validWords.put("where", "");
        this.validWords.put("whether", "");
        this.validWords.put("which", "");
        this.validWords.put("while", "");
        this.validWords.put("white", "");
        this.validWords.put("who", "");
        this.validWords.put("whole", "");
        this.validWords.put("whom", "");
        this.validWords.put("whose", "");
        this.validWords.put("why", "");
        this.validWords.put("wife", "");
        this.validWords.put("will", "");
        this.validWords.put("with", "");
        this.validWords.put("within", "");
        this.validWords.put("without", "");
        this.validWords.put("without", "");
        this.validWords.put("woman", "");
        this.validWords.put("word", "");
        this.validWords.put("words", "");
        this.validWords.put("work", "");
        this.validWords.put("working", "");
        this.validWords.put("world", "");
        this.validWords.put("would", "");
        this.validWords.put("year", "");
        this.validWords.put("years", "");
        this.validWords.put("yen", "");
        this.validWords.put("yes", "");
        this.validWords.put("yesterday", "");
        this.validWords.put("yet", "");
        this.validWords.put("yield", "");
        this.validWords.put("york", "");
        this.validWords.put("you", "");
        this.validWords.put("young", "");
        this.validWords.put("your", "");
        this.validWords.put("yours", "");
    }
}

