/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.net.URL;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCComponent;
import jclass.bwt.LabelConverter;
import jclass.util.JCString;
import jclass.util.JCStringTokenizer;

public class JCLabel
extends JCComponent {
    public static final int TOPLEFT = 0;
    public static final int LEFT = 0;
    public static final int TOPCENTER = 1;
    public static final int CENTER = 1;
    public static final int TOPRIGHT = 2;
    public static final int RIGHT = 2;
    public static final int MIDDLELEFT = 3;
    public static final int MIDDLECENTER = 4;
    public static final int MIDDLE = 4;
    public static final int MIDDLERIGHT = 5;
    public static final int BOTTOMLEFT = 6;
    public static final int BOTTOMCENTER = 7;
    public static final int BOTTOMRIGHT = 8;
    public static final int SHADOW_NONE = 0;
    public static final int SHADOW_ETCHED_IN = 1;
    public static final int SHADOW_ETCHED_OUT = 2;
    public static final int SHADOW_IN = 3;
    public static final int SHADOW_OUT = 4;
    public static final int SHADOW_PLAIN = 5;
    public static final int SHADOW_FRAME_IN = 6;
    public static final int SHADOW_FRAME_OUT = 7;
    int alignment = 4;
    Object label;
    protected int label_width;
    protected int label_height;
    protected Rectangle label_rect = new Rectangle();
    protected transient String url;
    transient URL label_url;
    private static final String base = "label";
    private static int nameCounter;

    public JCLabel() {
        this(null, null, null);
    }

    public JCLabel(Object object) {
        this(object, null, null);
    }

    public JCLabel(String string, Image image, int n) {
        this(new JCString(string, image, n), null, null);
    }

    public JCLabel(String string, String string2, Applet applet, int n) {
        this(null, null, null);
        this.setLabel(new JCString(string, JCComponent.conv.toImage(applet, string2), n));
    }

    public JCLabel(Object object, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.border = 0;
        this.highlight = 0;
        this.traversable = false;
        this.insets = new Insets(2, 5, 2, 5);
        if (this.getClass().getName().equals("jclass.bwt.JCLabel")) {
            this.getParameters(applet);
        }
        if (object != null) {
            this.setLabel(object);
        }
    }

    protected void getParameters() {
        super.getParameters();
        LabelConverter.getParams(this);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        LabelConverter.checkAlignment(n);
        if (n != this.alignment) {
            this.alignment = n;
            this.layout();
            this.repaint();
        }
    }

    public void setFont(Font font) {
        boolean bl = this.getFont() != null && !this.getFont().equals(font);
        super.setFont(font);
        if (bl) {
            this.setLabelSize(this.label);
            this.layout();
            this.repaint();
        }
    }

    void setFontInternal(Font font) {
        super.setFont(font);
        this.setLabelSize(this.label);
        this.layout();
    }

    public Object getLabel() {
        return this.label;
    }

    public void setLabel(Object object) {
        this.label = object;
        this.setLabelSize(this.label);
        this.layout();
        this.repaint();
    }

    public String getText() {
        if (this.label != null) {
            return this.label.toString();
        }
        return null;
    }

    public void setText(String string) {
        this.setLabel(string);
    }

    public String[] getTextList() {
        if (this.label == null) {
            return null;
        }
        String string = this.label.toString();
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        String[] stringArray = new String[jCStringTokenizer.countTokens('\n')];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            stringArray[n] = jCStringTokenizer.nextToken('\n').trim();
            ++n;
        }
        return stringArray;
    }

    public void setTextList(String[] stringArray) {
        if (stringArray == null) {
            this.setLabel(null);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n < stringArray.length - 1) {
                stringBuffer.append('\n');
            }
            ++n;
        }
        this.setLabel(new String(stringBuffer));
    }

    public URL getLabelImage() {
        return this.label_url;
    }

    public void setLabelImage(URL uRL) {
        this.label_url = uRL;
        this.setLabel(this.getToolkit().getImage(uRL));
    }

    public int getShadowType() {
        return this.border_style;
    }

    public void setShadowType(int n) {
        this.setBorderStyle(n);
    }

    protected synchronized void drawValue(Graphics graphics, Object object) {
        if (!this.isEnabled()) {
            Color color = graphics.getColor();
            graphics.translate(1, 1);
            graphics.setColor(Color.white);
            BWTUtil.draw(this, graphics, object, this.alignment, this.label_rect);
            graphics.translate(-1, -1);
            graphics.setColor(this.getBackground().darker());
            BWTUtil.draw(this, graphics, object, this.alignment, this.label_rect);
            graphics.setColor(color);
            return;
        }
        BWTUtil.draw(this, graphics, object, this.alignment, this.label_rect);
    }

    protected void paintComponent(Graphics graphics) {
        if (this.needs_layout) {
            this.layout();
        }
        this.drawValue(graphics, this.label);
    }

    protected void setLabelSize(Object object) {
        this.setLabelSize(object, this.getFont());
    }

    protected void setLabelSize(Object object, Font font) {
        if (this.getPeer() == null) {
            return;
        }
        this.label_width = BWTUtil.getWidth(object, this, font);
        this.label_height = BWTUtil.getHeight(object, this, font);
        if (this.applet_context != null && BWTUtil.is_jcstring(object)) {
            this.enableEvents(32L);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.setLabelSize(this.label);
        if (this.needs_layout) {
            this.layout();
        }
    }

    protected int preferredWidth() {
        return Math.max(20, this.label_width);
    }

    protected int preferredHeight() {
        return Math.max(20, this.label_height);
    }

    public Rectangle getLabelBounds() {
        return this.label_rect;
    }

    public void layout() {
        if (this.getPeer() == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        JCLabel jCLabel = this;
        synchronized (jCLabel) {
            this.getDrawingArea(this.label_rect);
            if (this.label_rect.width <= 0 || this.label_rect.height <= 0) {
                this.needs_layout = true;
                Object var4_4 = null;
                return;
            }
            this.needs_layout = false;
            if (BWTUtil.isRight(this.alignment)) {
                this.label_rect.x += this.label_rect.width - this.label_width;
            } else if (BWTUtil.isCenter(this.alignment)) {
                this.label_rect.x += (this.label_rect.width - this.label_width) / 2;
            }
            if (BWTUtil.isMiddle(this.alignment)) {
                this.label_rect.y += (this.label_rect.height - this.label_height) / 2;
            } else if (BWTUtil.isBottom(this.alignment)) {
                this.label_rect.y += this.label_rect.height - this.label_height;
            }
            n2 = this.label_width;
            n = this.label_height;
        }
        this.label_rect.resize(n2, n);
    }

    protected void layout(Object object) {
        this.setLabelSize(object);
        this.layout();
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.applet_context != null && BWTUtil.is_jcstring(this.label)) {
            this.url = JCString.getURL(this.applet, this.label, n, n2);
            if (this.url != null) {
                this.setCursor(12);
                return true;
            }
        }
        this.url = null;
        this.setCursor(0);
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.url != null) {
            JCString.showURL(this.url, this.applet_context, this.applet);
        }
        return false;
    }
}

