/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.Filter;
import innoval.mailer.FilterChoiceObject;
import innoval.mailer.FilterMessage;
import innoval.mailer.PopFileProcedure;
import java.lang.reflect.Method;
import java.util.Vector;

public class FilterDefinitions {
    String[] regFilterCompareField;
    String[] regFilterTestType;
    String[] listFilterTestType;
    String[] filterResultChoices;
    Vector regFilterFieldVector = new Vector(20, 2);
    static final int RFC_NONE = 0;
    static final int RFC_FROM = 101;
    static final int RFC_REPLYTO = 102;
    static final int RFC_TO = 103;
    static final int RFC_CC = 104;
    static final int RFC_SUBJECT = 105;
    static final int RFC_BODY = 106;
    static final int RFC_PRIORITY = 107;
    static final int RFC_RECEIVED = 108;
    static final int RFC_HEADERS = 109;
    static final int RFC_ALLTEXT = 110;
    Vector regFilterTestVector = new Vector(20, 2);
    static final int RFT_NONE = 0;
    static final int RFT_CONTAIN = 131;
    static final int RFT_NOTCONTAIN = 132;
    static final int RFT_EQUAL = 133;
    static final int RFT_NOTEQUAL = 134;
    static final int RFT_STARTWITH = 135;
    static final int RFT_ENDWITH = 136;
    static final int RFT_EXIST = 137;
    static final int RFT_NOTEXIST = 138;
    Vector listFilterTestVector = new Vector(20, 2);
    static final int LFT_NONE = 0;
    static final int LFT_MSGBODY_COMB = 151;
    static final int LFT_ANYHDR_COMB = 152;
    static final int LFT_RECV_DOM = 153;
    static final int LFT_FROM_RPLY_DOM = 154;
    static final int LFT_ANYHDR_DOM = 155;
    static final int LFT_FROM_RPLY_USR = 156;
    static final int LFT_TO_CC_USR = 157;
    static final int LFT_ANYHDR_USR = 158;
    Vector filterResultChoiceVector = new Vector(20, 2);
    static final int RESULT_NONE = 0;
    static final int RESULT_FOLDER_MOVE = 171;
    static final int RESULT_FOLDER_COPY = 172;
    static final int RESULT_PLAY_SOUND = 173;
    static final int RESULT_SHOW_MSG = 174;
    static final int RESULT_PRINT_MSG = 175;
    static final int RESULT_FORWD_NOW = 176;
    static final int RESULT_FORWD_LATER = 177;
    static final int RESULT_BOUNCE_NOW = 178;
    static final int RESULT_BOUNCE_LATER = 179;
    static final int RESULT_REPLY_NOW = 180;
    static final int RESULT_REPLY_LATER = 181;
    static final int RESULT_ACCT_MOVE = 182;
    static final int RESULT_ACCT_COPY = 183;
    static final int RESULT_NOTIFY_EMAIL = 184;
    static final int RESULT_STOP_FILTER = 185;
    static final int RESULT_DELETE_MSG = 186;
    static final int RESULT_DIR_MOVE = 187;
    static final int RESULT_DIR_COPY = 188;
    static final int RESULT_SET_COLORCODE = 189;

    public FilterDefinitions() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        int i = 0;
        this.regFilterFieldVector.addElement(new FilterChoiceObject(0, ""));
        this.regFilterFieldVector.addElement(new FilterChoiceObject(101, "From"));
        this.regFilterFieldVector.addElement(new FilterChoiceObject(102, "Reply-To"));
        this.regFilterFieldVector.addElement(new FilterChoiceObject(103, "To"));
        this.regFilterFieldVector.addElement(new FilterChoiceObject(104, "Cc"));
        this.regFilterFieldVector.addElement(new FilterChoiceObject(105, "Subject"));
        this.regFilterFieldVector.addElement(new FilterChoiceObject(107, "Priority"));
        this.regFilterFieldVector.addElement(new FilterChoiceObject(108, "Received"));
        this.regFilterFieldVector.addElement(new FilterChoiceObject(109, "Headers"));
        this.regFilterFieldVector.addElement(new FilterChoiceObject(106, "Body"));
        this.regFilterFieldVector.addElement(new FilterChoiceObject(110, "All Text"));
        this.regFilterTestVector.addElement(new FilterChoiceObject(0, " "));
        this.regFilterTestVector.addElement(new FilterChoiceObject(131, "contains"));
        this.regFilterTestVector.addElement(new FilterChoiceObject(132, "does not contain"));
        this.regFilterTestVector.addElement(new FilterChoiceObject(133, "equals"));
        this.regFilterTestVector.addElement(new FilterChoiceObject(134, "does not equal"));
        this.regFilterTestVector.addElement(new FilterChoiceObject(135, "starts with"));
        this.regFilterTestVector.addElement(new FilterChoiceObject(136, "ends with"));
        this.regFilterTestVector.addElement(new FilterChoiceObject(137, "exists"));
        this.regFilterTestVector.addElement(new FilterChoiceObject(138, "does not exist"));
        this.listFilterTestVector.addElement(new FilterChoiceObject(0, ""));
        this.listFilterTestVector.addElement(new FilterChoiceObject(151, "Message body contains any combination of the strings ..."));
        this.listFilterTestVector.addElement(new FilterChoiceObject(152, "Any header contains any combination of the strings ..."));
        this.listFilterTestVector.addElement(new FilterChoiceObject(0, " "));
        this.listFilterTestVector.addElement(new FilterChoiceObject(153, "Received header contains any of the domains ..."));
        this.listFilterTestVector.addElement(new FilterChoiceObject(154, "From or Reply-To contains any of the domains ..."));
        this.listFilterTestVector.addElement(new FilterChoiceObject(155, "Any header contains any of the domains ..."));
        this.listFilterTestVector.addElement(new FilterChoiceObject(0, "  "));
        this.listFilterTestVector.addElement(new FilterChoiceObject(156, "From or Reply-To contains any of the user names ..."));
        this.listFilterTestVector.addElement(new FilterChoiceObject(157, "To, Cc, or Bcc contains any of the user names ..."));
        this.listFilterTestVector.addElement(new FilterChoiceObject(158, "Any header contains any of the user names ..."));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(0, ""));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(186, "Delete Message"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(172, "Copy to Folder"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(171, "Move to Folder"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(188, "Copy to Directory"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(187, "Move to Directory"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(180, "Reply Now"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(181, "Reply Later"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(176, "Forward Now"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(177, "Forward Later"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(178, "Bounce Now"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(179, "Bounce Later"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(183, "Copy to Account"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(182, "Move to Account"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(189, "Set Color Code"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(173, "Play Sound"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(174, "Show Message"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(175, "Print Message"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(184, "Notify by Email Now"));
        this.filterResultChoiceVector.addElement(new FilterChoiceObject(185, "Stop Filtering "));
        this.regFilterCompareField = new String[this.regFilterFieldVector.size()];
        for (i = 0; i < this.regFilterFieldVector.size(); ++i) {
            this.regFilterCompareField[i] = ((FilterChoiceObject)this.regFilterFieldVector.elementAt(i)).getText();
        }
        this.regFilterTestType = new String[this.regFilterTestVector.size()];
        for (i = 0; i < this.regFilterTestVector.size(); ++i) {
            this.regFilterTestType[i] = ((FilterChoiceObject)this.regFilterTestVector.elementAt(i)).getText();
        }
        this.listFilterTestType = new String[this.listFilterTestVector.size()];
        for (i = 0; i < this.listFilterTestVector.size(); ++i) {
            this.listFilterTestType[i] = ((FilterChoiceObject)this.listFilterTestVector.elementAt(i)).getText();
        }
        this.filterResultChoices = new String[this.filterResultChoiceVector.size()];
        for (i = 0; i < this.filterResultChoiceVector.size(); ++i) {
            this.filterResultChoices[i] = ((FilterChoiceObject)this.filterResultChoiceVector.elementAt(i)).getText();
        }
    }

    public boolean RunRegFilter(PopFileProcedure message, Filter runFilter) {
        boolean ret_code = false;
        boolean ret_code1 = false;
        boolean ret_code2 = false;
        if (runFilter.regFilterAndOr.equals("")) {
            ret_code = this.RunRegFilter(message, runFilter.regFilterType1, runFilter.regFilterField1, runFilter.regFilterTestValue1, runFilter.regFilterIgnoreCase1);
        } else {
            ret_code1 = this.RunRegFilter(message, runFilter.regFilterType1, runFilter.regFilterField1, runFilter.regFilterTestValue1, runFilter.regFilterIgnoreCase1);
            ret_code2 = this.RunRegFilter(message, runFilter.regFilterType2, runFilter.regFilterField2, runFilter.regFilterTestValue2, runFilter.regFilterIgnoreCase2);
            if (runFilter.regFilterAndOr.equalsIgnoreCase("and")) {
                ret_code = ret_code1 & ret_code2;
            } else if (runFilter.regFilterAndOr.equalsIgnoreCase("or")) {
                ret_code = ret_code1 | ret_code2;
            } else if (runFilter.regFilterAndOr.equalsIgnoreCase("xor")) {
                ret_code = (ret_code1 | ret_code2) & !(ret_code1 & ret_code2);
            }
        }
        return ret_code;
    }

    public boolean RunRegFilter(PopFileProcedure message, Integer regFilterType, Integer regFilterField, String regFilterTestValue, boolean regFilterIgnoreCase) {
        boolean ret_code = false;
        String testString = new String();
        switch (regFilterField) {
            case 101: {
                testString = message.getHeaderLines("from").toString();
                break;
            }
            case 102: {
                testString = message.getHeaderLines("reply-to").toString();
                break;
            }
            case 103: {
                testString = message.getHeaderLines("to").toString();
                break;
            }
            case 104: {
                testString = message.getHeaderLines("cc").toString();
                break;
            }
            case 105: {
                testString = message.getHeaderLines("subject").toString();
                break;
            }
            case 106: {
                testString = message.getPopBodyText();
                break;
            }
            case 107: {
                testString = message.getHeaderLines("priority").toString();
                break;
            }
            case 108: {
                testString = message.getHeaderLines("received").toString();
                break;
            }
            case 109: {
                testString = message.getHeaderLines("all").toString();
                break;
            }
            case 110: {
                testString = message.getPopText();
            }
        }
        if (regFilterIgnoreCase) {
            testString = testString.toLowerCase().trim();
            regFilterTestValue = regFilterTestValue.toLowerCase().trim();
        } else {
            testString = testString.trim();
            regFilterTestValue = regFilterTestValue.trim();
        }
        switch (regFilterType) {
            case 131: {
                if (testString.indexOf(regFilterTestValue) < 0) break;
                ret_code = true;
                break;
            }
            case 132: {
                if (testString.indexOf(regFilterTestValue) >= 0) break;
                ret_code = true;
                break;
            }
            case 133: {
                ret_code = testString.equals(regFilterTestValue);
                break;
            }
            case 134: {
                ret_code = !testString.equals(regFilterTestValue);
                break;
            }
            case 135: {
                ret_code = testString.startsWith(regFilterTestValue);
                break;
            }
            case 136: {
                ret_code = testString.endsWith(regFilterTestValue);
                break;
            }
            case 137: {
                if (testString.length() <= 0) break;
                ret_code = true;
                break;
            }
            case 138: {
                if (testString.length() != 0) break;
                ret_code = true;
            }
        }
        return ret_code;
    }

    public boolean RunListFilter(PopFileProcedure message, Filter runFilter) {
        boolean ret_code = false;
        boolean index = false;
        int cnt = 0;
        String testString = new String();
        String testValues = new String();
        testValues = runFilter.listFilterTestValues.replace('\n', ',').toLowerCase();
        switch (runFilter.listFilterType) {
            case 0: {
                break;
            }
            case 151: {
                testString = message.readBody(message.getPopFile()).trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt <= 0 || cnt < runFilter.listFilterComboValue) break;
                ret_code = true;
                break;
            }
            case 152: {
                testString = message.getHeader("all").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt <= 0 || cnt < runFilter.listFilterComboValue) break;
                ret_code = true;
                break;
            }
            case 153: {
                testString = message.getHeader("received").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt <= 0) break;
                ret_code = true;
                break;
            }
            case 154: {
                testString = message.getHeader("from").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt > 0) {
                    ret_code = true;
                    break;
                }
                testString = message.getHeader("reply-to").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt <= 0) break;
                ret_code = true;
                break;
            }
            case 155: {
                testString = message.getHeader("all").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt <= 0) break;
                ret_code = true;
                break;
            }
            case 156: {
                testString = message.getHeader("from").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt > 0) {
                    ret_code = true;
                    break;
                }
                testString = message.getHeader("reply-to").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt <= 0) break;
                ret_code = true;
                break;
            }
            case 157: {
                testString = message.getHeader("to").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt > 0) {
                    ret_code = true;
                    break;
                }
                testString = message.getHeader("cc").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt > 0) {
                    ret_code = true;
                    break;
                }
                testString = message.getHeader("bcc").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt <= 0) break;
                ret_code = true;
                break;
            }
            case 158: {
                testString = message.getHeader("all").trim().toLowerCase();
                cnt = this.RunListFilter(testString, testValues);
                if (cnt <= 0) break;
                ret_code = true;
            }
        }
        return ret_code;
    }

    public int RunListFilter(String testString, String testValues) {
        int toIndex = 0;
        int cnt = 0;
        while (testValues.length() > 0) {
            toIndex = testValues.indexOf(",");
            if (toIndex > 0) {
                if (testString.indexOf(testValues.substring(0, toIndex)) >= 0) {
                    ++cnt;
                }
                testValues = testValues.substring(toIndex + 1);
                continue;
            }
            if (testString.indexOf(testValues) >= 0) {
                ++cnt;
            }
            testValues = "";
        }
        return cnt;
    }

    public boolean RunJavaFilter(PopFileProcedure message, Filter runFilter) {
        boolean ret_code = false;
        FilterMessage msg = new FilterMessage();
        msg.FROM = message.getHeader("from");
        msg.REPLY_TO = message.getHeader("reply-to");
        msg.TO = message.getHeader("to");
        msg.CC = message.getHeader("cc");
        msg.BCC = message.getHeader("bcc");
        msg.DATE = message.getHeader("date");
        msg.SUBJECT = message.getHeader("subject");
        msg.RECEIVED = message.getHeader("received");
        msg.PRIORITY = message.getHeader("priority");
        msg.BODY = message.readBody(message.getPopFile());
        msg.ALLHEADERS = message.getHeader("all");
        msg.ENTIREMSG = String.valueOf(msg.ALLHEADERS).concat(String.valueOf(msg.BODY));
        msg.MSG_FULLPATH = message.popfile.getAbsolutePath();
        int cnt = 0;
        int i = 0;
        int toIndex = 0;
        if (runFilter.javaFilterClassArgs.trim().length() > 0) {
            String buffer = runFilter.javaFilterClassArgs.trim();
            ++cnt;
            while ((toIndex = buffer.indexOf(",", toIndex + 1)) >= 0) {
                ++cnt;
            }
            msg.parameterValues = new String[cnt];
            i = 0;
            while ((toIndex = buffer.indexOf(",")) >= 0) {
                msg.parameterValues[i] = buffer.substring(0, toIndex);
                ++i;
                buffer = buffer.substring(toIndex + 1);
            }
            msg.parameterValues[i] = buffer.substring(0);
        } else {
            msg.parameterValues = new String[1];
        }
        try {
            Class[] parameterTypes = new Class[]{Class.forName("innoval.mailer.FilterMessage")};
            Object[] parameterValues = new FilterMessage[]{msg};
            Class<?> javaClass = Class.forName(runFilter.javaFilterClassName);
            Object javaObject = javaClass.newInstance();
            Method javaFilterMethod = javaClass.getMethod("getResult", parameterTypes);
            Object returnValue = javaFilterMethod.invoke(javaObject, parameterValues);
            ret_code = returnValue.toString().equals("true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret_code;
    }

    public int getVectorIndex(Vector searchVector, Integer symbol) {
        int i = 0;
        Integer test = new Integer(0);
        for (i = 0; i < searchVector.size(); ++i) {
            test = ((FilterChoiceObject)searchVector.elementAt(i)).getSymbol();
            if (symbol.intValue() != test.intValue()) continue;
            return i;
        }
        return 0;
    }

    public Integer getVectorSymbol(Vector searchVector, String text) {
        int i = 0;
        for (i = 0; i < searchVector.size(); ++i) {
            if (text != ((FilterChoiceObject)searchVector.elementAt(i)).getText()) continue;
            return ((FilterChoiceObject)searchVector.elementAt(i)).getSymbol();
        }
        return new Integer(0);
    }
}

