/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Box;
import ice.htmlbrowser.BoxLineBreak;
import ice.htmlbrowser.BoxWord;
import ice.htmlbrowser.Document;
import ice.htmlbrowser.VisControlPoint;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

class VisDocument
implements Runnable {
    private int visWidth = 0;
    private int startWidth = 0;
    private int numBoxes = 0;
    private int str_x = 0;
    private int str_start_x = 0;
    private int str_y = 0;
    private boolean str_underline = false;
    private boolean str_strikeout = false;
    private String str_buf;
    private Box firstBox;
    private Box firstVisBox;
    private Vector controlPoints = new Vector();
    private Thread layoutThread;
    private Document observer = null;
    private Dimension docNormalSize = new Dimension(0, 0);
    private Dimension docMinSize = null;
    private static boolean flagFullLayout = true;
    private volatile boolean start_flag = false;
    private boolean stopRunning = false;

    VisDocument() {
    }

    VisDocument(Document observer) {
        this();
        this.observer = observer;
        this.layoutThread = new Thread(this);
        this.layoutThread.start();
    }

    public void init() {
        this.visWidth = 0;
        this.startWidth = 0;
        this.numBoxes = 0;
        this.firstBox = null;
        this.firstVisBox = null;
        this.controlPoints = null;
        this.controlPoints = new Vector();
        this.docNormalSize = null;
        this.docMinSize = null;
        flagFullLayout = true;
        this.start_flag = false;
        this.str_x = 0;
        this.str_start_x = 0;
        this.str_y = 0;
        this.str_underline = false;
        this.str_strikeout = false;
        this.str_buf = null;
    }

    void doLayout(Box firstBox, int numBoxes, int visWidth, int startWidth) {
        block9: {
            if (numBoxes == 0) {
                return;
            }
            if (visWidth == this.visWidth && numBoxes == this.numBoxes && !flagFullLayout) {
                if (this.observer != null) {
                    this.observer.finalDocumentDimension(false);
                }
                return;
            }
            if (visWidth == 0 && numBoxes == this.numBoxes && this.docMinSize != null && !flagFullLayout) {
                this.visWidth = visWidth;
                this.docNormalSize = new Dimension(this.docMinSize);
                return;
            }
            this.firstBox = firstBox;
            this.visWidth = visWidth;
            this.startWidth = startWidth;
            if (this.observer != null) {
                this.start_flag = true;
                this.observer.firstDocumentDimension();
                if (!this.layoutThread.isAlive()) {
                    this.layoutThread = new Thread(this);
                    this.layoutThread.start();
                }
                VisDocument visDocument = this;
                synchronized (visDocument) {
                    try {
                        this.notify();
                        Object var7_6 = null;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        throw throwable;
                    }
                }
            }
            this.layoutBoxes();
        }
    }

    public void setStop(boolean val) {
        this.stopRunning = val;
    }

    public void run() {
        while (!this.stopRunning) {
            while (!this.start_flag) {
                VisDocument visDocument = this;
                synchronized (visDocument) {
                    Object var4_3;
                    try {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        throw throwable;
                    }
                }
            }
            this.start_flag = false;
            this.layoutBoxes();
        }
        System.out.println("visdoc ending...");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Box getNextBox(Box b) {
        if (b.getNext() != null) return b.getNext();
        if (this.observer == null) return null;
        if (this.observer.isParsingDone()) return null;
        VisDocument visDocument = this;
        synchronized (visDocument) {
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                Object var5_4 = null;
                return b.getNext();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void layoutBoxes() {
        int draw_width;
        Box b;
        this.controlPoints.removeAllElements();
        int h_align = 1;
        int marginWidth = 0;
        int marginHeight = 0;
        if (this.observer != null) {
            marginWidth = this.observer.getMarginWidth();
            marginHeight = this.observer.getMarginHeight();
        }
        int line_height = 0;
        int line_base = 0;
        int line_width = 0;
        int doc_width = this.startWidth;
        int doc_height = marginHeight;
        int height = marginHeight;
        int indentLeft = 0;
        int wrapLeft = 0;
        int wrapRight = 0;
        int wrapLeftEnd = 0;
        int wrapRightEnd = 0;
        Box line_start = b = this.firstBox;
        Box lastBreak = null;
        int lastBreakWidth = 0;
        this.numBoxes = 0;
        while (b != null && !this.start_flag) {
            block58: {
                int new_w;
                int x;
                if (b.isBreakable() && line_start != b) {
                    lastBreak = b;
                    lastBreakWidth = line_width;
                }
                if (height >= wrapLeftEnd) {
                    wrapLeft = 0;
                }
                if (height >= wrapRightEnd) {
                    wrapRight = 0;
                }
                if ((draw_width = this.visWidth - wrapLeft - wrapRight - indentLeft - marginWidth * 2) <= 0 && (wrapLeftEnd > height || wrapRightEnd > height)) {
                    int h = height;
                    if (wrapLeftEnd > h) {
                        h = wrapLeftEnd;
                    }
                    if (wrapRightEnd > h) {
                        h = wrapRightEnd;
                    }
                    height = h;
                    draw_width = this.visWidth - indentLeft - marginWidth * 2;
                    wrapRight = 0;
                    wrapLeft = 0;
                }
                b.layout(draw_width, line_start == b);
                Dimension bsize = b.size();
                int attrib = b.getAttrib();
                if (line_width > 0 && lastBreak != null && (b instanceof BoxLineBreak || line_width + bsize.width > draw_width)) {
                    x = wrapLeft + indentLeft + marginWidth;
                    if (lastBreakWidth < draw_width) {
                        if (h_align == 2) {
                            x += (draw_width - lastBreakWidth) / 2;
                        } else if (h_align == 3) {
                            x += draw_width - lastBreakWidth;
                        }
                    }
                    for (Box bb = line_start; bb != lastBreak && bb != null; x += bb.size().width, bb = bb.getNext()) {
                        int y = height + line_base - bb.getBaseLine();
                        bb.move(x, y);
                    }
                    if ((height += line_height) > doc_height) {
                        doc_height = height;
                    }
                    line_width -= lastBreakWidth;
                    line_base = 0;
                    line_height = 0;
                    line_start = lastBreak;
                    lastBreak.layout(draw_width, true);
                    lastBreak = null;
                    if (height >= wrapLeftEnd) {
                        wrapLeft = 0;
                    }
                    if (height >= wrapRightEnd) {
                        wrapRight = 0;
                    }
                    if ((draw_width = this.visWidth - wrapLeft - wrapRight - indentLeft - marginWidth * 2) <= 0 && (wrapLeftEnd > height || wrapRightEnd > height)) {
                        int h = height;
                        if (wrapLeftEnd > h) {
                            h = wrapLeftEnd;
                        }
                        if (wrapRightEnd > h) {
                            h = wrapRightEnd;
                        }
                        height = h;
                        draw_width = this.visWidth - indentLeft - marginWidth * 2;
                        wrapRight = 0;
                        wrapLeft = 0;
                    }
                    bsize = b.size();
                }
                switch (attrib) {
                    case 1: 
                    case 2: 
                    case 3: {
                        h_align = attrib;
                        break;
                    }
                    case 9: {
                        draw_width = this.visWidth - wrapLeft - wrapRight - (indentLeft += 40) - marginWidth * 2;
                        b.layout(draw_width, line_start == b);
                        bsize = b.size();
                        break;
                    }
                    case 10: {
                        draw_width = this.visWidth - wrapLeft - wrapRight - (indentLeft -= 40) - marginWidth * 2;
                        b.layout(draw_width, line_start == b);
                        bsize = b.size();
                        break;
                    }
                    case 11: {
                        if (indentLeft <= 0) break;
                        x = marginWidth + wrapLeft + indentLeft - bsize.width;
                        if (x < marginWidth) {
                            x = marginWidth;
                        }
                        b.move(x, height);
                        line_start = this.getNextBox(b);
                        lastBreak = null;
                        this.makeControlPoint(b, this.numBoxes, height + bsize.height);
                        break block58;
                    }
                    case 4: {
                        b.move(wrapLeft + marginWidth, height);
                        if (bsize.width < this.visWidth - marginWidth * 2 - wrapLeft) {
                            wrapLeft += bsize.width;
                            doc_height = wrapLeftEnd = height + bsize.height;
                        } else {
                            if (doc_width < bsize.width) {
                                doc_width = bsize.width;
                            }
                            if (doc_height < (height += bsize.height)) {
                                doc_height = height;
                            }
                        }
                        line_start = this.getNextBox(b);
                        lastBreak = null;
                        this.makeControlPoint(b, this.numBoxes, height + bsize.height);
                        break block58;
                    }
                    case 5: {
                        if (bsize.width < this.visWidth - marginWidth * 2) {
                            b.move(this.visWidth - bsize.width - marginWidth, height);
                            wrapRight = bsize.width;
                            doc_height = wrapRightEnd = height + bsize.height;
                        } else {
                            b.move(marginWidth, height);
                            if (doc_width < bsize.width) {
                                doc_width = bsize.width;
                            }
                            if (doc_height < (height += bsize.height)) {
                                doc_height = height;
                            }
                        }
                        line_start = this.getNextBox(b);
                        lastBreak = null;
                        this.makeControlPoint(b, this.numBoxes, height + bsize.height);
                        break block58;
                    }
                    case 6: {
                        if (wrapLeftEnd > height) {
                            height = wrapLeftEnd;
                        }
                        line_start = this.getNextBox(b);
                        lastBreak = null;
                        break;
                    }
                    case 7: {
                        if (wrapRightEnd > height) {
                            height = wrapRightEnd;
                        }
                        line_start = this.getNextBox(b);
                        lastBreak = null;
                        break;
                    }
                    case 8: {
                        int h = height;
                        if (wrapLeftEnd > h) {
                            h = wrapLeftEnd;
                        }
                        if (wrapRightEnd > h) {
                            h = wrapRightEnd;
                        }
                        height = h;
                        line_start = this.getNextBox(b);
                        lastBreak = null;
                    }
                }
                int d = b.getBaseLine() - line_base;
                if (d > 0) {
                    line_base += d;
                    line_height += d;
                    d = 0;
                }
                if ((d += bsize.height) > line_height) {
                    line_height = d;
                }
                if (!(b instanceof BoxLineBreak) && doc_width < (new_w = (line_width += bsize.width) + wrapLeft + indentLeft + marginWidth * 2)) {
                    doc_width = new_w;
                }
                if (this.observer != null) {
                    this.observer.updateDocumentDimension(doc_width, height);
                    Thread.yield();
                }
                this.makeControlPoint(b, this.numBoxes, height + bsize.height);
            }
            b = this.getNextBox(b);
            ++this.numBoxes;
        }
        if (line_width > 0) {
            draw_width = this.visWidth - wrapLeft - wrapRight - indentLeft - marginWidth * 2;
            int x = wrapLeft + indentLeft + marginWidth;
            if (line_width < draw_width) {
                if (h_align == 2) {
                    x += (draw_width - line_width) / 2;
                } else if (h_align == 3) {
                    x += draw_width - line_width;
                }
            }
            for (Box bb = line_start; bb != b; x += bb.size().width, bb = bb.getNext()) {
                int y = height + line_base - bb.getBaseLine();
                bb.move(x, y);
            }
            if ((height += line_height) > doc_height) {
                doc_height = height;
            }
        }
        if (this.start_flag) {
            return;
        }
        this.docNormalSize = new Dimension(doc_width, doc_height += marginHeight);
        if (this.visWidth == 0) {
            this.docMinSize = new Dimension(this.docNormalSize);
        }
        if (this.observer != null) {
            this.observer.finalDocumentDimension(true);
        }
        flagFullLayout = false;
    }

    void prepareFullLayout() {
        flagFullLayout = true;
    }

    synchronized Dimension docSize() {
        return new Dimension(this.docNormalSize);
    }

    private void makeControlPoint(Box b, int idx, int y) {
        if (this.controlPoints != null) {
            for (int next_y = this.controlPoints.size() * 100; y > next_y; next_y += 100) {
                this.controlPoints.addElement(new VisControlPoint(b, idx));
            }
        }
    }

    private int findFirstVisBox(int y) {
        Box b = this.firstBox;
        int count = 0;
        if ((y /= 100) >= 0 && y < this.controlPoints.size()) {
            VisControlPoint vcp = (VisControlPoint)this.controlPoints.elementAt(y);
            b = vcp.getBox();
            count = vcp.getBoxIndex();
        }
        while (b != null && b.location().y + b.size().height <= y) {
            b = b.getNext();
            ++count;
        }
        this.firstVisBox = b;
        return count;
    }

    Box mouseClicked(int x, int y) {
        return this.mouseClicked(x, y, 0);
    }

    Box mouseClicked(int x, int y, int add_y) {
        Box b = this.findBoxAt(x, y, add_y);
        if (b != null) {
            Point pos = b.location();
            return b.mouseClicked(x - pos.x, y - pos.y);
        }
        return null;
    }

    Box mouseDoubleClicked(int x, int y) {
        return this.findBoxAt(x, y, 0);
    }

    Box mouseMoved(int x, int y) {
        return this.mouseMoved(x, y, 0);
    }

    Box mouseMoved(int x, int y, int add_y) {
        Box b = this.findBoxAt(x, y, add_y);
        if (b != null) {
            Point pos = b.location();
            return b.mouseMoved(x - pos.x, y - pos.y);
        }
        return null;
    }

    private Box findBoxAt(int x, int y, int add_y) {
        int count = this.findFirstVisBox(y - add_y);
        Box theBox = null;
        boolean flag_below = false;
        int prev_x = 0;
        for (Box b = this.firstVisBox; b != null && count < this.numBoxes && theBox == null; b = b.getNext(), ++count) {
            Point pos = b.location();
            Dimension dim = b.size();
            if (prev_x > pos.x) {
                if (flag_below) break;
                flag_below = true;
            }
            if (y < pos.y) continue;
            flag_below = false;
            if (x < pos.x || x >= pos.x + dim.width || y >= pos.y + dim.height) continue;
            theBox = b;
        }
        return theBox;
    }

    void paint(Graphics g, int add_x, int add_y) {
        Rectangle bound = g.getClipBounds();
        int left = bound.x + add_x;
        int right = left + bound.width;
        int top = bound.y + add_y;
        int bot = top + bound.height;
        int count = this.observer == null ? this.findFirstVisBox(bound.y) : this.findFirstVisBox(top);
        boolean flag_below = false;
        int prev_x = 0;
        g.translate(-add_x, -add_y);
        for (Box b = this.firstVisBox; b != null && count < this.numBoxes; b = b.getNext(), ++count) {
            Point pos = b.location();
            Dimension bsize = b.size();
            if (prev_x > pos.x) {
                if (flag_below) break;
                flag_below = true;
            }
            prev_x = pos.x;
            if (pos.y >= bot) continue;
            flag_below = false;
            if (pos.x >= right || pos.x + b.size().width <= left) continue;
            if (b instanceof BoxWord) {
                ((BoxWord)b).paint(g, this);
                continue;
            }
            this.flushString(g);
            Graphics gg = g.create();
            gg.translate(pos.x, pos.y);
            b.paint(gg);
            gg.dispose();
        }
        this.flushString(g);
        g.translate(add_x, add_y);
    }

    void drawString(Graphics g, String str, int x, int y, int w, boolean u, boolean s) {
        if (this.str_x != x || this.str_y != y || this.str_buf == null || this.str_underline != u || this.str_strikeout != s) {
            this.flushString(g);
            this.str_start_x = x;
            this.str_x = x + w;
            this.str_y = y;
            this.str_buf = str;
            this.str_underline = u;
            this.str_strikeout = s;
        } else {
            this.str_buf = String.valueOf(this.str_buf).concat(String.valueOf(str));
            this.str_x += w;
        }
    }

    void flushString(Graphics g) {
        if (this.str_buf != null) {
            g.drawString(this.str_buf, this.str_start_x, this.str_y);
            if (this.str_underline) {
                g.drawLine(this.str_start_x, this.str_y + 1, this.str_x, this.str_y + 1);
                this.str_underline = false;
            }
            if (this.str_strikeout) {
                g.drawLine(this.str_start_x, this.str_y - 4, this.str_x, this.str_y - 4);
                this.str_strikeout = false;
            }
            this.str_buf = null;
        }
    }
}

