/* rexx */

/* 
 * This rexx script will resend the mail message it receives to the
 * group name.
 *
 */

Env = 'OS2ENVIRONMENT'
Mailer = 'hmailer.exe'
/* replace the domain with your domain, some systems require a */
/* valid address for this in order to accept mail */
GroupDaemon = 'postmaster@example.com'

/* The external functions we need */
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'

parse arg GroupName MsgFile
parse var GroupName GroupName '@' Domain

/* Find out where the group files should be */
/* 
 * By changing the environment variable used for this, the
 * group files can be moved to any directory. The default is
 * the MAILD directory.
 *
 */
GroupDir = value('MAILD',,Env)

/* Change to the group directory */
Junk = directory(GroupDir)

/* Build the group filename */
GroupFile = GroupDir'\'GroupName
/* Make sure it exists */
rc = SysFileTree(GroupFile, s., 'F')
if rc != 0 & s.0 != 1 then
  do
  say 'Group file not found. Deleting message file.'
  rc = SysFileDelete(MsgFile)
  exit
  end

/* Temporary file for group names */
NameFile = SysTempFileName('?????.tmp', '?')

/* Copy it */
call CopyLock(GroupFile NameFile)

/* Mail it */
Mailer GroupDaemon NameFile MsgFile

exit


