/*
	MR/2 - SaveVCs.CMD

	Copyright (c) 1995, Nick Knight
	All Rights Reserved.

	Author: 	Nick Knight
	Created:	01/06/95
	Usage:		savevcs target.qwk
	Purpose:	savevcs.cmd will pack MR/2-created NDX files back into
				the original QWK source packet (including MR/2 "merged"
				packets.)

	US Mail:	Nick Knight, 1823 David Ave.,  Parma, Ohio 44134
	Fidonet:	1:157/2 or 1:/157/200
	Internet:	nick.knight@pcohio.com
	Compuserve: 76066,1240
	BBS:		Private messages on Nerd's Nook, 356-1772 or 356-1872

	SaveVCs.CMD - MR/2 QWK Repacking Utility.

	This cmd file will repack the source QWK packet with NDX files
	after the Virtual Conferences have been built.	If MR/2 can find
	it, it is started up in a background session when virtual conference
	building has been completed.

	For PKZip use, The -u says to update, the -k says to keep the
	original ZIP file date. The -x claused exclude index files for
	non-packet conferences. %1 is replaced with the original QWK packet
	name.

	The date/time stamp is also preserved by this script.  It is first
	saved in a string called datestamp, then this is passed to the MR/2
	sfiledt.exe utility at the end of the script.
*/

echo off

/***********************************************************************/
/*		A R C H I V E R 	C O M M A N D	 D E F I N I T I O N S	   */
/***********************************************************************/
/*	To add support for a new unpacker, simply supply a new command
	definition here.  The file name to unpack will be appended to
	the end of the supplied command.  You can customize in more detail
	by modifying the code directly, if need be.
*/

path = ''       /* path prefix, if needed for archivers, can be set here */
UseInfoZip = 1	/* set this to 1 to use INFOZIP's ZIP.EXE instead of PKZIP's */

if (UseInfoZip > 0) then do
	zip_leader =   'zip -jku "'
	zip_trailer =  '" *.ndx -x Repl*.ndx InBasket.ndx'
end
else do
	zip_leader =   'pkzip -u -k -xRepl*.ndx -xInBasket.ndx "'
	zip_trailer =	'" *.ndx'
end

arj_leader =	   'arj u -e -s1 -xRepl*.ndx -xInBasket.ndx "'
arj_trailer =	   '" *.ndx'

lha_leader =	   'lh a /i /m "'           /* For lh2 for OS/2 */
lha_trailer =	   '" *.ndx'

zoo_command =		'zoo u'
lharc_command = 	'lha u'
arc_command =		'arc u'

/***********************************************************************/
/*					   S A V E V C S . C M D						   */
/***********************************************************************/
/*
	Returns -1 if it the file appears not to be a packed "archive".
	Returns -2 if the file doesn't exist
	Otherwise, the "archive_id" is returned (1 -> 6).
*/

parse arg filename

if (filename = "") then do
	say ' '
	say 'usage: savevcs bbs-pkt.qwk'
	say ' '
	pause
	return -1
end

/* trim off any quotations marks then filter in, it happens! ("filename") */
if (substr(filename,1,1) = '"') then do
	filename = substr(filename,2,length(filename)-2)
end

Say ' '
Say 'SaveVCs v1.00 - QWK Packet NDX Update Utility'
Say 'Copyright (c) 1995, Nick Knight - All Rights Reserved.'
Say ' '
Say 'Repacking: '||filename
Say ' '

if stream(filename,'c','query exists') = "" then do
	say '** ERROR:  Named packet "'||filename||'" not found.'
/*    pause */
	return -2
end

/*
  Check for long file name - copy to 'shorter' 8.3 name for packer
*/

flongname = length(filename) - lastpos('\',filename) - 12
if flongname <= 0 then do
	flongname = length(filename) - pos('.',filename) - 3
end
if flongname > 0 then do
	origname = filename
	'copy "'filename'" MR2$TMP.QWK'
	filename = 'MR2$TMP.QWK'
	flongname = 1
end

datestamp = stream(filename,'c','query datetime')

status = stream(filename,'c','open read')           /* read only */
header = charin(filename,1,16)

/*	If it doesn't have at least 16 chars, it probably isn't real */
if chars(filename) = 0 then do
	status = stream(filename,'c','close')
	say 'Packet "'||filename||'" appears to be too small to be valid'
/*    pause */
	return -1
end

status = stream(filename,'c','close')       /* Close the file - Important! */

archiver_id = which_archiver(header)		/* call analyzer function, below */

select										/* execute the corresponding command */
	when archiver_id = -1 then do
		say "UNKNOWN ARCHIVE TYPE: " filename
		return -1
	end
	when archiver_id = 1 then path || zip_leader||filename||zip_trailer
	when archiver_id = 2 then path || arj_leader||filename||arj_trailer
	when archiver_id = 3 then path || zoo_leader||filename||zoo_trailer
	when archiver_id = 4 then path || lharc_leader||filename||lharc_trailer
	when archiver_id = 5 then path || lha_leader||filename||lha_trailer
	when archiver_id = 6 then path || arc_leader||filename||arc_trailer
	otherwise
end

if RC <> 0 then return RC

'..\\sfiledt' filename datestamp

if flongname > 0 then do
	'copy MR2$TMP.QWK "'origname'"'
	'del MR2$TMP.QWK'
end

return archive_id							/* return the ID type */


/***********************************************************************/
/*				   W H I C H	 A R C H I V E R					   */
/***********************************************************************/
/*
	Returns -1 if it can't tell, otherwise it returns the archiver id
	that I've assigned to the ones I know about.  Others can be easily
	added.	Some of this may not be correct (lha vs lharc), but I tested
	as much of it as I could.  Looks OK.
*/

which_archiver:

parse arg header				/* header is the first 16 bytes of file */

select
	when substr(header,1,2) = "PK" then id = 1              /* PKWare */
	when substr(header,1,1) = '`' && substr(header,2,1) = '\xEA' then id = 2 /* ARJ */
	when substr(header,1,3) = "ZOO" then id = 3             /* ZOO */
	when substr(header,3,5) = "-lh0-" then id = 4           /* LHARC */
	when substr(header,3,5) = "-lh1-" then id = 4           /* LHARC */
	when substr(header,3,3) = "-lh" then id = 5             /* LHA */
	when c2d(substr(header,1,1)) = 26 then id = 6			/* ARC */
	otherwise
		id = -1 			/* Archiver unknown or not an archive */
end
return id

