/*
 * Installx.cmd installs the PMX server updates from disk or diskette.
 * This must be run from the disk or diskette e.g. "a:installx".
 * This version checks that XFILES environment variable has been
 * set up properly and both TCPBASE and TCPPMX have already been installed.
 */
ENV = 'OS2ENVIRONMENT'
XFILES = VALUE('XFILES',,ENV)
if XFILES = '' then
    do
    say ""
    say "WARNING!"
    say "You do NOT have the environment variable XFILES defined!"
    say "You should have already installed the OS/2 TCP/IP 1.2 base and"
    say "the X Window System option.  This update package only provides"
    say "changes and additions to the already installed product."
    say "Installation will not continue."
    say ""
    exit 1
    end
BASE=filespec("drive",XFILES)||filespec("path",XFILES)
if substr(BASE, length(BASE), 1) = '\' then
    BASE = substr(BASE, 1, length(BASE) - 1)
call dircheck XFILES
call dircheck BASE
BINDIR = dircheck(BASE'\BIN')
call dircheck BASE'\DLL'
call dircheck BASE'\HELP'
call dircheck BASE'\X11\MISC'
call dircheck BASE'\X11\75DPI'
call dircheck BASE'\X11\DEFAULTS'
cmdloc = getinstalldir()
call runcheckanderase BASE'\BIN\PMX.EXE'
call runcheckanderase BASE'\DLL\PMXHKDLL.DLL'
call runcheckanderase BASE'\DLL\PMXRES.DLL'
call backupfile BASE'\BIN\XINIT.CMD' 'XINITBAK.CMD'
/* now updating the CSD level info */
'attrib' BASE'\syslevel.pmx -r'
'copy' cmdloc'syslevel.pmx' BASE'\syslevel.pmx'
'attrib' BASE'\syslevel.pmx +r'
/* currentdir = directory() */
/* call directory BINDIR */
say ""
say "Now loading from the update files."
say ""
cmdloc'loadram2 'cmdloc'pmxmain.fls 'BASE' /sr /c /d'
/* call directory(currentdir) */
say ""
say "Loading from the update files is complete."
say ""
exit 0


dircheck: procedure
arg dir
curdir = directory()
newdir = directory(dir)
call directory(curdir)
if newdir \= '' then
    do
    return newdir
    end
else
    do
    say ""
    say "Directory '"dir"' could not be found even though the XFILES"
    say "environment variable is defined as '"XFILES"'!"
    say "The directory was supposed to be created by ICAT when the TCP/IP 1.2.1"
    say "base and X Window System 1.2.1 option were installed."
    say "Installation is terminated!"
    exit 1
    end

getinstalldir: procedure
parse source system calltype cmdloc
cmddir = filespec("drive",cmdloc)||filespec("path",cmdloc)
return cmddir

runcheckanderase: procedure
arg dir
progname = STREAM(dir, 'C', 'QUERY EXISTS')
if progname \= '' then do
    'ERASE' progname
    if STREAM(dir, 'C', 'QUERY EXISTS') \= '' then do
        say ""
        say "The file '"progname"' could not be erased."
        say "You probably have not stopped the PMX server."
        say "Please do so before you install this update."
        say ""
        exit 1
        end
    end
return

/* typical call: call backupfile BASE'\BIN\XINIT.CMD' 'XINITBAK.CMD' */
backupfile: procedure
arg oldfile firstbackname
backname = firstbackname
if STREAM(oldfile, "C", "QUERY EXISTS") \= '' then do
    oldloc = filespec("drive",oldfile)||filespec("path", oldfile)
    do forever
        backfile = oldloc||backname
        if STREAM(backfile, "C", "QUERY EXISTS") \= '' then do
            say "A new version of '"oldfile"' will be loaded. For backup,"
            say "the old version would have been renamed to '"backname"'."
            say "However, the backup file '"backfile"' already exists."
            backname = getnewbackname(oldfile)
            if backname = '' then
                return  /* no backup wanted, old file will be replaced */
            iterate
            end /* if */
        else
            do
            say "A new version of '"oldfile"' will be loaded. For backup,"
            say "the old version will be renamed to '"backname"'."
            'rename' oldfile backname
            if STREAM(backfile, "C", "QUERY EXISTS") \= '' then do
                'PAUSE'
                leave
                end
            say "Error! Renaming '"oldfile"' to '"backname"' did not work!"
            say "RC="rc 'from the rename command.'
            exit 1
            end /* else */
        end /* do forever */
    end /* if */
return

/* typical call
    backname = getnewbackname(oldfile)
 */
getnewbackname: procedure
arg oldfile
do forever
    say "Please enter a new name to rename '"oldfile"' to;"
    say "or else press Enter without any name, if you do not want a backup;"
    say "or else press ctrl-c and then Enter if you want to end the update."
    pull enteredfilename
    newfilename = filespec("name", enteredfilename)
    if newfilename = enteredfilename then
        return newfilename
    say "Try again, please. You should have entered a simple filename."
    say ''
    end /* do forever */
