/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*                                                                 */
/*                        Fichier Include PARI                     */
/*                                                                 */
/*                    commun a toutes les versions                 */
/*                                                                 */
/*                        copyright  Babecool                      */
/*                                                                 */
/*                                                                 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

typedef long    *GEN;
typedef unsigned long ulong;

typedef struct entree {
  char *name;
  long valence;
  void *value;
  long menu;
  struct entree *next;
} entree;

typedef unsigned char *byteptr;

/*      Variables statiques communes :
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  */

extern  unsigned long overflow,hiremainder;

extern  long    prec,precdl,defaultpadicprecision;
extern  GEN     bernzone,gpi,geuler;
extern  long    tglobal,paribuffsize,pariecho;
extern  long    *ordvar,varchanged;
extern  GEN     polvar;
extern  GEN     RAVYZARC;

extern  long    NUMFUNC;
extern  entree  fonctions[],*hashtable[];
extern  long    lontyp[],lontyp2[];

extern  jmp_buf environnement;
extern  FILE    *outfile, *logfile, *infile;

extern  unsigned long    avma,bot,top;
extern  GEN     gnil,gun,gdeux,ghalf,gi,gzero;

extern  GEN     *polun,*polx;
extern  byteptr diffptr;

extern  GEN     *g;
extern  entree  **varentries; /* noms des inconnues actives */
extern  GEN     *blocliste;   /* tableau des pointeur de blocs */
extern  long    nvar;         /* numero de la prochaine inconnue */
extern  long    glbfmt[];
extern  long    **rectgraph;

extern  char    *helpmessage[]; /* un message pour chaque fonction predefinie */
extern  char    *errmessage[];  /* un par numero d'erreur */

#define STACKSIZE      1000  /* nombre de gn possibles */
#define MAXVAR          150  /* nombre maximum de variables */
#define MAXFILES 5
#define TBLSZ           135  /* taille de la table de hashcodes */
#define MAXBLOC        5000  /* nombre de blocs autorises dans le tas */

#define K       9.632959862             /* 32*log(2)/log(10)    */
#define K1      0.103810253             /* log(10)/(32*log(2))  */
#define K2      1.1239968               /* 1/(1-(log(2)/(2*pi)))*/
/* #define K3      0.900643041 */            /* 1/(1+(log(2)/(2*pi)))*/
#define K4      0.5337333889            /* e*pi/16              */
#define LOG2    0.693147180559945       /* log(2)               */
#define L2SL10  0.301029995663981       /* log(2)/log(10)       */
#undef  PI
#define PI      3.141592653589          /* pi                   */
#define rac5    2.23606797749           /* racine de 5          */
#define C1      0.9189385332            /* log(2*pi)/2          */
#define C2      22.18070978             /* 32*log(2)            */
#define C3      0.0216950598            /* log((1+sqrt(5))/2)/(32*log(2)) */
#define C4      4294967296.0            /* 2^32                 */
#define C31     2147483648.0            /* 2^31                 */
#define CN31    -2147483648.0           /* -2^31                */
#define BIGINT  32767                   /* 2^15-1               */
#define EXP220  1048576               /* 2^20                 */
#define VERYBIGINT 2147483647           /* 2^31-1               */

#ifndef exp2
#define exp2(x) exp((double)(x)*log(2.))
#define log2(x) log((double)(x))/log(2.)
#endif

#define min(a,b) ((a)>(b)?(b):(a))
#define max(a,b) ((a)>(b)?(a):(b))

#define separe(c)     ((c==';')||(c==':')||(c=='\n'))

#define output(x)     {brute(x,'g',-1);pariputc('\n');fflush(stdout);}
#define outmat(x)     {matbrute(x,'g',-1);pariputc('\n');fflush(stdout);}
#define outbeaut(x)   {sor(x,'g',-1,0);pariputc('\n');fflush(stdout);}

#define addis(x,s)  addsi(s,x)
#define addrs(x,s)  addsr(s,x)
#define mulis(x,s)  mulsi(s,x)
#define mulri(x,s)  mulir(s,x)
#define mulrs(x,s)  mulsr(s,x)

#define gval(x,v) ggval(x,polx[v])
#define gvar9(x) ((typ(x)==9)?gvar2(x):gvar(x))

#define lgeti   (long)cgeti
#define lgetr   (long)cgetr
#define lpile   (long)gerepile
#define lstoi   (long)stoi
#define lnegi   (long)negi
#define lnegr   (long)negr
#define lmpneg  (long)mpneg
#define labsi   (long)absi
#define labsr   (long)absr
#define lmpabs  (long)mpabs
#define lmptrunc (long)mptrunc
#define lmpent  (long)mpent
#define lshifts (long)shifts
#define lshifti (long)shifti
#define lshiftr (long)shiftr
#define lmpshift (long)mpshift
#define laddsi  (long)addsi
#define laddsr  (long)addsr
#define laddis  (long)addis
#define laddrs  (long)addrs
#define laddii  (long)addii
#define laddir  (long)addir
#define laddrr  (long)addrr
#define lmpadd  (long)mpadd
#define lsubsi  (long)subsi
#define lsubis  (long)subis
#define lsubsr  (long)subsr
#define lsubrs  (long)subrs
#define lsubii  (long)subii
#define lsubir  (long)subir
#define lsubri  (long)subri
#define lsubrr  (long)subrr
#define lmpsub  (long)mpsub
#define lmulss  (long)mulss
#define lmulsi  (long)mulsi
#define lmulsr  (long)mulsr
#define lmulis  (long)mulis
#define lmulrs  (long)mulrs
#define lmulii  (long)mulii
#define lmulir  (long)mulir
#define lmulri  (long)mulri
#define lmulrr  (long)mulrr
#define lmpmul  (long)mpmul
#define ldivsi  (long)divsi
#define ldivis  (long)divis
#define ldivsr  (long)divsr
#define ldivrs  (long)divrs
#define ldivii  (long)divii
#define ldivir  (long)divir
#define ldivri  (long)divri
#define ldivrr  (long)divrr
#define lmpdiv  (long)mpdiv
#define lmodii  (long)modii
#define lresii  (long)resii
#define ldvmdii (long)dvmdii
#define ldvmdsi (long)dvmdsi
#define ldvmdis (long)dvmdis
  
#define ltree   (long)gettree
#define lgen    (long)getgen
#define lcopy   (long)gcopy
#define lclone  (long)gclone
#define lgetg   (long)cgetg
#define lgetp   (long)cgetp
#define laddpex (long)gaddpex
#define lgreffe (long)greffe
#define lopsg2  (long)gopsg2
#define lopgs2  (long)gopgs2
#define lco8    (long)co8
#define lneg    (long)gneg
#define labs    (long)gabs
#define lmax    (long)gmax
#define lmin    (long)gmin
#define ladd    (long)gadd
#define lsub    (long)gsub
#define lmul    (long)gmul
#define ldiv    (long)gdiv
#define linv    (long)ginv
#define lmod    (long)gmod
#define ldivmod (long)gdivmod
#define lshift  (long)gshift
#define lmul2n  (long)gmul2n
#define lpuigs  (long)gpuigs
#define lpui    (long)gpui
#define lsubst  (long)gsubst
#define lderiv  (long)deriv
#define linteg  (long)integ
#define lrecip  (long)recip
#define lceil   (long)gceil
#define lfloor  (long)gfloor
#define lround  (long)ground
#define lcvtoi  (long)gcvtoi
#define lrndtoi (long)grndtoi
#define lfrac   (long)gfrac
#define ltrunc  (long)gtrunc
#define lmodulcp  (long)gmodulcp
#define lmodulo  (long)gmodulo
  
#define lconcat (long)concat
#define lnorm   (long)gnorm
#define lnorml2 (long)gnorml2
#define lconj   (long)gconj
#define lreal   (long)greal
#define limag   (long)gimag
#define lmppi   (long)mppi
#define lmpeuler (long)mpeuler
#define lmpsqrt (long)mpsqrt
#define lsqrt   (long)gsqrt
#define lmpexp1 (long)mpexp1
#define lmpexp  (long)mpexp
#define lexp    (long)gexp
#define lmplog  (long)mplog
#define llog    (long)glog
#define lmpsc1  (long)mpsc1
#define lmpcos  (long)mpcos
#define lcos    (long)gcos
#define lmpsin  (long)mpsin
#define lsin    (long)gsin
#define lmpaut  (long)mpaut
#define lmptan  (long)mptan
#define ltan    (long)gtan
#define lmpatan (long)mpatan
#define latan   (long)gatan
#define lmpasin (long)mpasin
#define lasin   (long)gasin
#define lmpacos (long)mpacos
#define lacos   (long)gacos
#define lmpch   (long)mpch
#define lch     (long)gch
#define lmpsh   (long)mpsh
#define lsh     (long)gsh
#define lmpth   (long)mpth
#define lth     (long)gth
#define lmpath  (long)mpath
#define lath    (long)gath
#define lmpash  (long)mpash
#define lash    (long)gash
#define lmpach  (long)mpach
#define lach    (long)gach
#define lmpgamma (long)mpgamma
#define lgamma  (long)ggamma
#define lmplngamma (long)mplngamma
#define llngamma  (long)glngamma
#define lgamd   (long)ggamd
#define lmppsi  (long)mppsi
#define lpsi    (long)gpsi
#define lmpgamd (long)mpgamd
#define larg    (long)garg
#define lsqr    (long)gsqr
  
#define ltrans  (long)gtrans
#define lscalmat (long)gscalmat
#define lscalsmat (long)gscalsmat
#define laddmat (long)gaddmat
#define laddsmat (long)gaddsmat
#define lgauss  (long)gauss
#define linvmat (long)invmat
#define linvmulmat (long)invmulmat
#define ldet    (long)det
#define ldet2   (long)det2
#define lcaract (long)caract
#define lcaradj (long)caradj
#define ladj    (long)adj
#define ltrace  (long)trace
#define lassmat (long)assmat
#define lscal   (long)gscal
  
#define linvmod (long)ginvmod
#define lred    (long)gred
#define ldeuc   (long)gdeuc
#define lres    (long)gres
#define ldivres (long)poldivres
#define lpoleval (long)poleval
#define lroots  (long)roots
#define lgcd    (long)ggcd
#define lpolgcd (long)polgcd
#define lcontent (long)content
#define lprimpart (long)primpart
#define lpsres  (long)psres
#define lsubres (long)subres
#define ldiscsr (long)discsr
#define lquadpoly (long)quadpoly
#define lquadgen (long)quadgen
  
#define llegendre (long)legendre
#define ltchebi (long)tchebi
#define lhilb   (long)hilb
#define lpasc   (long)pasc
#define lprec   (long)gprec
#define lbinome (long)binome
  
#define lracine (long)racine
#define lmppgcd (long)mppgcd
#define lmpfact (long)mpfact
#define lsfcont (long)sfcont
#define lbezout (long)bezout
#define lmpinvmod (long)mpinvmod
#define lpuissmodulo (long)puissmodulo
#define lfibo   (long)fibo
#define lchangevar (long)changevar
  
#define zero    (long)gzero
#define un      (long)gun
#define deux    (long)gdeux
#define lhalf   (long)ghalf
  
#define lpolx   (long)polx
#define lpolun   (long)polun

#define mpmodz(x,y,z)     (modiiz(x,y,z))
#define mpresz(x,y,z)     (resiiz(x,y,z))
#define mpmod(x,y)        (modii(x,y))
#define mpres(x,y)        (resii(x,y))

#define laddsg(s,y)         (lopsg2(gadd,s,y))
#define laddgs(y,s)         (lopsg2(gadd,s,y))
#define lsubsg(s,y)         (lopsg2(gsub,s,y))
#define lsubgs(y,s)         (lopgs2(gsub,y,s))
#define lmulsg(s,y)         ((long)gmulsg(s,y))
#define lmulgs(y,s)         ((long)gmulsg(s,y))
#define ldivsg(s,y)         (lopsg2(gdiv,s,y))
#define ldivgs(x,s)         ((long)gdivgs(x,s))
#define lmodsg(s,y)         (lopsg2(gmod,s,y))
#define lmodgs(y,s)         (lopgs2(gmod,y,s))
#define ldiventsg(s,y)      (lopsg2(gdivent,s,y))
#define ldiventgs(y,s)      (lopgs2(gdivent,y,s))
#define lminsg(s,y)         (lopsg2(gmin,s,y))
#define lmings(y,s)         (lopgs2(gmin,y,s))
#define lmaxsg(s,y)         (lopsg2(gmax,s,y))
#define lmaxgs(y,s)         (lopgs2(gmax,y,s))


#define mppiz(x)              (gop0z(mppi,x))
#define mpeulerz(x)           (gop0z(mpeuler,x))
#define mpsqrtz(x,y)        (gop1z(mpsqrt,x,y))
#define mpexpz(x,y)         (gop1z(mpexp,x,y))
#define mpexp1z(x,y)        (gop1z(mpexp1,x,y))
#define mplogz(x,y)         (gop1z(mplog,x,y))
#define mpcosz(x,y)         (gop1z(mpcos,x,y))
#define mpsinz(x,y)         (gop1z(mpsin,x,y))
#define autz(x,y)           (gop1z(mpaut,x,y))
#define mptanz(x,y)         (gop1z(mptan,x,y))
#define mpatanz(x,y)        (gop1z(mpatan,x,y))
#define mpasinz(x,y)        (gop1z(mpasin,x,y))
#define mpacosz(x,y)        (gop1z(mpacos,x,y))
#define mpchz(x,y)          (gop1z(mpch,x,y))
#define mpshz(x,y)          (gop1z(mpsh,x,y))
#define mpthz(x,y)          (gop1z(mpth,x,y))
#define mpathz(x,y)         (gop1z(mpath,x,y))
#define mpashz(x,y)         (gop1z(mpash,x,y))
#define mpachz(x,y)         (gop1z(mpach,x,y))
#define mpgammaz(x,y)       (gop1z(mpgamma,x,y))
#define mpargz(x,y,z)      (gop2z(mparg,x,y,z))
#define mpfactz(s,y)        (gops1z(mpfact,s,y))

#define gredz(x,y)          (gop1z(gred,x,y))
#define gnegz(x,y)          (gop1z(gneg,x,y))
#define gabsz(x,y)          (gop1z(gabs,x,y))
#define gmaxz(x,y,z)       (gop2z(gmax,x,y,z))
#define gminz(x,y,z)       (gop2z(gmin,x,y,z))
#define gaddz(x,y,z)       (gop2z(gadd,x,y,z))
#define gsubz(x,y,z)       (gop2z(gsub,x,y,z))
#define gmulz(x,y,z)       (gop2z(gmul,x,y,z))
#define gdivz(x,y,z)       (gop2z(gdiv,x,y,z))
#define gdeucz(x,y,z)      (gop2z(gdeuc,x,y,z))
#define gdiventz(x,y,z)    (gop2z(gdivent,x,y,z))
#define gmodz(x,y,z)       (gop2z(gmod,x,y,z))
#define gshiftz(x,s,z)      (gops2gsz(gshift,x,s,z))
#define gmul2nz(x,s,z)      (gops2gsz(gmul2n,x,s,z))
#define gaddsg(s,y)         (gopsg2(gadd,s,y))
#define gaddgs(y,s)         (gopsg2(gadd,s,y))
#define gsubsg(s,y)         (gopsg2(gsub,s,y))
#define gsubgs(y,s)         (gopgs2(gsub,y,s))
#define gcmpsg(s,y)         (-opgs2(gcmp,y,s))
#define gcmpgs(y,s)         (opgs2(gcmp,y,s))
#define gegalsg(s,y)        (opgs2(gegal,y,s))
#define gegalgs(y,s)        (opgs2(gegal,y,s))
#define gmulgs(y,s)         (gmulsg(s,y))
#define gdivsg(s,y)         (gopsg2(gdiv,s,y))
#define gdiventsg(s,y)      (gopsg2(gdivent,s,y))
#define gdiventgs(y,s)      (gopgs2(gdivent,y,s))
#define gmodsg(s,y)         (gopsg2(gmod,s,y))
#define gmodgs(y,s)         (gopgs2(gmod,y,s))
#define gminsg(s,y)         (gopsg2(gmin,s,y))
#define gmings(y,s)         (gopgs2(gmin,y,s))
#define gmaxsg(s,y)         (gopsg2(gmax,s,y))
#define gmaxgs(y,s)         (gopgs2(gmax,y,s))


#define gaddsgz(s,y,z)    (gopsg2z(gadd,s,y,z))
#define gaddgsz(y,s,z)    (gopsg2z(gadd,s,y,z))
#define gsubsgz(s,y,z)    (gopsg2z(gsub,s,y,z))
#define gsubgsz(y,s,z)    (gopgs2z(gsub,y,s,z))
#define gmulsgz(s,y,z)    (gops2sgz(gmulsg,s,y,z))
#define gmulgsz(y,s,z)    (gops2sgz(gmulsg,s,y,z))
#define gdivsgz(s,y,z)    (gopsg2z(gdiv,s,y,z))
#define gdivgsz(y,s,z)    (gops2gsz(gdivgs,y,s,z))
#define gdiventsgz(s,y,z) (gopsg2z(gdivent,s,y,z))
#define gdiventgsz(y,s,z) (gopgs2z(gdivent,y,s,z))
#define gmodsgz(s,y,z)    (gopsg2z(gmod,s,y,z))
#define gmodgsz(y,s,z)    (gopgs2z(gmod,y,s,z))
#define gminsgz(s,y,z)    (gopsg2z(gmin,s,y,z))
#define gmingsz(y,s,z)    (gopgs2z(gmin,y,s,z))
#define gmaxsgz(s,y,z)    (gopsg2z(gmax,s,y,z))
#define gmaxgsz(y,s,z)    (gopgs2z(gmax,y,s,z))

#define coeff(a,i,j)      (*((long*)(*(a+(j)))+(i)))
#define coef1(a,i,j)      (*((long*)(*(a+(j)+1))+(i)+1))
#define bern(i)           (bernzone + (i)*(*(bernzone + 2)) + 3)

#define isonstack(x)   (RAVYZARC=(GEN)(x),((RAVYZARC>=(GEN)bot)&&(RAVYZARC<(GEN)top)))

#define copyifstack(x) (RAVYZARC=(GEN)(x),((RAVYZARC>=(GEN)bot)&&(RAVYZARC<(GEN)top))?lcopy(RAVYZARC):(long)RAVYZARC)

#define adecaler(x,tetpil,anavma) (RAVYZARC=(GEN)(x),((RAVYZARC>=(GEN)anavma)&&(RAVYZARC<(GEN)tetpil)))

#define isscalar(x)   ((typ(x)<10)||((typ(x)==10)&&(lgef(x)<=3)))
#define isnonscalar(x)  ((typ(x)==10)&&(lgef(x)>3))
#define leadingterm(x)  ((typ(x)<10)?x:((GEN)(x[lgef(x)-1])))

#define odd(x)                ((x) & 1)
#define mpodd(x) (signe(x) && odd(mant(x,lgef(x) - 2)))

/* mp.c ou mp.s */

GEN     cgetr(),cgeti(),gerepile(),stoi();
GEN     negi(),negr(),absi(),absr();
GEN     mptrunc(),mpent(),shifts(),shifti(),shiftr();
GEN     addsi(),addsr(),addii(),addir(),addrr(),mpadd();
GEN     subsi(),subsr(),subii(),subir();
GEN     subri(),subrr(),mpsub();
GEN     mulss(),mulsi(),mulsr(),mulii(),mulir(),mulrr(),mpmul();
GEN     divsi(),divis(),divsr(),divrs(),divir();
GEN     divri(),divrr(),mpdiv(),convi(),confrac();
GEN     modss(),resss(),modsi(),ressi(),modis(),resis(),modii();
GEN     dvmdii(),dvmdsi(),dvmdis();
long    itos(),vals(),vali(),divisii();
int     expi(),divise(),mpcmp(),cmpss(),cmpsi(),cmpsr(),cmpii(),cmpir();
int     cmprr(),mpdivis();
void    mpaff(),affsi(),affsr(),affii(),affir(),affrr(),mulsii(),addsii();
void    divsiz(),divisz(),divssz(),diviiz(),divrrz(),cgiv();
void    dvmdssz(),dvmdsiz(),dvmdisz(),dvmdiiz(),mpdivz(),modiiz();
void    addssz(),subssz(),mulssz(),modiiz(),resiiz();
     
/* alglin.c */
     
GEN     gtrans(),gscalmat(),gscalsmat(),gaddmat(),gaddsmat(),inverseimage();
GEN     ker(),keri(),kerreel(),image(),image2(),suppl(),eigen(),hess();
GEN     carhess();
GEN     gauss(),invmat(),det(),detreel(),det2(),deplin(),newdeplin();
GEN     caract(),caradj(),adj(),caradj0(),trace();
GEN     assmat(),gnorm(),gnorml2(),gconj(),concat(),idmat();
GEN     extract(),matextract(),gtomat(),invmulmat(),invmulmatreel(),invmatreel();
GEN     sqred(),sqred1(),sqred2(),sqred3(),signat(),jacobi(),matrixqz(),matrixqz2(),matrixqz3();
GEN     indexrank(),kerint(),kerint1(),kerint2(),intersect();
long    rank(),perf();

/* anal.c */
     
GEN     lisexpr(),readexpr(),lisseq(),readseq();
void    switchin(), switchout(), fliplog();
     
/* arith.c */
     
GEN     racine(),mppgcd(),mpfact(),mpfactr();
GEN     sfcont(),sfcont2(),gcf(),gcf2(),pnqn(),gboundcf();
GEN     bezout(),chinois(),mpinvmod(),puissmodulo(),fibo(),bigprem(),prime();
GEN     primes(),phi(),decomp(),auxdecomp(),smallfact(),boundfact();
GEN     sumdiv(),sumdivk(),numbdiv(),binaire(),order(),gener(),divisors();
GEN     ellfacteur(),classno(),classno2(),classno3(),fundunit(),regula();
GEN     compose(),sqcomp(),qfi(),qfr(),compreal(),redreal(),sqcompreal();
GEN     rhoreal(),rhorealnod(),redrealnod(),compose2(),sqcomp2(),redcomp();
GEN     primeform(),nucomp(),nudupl(),nupow();
GEN     comprealraw(),sqcomprealraw(),powrealraw();

GEN     gkronecker(),gkrogs(),gcarreparfait(),gcarrecomplet();
GEN     gisprime(),gispsp(),gissquarefree(),gisfundamental(),gbittest();
GEN     gpseudopremier(),gmillerrabin(),gmu(),gomega(),gbigomega();

long    kronecker(),krosg(),krogs(),kross(),kro8();
long    mu(),omega(),bigomega(),hil();
int     carreparfait(),carrecomplet(),bittest();
int     isprime(),ispsp(),issquarefree(),isfundamental(),mpsqrtmod();
int     millerrabin(),pseudopremier(),inversemodulo();
byteptr initprimes();
void    lucas();

/* base.c */

GEN     base(),smallbase(),discf(),smalldiscf(),hnf(),hnfold(),smith(),smith2();
GEN     factoredbase(),factoreddiscf(),allbase(),galois(),initalg();
GEN     tschirnhaus(),galoisconj(),initalg2(),primedec(),idealmul();
GEN     idealmulprime(),ideallllred(),minideal(),element_mul(),element_pow();
GEN     element_muli(),element_mulh(),element_sqr(),idealmulh();
long    idealval();

/* bibli1.c */
     
GEN     tayl(),legendre(),tchebi(),hilb(),pasc(),laplace();
GEN     gprec(),convol(),ggrando(),gconvsp(),gconvpe(),gaminc();
GEN     lll(),lll1(),lllrat(),lllgram(),lllgram1(),lllgramint(),lllint();
GEN     lllgramkerim(),lllkerim(),lllgramall(),lllall0();
GEN     lllgen(),lllkerimgen(),lllgramgen(),lllgramkerimgen(),lllgramallgen();
GEN     binome(),gscal(),cyclo(),vecsort();
GEN     lindep(),lindep2(),algdep(),algdep2(),changevar(),ordred();
GEN     polrecip(),reorder(),sort(),lexsort(),indexsort(),polsym(),minim();
GEN     polred(),factoredpolred(),smallpolred(),polred2(),factoredpolred2();
GEN     smallpolred2(),allpolred(),polymodrecip(),genrand(),permute();
long    setprecr(),setserieslength();
     
/* bibli2.c */

GEN     somme(),produit(),suminf(),prodinf(),prodinf1(),prodeuler();
GEN     vecteur(),vvecteur(),matrice(),divsomme();
GEN     qromb(),qromo(),qromi(),rombint();
GEN     polint(),plot(),ploth(),ploth2(),plothraw(),zbrent(),sumalt(),sumpos();
GEN     forpari(),forstep(),fordiv(),forprime();
GEN     initrect(),killrect(),rectcursor(),rectmove(),rectrmove(),rectpoint();
GEN     rectrpoint(),rectbox(),rectrbox(),rectline(),rectrline(),rectdraw();
GEN     rectpoints(),rectlines(),rectstring(),rectscale();
GEN     postdraw(),postploth(),postploth2(),postplothraw();

/* buch.c */

GEN     buchimag(),buchreal(),buchgen(),buchgennou();

/* elliptic.c */

GEN     ghell(),ghell2(),ghell3();
GEN     initell(),initell2(),smallinitell(),zell(),coordch(),pointch();
GEN     addell(),subell(),powell(),matell(),ordell(),apell(),apell1(),apell2();
GEN     anell(),akell();
GEN     localreduction(), globalreduction(),lseriesell(),pointell();
int     oncurve();
void    eulsum();

/* es.c */

void    filtre(),  pariputc(), pariputs(), ecrire(), voir(), sor();
void    brute(), matbrute(), texe(), etatpile();

/* gen1.c */

GEN     gadd(),gsub(),gmul(),gdiv();

/* gen2.c gen3.c */

GEN     gcopy(),forcecopy(),gclone(),cgetg(),cgetp(),gaddpex();
GEN     greffe(),gopsg2(),gopgs2(),co8(),cvtop(),compo(),gsqr();
GEN     gneg(),gabs(),gmax(),gmin(),ginv(),denom(),numer(),lift(),centerlift();
GEN     gmulsg(),gdivgs(),gmodulo(),gmodulcp(),simplify();
GEN     gmod(),gshift(),gmul2n(),gpuigs(),gpui();
GEN     gsubst(),deriv(),integ(),recip(),ground(),gcvtoi(),grndtoi();
GEN     gceil(),gfloor(),gfrac(),gtrunc(),gdivent(),gdiventres();
GEN     gdivmod(),geval(),glt(),gle(),ggt(),gge(),geq(),gne();
GEN     gand(),gor(),glength(),matsize(),truecoeff(),gtype();
GEN     gtopoly(),gtopolyrev(),gtoser(),gtovec(),dbltor();
GEN     karamul();

void    gop0z(),gop1z(),gop2z(),gops2gsz(),gops2sgz(),gops2ssz();
void    gop3z(),gops1z(),gopsg2z(),gopgs2z(),gaffsg(),gaffect();
void    normalize(),normalizepol();

int     gcmp0(),gcmp1(),gcmp_1(),gcmp(),lexcmp(),gegal(),polegal(),gsigne();
int     gvar(),gvar2(),tdeg(),precision(),ismonome(),iscomplex(),isexactzero();
long    opgs2(),taille(),gexpo(),gtolong(),ggval(),rounderror(),gsize(),pvaluation();
double  rtodbl(),gtodouble();

/* init.c */

GEN     newbloc(),geni();
long    marklist();
void    init(),killbloc(),newvalue(),killvalue();
void    err(),recover(),changevalue(),allocatemoremem();

/* polarit.c */
     
GEN     ginvmod(),gred(),gdeuc(),gres(),poldivres();
GEN     poleval(),roots(),rootslong(),ggcd(),gbezout(),vecbezout(),glcm();
GEN     polgcd(),srgcd(),polgcdnun(),content(),primpart(),psres(),factmod9();
GEN     factmod(),factmod2(),rootmod(),rootmod2(),decpol(),factor();
GEN     factpol(),factpol2(),simplefactmod();
GEN     subres(),discsr(),quadpoly(),quadgen(),bezoutpol(),polinvmod();
GEN     resultant2(),polfnf(),nfiso(),nfincl(),rootsof1();
GEN     newtonpoly(),apprgen(),apprgen9(),rootpadic(),gcvtop(),factorpadic();
long    sturm(),sturmpart();
int     poldivis(),gdivise();
void    gredsp(),split(),split9();
     
/* trans.c */
     
GEN     greal(),gimag(),teich(),agm(),palog();
GEN     mpsqrt(),gsqrt(),mpexp1(),mpexp(),gexp(),logagm(),glogagm();
GEN     mplog(),glog(),mpsc1(),mpcos(),gcos(),mpsin(),gsin();
GEN     mpaut(),mptan(),gtan(),mpatan(),gatan(),mpasin(),gasin();
GEN     mpacos(),gacos(),mparg(),mpch(),gch(),mpsh(),gsh();
GEN     mpth(),gth(),mpath(),gath(),mpash(),gash();
GEN     garg(),sarg(),mppsi(),gpsi(),transc(),kbessel(),hyperu();
GEN     cxpsi(),jbesselh(),gzeta();
GEN     kbessel2(),eint1(),gerfc(),eta(),jell(),wf2(),wf();
GEN     incgam(),incgam1(),incgam2(),incgam3(),incgam4(),bernreal(),bernvec();
GEN     mpach(),gach(),mpgamma(),cxgamma(),ggamma(),mpgamd(),ggamd(),mppi();
GEN     mpeuler(),polylog(),dilog(),polylogd(),polylogdold(),polylogp(),gpolylog();
GEN     theta(),thetanullk(),mplngamma(),cxlngamma(),glngamma(),izeta();

void    constpi(),consteuler(),mpbern(),gsincos();
void    gsqrtz(),gexpz(),glogz(),gcosz(),gsinz(),mpsincos(),gtanz();
void    gatanz(),gasinz(),gacosz(),gchz(),gshz(),gthz(),gashz(),gachz();
void    gathz(),ggammaz(),glngammaz(),mpgamdz(),ggamdz(),gpsiz(),gzetaz();
void    gpolylogz();

/* version.c */

GEN     gerepilc();
void    printversion();
