/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*                                                                 */
/*            ALGORITHMES SOUS-EXPONENTIELS DE CALCUL              */
/*            DU GROUPE DE CLASSES ET DU REGULATEUR                */
/*                    (McCURLEY, BUCHMANN)                         */
/*                                                                 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

#include "genpari.h"
#define CBUCH 15 /*DOIT ETRE DE LA FORME 2^k-1 !!!*/
#define HASHT 1024

void hphaseimag1(),hphaseimag2(),hphasereal1(),hphasereal2();
void addcolumnmat(),addcolumnmat1(),addcolumnmat2(),initbuchreal();
long *subfactorbaseimag(),*subfactorbasereal(),factorbase();
long factorise(),*largeprime(),*largeprime2();
GEN **powsubfactimag(),**powsubfactreal(),rangi(),clean(),hnfimag();
GEN sqrealform3(),comprealform3(),rhorealform3(),redrealform3(),initializeform3();
GEN sqrealform5(),powrealform5(),comprealform5(),rhorealform5(),redrealform5();
GEN initializeform5(),redrealform(),gcdreal(),gcdrealnoer(),hnfreal(),lfunc();

GEN subfactorbasegen(),**powsubfactgen(),idealmulprimered(),getfu(),hnfarch();
long factorisegen(),factorbasegen(),*calcindice();
void hphasegen1(),hphasegen2();

GEN buchimag(D,gcbach,gcbach2,gCO)
     GEN D,gcbach,gcbach2,gCO;
{
  long CO;
  double cbach,cbach2;
  long limc,limc2,mglob,m,cp,nbram,auxrel,lo,lo1,ran,fl,fl2;
  long *fpd,b1,b2,fpc,pp,ep,b,extrarel,c,ic,jc,limhash;
  long kc2,nbcol1,nbcol2,nbcol3,nbrow1,nbrow2,nbrow3,*numbase,*base,*subbase;
  long **mat,*vectprime;
  long primfact[100],expoprimfact[100],primfact1[100],expoprimfact1[100];
  long badprim[100],nbbadprim;
  long av=avma,tetpil,kc,kcco,i,j,*pro,p2,*p1,*ex,q,s,nbtest,mm,av3;
  double drc,lim,logd;
  GEN dr,v,detmat,detmatsur2;
  GEN matgen,**vp,form,form1,pc,mit,met,mot,p3,p4;
  GEN matpro; 
  long* hashtab[HASHT];

  if((typ(D)!=1)||(typ(gCO)!=1)) 
    err(talker,"incorrect type in buch");
  if(!signe(D)) err(talker,"zero discriminant in buchimag");
  if(signe(D)>0) err(talker,"positive discriminant in buchimag, try buchreal");
  s=D[lgef(D)-1]&3;
  if((s==1)||(s==2)) err(talker,"discriminant not 0 or 1 mod 4 in buchimag");
  if(signe(gCO)<=0) err(talker,"not enough relations in buchimag");
  CO=itos(gCO);cbach=gtodouble(gcbach);cbach2=gtodouble(gcbach2);
  if((!cmpis(D,-3))||(!cmpis(D,-4)))
    {
      p3=cgetg(3,17);p3[1]=un;p3[2]=lgetg(1,17);return p3;
    }
  dr=cgetr(3);affir(D,dr);drc=rtodbl(dr);
  lim=sqrt(fabs(drc)/3.0);
  logd=log(fabs(drc));limc=cbach*logd*logd;cp=exp(sqrt(logd*log(logd)/8.0));
  if(cp>limc) limc=cp;limc2=cbach2*logd*logd;if(limc>limc2) limc2=limc;
  subbase=subfactorbaseimag(D,&v,lim,&nbram);
  mglob=m=subbase[0];
  vp=powsubfactimag(v,m,CBUCH+7);
  kc2=factorbase(D,limc2,limc,&numbase,&base,&kc,badprim,&nbbadprim);
  pro=(long*)malloc(4*(kc2+1));vectprime=(long*)malloc(4*(kc2+1));
  for(i=1;i<=kc2;i++)
    {
      p2=vectprime[i]=base[i];
      pro[i]=(p2>0) ? p2 : -p2;
    }
  free(base);base=pro;
  kcco=kc+CO;
  mat=(long **)malloc(4*(kcco+1));
  for(i=1;i<=kcco;i++)
    {
      p1=(long *)malloc(4*(kc+1));mat[i]=p1;
      for(j=1;j<=kc;j++) p1[j]=0;
    }
  ex=(long*)malloc((m+1)*4);
  q=31-(long)ceil(log((double)CBUCH)/log(2.0));
  s=0;nbtest=0;
  mm=m+nbram+CO;
  limhash=(limc<32767)?limc*limc:(2<<30);
  for(i=0;i<HASHT;i++) hashtab[i]=(long*)0;
  auxrel=0;
  while(s<mm)
    {
      for(i=1;i<=m;i++) ex[i]=(rand()>>q)+7;
      av3=avma;
      form=vp[1][ex[1]];
      for (i=2;i<=m;i++) form=compose(form,vp[i][ex[i]]);
      fpc=factorise(form,kc,limc,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
      nbtest++;
      if(fpc>1)
	{
	  fpd=largeprime(fpc,ex,0,0,mglob,hashtab);
	  if(fpd)
	    {
	      auxrel++;
	      s++;lo1=lo;
	      for(j=1;j<=lo1;j++) {primfact1[j]=primfact[j];expoprimfact1[j]=expoprimfact[j];}
	      form1=vp[1][fpd[2]];
	      for(i=2;i<=m;i++) 
		form1=compose(form1,vp[i][fpd[i+1]]);
	      b1=itos(modis(form1[2],(fpc<<1)));b2=itos(modis(form[2],(fpc<<1)));
	      factorise(form1,kc,limc,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	      if(b1==b2)
		{
		  for(i=1;i<=m;i++)
		    mat[s][numbase[subbase[i]]]=fpd[i+1]-ex[i];
		  for(j=1;j<=lo;j++)
		    {
		      pp=primfact[j];ep=expoprimfact[j];
		      b1=itos(modis(form1[2],(pp<<1)));
		      if(b1>pp) ep= -ep;
		      mat[s][numbase[pp]]-=ep;
		    }
		  for(j=1;j<=lo1;j++)
		    {
		      pp=primfact1[j];ep=expoprimfact1[j];
		      b1=itos(modis(form[2],(pp<<1)));
		      if(b1>pp) ep= -ep;
		      mat[s][numbase[pp]]+=ep;
		    }
		}
	      else
		{
		  if((b1+b2)!=(fpc<<1)) {s--;auxrel--;}
		  else
		    {
		      for(i=1;i<=m;i++)
			mat[s][numbase[subbase[i]]]= -fpd[i+1]-ex[i];
		      for(j=1;j<=lo;j++)
			{
			  pp=primfact[j];ep=expoprimfact[j];
			  b1=itos(modis(form1[2],(pp<<1)));
			  if(b1>pp) ep= -ep;
			  mat[s][numbase[pp]]+=ep;
			}
		      for(j=1;j<=lo1;j++)
			{
			  pp=primfact1[j];ep=expoprimfact1[j];
			  b1=itos(modis(form[2],(pp<<1)));
			  if(b1>pp) ep= -ep;
			  mat[s][numbase[pp]]+=ep;
			}
		    }
		}
	    }
	}	  
      if(fpc==1)
	{
	  s++;
	  for(i=1;i<=m;i++) mat[s][numbase[subbase[i]]]= -ex[i];
	  for(j=1;j<=lo;j++)
	    {
	      pp=primfact[j];ep=expoprimfact[j];
	      b=itos(modis(form[2],(pp<<1)));
	      if(b>pp) ep= -ep;
	      mat[s][numbase[pp]]+=ep;
	    }
	}
      avma=av3;
    }
  while(s<kcco)
    {
      for(i=1;i<=m;i++) ex[i]=(rand()>>q)+7;
      av3=avma;
      form=vp[1][ex[1]];
      for (i=2;i<=m;i++) form=compose(form,vp[i][ex[i]]);
      pc=primeform(D,stoi(base[s+1-CO]));
      form=compose(form,pc);
      fpc=factorise(form,kc,limc,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
      nbtest++;
      if(fpc>1)
	{
	  fpd=largeprime(fpc,ex,s+1-CO,0,mglob,hashtab);
	  if(fpd)
	    {
	      auxrel++;
	      s++;lo1=lo;
	      for(j=1;j<=lo1;j++) {primfact1[j]=primfact[j];expoprimfact1[j]=expoprimfact[j];}
	      form1=vp[1][fpd[2]];
	      for(i=2;i<=m;i++) 
		form1=compose(form1,vp[i][fpd[i+1]]);
	      if(fpd[m+2])
		{
		  pc=primeform(D,stoi(base[fpd[m+2]]));
		  form1=compose(form1,pc);
		}
	      b1=itos(modis(form1[2],(fpc<<1)));b2=itos(modis(form[2],(fpc<<1)));
	      factorise(form1,kc,limc,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	      if(b1==b2)
		{
		  for(i=1;i<=m;i++)
		    mat[s][numbase[subbase[i]]]=fpd[i+1]-ex[i];
		  mat[s][s-CO]= -1;
		  if(fpd[m+2]) mat[s][fpd[m+2]]++;
		  for(j=1;j<=lo;j++)
		    {
		      pp=primfact[j];ep=expoprimfact[j];
		      b1=itos(modis(form1[2],(pp<<1)));
		      if(b1>pp) ep= -ep;
		      mat[s][numbase[pp]]-=ep;
		    }
		  for(j=1;j<=lo1;j++)
		    {
		      pp=primfact1[j];ep=expoprimfact1[j];
		      b1=itos(modis(form[2],(pp<<1)));
		      if(b1>pp) ep= -ep;
		      mat[s][numbase[pp]]+=ep;
		    }
		}
	      else
		{
		  if((b1+b2)!=(fpc<<1)) {s--;auxrel--;}
		  else
		   {
		      for(i=1;i<=m;i++)
			mat[s][numbase[subbase[i]]]= -fpd[i+1]-ex[i];
		      mat[s][s-CO]= -1;
		      if(fpd[m+2]) mat[s][fpd[m+2]]--;
		      for(j=1;j<=lo;j++)
			{
			  pp=primfact[j];ep=expoprimfact[j];
			  b1=itos(modis(form1[2],(pp<<1)));
			  if(b1>pp) ep= -ep;
			  mat[s][numbase[pp]]+=ep;
			}
		      for(j=1;j<=lo1;j++)
			{
			  pp=primfact1[j];ep=expoprimfact1[j];
			  b1=itos(modis(form[2],(pp<<1)));
			  if(b1>pp) ep= -ep;
			  mat[s][numbase[pp]]+=ep;
			}
		    }
		}
	    }
	}
      if(fpc==1)
	{
	  s++;
	  for(i=1;i<=m;i++) mat[s][numbase[subbase[i]]]= -ex[i];
	  mat[s][s-CO]= -1;
	  for(j=1;j<=lo;j++)
	    {
	      pp=primfact[j];ep=expoprimfact[j];
	      b=itos(modis(form[2],(pp<<1)));
	      if(b>pp) ep= -ep;
	      mat[s][numbase[pp]]+=ep;
	    }
	  if(!(mat[s][s-CO])) {for(i=1;i<=kc;i++) mat[s][i]=0;s--;}
	}
      avma=av3;
    }
  nbtest=auxrel=0;
  while(s<kc2)
    {
      for (i=1;i<=m;i++) ex[i]=(rand()>>q)+7;
      av3=avma;
      form=vp[1][ex[1]];
      for (i=2;i<=m;i++) form=compose(form,vp[i][ex[i]]);
      pp=base[s+1];
      pc=primeform(D,stoi(pp));
      form=compose(form,pc);
      fpc=factorise(form,s,pp,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
      nbtest++;
      if(fpc>1)
	{
	  fpd=largeprime2(fpc,ex,s+1,mglob,hashtab);
	  if(fpd&&(fpc!=pp)) {auxrel++;s++;}
	}
      if(fpc==1) s++;
      avma=av3;
    }
  hphaseimag1(mat,vectprime,kcco,kc,&nbcol1,&nbrow1);
  hphaseimag2(mat,vectprime,nbcol1,nbrow1,&nbcol2,&nbrow2);
  nbcol3=nbcol2;nbrow3=nbrow2;
  matgen=cgetg(nbcol3+1,19);
  for(i=1;i<=nbcol3;i++) matgen[i]=lgetg(nbrow3+1,18);
  for(i=1;i<=nbcol3;i++)
    {
      for(j=1;j<=nbrow3;j++) ((GEN)(matgen[i]))[j]=lstoi(mat[i][j]);
    }
  detmat=absi(rangi(matgen,&ran));
  detmatsur2=shifti(detmat,-1);
  if(gcmp1(absi(detmat))) {mit=idmat(1);nbrow3=1;nbcol3=lg(matpro);}
  else mit=hnfimag(matgen,detmat,detmatsur2);
  extrarel=nbcol3-nbrow3;
  p1=gun;
  for(i=1;i<=nbrow3;i++)
    {
      p3=(GEN)coeff(mit,i,i);
      if(signe(p3)) p1=mulii(p1,p3);
    }
  c=0;for(i=1;i<=nbrow3;i++) if(!gcmp1(coeff(mit,i,i))) c++;
  if(!c) met=idmat(1);
  else
    {
      met=cgetg(c+1,19);ic=0;
      for(i=1;i<=nbrow3;i++)
	{
	  if(!gcmp1(coeff(mit,i,i)))
	    {
	      ic++;p3=cgetg(c+1,18);met[ic]=(long)p3;jc=0;
	      for(j=1;j<=nbrow3;j++)
		{
		  if(!gcmp1(coeff(mit,j,j)))
		    {
		      jc++;p3[jc]=coeff(mit,j,i);
		    }
		}
	    }
	}
    }
  met=smith(met);
  lo=lg(met)-1;
  c=0;for(i=1;i<=lo;i++) if(!gcmp1(met[i])) c++;
  p3=gdiv(gmul(p1,mppi(4)),gmul(lfunc(D),gsqrt(absi(D),4)));
  tetpil=avma;p4=cgetg(4,17);p4[1]=lcopy(p1);mot=cgetg(c+1,17);p4[2]=(long)mot;
  for(i=1;i<=c;i++) mot[i]=lcopy(met[i]);p4[3]=lcopy(p3);
  free(base);free(vectprime);free(ex);free(subbase);free(numbase);
  for(i=1;i<=kcco;i++) free(mat[i]);free(mat);
  for(i=1;i<=m;i++) free(vp[i]);free(vp);
  return gerepile(av,tetpil,p4);
}

long *subfactorbaseimag(d,w,ll,ptnbram)
     long *ptnbram;
     double ll;
     GEN d,*w;
{
  byteptr delta=diffptr;
  long av1,i,j,pp,tp,fl,*subbase,pro[100],toto=0;
  double prod;
  GEN p1;

  av1=avma;
  i=1;pp=0;*ptnbram=0;fl=1;prod=1;
  while(fl||(i==1))
    {
      pp+=*delta++;tp=krogs(d,pp);
      if(tp==1) {pro[i]=pp;i++;prod*=pp;} else if(!tp) (*ptnbram)++;
      if((prod>ll)&&(i>1)) fl=0;
    }
  avma=av1;i--;
  *w=cgetg(i+1,18);
  for(j=1;j<=i;j++) 
    {
      p1=primeform(d,stoi(pro[j]));(*w)[j]=(long)p1;
    }
  subbase=(long*)malloc(4*(i+1));subbase[0]=i;
  for(j=1;j<=i;j++) subbase[j]=pro[j];
  return subbase;
}
  
GEN **powsubfactimag(w,n,a)
     GEN w;
     long n,a;
{
  long i,j,toto=0;
  GEN **x;

  x=(GEN**)malloc(4*(n+1));
  for(i=1;i<=n;i++) x[i]=(GEN*)malloc(4*(a+1));
  for(i=1;i<=n;i++)
    {
      x[i][0]=gpuigs(w[1],0);
      for(j=1;j<=a;j++) x[i][j]=compose(x[i][j-1],w[i]);
    }
  return x;
}


long factorbase(d,n2,n,ptnum,ptbase,ptkc,badprim,nbbadprim)
     GEN d;
     long n2,n,**ptnum,**ptbase,*ptkc,*badprim,*nbbadprim;
{
  byteptr delta=diffptr;
  long av2,i,pp,qq,fl,kr,r,*numbase,*base,sizemat;
  GEN p1;

  numbase=(long*)malloc(4*(n2+1));*ptnum=numbase;base=(long*)malloc(4*(n2+1));*ptbase=base;
  *nbbadprim=0;av2=avma;i=0;pp=*delta++;qq=2;fl=1;
  while(pp<=n2)
    {
      if((kr=krogs(d,pp))!=-1)
	{
	  if(kr) {i++;numbase[pp]=i;base[i]=pp;}
	  else
	    {
	      p1=divis(d,pp);
	      if(signe(modis(p1,pp))) {i++;numbase[pp]=i;base[i]= -pp;}
	      else
		{
		  if(pp==2)
		    {
		      r=p1[lgef(p1)-1]&7;if(signe(d)<0) r=8-r;
		      if(r>=4) {i++;numbase[pp]=i;base[i]= -pp;}
		      else badprim[++(*nbbadprim)]=pp;
		    }
		  else badprim[++(*nbbadprim)]=pp;
		}
	    }
	}
      pp+=*delta++;
      if((pp>n)&&fl) {sizemat=i;*ptkc=sizemat;fl=0;}
    }
  avma=av2;return i;
}


long factorise(f,n,limp,ptlo,primfact,expoprimfact,badprim,nbbadprim,base,limhash)
     GEN f;
     long n,limp,*ptlo,*primfact,*expoprimfact,*badprim,nbbadprim,*base,limhash;

{
  long sr,i,p,k,fl=1,av1,av2,q1,lo;
  GEN x,q,r;

  av1=avma;lo=0;x=(GEN)(absi(f[1]));if(gcmp1(x)) {avma=av1;*ptlo=0;return 1;}
  av2=avma;
  for(i=1;(i<=n)&&fl;i++)
    {
      p=base[i];q=dvmdis(x,p,&r);
      if(sr=(!signe(r)))
	{
	  primfact[++lo]=p;x=q;k=0;av2=avma;
	  while(sr)
	    {k++;q=dvmdis(x,p,&r);if(sr=(!signe(r))) {x=q;av2=avma;}}
	  expoprimfact[lo]=k;
	}
      else avma=av2;
      fl=(cmpis(q,p)>0);
    }
  if(!fl)
    {
      if(gcmp1(x)) {avma=av1;*ptlo=lo;return 1;}
      else
	{
	  if(cmpis(x,limp)<=0)
	    {
	      for(i=1;i<=nbbadprim;i++)
		if(!signe(modis(x,badprim[i]))) {avma=av1;*ptlo=lo;return 0;}
	      primfact[++lo]=itos(x);expoprimfact[lo]=1;avma=av1;*ptlo=lo;return 1;
	    }
	}
    }
  *ptlo=lo;
  if(cmpis(x,limhash)<=0)
    {q1=itos(x);avma=av1;return q1;}
  else {avma=av1;return 0;}
}

long *largeprime2(q1,ex,np,cardsubbase,hashtab)
     long q1,*ex,np,cardsubbase,*hashtab[];
{
  long hashv,*pt,cpt,i,*p1;

  hashv=((q1&2047)-1)>>1;pt=hashtab[hashv];cpt=0;
  while(pt&&(q1!=pt[1])) {pt=(long*)(*pt);cpt++;}
  if(!pt)
    {
      if(!(p1=(long*)malloc((cardsubbase+4)<<2))) err(talker,"debordement de pile de hash");
      p1[1]=q1;
      for(i=2;i<cardsubbase+2;i++) p1[i]=ex[i-1];p1[cardsubbase+2]=np;p1[cardsubbase+3]=0;
      p1[0]=cpt ? (long)hashtab[hashv] : 0;hashtab[hashv]=p1;return (long*)0;
    }
  else return (pt[cardsubbase+2]==np) ? (long*)0 : pt;
}
	
int compte(mat,row,longueur,firstnonzero)
     long **mat,row,longueur,*firstnonzero;
{
  int n,j,p;
  n=0;
  for (j=1;j<=longueur;j++)
    {
      p=mat[j][row];
      if(p) {if(abs(p)>=2) return 32767;else {n++;*firstnonzero=j;}}
    }
  return n;
}

void hphaseimag1(mat,vectprime,kcco,kc,ptcol,ptrow)
     long **mat,*vectprime,kcco,kc,*ptcol,*ptrow;

{
  long numrow,i,i1,j,nb,n,extrarel;
  extrarel=kcco-kc;
  numrow=kc;
  while(numrow>=1)
    {
      for(i=numrow;(i>=1)&&((nb=compte(mat,i,extrarel+numrow,&n))>1);i--);
      if(!nb)
	{
	  for(j=1;j<=extrarel+numrow;j++)
	    for(i1=i;i1<numrow;i1++) mat[j][i1]=mat[j][i1+1];
	  for(i1=i;i1<numrow;i1++) vectprime[i1]=vectprime[i1+1];
	  numrow--;extrarel++;
	}
      else if(nb==1)
	{
	  for(j=1;j<=extrarel+numrow;j++) mat[j][i]=mat[j][numrow];
	  vectprime[i]=vectprime[numrow];
	  mat[n]=mat[extrarel+numrow];
	  numrow--;
	}
      else {*ptrow=numrow;*ptcol=numrow+extrarel;return;}
    }
  err(talker,"not enough relations or h=1 in hphaseimag1");
}

void hphaseimag2(mat,vectprime,nbcol1,nbrow1,ptcol,ptrow)
     long **mat,*vectprime,nbcol1,nbrow1,*ptcol,*ptrow;

{
  long numrow,i,j,nb,n,sizemax,imin,nbmin,nmin,s,t,fl=1,extrarel;

  extrarel=nbcol1-nbrow1;
  numrow=nbrow1;sizemax=0;
  while(fl&&(numrow>=1)&&(sizemax<=1073741823))
    {
      imin=numrow;nbmin=compte(mat,numrow,extrarel+numrow,&n);nmin=n;
      for(i=numrow-1;i>=1;i--)
	{
	  nb=compte(mat,i,extrarel+numrow,&n);
	  if(nb<nbmin) {nbmin=nb;imin=i;nmin=n;}
	}
      if(nbmin<32767)
	{
	  s=mat[nmin][imin];
	  for(j=1;j<nmin;j++)
	    {
	      sizemax=0;
	      if(t=mat[j][imin])
		{
		  if(s==t)
		    {
		      for(i=1;i<=numrow;i++)
			{
			  mat[j][i]-=mat[nmin][i];
			  sizemax=max(sizemax,abs(mat[j][i]));
			}
		    }
		  else
		    {
		      for(i=1;i<=numrow;i++)
			{
			  mat[j][i]+=mat[nmin][i];
			  sizemax=max(sizemax,abs(mat[j][i]));
			}
		    }
		}
	    }
	  for(j=1;j<=extrarel+numrow;j++) mat[j][imin]=mat[j][numrow];
	  vectprime[imin]=vectprime[numrow];
	  mat[nmin]=mat[extrarel+numrow];
	  numrow--;
	}
      else {*ptrow=numrow;*ptcol=numrow+extrarel;fl=0;}
    }
  if(!numrow) err(talker,"not enough relations or h=1 in hphaseimag2");
  if(sizemax>1073741823) return;
  return;
}

GEN hnfimag(x,detmat,detmatsur2)
     GEN x,detmat,detmatsur2;
{
  long li,co,av,tetpil,i,j,def,ldef,lim,dec;
  GEN b,q,w,p1,y,d,u,v,p3,p4;

  lim=(avma+bot)>>1;
  av=avma;co=lg(x);li=lg(x[1]);y=gcopy(x);
  def=co;ldef=(li>co)?li-co+1:1;
  for(i=li-1;i>=ldef;i--)
    {
      def--;j=def-1;while(j&&(!signe(coeff(y,i,j)))) j--;
      while(j>1)
	{
	  d=bezout(coeff(y,i,j),coeff(y,i,j-1),&u,&v);
	  p1=gadd(gmul(u,y[j]),gmul(v,y[j-1]));
	  y[j]=lsub(gmul(p3=divii(coeff(y,i,j),d),y[j-1]),gmul(p4=divii(coeff(y,i,j-1),d),y[j]));
	  y[j]=(long)clean(y[j],detmat,detmatsur2);
	  y[j-1]=(long)p1;
	  y[j-1]=(long)clean(y[j-1],detmat,detmatsur2);
	  j--;while(j&&(!signe(coeff(y,i,j)))) j--;
	  if(avma<lim) {tetpil=avma;y=gerepile(av,tetpil,gcopy(y));}
	}
      if(j==1)
	{
	  d=bezout(coeff(y,i,1),coeff(y,i,def),&u,&v);
	  p1=gadd(gmul(u,y[1]),gmul(v,y[def]));
	  y[1]=lsub(gmul(p3=divii(coeff(y,i,1),d),y[def]),gmul(p4=divii(coeff(y,i,def),d),y[1]));
	  y[1]=(long)clean(y[1],detmat,detmatsur2);
	  y[def]=(long)p1;
	  y[def]=(long)clean(y[def],detmat,detmatsur2);
	}
      if(avma<lim) {tetpil=avma;y=gerepile(av,tetpil,gcopy(y));}
    }
  tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
  b=gcopy(detmat);w=cgetg(li,19);def--;
  for(i=li-1;i>=1;i--)
    {
      d=bezout(coeff(y,i,i+def),b,&u,&v);w[i]=lmod(gmul(u,y[i+def]),b);
      if(!signe(coeff(w,i,i))) coeff(w,i,i)=(long)d;
      if(i>1) b=divii(b,d);
    }
  for(i=li-2;i>=1;i--)
    {
      for(j=i+1;j<li;j++)
	{
	  q=gdivent(coeff(w,i,j),coeff(w,i,i));w[j]=lsub(w[j],gmul(q,w[i]));
	}
      if(avma<lim) {tetpil=avma;w=gerepile(av,tetpil,gcopy(w));}
    }
  tetpil=avma;w=gerepile(av,tetpil,gcopy(w));
  return w;
}


GEN rangi(x,rr)
     GEN  x;
     long *rr;
{
  GEN pass,c,v,det1;
  long i,j,k,rg,t,n,n1,m,m1,nbmot,av,av1,pivprec,piv,p1,p,vi,tetpil,cm=0;
  
  nbmot=20;n=(n1=lg(x))-1;m=(m1=lg(x[1]))-1;av=avma;
  pivprec=lgeti(nbmot);affsi(0,det1=cgeti(nbmot));affsi(1,piv=lgeti(nbmot));pass=cgetg(m1,19);
  for(j=1;j<=m;j++)
    {p=pass[j]=lgetg(m1,18);for(i=1;i<=m;i++) ((GEN)p)[i]=lgeti(nbmot);}
  c=cgeti(m1);for(k=1;k<=m;k++) c[k]=0;
  v=cgetg(m1,18);av1=avma;k=1;rg=0;
  while((k<=n)&&(rg<m))
    {
      for(t=0,i=1;i<=m;i++)
	if(!c[i])
	  {
	    vi=lmulii(piv,coeff(x,i,k));
	    for(j=1;j<=m;j++)
	      if(c[j]) vi=laddii(vi,mulii(coeff(pass,i,j),coeff(x,j,k)));
	    v[i]=vi;if(!t) if(signe(vi)) t=i;
	  }
      if (t)
	{
	  rg++;c[t]=k;affii(piv,pivprec);affii(v[t],piv);
	  if(rg<m)
	    {
	      for(i=1;i<=m;i++)
		if(!c[i])
		  for(j=1;j<=m;j++)
		    if(c[j]&&(j!=t))
		      {
			p1=lsubii(mulii(piv,coeff(pass,i,j)),mulii(v[i],coeff(pass,t,j)));
			if(rg>1) diviiz(p1,pivprec,coeff(pass,i,j));
			else affii(p1,coeff(pass,i,j));
		      }
	      for(i=1;i<=m;i++) if(!c[i]) mpnegz(v[i],coeff(pass,i,t));
	    }
	  else c[t]=0;
	}
      if(rg==m) 
	{cm=1;affii(ggcd(piv,det1),det1);affii(pivprec,piv);rg--;}
      avma=av1;k++;
    }
  *rr=rg+cm;tetpil=avma;return gerepile(av,tetpil,gcopy(det1));
}

GEN clean(x,detmat,detmatsur2)
     GEN x,detmat,detmatsur2;
{
  long lx=lg(x),i;
  GEN y,p1;

  y=cgetg(lx,18);
  for(i=1;i<lx;i++)
    {p1=modii(x[i],detmat);y[i]=(cmpii(p1,detmatsur2)>0) ? lsubii(p1,detmat) : (long)p1;}
  return y;
}

GEN buchreal(D,gsens,gcbach,gcbach2,gRELSUP,prec)
     GEN D,gsens,gcbach,gcbach2,gRELSUP;
     long prec;
{
  long sens,RELSUP;
  double cbach,cbach2;
  long precreg,limc,limbach,cardsubbase,cardsub,cp,nbram,nbrederr,auxrel;
  long nbprimfact,nbprimfact1,ran,fl,fl2,lo,initform5,findecycle,memoirefindecycle;
  long nbrhocourant,nbrhocumule,nrho,*fpd,b1,b2,fpc,pp,ep,b,extrarel,c,ic,jc,limhash;
  long sizebach,nbcol1,nbcol2,nbcol3,nbrow1,nbrow2,nbrow3,*numbase,*base,*subbase;
  long **mat,*vectprime;
  long primfact[100],expoprimfact[100],primfact1[100],expoprimfact1[100];
  long badprim[100],nbbadprim;
  long av,av1,av2,tetpil,dec,sizemat,sizematcol,i,j,*pro,p2,*p1,*ex,qqq,s,nbtest,mm;
  double drc,lim,logd;
  GEN dr,sqrtD,isqrtD,errglob,log2precis,tabprform,detmat,detmatsur2;
  GEN matgen,vecexpo,vecerr,ermax,**tabpowprform;
  GEN forminit,form,form0,form1,form2,pc,mit,met,mot,p3,p4;
  GEN wecexpo,wecerr,xecexpo,xecerr,matpro; 
  long* hashtab[HASHT];

  if((typ(D)!=1)||(typ(gRELSUP)!=1)||(typ(gsens)!=1)) 
    err(talker,"incorrect type in buchreal");
  if(!signe(D)) err(talker,"zero discriminant in buchreal");
  if(signe(D)<0) err(talker,"negative discriminant in buchreal, try buchimag");
  s=D[lgef(D)-1]&3;
  if((s==2)||(s==3)) err(talker,"discriminant not 0 or 1 mod 4 in buchreal");
  if(signe(gRELSUP)<=0) err(talker,"not enough relations in buchreal");
  RELSUP=itos(gRELSUP);cbach=gtodouble(gcbach);cbach2=gtodouble(gcbach2);
  sens=abs(signe(gsens));
  initbuchreal(D,cbach,cbach2,&precreg,&log2precis,&qqq,&dr,&drc,&logd,&sqrtD,&isqrtD,&lim,&errglob,&limc,&limbach,prec);
  subbase=subfactorbasereal(D,&tabprform,lim,precreg,&nbram,isqrtD,sqrtD,sens);
  cardsubbase=cardsub=subbase[0];
  tabpowprform=powsubfactreal(tabprform,cardsub,CBUCH+7,D,isqrtD,sqrtD,sens,precreg);
  sizebach=factorbase(D,limbach,limc,&numbase,&base,&sizemat,badprim,&nbbadprim);
  pro=(long*)malloc(4*(sizebach+1));vectprime=(long*)malloc(4*(sizebach+1));
  for(i=1;i<=sizebach;i++)
    {p2=vectprime[i]=base[i];pro[i]=(p2>0) ? p2 : -p2;}
  free(base);base=pro;
  sizematcol=sizemat+RELSUP;
  mat=(long **)malloc(4*(sizematcol+1));
  vecexpo=cgetg(sizematcol+1,17);vecerr=cgetg(sizematcol+1,17);
  for(i=1;i<=sizematcol;i++) {vecexpo[i]=lgetr(precreg);vecerr[i]=lgetr(4);}
  for(i=1;i<=sizematcol;i++)
    {p1=(long *)malloc(4*(sizemat+1));mat[i]=p1;for(j=1;j<=sizemat;j++) p1[j]=0;}
  ex=(long*)malloc((cardsub+1)*4);
  limhash=(limc<32767)? limc*limc:(2<<30);

  s=nbtest=auxrel=0;
  mm=cardsub+nbram+RELSUP;
  av=avma;
  for(i=0;i<HASHT;i++) hashtab[i]=(long*)0;

  while(s<mm)
    {
      for(i=1;i<=cardsub;i++) ex[i]=(rand()>>qqq)+7;
      av1=avma;
      form=form0=initializeform3(ex,tabpowprform,cardsub,D,isqrtD,sens);
      initform5=0;findecycle=memoirefindecycle=1;nbrederr=nbrhocourant=nbrhocumule=0;
      do
	{
	  av2=avma;
	  fpc=factorise(form,sizemat,limc,&nbprimfact,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	  if(fpc==1)
	    {
	      if(!initform5)
		{
		  form1=initializeform5(ex,tabpowprform,cardsub,&nbrederr,D,isqrtD,sqrtD,sens);
		  initform5=1;
		}
	      for(i=1;i<=nbrhocourant;i++) form1=rhorealform5(form1,&nbrederr,D,isqrtD,sqrtD);
	      nbrhocourant=0;s++;
	      addcolumnmat(mat,s,cardsub,numbase,subbase,ex,nbprimfact,primfact,expoprimfact,form1,log2precis,nbrederr,errglob,vecexpo,vecerr);
	    }
	  else if(fpc>1)
	    {
	      fpd=largeprime(fpc,ex,0,nbrhocumule,cardsubbase,hashtab);
	      if(fpd)
		{
		  if(!initform5)
		    {
		      form1=initializeform5(ex,tabpowprform,cardsub,&nbrederr,D,isqrtD,sqrtD,sens);
		      initform5=1;
		    }
		  for(i=1;i<=nbrhocourant;i++)
		    form1=rhorealform5(form1,&nbrederr,D,isqrtD,sqrtD);
		  nbrhocourant=0;nbprimfact1=nbprimfact;
		  for(j=1;j<=nbprimfact1;j++)
		    {primfact1[j]=primfact[j];expoprimfact1[j]=expoprimfact[j];}
		  form2=tabpowprform[1][fpd[2]];
		  for(i=2;i<=cardsub;i++) 
		    form2=comprealform5(form2,tabpowprform[i][fpd[i+1]],&nbrederr,D,
					isqrtD,sqrtD,sens);
		  for(i=1;i<=fpd[cardsub+3];i++)
		    form2=rhorealform5(form2,&nbrederr,D,isqrtD,sqrtD);
		  if((!sens)&&(signe(addii(form2[1],form2[3]))))
		    {setsigne(form2[1],1);setsigne(form2[3],-1);}
		  b1=itos(modis(form2[2],(fpc<<1)));b2=itos(modis(form1[2],(fpc<<1)));
		  factorise(form2,sizemat,limc,&nbprimfact,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
		  if(b1==b2)
		    {
		      s++;
		      addcolumnmat1(mat,s,cardsub,numbase,subbase,ex,nbprimfact1,primfact1,expoprimfact1,form1,fpd,nbprimfact,primfact,expoprimfact,
				    form2,log2precis,nbrederr,errglob,vecexpo,vecerr);
		    }
		  else
		    {
		      if((b1+b2)==(fpc<<1))
			{
			  s++;
			  addcolumnmat2(mat,s,cardsub,numbase,subbase,ex,nbprimfact1,primfact1,expoprimfact1,form1,fpd,nbprimfact,primfact,expoprimfact,form2,log2precis,nbrederr,errglob,vecexpo,vecerr);
			}
		    }
		}
	    }
	  form=rhorealform3(form,D,isqrtD);nbrhocourant++;nbrhocumule++;
	  if(!sens)
	    {
	      if(memoirefindecycle==findecycle)
		{
		  if(gegal(form[1],form0[1])&&gegal(form[2],form0[2]))
		    memoirefindecycle=0;
		  if(gegal(form[1],negi(form0[1]))&&gegal(form[2],form0[2]))
		    memoirefindecycle=0;
		  tetpil=avma;form=gcopy(form);if(initform5) form1=gcopy(form1);
		  dec=lpile(av2,tetpil,0)>>2;form+=dec;if(initform5) form1+=dec;
		}
	      else {findecycle=0;avma=av2;}
	    }
	  else
	    {
	      if(memoirefindecycle==findecycle)
		{
		  if(gegal(form[1],form0[1])&&gegal(form[2],form0[2]))
		    memoirefindecycle=0;
		  tetpil=avma;form=gcopy(form);if(initform5) form1=gcopy(form1);
		  dec=lpile(av2,tetpil,0)>>2;form+=dec;if(initform5) form1+=dec;
		}
	      else {findecycle=0;avma=av2;}
	    }
	}
      while((s<mm)&&findecycle);
      avma=av1;
    }
  while(s<sizematcol)
    {
      for(i=1;i<=cardsub;i++) ex[i]=(rand()>>qqq)+7;
      av1=avma;
      form=initializeform3(ex,tabpowprform,cardsub,D,isqrtD,sens);
      pc=redrealform3(primeform(D,stoi(base[s+1-RELSUP]),precreg),D,isqrtD,sens);
      form=comprealform3(form,pc,D,isqrtD,sens);forminit=form;nrho=fl2=0;
      do
	{
	  fpc=factorise(form,sizemat,limc,&nbprimfact,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	  nbtest++;
	  if(fpc>1)
	    {
	      fpd=largeprime(fpc,ex,s+1-RELSUP,nrho,cardsubbase,hashtab);
	      if(fpd)
		{
		  form=initializeform5(ex,tabpowprform,cardsub,&nbrederr,D,isqrtD,sqrtD,sens);
		  pc=redrealform(primeform(D,stoi(base[s+1-RELSUP]),precreg),&nbrederr,D,
				 isqrtD,sqrtD,sens,precreg);
		  pc[4]=zero;affsr(1,pc[5]);
		  form=comprealform5(form,pc,&nbrederr,D,isqrtD,sqrtD,sens);
		  for(i=1;i<=nrho;i++) form=rhorealform5(form,&nbrederr,D,isqrtD,sqrtD);
		  auxrel++;s++;nbprimfact1=nbprimfact;
		  for(j=1;j<=nbprimfact1;j++)
		    {primfact1[j]=primfact[j];expoprimfact1[j]=expoprimfact[j];}
		  form1=tabpowprform[1][fpd[2]];
		  for(i=2;i<=cardsub;i++) 
		    form1=comprealform5(form1,tabpowprform[i][fpd[i+1]],&nbrederr,D,
					isqrtD,sqrtD,sens);
		  if(fpd[cardsub+2])
		    {
		      pc=redrealform(primeform(D,stoi(base[fpd[cardsub+2]]),precreg),
				     &nbrederr,D,isqrtD,sqrtD,sens,precreg);
		      pc[4]=zero;affsr(1,pc[5]);
		      form1=comprealform5(form1,pc,&nbrederr,D,isqrtD,sqrtD,sens);
		      for(i=1;i<=fpd[cardsub+3];i++) 
			form1=rhorealform5(form1,&nbrederr,D,isqrtD,sqrtD);
		      if((!sens)&&(signe(addii(form1[1],form1[3]))))
			{setsigne(form1[1],1);setsigne(form1[3],-1);}
		    }
		  b1=itos(modis(form1[2],(fpc<<1)));b2=itos(modis(form[2],(fpc<<1)));
		  factorise(form1,sizemat,limc,&nbprimfact,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
		  if(b1==b2)
		    {
		      fl2=1;
		      for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]=fpd[i+1]-ex[i];
		      mat[s][s-RELSUP]= -1;
		      if(fpd[cardsub+2]) mat[s][fpd[cardsub+2]]++;
		      for(j=1;j<=nbprimfact;j++)
			{
			  pp=primfact[j];ep=expoprimfact[j];b1=itos(modis(form1[2],(pp<<1)));
			  if(b1>pp) ep= -ep;mat[s][numbase[pp]]-=ep;
			}
		      for(j=1;j<=nbprimfact1;j++)
			{
			  pp=primfact1[j];ep=expoprimfact1[j];b1=itos(modis(form[2],(pp<<1)));
			  if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
			}
		      affrr(shiftr(mpadd(mulir(mulsi(EXP220,subii(form[4],form1[4])),
			log2precis),mplog(absr(divrr(form[5],form1[5])))),-1),vecexpo[s]);
		      mulsrz(nbrederr,errglob,vecerr[s]);
		    }
		  else
		    {
		      if((b1+b2)!=(fpc<<1)) {s--;auxrel--;}
		      else
			{
			  fl2=1;
			  for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]= -fpd[i+1]-ex[i];
			  mat[s][s-RELSUP]= -1;
			  if(fpd[cardsub+2]) mat[s][fpd[cardsub+2]]--;
			  for(j=1;j<=nbprimfact;j++)
			    {
			      pp=primfact[j];ep=expoprimfact[j];
			      b1=itos(modis(form1[2],(pp<<1)));
			      if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
			    }
			  for(j=1;j<=nbprimfact1;j++)
			    {
			      pp=primfact1[j];ep=expoprimfact1[j];
			      b1=itos(modis(form[2],(pp<<1)));
			      if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
			    }
			  affrr(shiftr(mpadd(mulir(mulsi(EXP220,addii(form1[4],form[4])),
			    log2precis),mplog(absr(mulrr(form1[5],form[5])))),-1),vecexpo[s]);
			  mulsrz(nbrederr,errglob,vecerr[s]);
			}
		    }
		}
	    }
	  if ((fpc!=1)&&(!fl2))
	    {
	      form=rhorealform3(form,D,isqrtD);nrho++;
	      if((sens)||(!signe(addii(form[1],form[3]))))
		{form=rhorealform3(form,D,isqrtD);nrho++;}
	      else {setsigne(form[1],1);setsigne(form[3],-1);}
	      fl=gegal(form[1],forminit[1]);
	      if(fl) fl=gegal(form[2],forminit[2]);
	      if(fl) fl=gegal(form[3],forminit[3]);
	    }
	}
      while((fpc!=1)&&(!fl)&&(!fl2));
      if(fpc==1)
	{
	  nbrederr=0;
	  form=initializeform5(ex,tabpowprform,cardsub,&nbrederr,D,isqrtD,sqrtD,sens);
	  pc=redrealform(primeform(D,stoi(base[s+1-RELSUP]),precreg),&nbrederr,D,isqrtD,
			 sqrtD,sens,precreg);
	  pc[4]=zero;affsr(1,pc[5]);
	  form=comprealform5(form,pc,&nbrederr,D,isqrtD,sqrtD,sens);
	  for(i=1;i<=nrho;i++) form=rhorealform5(form,&nbrederr,D,isqrtD,sqrtD);
	  s++;
	  for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]= -ex[i];
	  mat[s][s-RELSUP]= -1;
 	  for(j=1;j<=nbprimfact;j++)
	    {
	      pp=primfact[j];ep=expoprimfact[j];b=itos(modis(form[2],(pp<<1)));
	      if(b>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
	    }
	  affrr(shiftr(mpadd(mulir(mulsi(EXP220,form[4]),log2precis),
			     mplog(absr(form[5]))),-1),vecexpo[s]);
	  mulsrz(nbrederr,errglob,vecerr[s]);
	  if(!(mat[s][s-RELSUP])) {for(i=1;i<=sizemat;i++) mat[s][i]=0;s--;}
	}
      avma=av1;
    }
  nbtest=auxrel=0;
  while(s<sizebach)
    {
      for (i=1;i<=cardsub;i++) ex[i]=(rand()>>qqq)+7;
      av1=avma;
      form=initializeform3(ex,tabpowprform,cardsub,D,isqrtD,sens);
      pp=base[s+1];
      pc=redrealform3(primeform(D,stoi(pp),precreg),D,isqrtD,sens);
      form=comprealform3(form,pc,D,isqrtD,sens);forminit=form;fl2=0;
      do
	{
	  fpc=factorise(form,s,pp,&nbprimfact,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	  nbtest++;
	  if(fpc>1)
	    {
	      fpd=largeprime2(fpc,ex,s+1,cardsubbase,hashtab);
	      if(fpd&&(fpc!=pp)){auxrel++;s++;fl2=1;}
	    }
	  if((fpc!=1)&&(!fl2))
	    {
	      form=rhorealform3(form,D,isqrtD);
	      if((sens)||(!signe(addii(form[1],form[3])))) 
		form=rhorealform3(form,D,isqrtD);
	      else{setsigne(form[1],1);setsigne(form[3],-1);}
	      fl=gegal(form[1],forminit[1]);
	      if(fl) fl=gegal(form[2],forminit[2]);
	      if(fl) fl=gegal(form[3],forminit[3]);
	    }
	}
      while((fpc!=1)&&(!fl)&&(!fl2));
      if(fpc==1) s++;
      avma=av1;
    }
  hphasereal1(mat,vectprime,vecexpo,vecerr,sizematcol,sizemat,&nbcol1,&nbrow1);
  hphasereal2(mat,vectprime,vecexpo,vecerr,nbcol1,nbrow1,&nbcol2,&nbrow2);
  nbcol3=nbcol2;nbrow3=nbrow2;
  matgen=cgetg(nbcol3+1,19);for(i=1;i<=nbcol3;i++) matgen[i]=lgetg(nbrow3+1,18);
  wecexpo=cgetg(nbcol3+1,17);wecerr=cgetg(nbcol3+1,17);
  for(i=1;i<=nbcol3;i++)
    {
      wecexpo[i]=vecexpo[i];wecerr[i]=vecerr[i];
      for(j=1;j<=nbrow3;j++) ((GEN)(matgen[i]))[j]=lstoi(mat[i][j]);
    }
  vecexpo=wecexpo;vecerr=wecerr;
  detmat=absi(rangi(matgen,&ran));detmatsur2=shifti(detmat,-1);
  matpro=kerint(matgen);
  xecexpo=gmul(vecexpo,matpro);xecerr=gmul(vecerr,gabs(matpro));
  if(gcmp1(absi(detmat))) {mit=idmat(1);nbrow3=1;nbcol3=lg(matpro);}
  else mit=hnfreal(matgen,detmat,detmatsur2,vecexpo,vecerr,&wecexpo,&wecerr);
  wecexpo=xecexpo;wecerr=xecerr;
  extrarel=nbcol3-nbrow3;
  for(i=2;i<=extrarel;i++)
    {
      wecexpo[i]=(long)gcdreal(wecexpo[i-1],wecexpo[i],wecerr[i-1],wecerr[i],wecexpo+i-1);
    }
  ermax=(GEN)wecexpo[1];for(i=2;i<extrarel;i++) ermax=gmax(ermax,wecexpo[i]);
  p1=gun;
  for(i=1;i<=nbrow3;i++)
    {p3=(GEN)coeff(mit,i,i);if(signe(p3)) p1=mulii(p1,p3);}
  c=0;for(i=1;i<=nbrow3;i++) if(!gcmp1(coeff(mit,i,i))) c++;
  if(!c) met=idmat(1);
  else
    {
      met=cgetg(c+1,19);ic=0;
      for(i=1;i<=nbrow3;i++)
	{
	  if(!gcmp1(coeff(mit,i,i)))
	    {
	      ic++;p3=cgetg(c+1,18);met[ic]=(long)p3;jc=0;
	      for(j=1;j<=nbrow3;j++){if(!gcmp1(coeff(mit,j,j))){jc++;p3[jc]=coeff(mit,j,i);}}
	    }
	}
    }
  met=smith(met);
  lo=lg(met)-1;c=0;for(i=1;i<=lo;i++) if(!gcmp1(met[i])) c++;
  p2=(long)absr(wecexpo[extrarel]);
  p3=gdiv(gmul2n(gmul(p1,p2),1),gmul(lfunc(D),sqrtD));
  tetpil=avma;p4=cgetg(5,17);p4[1]=lcopy(p1);
  mot=cgetg(c+1,17);p4[2]=(long)mot;for(i=1;i<=c;i++) mot[i]=lcopy(met[i]);
  p4[3]=lcopy(p2);p4[4]=lcopy(p3);
  if(gexpo(ermax)> -25) err(talker,"precision loss in buchreal");
  free(base);free(vectprime);free(ex);free(subbase);free(numbase);
  for(i=1;i<=sizematcol;i++) free(mat[i]);free(mat);
  for(i=1;i<=cardsub;i++) free(tabpowprform[i]);free(tabpowprform);
  return gerepile(av,tetpil,p4);
}


long *subfactorbasereal(d,w,ll,precreg,ptnbram,isqrtD,sqrtD,sens)
     long precreg,*ptnbram,sens;
     double ll;
     GEN d,*w;
     GEN isqrtD,sqrtD;
{
  byteptr delta=diffptr;
  long av1,i,j,pp,tp,fl,*subbase,pro[100],toto=0;
  double prod;
  GEN p1,D=d;

  av1=avma;i=1;pp=0;*ptnbram=0;fl=1;prod=1;
  while(fl||(i==1))
    {
      pp+=*delta++;tp=krogs(d,pp);
      if(tp==1) {pro[i]=pp;i++;prod*=pp;} else if(!tp) (*ptnbram)++;
      if((prod>ll)&&(i>1)) fl=0;
    }
  avma=av1;i--;(*w)=cgetg(i+1,18);
  for(j=1;j<=i;j++) 
    {
      p1=redrealform(primeform(d,stoi(pro[j]),precreg),&toto,D,isqrtD,sqrtD,sens,precreg);
      p1[4]=zero;affsr(1,p1[5]);(*w)[j]=(long)p1;
    }
  subbase=(long*)malloc(4*(i+1));subbase[0]=i;for(j=1;j<=i;j++) subbase[j]=pro[j];
  return subbase;
}

  
GEN **powsubfactreal(w,n,a,D,isqrtD,sqrtD,sens,precreg)
     GEN w,D,isqrtD,sqrtD;
     long n,a,sens,precreg;
{
  long i,j,toto=0;
  GEN **x;

  x=(GEN**)malloc(4*(n+1));for(i=1;i<=n;i++) x[i]=(GEN*)malloc(4*(a+1));
  for(i=1;i<=n;i++)
    {
      j=0;x[i][j]=powrealform5(w[1],0,D,isqrtD,sqrtD,sens,precreg);
      while(j<a){j++;x[i][j]=comprealform5(x[i][j-1],w[i],&toto,D,isqrtD,sqrtD,sens);}
    }
  return x;
}
  
long *largeprime(q1,ex,np,nrho,cardsubbase,hashtab)
     long q1,*ex,np,nrho,cardsubbase,*hashtab[];
{
  long hashv,*pt,cpt,i,*p1,fl;

  hashv=((q1&2047)-1)>>1;pt=hashtab[hashv];cpt=0;
  while(pt&&(q1!=pt[1])) {pt=(long*)(*pt);cpt++;}
  if(!pt)
    {
      if(!(p1=(long*)malloc((cardsubbase+4)<<2))) err(talker,"debordement de pile de hash");
      p1[1]=q1;
      for(i=2;i<cardsubbase+2;i++) p1[i]=ex[i-1];p1[cardsubbase+2]=np;p1[cardsubbase+3]=nrho;
      p1[0]=cpt ? (long)hashtab[hashv] : 0;hashtab[hashv]=p1;return (long*)0;
    }
  else
    {
      fl=1;i=2;while(fl&&(i<(cardsubbase+2))) {fl=(pt[i]==ex[i-1]);i++;}
      if(fl) fl=(pt[i]==np);return fl ? (long*)0 : pt;
    }
}

void hphasereal1(mat,vectprime,vecexpo,vecerr,sizematcol,sizemat,ptcol,ptrow)
     long **mat,*vectprime,sizematcol,sizemat,*ptcol,*ptrow;
     GEN vecexpo,vecerr;
{
  long numrow,i,i1,j,nb,n,extrarel;

  extrarel=sizematcol-sizemat;numrow=sizemat;
  while(numrow>=1)
    {
      for(i=numrow;(i>=1)&&((nb=compte(mat,i,extrarel+numrow,&n))>1);i--);
      if(!nb)
	{
	  for(j=1;j<=extrarel+numrow;j++)
	    for(i1=i;i1<numrow;i1++) mat[j][i1]=mat[j][i1+1];
	  for(i1=i;i1<numrow;i1++) vectprime[i1]=vectprime[i1+1];
	  numrow--;extrarel++;
	}
      else if(nb==1)
	{
	  for(j=1;j<=extrarel+numrow;j++) mat[j][i]=mat[j][numrow];
	  vectprime[i]=vectprime[numrow];mat[n]=mat[extrarel+numrow];
	  vecexpo[n]=vecexpo[extrarel+numrow];vecerr[n]=vecerr[extrarel+numrow];
	  numrow--;
	}
      else {*ptrow=numrow;*ptcol=numrow+extrarel;return;}
    }
  err(talker,"not enough relations or h=1 in hphasereal1");
}

void hphasereal2(mat,vectprime,vecexpo,vecerr,nbcol1,nbrow1,ptcol,ptrow)
     long **mat,*vectprime,nbcol1,nbrow1,*ptcol,*ptrow;
     GEN vecexpo,vecerr;
{
  long numrow,i,j,nb,n,sizemax,imin,nbmin,nmin,s,t,fl=1,extrarel;

  extrarel=nbcol1-nbrow1;numrow=nbrow1;sizemax=0;
  while(fl&&(numrow>=1)&&(sizemax<=1073741823))
    {
      imin=numrow;nbmin=compte(mat,numrow,extrarel+numrow,&n);nmin=n;
      for(i=numrow-1;i>=1;i--)
	{nb=compte(mat,i,extrarel+numrow,&n);if(nb<nbmin) {nbmin=nb;imin=i;nmin=n;}}
      if(nbmin<32767)
	{
	  s=mat[nmin][imin];
	  for(j=1;j<nmin;j++)
	    {
	      sizemax=0;
	      if(t=mat[j][imin])
		{
		  if(s==t)
		    {
		      for(i=1;i<=numrow;i++)
			{mat[j][i]-=mat[nmin][i];sizemax=max(sizemax,abs(mat[j][i]));}
		      subrrz(vecexpo[j],vecexpo[nmin],vecexpo[j]);
		      addrrz(vecerr[j],vecerr[nmin],vecerr[j]);
		    }
		  else
		    {
		      for(i=1;i<=numrow;i++)
			{mat[j][i]+=mat[nmin][i];sizemax=max(sizemax,abs(mat[j][i]));}
		      addrrz(vecexpo[j],vecexpo[nmin],vecexpo[j]);
		      addrrz(vecerr[j],vecerr[nmin],vecerr[j]);
		    }
		}
	    }
	  for(j=1;j<=extrarel+numrow;j++) mat[j][imin]=mat[j][numrow];
	  vectprime[imin]=vectprime[numrow];mat[nmin]=mat[extrarel+numrow];
	  vecexpo[nmin]=vecexpo[extrarel+numrow];vecerr[nmin]=vecerr[extrarel+numrow];
	  numrow--;
	}
      else {*ptrow=numrow;*ptcol=numrow+extrarel;fl=0;}
    }
  if(!numrow) err(talker,"not enough relations or h=1 in hphasereal2");
  if(sizemax>1073741823) return;return;
}

GEN gcdreal(a,b,era,erb,erd)
     GEN a,b,era,erb,*erd;
{
  long av,tetpil,dec,e;
  GEN k1,r;

  if(expo(a)<-2) {*erd=gcopy(a);return gcopy(b);}
  if(expo(b)<-2) {*erd=gcopy(b);return gcopy(a);}
  av=avma;a=absr(a);b=absr(b);
  while((expo(b)>=(-2))&&(signe(b)))
    {k1=gcvtoi(divrr(a,b),&e);r=subrr(a,mulir(k1,b));a=b;b=r;}
  tetpil=avma;a=gcopy(a);b=gcopy(b);dec=lpile(av,tetpil,0)>>2;*erd=b+dec;return a+dec;
}


GEN hnfreal(x,detmat,detmatsur2,vlog,verr,wlog,werr)
     GEN x,detmat,detmatsur2,vlog,verr,*wlog,*werr;
{
  long li,co,av,tetpil,i,j,def,ldef,lim,dec;
  GEN b,q,w,p1,y,d,u,v,p3,p4;

  lim=(avma+bot)>>1;av=avma;co=lg(x);li=lg(x[1]);y=gcopy(x);
  def=co;ldef=(li>co)?li-co+1:1;
  for(i=li-1;i>=ldef;i--)
    {
      def--;j=def-1;while(j&&(!signe(coeff(y,i,j)))) j--;
      while(j>1)
	{
	  d=bezout(coeff(y,i,j),coeff(y,i,j-1),&u,&v);
	  p1=gadd(gmul(u,y[j]),gmul(v,y[j-1]));
	  y[j]=lsub(gmul(p3=divii(coeff(y,i,j),d),y[j-1]),
		    gmul(p4=divii(coeff(y,i,j-1),d),y[j]));
	  y[j]=(long)clean(y[j],detmat,detmatsur2);y[j-1]=(long)p1;
	  y[j-1]=(long)clean(y[j-1],detmat,detmatsur2);
	  p1=gadd(gmul(u,vlog[j]),gmul(v,vlog[j-1]));
	  vlog[j]=lsub(gmul(p3,vlog[j-1]),gmul(p4,vlog[j]));vlog[j-1]=(long)p1;
	  p1=gadd(gmul(absi(u),verr[j]),gmul(absi(v),verr[j-1]));
	  verr[j]=ladd(gmul(gabs(p3),verr[j-1]),gmul(gabs(p4),verr[j]));verr[j-1]=(long)p1;
	  j--;while(j&&(!signe(coeff(y,i,j)))) j--;
	  if(avma<lim)
	    {
	      tetpil=avma;y=gcopy(y);vlog=gcopy(vlog);verr=gcopy(verr);
	      dec=lpile(av,tetpil,0)>>2;y+=dec;vlog+=dec;verr+=dec;
	    }
	}
      if(j==1)
	{
	  d=bezout(coeff(y,i,1),coeff(y,i,def),&u,&v);
	  p1=gadd(gmul(u,y[1]),gmul(v,y[def]));
	  y[1]=lsub(gmul(p3=divii(coeff(y,i,1),d),y[def]),
		    gmul(p4=divii(coeff(y,i,def),d),y[1]));
	  y[1]=(long)clean(y[1],detmat,detmatsur2);y[def]=(long)p1;
	  y[def]=(long)clean(y[def],detmat,detmatsur2);
	  p1=gadd(gmul(u,vlog[1]),gmul(v,vlog[def]));
	  vlog[1]=lsub(gmul(p3,vlog[def]),gmul(p4,vlog[1]));vlog[def]=(long)p1;
	  p1=gadd(gmul(absi(u),verr[1]),gmul(absi(v),verr[def]));
	  verr[1]=ladd(gmul(p3,verr[def]),gmul(p4,verr[1]));verr[def]=(long)p1;
	}
      if(avma<lim)
	{
	  tetpil=avma;y=gcopy(y);vlog=gcopy(vlog);verr=gcopy(verr);
	  dec=lpile(av,tetpil,0)>>2;y+=dec;vlog+=dec;verr+=dec;
	}
    }
  tetpil=avma;y=gcopy(y);vlog=gcopy(vlog);verr=gcopy(verr);
  dec=lpile(av,tetpil,0)>>2;y+=dec;vlog+=dec;verr+=dec;
  b=gcopy(detmat);w=cgetg(li,19);def--;
  for(i=li-1;i>=1;i--)
    {
      d=bezout(coeff(y,i,i+def),b,&u,&v);w[i]=lmod(gmul(u,y[i+def]),b);
      if(!signe(coeff(w,i,i))) coeff(w,i,i)=(long)d;
      vlog[i+def]=lmul(u,vlog[i+def]);verr[i+def]=labs(gmul(u,verr[i+def]));
      if(i>1) b=divii(b,d);
    }
  for(i=li-2;i>=1;i--)
    {
      for(j=i+1;j<li;j++)
	{
	  q=gdivent(coeff(w,i,j),coeff(w,i,i));w[j]=lsub(w[j],gmul(q,w[i]));
	  vlog[j+def]=lsub(vlog[j+def],gmul(q,vlog[i+def]));
	  verr[j+def]=ladd(verr[j+def],gabs(gmul(q,verr[i+def])));
	}
      if(avma<lim)
	{
	  tetpil=avma;w=gcopy(w);vlog=gcopy(vlog);verr=gcopy(verr);
	  dec=lpile(av,tetpil,0)>>2;w+=dec;vlog+=dec;verr+=dec;
	}
    }
  tetpil=avma;w=gcopy(w);vlog=gcopy(vlog);verr=gcopy(verr);
  dec=lpile(av,tetpil,0)>>2;w+=dec;vlog+=dec;verr+=dec;
  *wlog=vlog;*werr=verr;return w;
}


GEN comprealform3(x,y,D,isqrtD,sens)
     GEN x,y,D,isqrtD;
     long sens;
{
  long av,tetpil;
  GEN s,n,d,d1,x1,x2,y1,y2,v1,v2,b3,c3,m,z,p1,r;
  
  av=avma;s=shifti(addii(x[2],y[2]),-1);n=subii(y[2],s);
  d=bezout(y[1],x[1],&y1,&x1);d1=bezout(s,d,&x2,&y2);
  v1=divii(x[1],d1);v2=divii(y[1],d1);
  m=addii(mulii(mulii(y1,y2),n),mulii(y[3],x2));setsigne(m,-signe(m));
  r=modii(m,v1);b3=shifti((p1=mulii(v2,r)),1);
  c3=addii(mulii(y[3],d1),mulii(r,addii(y[2],p1)));
  z=cgetg(4,17);z[1]=lmulii(v1,v2);z[2]=laddii(y[2],b3);z[3]=ldivii(c3,v1);
  tetpil=avma;return gerepile(av,tetpil,redrealform3(z,D,isqrtD,sens));
}

GEN comprealform5(x,y,pterr,D,isqrtD,sqrtD,sens)
     GEN x,y,D,isqrtD,sqrtD;
     long *pterr,sens;
{
  long av,tetpil,ss;
  GEN s,n,d,d1,x1,x2,y1,y2,v1,v2,b3,c3,m,z,p1,r;
  
  av=avma;s=shifti(addii(x[2],y[2]),-1);n=subii(y[2],s);
  d=bezout(y[1],x[1],&y1,&x1);d1=bezout(s,d,&x2,&y2);
  v1=divii(x[1],d1);v2=divii(y[1],d1);
  m=addii(mulii(mulii(y1,y2),n),mulii(y[3],x2));setsigne(m,-signe(m));
  r=modii(m,v1);b3=shifti((p1=mulii(v2,r)),1);
  c3=addii(mulii(y[3],d1),mulii(r,addii(y[2],p1)));
  z=cgetg(6,17);z[1]=lmulii(v1,v2);z[2]=laddii(y[2],b3);z[3]=ldivii(c3,v1);
  z[5]=lmulrr(x[5],y[5]);(*pterr)++;
  if((ss=expo(z[5]))>=EXP220) {z[4]=laddii(addsi(1,x[4]),y[4]);setexpo(z[5],ss-EXP220);}
  else z[4]=laddii(x[4],y[4]);
  tetpil=avma;return gerepile(av,tetpil,redrealform5(z,pterr,D,isqrtD,sqrtD,sens));
}

GEN sqrealform3(x,D,isqrtD,sens)
     GEN x,D,isqrtD;
     long sens;
{
  long av,tetpil;
  GEN d1,x2,y2,v1,b3,c3,m,z,p1,r;
  
  av=avma;
  d1=bezout(x[2],x[1],&x2,&y2);v1=divii(x[1],d1);
  m=mulii(x[3],x2);setsigne(m,-signe(m));
  r=modii(m,v1);b3=shifti((p1=mulii(v1,r)),1);
  c3=addii(mulii(x[3],d1),mulii(r,addii(x[2],p1)));
  z=cgetg(4,17);z[1]=lmulii(v1,v1);z[2]=laddii(x[2],b3);z[3]=ldivii(c3,v1);
  tetpil=avma;return gerepile(av,tetpil,redrealform3(z,D,isqrtD,sens));
}

GEN sqrealform5(x,pterr,D,isqrtD,sqrtD,sens)
     GEN x,D,isqrtD,sqrtD;
     long *pterr,sens;
{
  long av,tetpil,ss;
  GEN d1,x2,y2,v1,b3,c3,m,z,p1,r;
  
  av=avma;
  d1=bezout(x[2],x[1],&x2,&y2);v1=divii(x[1],d1);
  m=mulii(x[3],x2);setsigne(m,-signe(m));
  r=modii(m,v1);b3=shifti((p1=mulii(v1,r)),1);
  c3=addii(mulii(x[3],d1),mulii(r,addii(x[2],p1)));
  z=cgetg(6,17);z[1]=lmulii(v1,v1);z[2]=laddii(x[2],b3);z[3]=ldivii(c3,v1);
  z[5]=lmulrr(x[5],x[5]);(*pterr)++;
  if((ss=expo(z[5]))>=EXP220) {z[4]=laddii(addsi(1,x[4]),x[4]);setexpo(z[5],ss-EXP220);}
  else z[4]=lshifti(x[4],1);
  tetpil=avma;return gerepile(av,tetpil,redrealform5(z,pterr,D,isqrtD,sqrtD,sens));
}

GEN rhorealform3(x,D,isqrtD)
     GEN x,D,isqrtD;
{
  long av,tetpil,s;
  GEN y,p1,nn;
  
  av=avma;y=cgetg(4,17);y[1]=lcopy(x[3]);
  s=signe(y[1]);setsigne(y[1],1);
  if(cmpii(isqrtD,y[1])>=0) nn=divii(addii(isqrtD,x[2]),p1=shifti(y[1],1));
  else nn=divii(addii(y[1],x[2]),p1=shifti(y[1],1));
  p1=mulii(nn,p1);y[2]=lsubii(p1,x[2]);
  setsigne(y[1],s);p1=shifti(subii(mulii(y[2],y[2]),D),-2);y[3]=ldivii(p1,y[1]);
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN rhorealform5(x,pterr,D,isqrtD,sqrtD)
     GEN x,D,isqrtD,sqrtD;
     long *pterr;
{
  long av,tetpil,s,ss;
  GEN y,p1,nn;
  
  av=avma;y=cgetg(6,17);y[1]=lcopy(x[3]);
  s=signe(y[1]);setsigne(y[1],1);
  if(cmpii(isqrtD,y[1])>=0) nn=divii(addii(isqrtD,x[2]),p1=shifti(y[1],1));
  else nn=divii(addii(y[1],x[2]),p1=shifti(y[1],1));
  p1=mulii(nn,p1);y[2]=lsubii(p1,x[2]);
  setsigne(y[1],s);p1=shifti(subii(mulii(y[2],y[2]),D),-2);y[3]=ldivii(p1,y[1]);
  y[5]=lmulrr(divrr(addir(x[2],sqrtD),subir(x[2],sqrtD)),x[5]);(*pterr)++;
  if((ss=expo(y[5]))>=EXP220) {y[4]=laddsi(1,x[4]);y[5]=lshiftr(y[5],-EXP220);}
  else y[4]=x[4];
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN redrealform3(x,D,isqrtD,sens)
     GEN x,D,isqrtD;
     long sens;
{
  long fl,av=avma,tetpil;
  GEN y,p1;
  
  y=cgetg(4,17);y[1]=x[1];y[2]=x[2];y[3]=x[3];
  if((signe(x[2])<=0)||(cmpii(x[2],isqrtD)>0)) fl=1;
  else
    {
      p1=subii(isqrtD,shifti(absi(x[1]),1));
      if(signe(p1)<0) fl=(cmpii(x[2],absi(p1))<0);else fl=(cmpii(x[2],p1)<=0);
    }
  while(fl)
    {
      y=rhorealform3(y,D,isqrtD);
      if((signe(y[2])<=0)||(cmpii(y[2],isqrtD)>0)) fl=1;
      else
	{
	  p1=subii(isqrtD,shifti(absi(y[1]),1));
	  if(signe(p1)<0) fl=(cmpii(y[2],absi(p1))<0);else fl=(cmpii(y[2],p1)<=0);
	}
    }
  if(signe(y[1])<0)
    {
      if(sens||(!signe(addii(y[1],y[3]))))
	{tetpil=avma;return gerepile(av,tetpil,rhorealform3(y,D,isqrtD));}
      else
	{
	  tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
	  setsigne(y[1],1);setsigne(y[3],-1);return y;
	}
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN redrealform5(x,pterr,D,isqrtD,sqrtD,sens)
     GEN x,D,isqrtD,sqrtD;
     long *pterr,sens;
{
  long fl,av=avma,tetpil;
  GEN y,p1;
  
  y=cgetg(6,17);y[1]=x[1];y[2]=x[2];y[3]=x[3];y[4]=x[4];y[5]=x[5];
  if((signe(x[2])<=0)||(cmpii(x[2],isqrtD)>0)) fl=1;
  else
    {
      p1=subii(isqrtD,shifti(absi(x[1]),1));
      if(signe(p1)<0) fl=(cmpii(x[2],absi(p1))<0);else fl=(cmpii(x[2],p1)<=0);
    }
  while(fl)
    {
      y=rhorealform5(y,pterr,D,isqrtD,sqrtD);
      if((signe(y[2])<=0)||(cmpii(y[2],isqrtD)>0)) fl=1;
      else
	{
	  p1=subii(isqrtD,shifti(absi(y[1]),1));
	  if(signe(p1)<0) fl=(cmpii(y[2],absi(p1))<0);else fl=(cmpii(y[2],p1)<=0);
	}
    }
  if(signe(y[1])<0)
    {
      if(sens||(!signe(addii(y[1],y[3]))))
	{tetpil=avma;return gerepile(av,tetpil,rhorealform5(y,pterr,D,isqrtD,sqrtD));}
      else
	{
	  tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
	  setsigne(y[1],1);setsigne(y[3],-1);return y;
	}
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN redrealform(x,pterr,D,isqrtD,sqrtD,sens,precreg)
     GEN x,D,isqrtD,sqrtD;
     long *pterr,sens,precreg;
{
  long fl,av=avma,tetpil;
  GEN y,p1;
  
  y=cgetg(6,17);y[1]=x[1];y[2]=x[2];y[3]=x[3];y[4]=zero;affsr(1,y[5]=lgetr(precreg));
  if((signe(x[2])<=0)||(cmpii(x[2],isqrtD)>0)) fl=1;
  else
    {
      p1=subii(isqrtD,shifti(absi(x[1]),1));
      if(signe(p1)<0) fl=(cmpii(x[2],absi(p1))<0);else fl=(cmpii(x[2],p1)<=0);
    }
  while(fl)
    {
      y=rhorealform5(y,pterr,D,isqrtD,sqrtD);
      if((signe(y[2])<=0)||(cmpii(y[2],isqrtD)>0)) fl=1;
      else
	{
	  p1=subii(isqrtD,shifti(absi(y[1]),1));
	  if(signe(p1)<0) fl=(cmpii(y[2],absi(p1))<0);else fl=(cmpii(y[2],p1)<=0);
	}
    }
  if(signe(y[1])<0)
    {
      if(sens||(!signe(addii(y[1],y[3]))))
	{tetpil=avma;return gerepile(av,tetpil,rhorealform5(y,pterr,D,isqrtD,sqrtD));}
      else
	{
	  tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
	  setsigne(y[1],1);setsigne(y[3],-1);return y;
	}
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN powrealform5(x,n,D,isqrtD,sqrtD,sens,precreg)
     GEN x,D,isqrtD,sqrtD;
     long n,sens,precreg;
{
  GEN y,p1;
  long av,tetpil,fl,toto=0;

  if(!n)
    {
      y=cgetg(6,17);y[1]=un;
      if(mpodd(x[2])) y[2]=(mpodd(isqrtD)) ? lcopy(isqrtD) : laddsi(-1,isqrtD);
      else {y[2]=lcopy(isqrtD);(((GEN)y[2])[lgef(isqrtD)-1])&=0xfffffffe;}
      av=avma;p1=subii(mulii(y[2],y[2]),D);tetpil=avma;
      y[3]=lpile(av,tetpil,shifti(p1,-2));y[4]=zero;affsr(1,y[5]=lgetr(precreg));
      return y;
    }
  if(n<0)
    {
      p1=cgetg(6,17);p1[1]=x[1];p1[2]=lnegi(x[2]);p1[3]=x[3];
      p1[4]=lnegi(addsi(1,x[4]));p1[5]=lshiftr(divir(un,x[5]),EXP220);n= -n;x=p1;
    }
  if(n==1) 
    {tetpil=avma;return gerepile(av,tetpil,redrealform(x,&toto,D,isqrtD,sqrtD,sens,precreg));}
  for(fl=0;n>1;n>>=1)
    {
      if(n&1)
	{if(fl) y=comprealform5(y,x,&toto,D,isqrtD,sqrtD,sens);else {fl=1;y=x;}}
      x=sqrealform5(x,&toto,D,isqrtD,sqrtD,sens);
    }
  tetpil=avma;y=fl ? comprealform5(y,x,&toto,D,isqrtD,sqrtD,sens) : gcopy(x);
  return gerepile(av,tetpil,y);
}

GEN initializeform3(ex,tabform,cardtab,d,isqrtd,sens)
     long *ex,cardtab,sens;
     GEN **tabform,d,isqrtd;
{
  long av,tetpil,i;
  GEN form;

  av=avma;form=tabform[1][ex[1]];
  for(i=2;i<=cardtab;i++)
    {form=comprealform3(form,tabform[i][ex[i]],d,isqrtd,sens);}
  tetpil=avma;
  return gerepile(av,tetpil,gcopy(form));
}

GEN initializeform5(ex,tabform,cardtab,pterr,d,isqrtd,sqrtd,sens)
     long *ex,cardtab,*pterr,sens;
     GEN **tabform,d,isqrtd,sqrtd;
{
  long av,tetpil,i;
  GEN form;

  av=avma;form=tabform[1][ex[1]];
  for(i=2;i<=cardtab;i++)
    {form=comprealform5(form,tabform[i][ex[i]],pterr,d,isqrtd,sqrtd,sens);}
  tetpil=avma;
  return gerepile(av,tetpil,gcopy(form));
}

void addcolumnmat(mat,s,cardsub,numbase,subbase,ex,nbprimfact,primfact,expoprimfact,form1,log2precis,nbrederr,errglob,vecexpo,vecerr)
     long **mat,s,cardsub,*numbase,*subbase,*ex,nbprimfact,*primfact,*expoprimfact,nbrederr;
     GEN form1,log2precis,errglob,vecexpo,vecerr;
{
  long i,j,pp,b,ep;

  for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]= -ex[i];
  for(j=1;j<=nbprimfact;j++)
    {
      pp=primfact[j];ep=expoprimfact[j];b=itos(modis(form1[2],(pp<<1)));
      if(b>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
    }
  affrr(shiftr(mpadd(mulir(mulsi(EXP220,form1[4]),log2precis),
		     mplog(absr(form1[5]))),-1),vecexpo[s]);
  mulsrz(nbrederr,errglob,vecerr[s]);
}

void addcolumnmat1(mat,s,cardsub,numbase,subbase,ex,nbprimfact1,primfact1,expoprimfact1,form1,fpd,nbprimfact,primfact,expoprimfact,form2,log2precis,nbrederr,errglob,vecexpo,vecerr)
     long **mat,s,cardsub,*numbase,*subbase,*ex,nbprimfact1,*primfact1,*expoprimfact1;
     long *fpd,nbprimfact,*primfact,*expoprimfact,nbrederr;
     GEN form1,form2,log2precis,errglob,vecexpo,vecerr;
{
  long i,j,pp,b1,ep;

  for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]=fpd[i+1]-ex[i];
  for(j=1;j<=nbprimfact;j++)
    {
      pp=primfact[j];ep=expoprimfact[j];b1=itos(modis(form2[2],(pp<<1)));
      if(b1>pp) ep= -ep;mat[s][numbase[pp]]-=ep;
    }
  for(j=1;j<=nbprimfact1;j++)
    {
      pp=primfact1[j];ep=expoprimfact1[j];b1=itos(modis(form1[2],(pp<<1)));
      if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
    }
  affrr(shiftr(mpadd(mulir(mulsi(EXP220,subii(form1[4],form2[4])),log2precis),
		     mplog(absr(divrr(form1[5],form2[5])))),-1),vecexpo[s]);
  mulsrz(nbrederr,errglob,vecerr[s]);
}

void addcolumnmat2(mat,s,cardsub,numbase,subbase,ex,nbprimfact1,primfact1,expoprimfact1,form1,fpd,nbprimfact,primfact,expoprimfact,form2,log2precis,nbrederr,errglob,vecexpo,vecerr)
     long **mat,s,cardsub,*numbase,*subbase,*ex,nbprimfact1,*primfact1,*expoprimfact1;
     long *fpd,nbprimfact,*primfact,*expoprimfact,nbrederr;
     GEN form1,form2,log2precis,errglob,vecexpo,vecerr;
{
  long i,j,pp,b1,ep;

  for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]=-fpd[i+1]-ex[i];
  for(j=1;j<=nbprimfact;j++)
    {
      pp=primfact[j];ep=expoprimfact[j];b1=itos(modis(form2[2],(pp<<1)));
      if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
    }
  for(j=1;j<=nbprimfact1;j++)
    {
      pp=primfact1[j];ep=expoprimfact1[j];b1=itos(modis(form1[2],(pp<<1)));
      if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
    }
  affrr(shiftr(mpadd(mulir(mulsi(EXP220,addii(form1[4],form2[4])),log2precis),
		     mplog(absr(mulrr(form1[5],form2[5])))),-1),vecexpo[s]);
  mulsrz(nbrederr,errglob,vecerr[s]);
}

void initbuchreal(D,cbach,cbach2,precreg,log2precis,qqq,dr,drc,logd,sqrtD,isqrtD,lim,errglob,limc,limbach,prec)
     long *precreg,*qqq,*limc,*limbach,prec;
     double cbach,cbach2,*drc,*logd,*lim;
     GEN D,*log2precis,*dr,*sqrtD,*isqrtD,*errglob;
{
  long cp,*pro,p2,*p1,i,j;
	 
  /* precision en digits decimaux=(#digits decimaux de D)+50 */
  /* ici CBUCH=15,q=27 */
  /* on prendra les p decomposes tels que prod(p)>lim dans la subbase */
  /* initialisation de erreur */
  /* limc=Max(c.(log(D))^2,exp((1/8).sqrt(log(D).loglog(D)))) */
  /* limbach=Max(6.(log(D))^2,exp((1/8).sqrt(log(D).loglog(D)))) */
  /* subbase contient les p decomposes tels que prod(p)>sqrt(D) */
  /* cardsubbase=cardsub=subbase[0]=#subbase; */
  /* tabprform est la table des form[p] pour p dans subbase */
  /* nbram est le nombre de p divisant D elimines dans subbase */
  /* tabpowprform est la table des puissances des formes dans tabprform */

  *precreg=max(prec,(gexpo(D)>>5)+5);
  *log2precis=glog(gdeux,*precreg);
  (*qqq)=31-(long)ceil(log((double)CBUCH)/log(2.0));
  *dr=cgetr(3);affir(D,*dr);
  *drc=rtodbl(*dr);
  *logd=log(*drc);
  *sqrtD=gsqrt(D,*precreg);
  *isqrtD=gfloor(*sqrtD);
  *lim=sqrt(*drc);
  affsr(1,(*errglob)=cgetr(4));setexpo(*errglob,-(((*precreg)-2)<<5));
  (*limc)=max(cbach*(*logd)*(*logd),13);
  cp=exp(sqrt((*logd)*log((*logd))/8.0));
  if(cp>(*limc)) *limc=cp;
  (*limbach)=cbach2*(*logd)*(*logd);if((*limc)>(*limbach)) *limbach=*limc;
}

#define LIMP 30000

GEN lfunc(D)
     GEN D;
{
  GEN y;
  long av=avma,tetpil,prime=0;
  byteptr p=diffptr;
  
  prime=*p++;affsr(1,y=cgetr(4));
  do
    {
      if(!*p) err(recprimer);
      y=mulsr(prime,divrs(y,prime-krogs(D,prime)));
      prime+=*p++;
    }
  while(prime<=LIMP);
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN buchall(P,gcbach,gcbach2,gRELSUP,flun,prec)
     GEN P,gcbach,gcbach2,gRELSUP;
     long flun,prec;
{
  long i,j,k,l,ii,ee,nn,ss,lon1,lgsub,n1,cp,av,tetpil,*pro,p2,de,*p1,*ex,q,s,nbtest,mm,lon,av3;
  long N,R1,R2,RU,CO,PRECREG,LIMC,LIMC2,lim,blim,KC,KC2,KCZ,KCZ2,KCCO;
  long ip,nbcol3,nbrow3,ran,c,ic,jc,lo,extrarel;
  long **mat;
  long limhash=0,fpc;
  long expoprimfact[500],primfact[500],*numprim,*prim,*numideal,*indicesubfb;
  double cbach,cbach2,drc,mr,LOGD;
  GEN pgen1,pgen2,pgen3,pgen4,pgen5,dr,prid,ideal,prod,pzk,**vp,*idealbase,matarch,exu,fu,zu;
  GEN nf,DP,D,F,BINV,gex,primsubfactorbase,vectbase;
  GEN matgen,matpro,xarch,xreal,vei,p3,met,mot,mit,detmat,reg,mdet,lfun,z,clh;
  GEN RES;

  av=avma;RES=flun?cgetg(11,17):cgetg(8,17);
  if(typ(gRELSUP)!=1) gRELSUP=gtrunc(gRELSUP);
  if(gsigne(gRELSUP)<=0) err("not enough relations in buchgen");
  N=lgef(P)-3;
  if(N<=1)
    {
      z=cgetg(2,19);z[1]=(long)RES;
      RES[1]=(long)polx[0];pgen1=cgetg(3,17);RES[2]=(long)pgen1;pgen1[1]=un;
      pgen1[2]=zero;pgen1=cgetg(3,17);RES[3]=(long)pgen1;pgen1[1]=un;pgen1[2]=un;
      pgen1=cgetg(2,17);RES[4]=(long)pgen1;pgen1[1]=un;
      pgen1=cgetg(3,17);RES[5]=(long)pgen1;pgen1[1]=un;pgen1[2]=lgetg(1,17);
      RES[6]=un;RES[7]=un;
      if(flun)
	{
	  pgen1=cgetg(3,17);RES[8]=(long)pgen1;
	  pgen1[1]=deux;pgen1[2]=lneg(gun);
	  RES[9]=lgetg(1,19);RES[10]=lstoi(EXP220);
	}
      return z;
    }
  pgen1=factor(P);pgen2=(GEN)pgen1[1];pgen3=(GEN)pgen1[2];
  if((lg(pgen2)>2)||(cmpis(pgen3[1],1)>0)) 
    err(talker,"reducible polynomial in buchgen");
  nf=initalg(P,max(8,prec));
  RES[1]=nf[1];RES[2]=nf[2];pgen1=cgetg(3,17);RES[3]=(long)pgen1;pgen1[1]=nf[3];pgen1[2]=nf[4];
  R1=itos(((GEN)nf[2])[1]);R2=(N-R1)/2;RU=R1+R2;
  F=(GEN)nf[4];D=(GEN)nf[3];RES[4]=nf[7];
  BINV=(GEN)nf[8];
  cbach=gtodouble(gcbach);cbach2=gtodouble(gcbach2);CO=itos(gRELSUP);
  CO+=(RU-1);
  PRECREG=max(prec,(gexpo(D)>>5)+N+3);
  dr=cgetr(3);affir(D,dr);drc=rtodbl(dr);
  LOGD=log(fabs(drc));mr=LOGD*log(LOGD);
  lim=exp(-(N+0.))*sqrt(2*PI*N*fabs(drc))*pow(4/PI,R2+0.);
  LIMC=cbach*LOGD*LOGD;cp=exp(sqrt(mr/8.0));
  if(cp>LIMC) LIMC=cp;LIMC2=cbach2*LOGD*LOGD;if(LIMC>LIMC2) LIMC2=LIMC;
  primsubfactorbase=subfactorbasegen(nf,lim,&blim,LIMC2);
  if(blim>LIMC) LIMC=blim;if(LIMC>LIMC2) LIMC2=LIMC;
  lgsub=lg(primsubfactorbase);
  vp=powsubfactgen(nf,primsubfactorbase,CBUCH+1,PRECREG);
  KC2=factorbasegen(nf,LIMC2,LIMC,&numprim,&prim,&numideal,&idealbase,&KC,&KCZ,&KCZ2,&lfun);
  indicesubfb=calcindice(primsubfactorbase,numprim,numideal,idealbase);
  KCCO=KC+CO;mat=(long **)malloc(4*(KCCO+1));matarch=cgetg(KCCO+1,19);
  vectbase=cgetg(KC+1,18);
  for(i=1;i<=KCZ;i++) 
    {
      ip=numideal[prim[i]];pgen1=idealbase[i];n1=lg(pgen1);
      for(j=1;j<n1;j++) vectbase[ip+j]=pgen1[j];
    }
  for(i=1;i<=KCCO;i++)
    {
      p1=(long *)malloc(4*(KC+1));mat[i]=p1;
      for(j=1;j<=KC;j++) p1[j]=0;
      pgen1=cgetg(RU+1,18);matarch[i]=(long)pgen1;
      for(j=1;j<=RU;j++) 
	{
	  pgen2=cgetg(3,6);pgen1[j]=(long)pgen2;
	  pgen2[1]=lgetr(PRECREG);pgen2[2]=lgetr(PRECREG);
	}
    }
  ex=(long*)malloc(lgsub<<2);exu=cgetg(RU+1,17);
  q=31-(long)ceil(log((double)CBUCH)/log(2.0));
  s=0;
  for(i=1;i<=KCZ;i++)
    {
      ip=numideal[prim[i]];pgen1=idealbase[i];
      n1=lg(pgen1);k=0;
      for(j=1;j<n1;j++) k+=(itos(((GEN)pgen1[j])[3])*itos(((GEN)pgen1[j])[4]));
      if(k==N)
	{
	  s++;for(j=1;j<n1;j++) mat[s][ip+j]=itos(((GEN)pgen1[j])[3]);
	  for(j=1;j<=RU;j++) gaffsg(0,((GEN)matarch[s])[j]);
	}
    }
  nbtest=ss=s;
/*  printf("%ld relations triviales\n",s); */
  for(i=1;i<=ss;i++)
    {
      for(j=1;j<=KCZ;j++)
	{
	  ip=numideal[prim[j]];
	  if(mat[i][ip+1])
	    {
	      nn=lg(idealbase[j])-1;k=1;while((k<=nn)&&((ee=mat[i][ip+k])<=1)) k++;
	      if(k<=nn)
		{
		LAB1:
		  for(l=1;l<lgsub;l++) ex[l]=rand()>>q;av3=avma;ideal=vp[1][0];
		  for(l=1;l<=RU;l++) exu[l]=lstoi((rand()>>q)+1);
		  for (l=1;l<lgsub;l++) ideal=idealmulh(nf,ideal,vp[l][ex[l]]);
		  nbtest++;
		  ideal=ideallllred(nf,idealmulprime(nf,ideal,((GEN)(idealbase[j]))[k]),exu,PRECREG);
		  fpc=factorisegen(nf,ideal[1],KCZ,LIMC,primfact,expoprimfact,prim,idealbase,numideal,numprim,limhash);
		  if (fpc)
		    {
		      for(l=1;l<=primfact[0];l++)
			{
			  if(primfact[l]==ip+k)
			    {
			      if(itos(mppgcd(stoi(ee),stoi(expoprimfact[l]-1)))==1)
				{
				  expoprimfact[l]-=1;s++;for(ii=1;ii<lgsub;ii++) mat[s][indicesubfb[ii]]= -ex[ii];
				  for(ii=1;ii<=primfact[0];ii++) mat[s][primfact[ii]]+=expoprimfact[ii];
				  for(ii=1;ii<=RU;ii++) gaffect(((GEN)ideal[2])[ii],((GEN)matarch[s])[ii]);
				  avma=av3;l=primfact[0]+2;
				}
			      else {avma=av3;goto LAB1;}
			    }
			}
		      if(l==(primfact[0]+1))
			{
			  s++;mat[s][ip+k]= -1;for(ii=1;ii<lgsub;ii++) mat[s][indicesubfb[ii]]= -ex[ii];
			  for(ii=1;ii<=primfact[0];ii++) mat[s][primfact[ii]]+=expoprimfact[ii];
			  for(ii=1;ii<=RU;ii++) gaffect(((GEN)ideal[2])[ii],((GEN)matarch[s])[ii]);avma=av3;
			}
		    }
		  else {avma=av3;goto LAB1;}
		}
	    }
	}
    }
/*  pgen1=(GEN)minim(((GEN)nf[5])[3],(long)(N*pow(((double)LIMC)*LIMC,(double)(2./N))),-max(4*KCCO,1))[3]; */
  pgen1=cgetg(1,17);
  pgen3=idmat(N);
  for(k=1;(s<KCCO)&&(k<lg(pgen1));k++)
    {
      av3=avma;
      pgen2=(GEN)pgen1[k];
      j=N;while((j>=2)&&(!signe(pgen2[j]))) --j;
      if(j>1)
	{
	  pgen4=cgetg(N+1,19);
	  for(i=1;i<=N;i++) pgen4[i]=(long)element_mulh(nf,j,i,pgen2,pgen3[i]);
	  pgen5=content(pgen4);if(!gcmp1(pgen5)) pgen4=gdiv(pgen4,pgen5);
	  ideal=cgetg(3,17);ideal[1]=(long)hnf(pgen4);
	  pgen5=gmul(((GEN)nf[5])[1],pgen2);
	  pgen4=cgetg(RU+1,17);ideal[2]=(long)pgen4;
	  for(i=1;i<=R1;i++) pgen4[i]=(long)glog(pgen5[i],PRECREG);
	  for(i=R1+1;i<=RU;i++) pgen4[i]=lmul2n(glog(pgen5[i],PRECREG),1);
	  fpc=factorisegen(nf,ideal[1],KCZ,LIMC,primfact,expoprimfact,prim,idealbase,numideal,numprim,limhash);
	  nbtest++;
	  if (fpc)
	    {
	      s++;
	      for(j=1;j<=primfact[0];j++) mat[s][primfact[j]]=expoprimfact[j];
	      for(j=1;j<=RU;j++) gaffect(((GEN)ideal[2])[j],((GEN)matarch[s])[j]);
	    }
	}
      avma=av3;
    }
/*  printf("%ld relations sur %ld deja trouvees\n",s,KCCO);fflush(stdout); */
/*  for(i=1;i<=KC;i++) {for(j=1;j<=s;j++) printf(" %ld",mat[j][i]);printf("\n");} */
  while(s<KCCO)
    {
      for(i=1;i<lgsub;i++) ex[i]=rand()>>q;
      for(l=1;l<=RU;l++) exu[l]=lstoi((rand()>>q)+1);
      av3=avma;ideal=vp[1][0];
      for (l=1;l<lgsub;l++) ideal=idealmulh(nf,ideal,vp[l][ex[l]]);
      ideal=ideallllred(nf,ideal,exu,PRECREG);
      fpc=factorisegen(nf,ideal[1],KCZ,LIMC,primfact,expoprimfact,prim,idealbase,numideal,numprim,limhash);
      nbtest++;
      if (fpc)
	{
	  s++;
	  for(i=1;i<lgsub;i++) mat[s][indicesubfb[i]]= -ex[i];
	  for(j=1;j<=primfact[0];j++) mat[s][primfact[j]]+=expoprimfact[j];
	  for(j=1;j<=RU;j++) gaffect(((GEN)ideal[2])[j],((GEN)matarch[s])[j]);
	}
      avma=av3;
    }
/*  nbcol3=lg(matarch)-1;nbrow3=lg(vectbase)-1;
  matgen=cgetg(nbcol3+1,19);
  for(i=1;i<=nbcol3;i++) matgen[i]=lgetg(nbrow3+1,18);
  for(i=1;i<=nbcol3;i++)
    for(j=1;j<=nbrow3;j++) ((GEN)(matgen[i]))[j]=lstoi(mat[i][j]);
  outbeaut(matgen); */

  hphasegen1(mat,matarch,vectbase);
  hphasegen2(mat,matarch,vectbase);
  nbcol3=lg(matarch)-1;nbrow3=lg(vectbase)-1;
  matgen=cgetg(nbcol3+1,19);
  for(i=1;i<=nbcol3;i++) matgen[i]=lgetg(nbrow3+1,18);
  for(i=1;i<=nbcol3;i++)
    for(j=1;j<=nbrow3;j++) ((GEN)(matgen[i]))[j]=lstoi(mat[i][j]);
  detmat=absi(rangi(matgen,&ran));
  if(ran<nbrow3) 
    {
      matgen=gtrans(matgen);matgen=gtrans(gmul(matgen,lllkerim(matgen)[2]));
      detmat=absi(rangi(matgen,&ran));
      nbrow3=ran;
    }
  matpro=lllall0(matgen,1);/* matpro=gmul(matpro,lllint(matpro)); */
  xarch=gmul(matarch,matpro);xreal=greal(xarch);
  vei=cgetg(RU+1,18);for(i=1;i<=RU;i++) vei[i]=(i<=R1)?un:deux;
  mit=hnfarch(matgen,vectbase,detmat);
  mdet=cgetg(RU+1,19);for(j=1;j<RU;j++) mdet[j]=xreal[j];mdet[RU]=(long)vei;
  reg=detreel(mdet);extrarel=nbcol3-nbrow3;
  for(i=2;i<=extrarel-RU+2;i++)
    {
      for(j=1;j<RU;j++) mdet[j]=xreal[j+i-1];
      reg=gcdrealnoer(reg,detreel(mdet));
    }
  reg=gabs(gdivgs(reg,N));p1=gun;
  for(i=1;i<=nbrow3;i++)
    {p3=(GEN)coeff(mit,i,i);if(signe(p3)) p1=mulii(p1,p3);}
  fflush(stdout);clh=p1;
  c=0;for(i=1;i<=nbrow3;i++) if(!gcmp1(coeff(mit,i,i))) c++;
  if(!c) met=idmat(1);
  else
    {
      met=cgetg(c+1,19);ic=0;
      for(i=1;i<=nbrow3;i++)
	{
	  if(!gcmp1(coeff(mit,i,i)))
	    {
	      ic++;p1=cgetg(c+1,18);met[ic]=(long)p1;jc=0;
	      for(j=1;j<=nbrow3;j++){if(!gcmp1(coeff(mit,j,j))){jc++;p1[jc]=coeff(mit,j,i);}}
	    }
	}
    }
  met=smith(met);
  setlg(vectbase,KC+1);setlg(matarch,KCCO+1);
  lo=lg(met)-1;
  c=0;for(i=1;i<=lo;i++) if(!gcmp1(met[i])) c++;
  mot=cgetg(c+1,17);for(i=1;i<=c;i++) mot[i]=met[i];
  pgen1=cgetg(3,17);RES[5]=(long)pgen1;pgen1[1]=(long)clh;pgen1[2]=(long)mot;RES[6]=(long)reg;
  z=gmul(gmul(gmul(gpuigs(gdeux,-R1),gpuigs(gmul2n(mppi(5),1),-R2)),gsqrt(gabs(D),5)),lfun);
  zu=rootsof1(nf);
  z=gdiv(gmul(reg,clh),gmul((GEN)zu[1],z));
  RES[7]=(long)z;
  if(flun)
    {
      pgen1=cgetg(3,17);RES[8]=(long)pgen1;
      pgen1[1]=zu[1];pgen1[2]=lmul(nf[7],zu[2]);
      fu=getfu(nf,xarch,reg,mdet,&c,PRECREG);
      if(lg(fu)>1)
	{
	  p1=gmul(nf[7],fu);
	  for(j=1;j<lg(fu);j++) 
	    if(!gcmp1(gabs(gnorm(gmodulcp(p1[j],nf[1])))))
	      err(talker,"fundamental units too large, use buchgennou");
	}
      else c=0;
      if(c) RES[9]=lmul(nf[7],fu);else RES[9]=(long)fu;RES[10]=lstoi(c);
    }
  for(i=1;i<lg(primsubfactorbase);i++) free(vp[i]);free(vp);
  free(numprim);free(prim);free(numideal);free(idealbase);free(indicesubfb);
  free(ex);for(i=1;i<=KCCO;i++) free(mat[i]);free(mat);
  tetpil=avma;z=cgetg(2,19);z[1]=lcopy(RES);return gerepile(av,tetpil,z);
}

GEN buchgen(P,gcbach,gcbach2,gRELSUP,prec)
     GEN P,gcbach,gcbach2,gRELSUP;
     long prec;
{
  return buchall(P,gcbach,gcbach2,gRELSUP,1,prec);
}

GEN buchgennou(P,gcbach,gcbach2,gRELSUP,prec)
     GEN P,gcbach,gcbach2,gRELSUP;
     long prec;
{
  return buchall(P,gcbach,gcbach2,gRELSUP,0,prec);
}

/*Calcul de la base des sous-facteurs pour generer les relations entre ideaux : m est le nombre
d'ideaux premiers utilises ; on ne considere que les nombres premiers ne divisant pas
l'index F, et sur chaque premier, on prend tous les ideaux non inertes sauf 1.
Rend le tableau primsubfactorbase[] et sa longueur. */

GEN subfactorbasegen(nf,m,bm,n2)
     GEN nf;
     long m,*bm,n2;
{
  byteptr delta=diffptr;
  long av1=avma,tetpil,i,j,nbidp,pp,N=lgef(nf[1])-3,bigm=1;
  double prod=1.0;
  GEN pgen1,pgen2,pgen3,y,y1;

  y=cgetg(100*N+1,18);
  pp=0;nbidp=0;n2=min(n2,m);
  for(pp+=*delta++;(pp<=m)||(!nbidp);pp+=*delta++)
    {
      if(signe(modis(nf[3],pp)))
	 {
	   pgen1=primedec(nf,stoi(pp));
	   for(j=1;j<lg(pgen1)-1;j++)
	     {
	       pgen2=(GEN)pgen1[j];
	       if((cmpis(pgen3=gpui(stoi(pp),pgen2[4]),n2)<=0)||(!nbidp))
		 {
		   prod*=gtodouble(pgen3);y[++nbidp]=(long)pgen2;
		   if(cmpis(pgen3,bigm)>0) bigm=itos(pgen3);
		   if(prod>m) goto label1;
		 }
	     }
	 }
    }
 label1:
  tetpil=avma;*bm=bigm;
  y1=cgetg(nbidp+1,18);for(i=1;i<=nbidp;i++) y1[i]=lcopy(y[i]);
  return gerepile(av1,tetpil,y1);
}

/*Calcul la table des puissances des ideaux premiers de la base des sous-facteurs ;
w est la base des sous-facteurs, a est l'exposant maximum calcule : 
renvoie une matrice x de GEN , x[j][i] contenant
l'ideal (P_i)^j, sous forme HNF */

GEN **powsubfactgen(nf,w,a,PRECREG)
     GEN nf,w;
     long a,PRECREG;
{
  long i,j,n=lg(w)-1,N=lgef(nf[1])-3,R1,R2,RU;
  GEN **x,pgen1,id;

  R1=itos(((GEN)nf[2])[1]);R2=(N-R1)/2;RU=R1+R2;
  x=(GEN**)malloc(4*(n+1));
  for(i=1;i<=n;i++) x[i]=(GEN*)malloc(4*(a+1));
  id=cgetg(3,17);id[1]=(long)idmat(N);pgen1=cgetg(RU+1,17);
  id[2]=(long)pgen1;for(i=1;i<=RU;i++) pgen1[i]=zero;
  for(i=1;i<=n;i++) 
    {
      x[i][0]=id;
      for(j=1;j<=a;j++) 
	x[i][j]=(j==1)?idealmulprime(nf,id,w[i],PRECREG):idealmulprimered(nf,x[i][j-1],w[i],PRECREG);
    }
  return x;
}

GEN **newpowsubfactgen(nf,w,a,PRECREG)
     GEN nf,w;
     long a,PRECREG;
{
  long i,j,n=lg(w)-1,N=lgef(nf[1])-3,R1,R2,RU;
  GEN **x,pgen1,pgen2,pgen3,pgen4,pgen5,pgen6,id;

  R1=itos(((GEN)nf[2])[1]);R2=(N-R1)/2;RU=R1+R2;
  x=(GEN**)malloc(4*(n+1));
  for(i=1;i<=n;i++) x[i]=(GEN*)malloc(4*(a+1));
  id=cgetg(3,17);id[1]=(long)idmat(N);pgen1=cgetg(RU+1,17);
  id[2]=(long)pgen1;for(i=1;i<=RU;i++) pgen1[i]=zero;
  for(i=1;i<=n;i++) 
    {
      x[i][0]=id;
      pgen1=(GEN)w[i];x[i][1]=idealmulprime(nf,id,pgen1,PRECREG);
      pgen2=cgetg(6,17);pgen2[1]=pgen1[1];pgen2[2]=pgen1[5];pgen2[5]=pgen1[2];
      pgen2[3]=pgen2[4]=un;pgen4=x[i][1];
      pgen5=idealmulprime(nf,x[i][0],pgen2);
      pgen6=(GEN)pgen1[1];
      for(j=2;j<=a;j++)
	{
	  pgen4=idealmulprime(nf,pgen4,pgen1,PRECREG);
	  pgen5=idealmulprime(nf,pgen5,pgen2,PRECREG);
	  pgen6=mulii(pgen6,pgen1[1]);
	  pgen3=minideal(nf,pgen5,zero,2*PRECREG);
	  x[i][j]=idealmul(nf,pgen3,pgen4);x[i][j][1]=ldiv(x[i][j][1],pgen6);
	}
    }
  return x;
}

/*Calcul de la base de facteurs : n2 est la borne pour les nombres premiers qui vont
etre testes pour obtenir toutes les relations et la norme des ideaux choisis,
n est la borne des nombres premiers qui vont etre testes pour les relations primaires
(constante de Bach).
Cette fonction cree et affecte un certain nombre de variables :
numprimfactorbase[i] est l'indice k tel que primfactorbase[k]=i (si i n'est pas premier,
numprimfactorbase[i]=0), ; primfactorbase[i] contient le i-eme nombre premier utilise
pour construire la base de facteurs ; numideal[i] est l'indice k tel que
idealbase[k]=i ; idealbase[i] contient les ideaux premiers de norme convenable et
au dessus du nombre premier numero i ;
KCZ contient le nombre de nombres premiers utilises pour construire la base de facteurs 
jusqu'a la constante de Bach, KC contient le nombre d'ideaux premiers jusqu'a la constante
de Bach ; KCZ2 contient le nombre de nombres premiers de la base de facteurs au total ;
enfin, la fonction renvoie le nombre d'ideaux premiers utilises au total.
On n'utilise que des nombres premiers ne divisant pas l'index F, et non inertes.*/

long factorbasegen(nf,n2,n,ptnumprim,ptprim,ptnum,ptideal,ptkc,ptkcz,ptkcz2,ptlfun)
     GEN nf,**ptideal,*ptlfun;
     long n2,n,**ptnumprim,**ptprim,**ptnum,*ptkc,*ptkcz,*ptkcz2;

{
  byteptr delta=diffptr;
  long av1,tetpil,i,j,k,pp,fl,lon,ip,N=lgef(nf[1])-3,*numprimfactorbase,*primfactorbase;
  long *numideal,ip0;
  GEN prim,pgen1,pgen2,pgen3,pgen4,*idealbase,lfun;

  numprimfactorbase=(long*)malloc(4*(n2+1));
  primfactorbase=(long*)malloc(4*(n2+1));
  numideal=(long*)malloc(4*(n2+1));
  idealbase=(GEN*)malloc(4*(n2+1));
  lfun=cgetr(5);affsr(1,lfun);*ptlfun=lfun;
  i=0;pp=*delta++;fl=1;ip=0;
  while(pp<=n2)
    {
      av1=avma;
      prim=stoi(pp);pgen1=primedec(nf,prim);
      lon=lg(pgen1);divriz(mulir(subis(prim,1),lfun),prim,lfun);
      if((lon>2)||cmpis(((GEN)pgen1[1])[3],1)>0)
	{
	  ip0=ip;
	  pgen2=cgetg(lon,18);
	  for(j=0,k=1;k<lon;k++)
	    {
	      pgen3=(GEN)pgen1[k];pgen4=gpui(prim,pgen3[4]);
	      if(cmpis(pgen4,n2)<=0) 
		{
		  ip++;j++;pgen2[j]=(long)pgen3;
		  divriz(mulir(pgen4,lfun),subis(pgen4,1),lfun);
		}
	    }
	  i++;numprimfactorbase[pp]=i;primfactorbase[i]=pp;
	  numideal[pp]=ip0;tetpil=avma;pgen3=cgetg(j+1,17);
	  for(k=1;k<=j;k++) pgen3[k]=lcopy(pgen2[k]);
	  idealbase[i]=gerepile(av1,tetpil,pgen3);
	}
      else
	{
	  pgen4=gpui(prim,(GEN)((GEN)pgen1[1])[4]);
	  if(cmpis(pgen4,n2)<=0) 
	    divriz(mulir(pgen4,lfun),subis(pgen4,1),lfun);
	}
      pp+=*delta++;
      if((pp>n)&&fl) {*ptkc=ip;fl=0;*ptkcz=i;}
    }
  *ptkcz2=i;
  *ptnumprim=numprimfactorbase;*ptprim=primfactorbase;*ptnum=numideal;*ptideal=idealbase;
  return ip;
}

long factorisegen(nf,ideal,kcz,limp,primfact,expoprimfact,primfactorbase,idealbase,numideal,numprimfactorbase,limhash)
     GEN nf,ideal,*idealbase;
     long kcz,limp,*primfact,*expoprimfact,*primfactorbase,*numideal,*numprimfactorbase,limhash;

{
  long sr,i,j,n1,ip,v,p,k,fl=1,av1,av2,q1,lo;
  GEN x,q,r,pg1;

  av1=avma;lo=0;
  for(x=gun,i=1;i<lg(ideal);i++) x=mulii(x,coeff(ideal,i,i));
  if(gcmp1(x)) {avma=av1;primfact[0]=0;return 1;}
  av2=avma;
  for(i=1;(i<=kcz)&&fl;i++)
    {
      p=primfactorbase[i];q=dvmdis(x,p,&r);
      if(sr=(!signe(r)))
	{
	  x=q;k=0;av2=avma;
	  while(sr) {k++;q=dvmdis(x,p,&r);if(sr=(!signe(r))) {x=q;av2=avma;}}
	  pg1=idealbase[numprimfactorbase[p]];
	  n1=lg(pg1);ip=numideal[p];
	  for(j=1;(j<n1)&&k;j++)
	    {
	      v=idealval(nf,ideal,pg1[j]);
	      if(v) 
		{
		  primfact[++lo]=ip+j;expoprimfact[lo]=v;
		  k-=v*itos(((GEN)pg1[j])[4]);
		}
	    }
	  if(k) {avma=av1;return 0;}
	}
      else avma=av2;
      fl=(cmpis(q,p)>0);
    }
  if(!fl)
    {
      if(gcmp1(x)) {avma=av1;primfact[0]=lo;return 1;}
      else
	{
	  if(cmpis(x,limp)<=0)
	    {
	      p=itos(x);
	      pg1=idealbase[numprimfactorbase[p]];
	      n1=lg(pg1);ip=numideal[p];k=1;
	      for(j=1;(j<n1)&&k;j++)
		{
		  v=idealval(nf,ideal,pg1[j]);
		  if(v) 
		    {
		      primfact[++lo]=ip+j;expoprimfact[lo]=v;
		      k-=v*itos(((GEN)pg1[j])[4]);
		    }
		}
	      if(k) {avma=av1;return 0;}
	      avma=av1;primfact[0]=lo;return 1;
	    }
	}
    }
  if(cmpis(x,limhash)<=0)
    {q1=itos(x);avma=av1;primfact[0]=lo;return q1;}
  else {avma=av1;return 0;}
}

void hphasegen1(mat,matarch,vectbase)
     long **mat;
     GEN matarch,vectbase;
{
  long numrow,i,i1,j,nb,n,extrarel,KC;

  numrow=KC=lg(vectbase)-1;
  extrarel=lg(matarch)-1-KC;
  while(numrow>=1)
    {
      for(i=numrow;(i>=1)&&((nb=compte(mat,i,extrarel+numrow,&n))>1);i--);
      if(!nb)
	{
	  for(j=1;j<=extrarel+numrow;j++)
	    for(i1=i;i1<numrow;i1++) mat[j][i1]=mat[j][i1+1];
	  for(i1=i;i1<numrow;i1++) vectbase[i1]=vectbase[i1+1];
	  numrow--;extrarel++;
	}
      else if(nb==1)
	{
	  for(j=1;j<=extrarel+numrow;j++) mat[j][i]=mat[j][numrow];
	  vectbase[i]=vectbase[numrow];mat[n]=mat[extrarel+numrow];
	  matarch[n]=matarch[extrarel+numrow];
	  numrow--;if(!numrow) {setlg(vectbase,2);setlg(matarch,extrarel+2);return;}
	}
      else 
	{
	  setlg(vectbase,numrow+1);setlg(matarch,numrow+extrarel+1);
	  return;
	}
    }
  err(talker,"not enough relations or h=1 in hphasegen1");
}

void hphasegen2(mat,matarch,vectbase)
     long **mat;
     GEN matarch,vectbase;
{
  long numrow,i,j,nb,n,sizemax,imin,nbmin,nmin,s,t,fl=1,extrarel;
  long nbcol1=lg(matarch)-1,nbrow1=lg(vectbase)-1;
  
  extrarel=nbcol1-nbrow1;numrow=nbrow1;sizemax=0;
  while(fl&&(numrow>=1)&&(sizemax<=1073741823))
    {
      imin=numrow;nbmin=compte(mat,numrow,extrarel+numrow,&n);nmin=n;
      for(i=numrow-1;i>=1;i--)
	{nb=compte(mat,i,extrarel+numrow,&n);if(nb<nbmin) {nbmin=nb;imin=i;nmin=n;}}
      if(nbmin<32767)
	{
	  s=mat[nmin][imin];
	  for(j=1;j<nmin;j++)
	    {
	      sizemax=0;
	      if(t=mat[j][imin])
		{
		  if(s==t)
		    {
		      for(i=1;i<=numrow;i++)
			{
			  mat[j][i]-=mat[nmin][i];
			  sizemax=max(sizemax,abs(mat[j][i]));
			}
		      gsubz(matarch[j],matarch[nmin],matarch[j]);
		    }
		  else
		    {
		      for(i=1;i<=numrow;i++)
			{
			  mat[j][i]+=mat[nmin][i];
			  sizemax=max(sizemax,abs(mat[j][i]));
			}
		      gaddz(matarch[j],matarch[nmin],matarch[j]);
		    }
		}
	    }
	  for(j=1;j<=extrarel+numrow;j++) mat[j][imin]=mat[j][numrow];
	  vectbase[imin]=vectbase[numrow];mat[nmin]=mat[extrarel+numrow];
	  matarch[nmin]=matarch[extrarel+numrow];
	  numrow--;if(!numrow) {setlg(vectbase,2);setlg(matarch,extrarel+2);}
	}
      else 
	{
	  setlg(vectbase,numrow+1);setlg(matarch,numrow+extrarel+1);
	  fl=0;
	}
    }
  return;
}

/* version avec matarch. Inutile si on utilise kerint

GEN hnfarch(x,matarch,vectbase,detmat)
     GEN x,matarch,vectbase,detmat;
{
  long li,co,av,tetpil,i,j,def,ldef,lim,dec;
  GEN b,q,w,p1,y,d,u,v,p3,p4,detmatsur2=shifti(detmat,-1);

  lim=(avma+bot)>>1;av=avma;co=lg(x);li=lg(x[1]);y=x;
  def=co;ldef=(li>co)?li-co+1:1;
  for(i=li-1;i>=ldef;i--)
    {
      def--;j=def-1;while(j&&(!signe(coeff(y,i,j)))) j--;
      while(j>1)
	{
	  d=bezout(coeff(y,i,j),coeff(y,i,j-1),&u,&v);
	  p1=gadd(gmul(u,y[j]),gmul(v,y[j-1]));
	  y[j]=lsub(gmul(p3=divii(coeff(y,i,j),d),y[j-1]),
		    gmul(p4=divii(coeff(y,i,j-1),d),y[j]));
	  y[j]=(long)clean(y[j],detmat,detmatsur2);y[j-1]=(long)p1;
	  y[j-1]=(long)clean(y[j-1],detmat,detmatsur2);
	  p1=gadd(gmul(u,matarch[j]),gmul(v,matarch[j-1]));
	  gsubz(gmul(p3,matarch[j-1]),gmul(p4,matarch[j]),matarch[j]);
	  gaffect(p1,matarch[j-1]);
	  j--;while(j&&(!signe(coeff(y,i,j)))) j--;
	  if(avma<lim)
	    {
	      tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
	    }
	}
      if(j==1)
	{
	  d=bezout(coeff(y,i,1),coeff(y,i,def),&u,&v);
	  p1=gadd(gmul(u,y[1]),gmul(v,y[def]));
	  y[1]=lsub(gmul(p3=divii(coeff(y,i,1),d),y[def]),
		    gmul(p4=divii(coeff(y,i,def),d),y[1]));
	  y[1]=(long)clean(y[1],detmat,detmatsur2);y[def]=(long)p1;
	  y[def]=(long)clean(y[def],detmat,detmatsur2);
	  p1=gadd(gmul(u,matarch[1]),gmul(v,matarch[def]));
	  gsubz(gmul(p3,matarch[def]),gmul(p4,matarch[1]),matarch[1]);
	  gaffect(p1,matarch[def]);
	}
      if(avma<lim)
	{
	  tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
	}
    }
  tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
  b=gcopy(detmat);w=cgetg(li,19);def--;
  for(i=li-1;i>=1;i--)
    {
      d=bezout(coeff(y,i,i+def),b,&u,&v);w[i]=lmod(gmul(u,y[i+def]),b);
      if(!signe(coeff(w,i,i))) coeff(w,i,i)=(long)d;
      gmulz(u,matarch[i+def],matarch[i+def]);
      if(i>1) b=divii(b,d);
    }
  for(i=li-2;i>=1;i--)
    {
      for(j=i+1;j<li;j++)
	{
	  q=gdivent(coeff(w,i,j),coeff(w,i,i));w[j]=lsub(w[j],gmul(q,w[i]));
	  gsubz(matarch[j+def],gmul(q,matarch[i+def]),matarch[j+def]);
	}
      if(avma<lim)
	{
	  tetpil=avma;w=gerepile(av,tetpil,gcopy(w));
	}
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(w));
}

*/

/* Version sans matarch, a utiliser avec kerint */

GEN hnfarch(x,vectbase,detmat)
     GEN x,vectbase,detmat;
{
  long li,co,av,tetpil,i,j,def,ldef,lim,dec;
  GEN b,q,w,p1,y,d,u,v,p3,p4,detmatsur2=shifti(detmat,-1);

  lim=(avma+bot)>>1;av=avma;co=lg(x);li=lg(x[1]);y=x;
  def=co;ldef=(li>co)?li-co+1:1;
  for(i=li-1;i>=ldef;i--)
    {
      def--;j=def-1;while(j&&(!signe(coeff(y,i,j)))) j--;
      while(j>1)
	{
	  d=bezout(coeff(y,i,j),coeff(y,i,j-1),&u,&v);
	  p1=gadd(gmul(u,y[j]),gmul(v,y[j-1]));
	  y[j]=lsub(gmul(p3=divii(coeff(y,i,j),d),y[j-1]),
		    gmul(p4=divii(coeff(y,i,j-1),d),y[j]));
	  y[j]=(long)clean(y[j],detmat,detmatsur2);y[j-1]=(long)p1;
	  y[j-1]=(long)clean(y[j-1],detmat,detmatsur2);
	  j--;while(j&&(!signe(coeff(y,i,j)))) j--;
	  if(avma<lim)
	    {
	      tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
	    }
	}
      if(j==1)
	{
	  d=bezout(coeff(y,i,1),coeff(y,i,def),&u,&v);
	  p1=gadd(gmul(u,y[1]),gmul(v,y[def]));
	  y[1]=lsub(gmul(p3=divii(coeff(y,i,1),d),y[def]),
		    gmul(p4=divii(coeff(y,i,def),d),y[1]));
	  y[1]=(long)clean(y[1],detmat,detmatsur2);y[def]=(long)p1;
	  y[def]=(long)clean(y[def],detmat,detmatsur2);
	}
      if(avma<lim) {tetpil=avma;y=gerepile(av,tetpil,gcopy(y));}
    }
  tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
  b=gcopy(detmat);w=cgetg(li,19);def--;
  for(i=li-1;i>=1;i--)
    {
      d=bezout(coeff(y,i,i+def),b,&u,&v);w[i]=lmod(gmul(u,y[i+def]),b);
      if(!signe(coeff(w,i,i))) coeff(w,i,i)=(long)d;
      if(i>1) b=divii(b,d);
    }
  for(i=li-2;i>=1;i--)
    {
      for(j=i+1;j<li;j++)
	{
	  q=gdivent(coeff(w,i,j),coeff(w,i,i));w[j]=lsub(w[j],gmul(q,w[i]));
	}
      if(avma<lim)
	{
	  tetpil=avma;w=gerepile(av,tetpil,gcopy(w));
	}
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(w));
}

GEN idealmulprimered(nf,x,vp,PRECREG)
     GEN nf,x,vp;
     long PRECREG;
{
  long av=avma,tetpil;
  GEN y;
  
  y=idealmulprime(nf,x,vp);tetpil=avma;
  return gerepile(av,tetpil,ideallllred(nf,y,zero,PRECREG));
}

long* calcindice(primsubfactorbase,numprim,numideal,idealbase)
     GEN primsubfactorbase,*idealbase;
     long *numprim,*numideal;
{
  long n=lg(primsubfactorbase),i,j,*y,pp;
  GEN p1,p2;
  
  y=(long*)malloc(4*n);
  for(i=1;i<n;i++)
    {
      p1=(GEN)primsubfactorbase[i];
      p2=idealbase[numprim[pp=itos(p1[1])]];
      for(j=1;(j<lg(p2))&&(!gegal(p2[j],p1));j++);
      if(j==lg(p2)) err(talker,"bug in calcindice");
      y[i]=numideal[pp]+j;
    }
  return y;
}

GEN getfu(nf,xarch,reg,mdet,pte,PRECREG)
     GEN nf,xarch,reg,mdet;
     long PRECREG,*pte;
{
  long av=avma,tetpil,i,j,RU=lg(mdet)-1,N=lgef(nf[1])-3,e,k,R1,R2;
  GEN p1,p2,p3,y,rpro,rpro2,matep,s,u,v;
  
  if(expo(reg)< -8) return cgetg(1,19);
  R1=itos(((GEN)nf[2])[1]);R2=(N-R1)>>1;
  for(j=1;j<RU;j++) mdet[j]=lreal(xarch[j]);reg=gmulsg(N,reg);
  rpro=ground(gdiv(detreel(mdet),reg));i=RU-1;
  while(!gcmp1(gabs(rpro)))
    {
      i++;if(i>=lg(xarch)) {fprintf(stderr, "\n  ***   %s","bug1 in getfu please report");avma=av;return cgetg(1,19);}
      for(j=1;j<RU;j++) mdet[j]=lreal(xarch[j+i-RU+1]);
      rpro2=ground(gdiv(detreel(mdet),reg));
      if(signe(rpro))
	{
	  rpro=bezout(rpro,rpro2,&u,&v);if(RU%2) u=gneg(u);
	  xarch[i]=ladd(gmul(u,xarch[i-RU+1]),gmul(v,xarch[i]));
	}
      else rpro=rpro2;
    }
  for(j=1;j<RU;j++) mdet[j]=lreal(xarch[j+i-RU+1]);
  rpro2=ground(gdiv(detreel(mdet),reg));
  if(!gcmp1(gabs(rpro2))) {fprintf(stderr, "\n  ***   %s","bug1 in getfu please report");avma=av;return cgetg(1,19);}
  k=i;matep=cgetg(RU,19);
  for(j=1;j<RU;j++)
    {
      s=gzero;for(i=1;i<=RU;i++) s=gadd(s,greal(coeff(xarch,i,j+k-RU+1)));
      s=gdivgs(s,N);
      p1=cgetg(N+1,18);matep[j]=(long)p1;
      for(i=1;i<=R1;i++)
	p1[i]=lsub(coeff(xarch,i,j+k-RU+1),s);
      for(i=R1+1;i<=RU;i++)
	{
	  p1[i]=lsub(gmul2n(coeff(xarch,i,j+k-RU+1),-1),s);
	  p1[i+R2]=lconj(p1[i]);
	}
    }
  matep=gexp(gmul(matep,lll(greal(matep),PRECREG)));
  p1=(GEN)((GEN)nf[5])[1];
  p2=cgetg(N+1,19);
  for(j=1;j<=N;j++)
    {
      p3=cgetg(N+1,18);p2[j]=(long)p3;
      for(i=1;i<=R1;i++) p3[i]=coeff(p1,i,j);
      for(i=R1+1;i<=RU;i++)
	{
	  p3[i]=coeff(p1,i,j);p3[i+R2]=lconj(p3[i]);
	}
    }
  y=greal(grndtoi(invmulmat(p2,matep),&e));
  *pte= -e;
  for(j=1;j<lg(y);j++)
    {
      p1=(GEN)y[j];p2=(GEN)(ginv(gmodulcp(gmul(nf[7],p1),nf[1]))[2]);
      p3=cgetg(N+1,18);for(i=1;i<lgef(p2)-1;i++) p3[i]=p2[i+1];
      for(;i<=N;i++) p3[i]=zero;
      p2=gmul(nf[8],p3);if(gcmp(gnorml2(p2),gnorml2(p1))<0) p1=p2;
      for(i=N;(i>=1)&&gcmp0(p1[i]);i--);
      y[j]=(gsigne(p1[i])<0) ? lneg(p1) : (long)p1;
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}


GEN gcdrealnoer(a,b)
     GEN a,b;
{
  long av,tetpil,e;
  GEN k1,r;

  if(expo(a)<-5) return gcopy(b);
  if(expo(b)<-5) return gcopy(a);
  av=avma;a=absr(a);b=absr(b);
  while((expo(b)>=(-5))&&(signe(b)))
    {k1=gcvtoi(divrr(a,b),&e);r=subrr(a,mulir(k1,b));a=b;b=r;}
  tetpil=avma;return gerepile(av,tetpil,gcopy(a));
}
