/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*                                                                 */
/*                       BASE D'ENTIERS                            */
/*                                                                 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

# include "genpari.h"
GEN rquot(),ordmax(),rtran(),mtran(),matinv();
GEN pradical(),pol_min(),eval_pol(),lens(),two_elt();
GEN fasthnf();

void rowred();

GEN allbase(x,code,y)

     GEN x,*y;
     long code;

/*******************************************************************
  Entree:     x polynome unitaire a coefficients dans Z de deg n
	    definissant un corps de nombres K=Q(theta);
              code 0, 1 ou (long)p selon que l'on veut base, smallbase
            ou factoredbase.
	      y pointeur sur un GEN destine a recevoir
	    le discriminant du corps K.
  Sortie:    retourne 1) un vecteur (horizontal) a n composantes, 
            de polynomes a coeff dans Q (de deg 0,1...n-1)
	    constituant une base de l'anneau des entiers de K.
	        2) le discriminant de K (dans *y).
	    Rem: le denominateur commun des coef. est dans da.
*******************************************************************/

{
  GEN p,a,at,bt,b,da,db,q;
  long av=avma,tetpil,n,h,j,je,k,r,s,t,pro,v;

  if(typ(x)!=10) err(allbaser1);
  n=lgef(x)-3;if(n<=0) err(allbaser1);
  v=varn(x);*y=discsr(x);
  switch(code)
    {
    case 0: p=auxdecomp(absi(*y),1);h=lg(p[1])-1;break; /* base */
    case 1: p=auxdecomp(absi(*y),0);h=lg(p[1])-1;break; /* smallbase */
    default: p=(GEN)code;
      if((typ(p)!=19)||(lg(p)!=3)) err(factoreder1); /* factoredbase */
      h=lg(p[1])-1;
      q=gun;for(je=1;je<=h;je++) q=gmul(q,gpui(coeff(p,je,1),coeff(p,je,2)));
      if(gcmp(absi(q),absi(*y))) err(factoreder2);
    }
  a=idmat(n);da=gun;
  for(je=1;je<=h;je++)
    {
      if(gcmpgs(coeff(p,je,2),1)>0)
	{
	  b=ordmax(x,coeff(p,je,1),coeff(p,je,2),&db);
	  a=gmul(db,a);b=gmul(da,b);
	  da=mulii(db,da);db=da;
	  at=gtrans(a);bt=gtrans(b);
	  for(r=n-1;r>=0;r--)
	    for(s=r;s>=0;s--)
	      while(signe(coef1(bt,s,r)))
		{
		  q=rquot(coef1(at,s,s),coef1(bt,s,r));
		  at[s+1]=(long)rtran(at[s+1],bt[r+1],q);
		  for(t=s-1;t>=0;t--)
		    {
		      q=rquot(coef1(at,t,s),coef1(at,t,t));
		      at[s+1]=(long)rtran(at[s+1],at[t+1],q);
		    }
		  pro=at[s+1];at[s+1]=bt[r+1];bt[r+1]=pro;
		}
	  for(j=n-1;j>=0;j--)
	    {
	      for(k=0;k<j;k++)
		{
		  while(signe(coef1(at,j,k)))
		    {
		      q=rquot(coef1(at,j,j),coef1(at,j,k));
		      at[j+1]=(long)rtran(at[j+1],at[k+1],q);
		      pro=at[j+1];at[j+1]=at[k+1];at[k+1]=pro;
		    }
		}
	      if(signe(coef1(at,j,j))<0)
		for(k=0;k<=j;k++) coef1(at,k,j)=lnegi(coef1(at,k,j));
	      for(k=j+1;k<n;k++)
		{
		  q=rquot(coef1(at,j,k),coef1(at,j,j));
		  at[k+1]=(long)rtran(at[k+1],at[j+1],q);
		}
	    }
	  for(j=1;j<n;j++)
	    if(!cmpii(coef1(at,j,j),coef1(at,j-1,j-1)))
	      {
		coef1(at,0,j)=zero;
		for(k=1;k<=j;k++)
		  coef1(at,k,j)=coef1(at,k-1,j-1);
	      }
	  a=gtrans(at);
	}
    }
  for(j=1;j<=n;j++)
    {
      *y=divii(mulii(coeff(a,j,j),*y),da);
      *y=divii(mulii(coeff(a,j,j),*y),da);
    }
  tetpil=avma;*y=gcopy(*y);at=cgetg(n+1,17);
  for(j=1;j<=n;j++)
    {
      q=cgetg(j+2,10);q[1]=0x1000002+j+(v<<16);at[j]=(long)q;
      for(k=2;k<=j+1;k++) q[k]=ldiv(coeff(a,j,k-1),da);
    }
  pro=lpile(av,tetpil,0)>>2;at+=pro;(*y)+=pro;
  return at;
}

GEN base(x,y)
     GEN x,*y;
{
  return allbase(x,0,y);
}

GEN smallbase(x,y)
     GEN x,*y;
{
  return allbase(x,1,y);
}

GEN factoredbase(x,p,y)
     GEN x,p,*y;
{
  return allbase(x,(long)p,y);
}

GEN discf(x)
     GEN x;
{
  GEN y;
  long av,tetpil;

  av=avma;allbase(x,0,&y);tetpil=avma;
  return gerepile(av,tetpil,gcopy(y));
}

GEN smalldiscf(x)
     GEN x;
{
  GEN y;
  long av,tetpil;

  av=avma;allbase(x,1,&y);tetpil=avma;
  return gerepile(av,tetpil,gcopy(y));
}

GEN factoreddiscf(x,p)
     GEN x,p;
{
  GEN y;
  long av,tetpil;

  av=avma;allbase(x,(long)p,&y);tetpil=avma;
  return gerepile(av,tetpil,gcopy(y));
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*                                                                 */
/*   Quotient et Reste normalises   ( -1/2 < r = x-q*y <= 1/2 )    */
/*                                                                 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

GEN rquot(x,y)

     GEN x,y;

{
  GEN u,v,w,p;
  long av,av1;

  av=avma;
  u=absi(y);v=shifti(x,1);w=shifti(y,1);
  if ( cmpii(u,v)>0) p=subii(v,u);
  else p=addsi(-1,addii(u,v));
  av1=avma;
  return(gerepile(av,av1,divii(p,w)));
}
 
GEN rrmdr(x,y)

     GEN x,y;

{
  GEN p;
  long av,av1;

  av=avma;
  p=mulii(rquot(x,y),y);
  av1=avma;
  return(gerepile(av,av1,subii(x,p)));
}

GEN rinv(x,y)

     GEN x,y;

{
  GEN a,c,q,r,t;
  long av,av1;

  av=avma;
  a=gun;c=gzero;
  while( signe(y))
	{
	  q=rquot(x,y);
	  r=subii(a,mulii(q,c));a=c;c=r;
	  t=subii(x,mulii(q,y));x=y;y=t;
	}
  av1=avma;
  if (signe(x)<0) a=negi(a);
  if (signe(c)) { av1=avma; a=rrmdr(a,c); }
  return( gerepile(av,av1,a));
}

GEN rgcd(x,y)

     GEN x,y;

{
  GEN z;
  long av,av1;

  av=avma;
  while(signe(y))
    {
      z=rrmdr(x,y);x=y;y=z;
    }
  av1=avma;
  return(gerepile(av,av1,absi(x)));
}
    

GEN rlcm(x,y)

     GEN x,y;

{
  GEN d,z;
  long av,av1;

  av=avma;
  z=mulii(x,y);d=rgcd(x,y);
  av1=avma;
  return(gerepile(av,av1,divii(z,d)));
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*                                                                 */
/*           Matrice compagnon du polynome unitaire x              */
/*                                                                 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

GEN companion(x)

     GEN     x;

{
  long    i,j,l;
  GEN     y;
  
  l=lgef(x)-2;y=cgetg(l,19);
  for(i=1;i<l;i++) y[i]=lgetg(l,18);
  for(i=0;i<l-2;i++)
    for(j=0;j<l-1;j++) coef1(y,i,j)=((i+1)==j) ? un : zero;
  for(j=0;j<l-1;j++) coef1(y,l-2,j)=lneg(x[j+2]);
  return(y);
}



GEN ordmax(f,p,e,ptdelta)

GEN f,p,e;
GEN *ptdelta;

{
  GEN m,hh,pp,dd,ppdd,index,q,r,s,b,c,t,jp,v,delta;
  GEN cf[20],w[20],a;
  long h,i,j,k,sp,epsilon,n=lgef(f)-3,av=avma,tetpil,dec;

  a=cgetg(n*n+1,19);
  for(j=1;j<=n*n;j++)
  {
    a[j]=lgetg(n+1,18);
    for(k=1;k<=n;k++) coeff(a,k,j)=zero;
  }
  v=cgetg(n+1,18);
  cf[0]=idmat(n);
  cf[1]=companion(f);
  for(j=2;j<n;j++) cf[j]=gmul(cf[1],cf[j-1]);
  delta=gun; epsilon=itos(e);
  m=idmat(n);

  do
    {
      pp=mulii(p,p);
      dd=mulii(delta,delta);
      ppdd=mulii(dd,pp);
      b=matinv(m,delta);
      for(i=0;i<n;i++)
	{
	  t=gscalsmat(0,n); /* t <--- matrice nulle d'ordre n */
	  for(h=0;h<n;h++)
	    for(j=0;j<n;j++)
	      for(k=0;k<n;k++)
		coef1(t,j,k)=(long)rrmdr(addii(coef1(t,j,k),mulii(coef1(m,i,h),coef1(cf[h],j,k))),ppdd);
	  c=gmul(t,b);
	  w[i]=gmul(m,c);
	  for(j=0;j<n;j++)
	    for(k=0;k<n;k++)
	      coef1(w[i],j,k)=(long)rrmdr(divii(coef1(w[i],j,k),dd),pp);
	}
      if(cmpis(p,n)>0)
	{
	  for(i=0;i<n;i++)
	    for(j=0;j<n;j++)
	      {
		coeff(t,i+1,j+1)=zero;
		for(k=0;k<n;k++)
		  for(h=0;h<n;h++)
		    {
		      r=modii(coef1(w[i],k,h),p);
		      s=modii(coef1(w[j],h,k),p);
		      coef1(t,i,j)=lmodii(addii(coef1(t,i,j),mulii(r,s)),p);
		    }
	      }
	}
      else
	{
	  for(j=0;j<n;j++)
	    {
	      for(i=0;i<n;i++)
		coef1(b,i,j)=(i==0)? un:zero;
/* ici la boucle en k calcule la puissance p mod p de w[j] */
	      sp=itos(p);
	      for(k=0;k<sp;k++)
		{
		  for(i=0;i<n;i++)
		    {
		      v[i+1]=zero;
		      for(h=0;h<n;h++)
			v[i+1]=lmodii(addii(v[i+1],mulii(coef1(b,h,j),coef1(w[j],h,i))),p);
		    }
		  for(i=0;i<n;i++) coef1(b,i,j)=v[i+1];
		}
	    }
	  q=p;t=b;
	  while(cmpis(q,n)<0)
	    {
	      q=mulii(q,p);
	      t=gmul(b,t);
	    }
	}
      for(i=0;i<n;i++)
	for(j=0;j<n;j++)
	  {
	    coef1(a,j,i)=(i==j)? (long)p:zero;
	    coef1(a,j,n+i)=lmodii(coef1(t,i,j),p);
	  }
      rowred(a,2*n-1,pp);
      for(i=0;i<n;i++)
	for(j=0;j<n;j++)
	  coef1(b,j,i)=coef1(a,j,i);
      jp=matinv(b,p);
      for(k=0;k<n;k++)
	{
	  t=gmul(jp,w[k]);
	  t=gmul(t,b);
	  for(i=0;i<n;i++)
	    for(j=0;j<n;j++)
	      coef1(t,i,j)=ldivii(coef1(t,i,j),p);
	  h=0;
	  for(i=0;i<n;i++)
	    for(j=0;j<n;j++)
	      {
		coef1(a,k,h)=coef1(t,i,j);
		h++;
	      }
	}
      rowred(a,n*n-1,pp);
      index=gun;
      for(i=0;i<n;i++)
	index=mulii(index,coef1(a,i,i));
      if (cmpsi(1,index))
	{
	  delta=mulii(index,delta);
	  for(i=0;i<n;i++)
	    for(j=0;j<n;j++)
	      coef1(c,i,j)=coef1(a,i,j);
	  b=matinv(c,index);
	  m=gmul(b,m);
	  hh=delta;
	  for(i=0;i<n;i++)
	    for(j=0;j<n;j++)
	      hh=rgcd(coef1(m,i,j),hh);
	  if(cmpis(hh,1)>1)
	    {
	      delta=divii(delta,hh);
	      for(i=0;i<n;i++)
		for(j=0;j<n;j++)
		  coef1(m,i,j)=ldivii(coef1(m,i,j),hh);
	    }
	  q=index;
	  while(!signe(modii(q,p)))
	    {
	      q=divii(q,p);
	      epsilon=epsilon-2;
	    }
	}
    }
  while(!gcmp1(index) && (epsilon>=2));
  tetpil=avma;delta=gcopy(delta);m=gcopy(m);
  dec=lpile(av,tetpil,0)>>2;
  *ptdelta=delta+dec;
  return m+dec;
}

void rowred(a,rlim,rmod)
     GEN a,rmod;
     long rlim;

{
  long j,k,n,pro;
  GEN q;

  n=lg(a[1])-1;
  for(j=0;j<n;j++)
    {
      for(k=j+1;k<=rlim;k++)
	while (signe(coef1(a,j,k)))
	  {
	    q=rquot(coef1(a,j,j),coef1(a,j,k));
	    a[j+1]=(long)mtran(a[j+1],a[k+1],q,rmod);
	    pro=a[j+1];a[j+1]=a[k+1];a[k+1]=pro;
	  }
      if (signe(coef1(a,j,j))<0)
	for(k=j;k<n;k++) coef1(a,k,j)=lnegi(coef1(a,k,j));
      for(k=0;k<j;k++)
	{
	  q=rquot(coef1(a,j,k),coef1(a,j,j));
	  a[k+1]=(long)mtran(a[k+1],a[j+1],q,rmod);
	}
    }
}

GEN rtran(v,w,q)
     GEN v,w,q ;

{
  long av,tetpil;
  GEN p1;

  if (signe(q))
    {
      av=avma;p1=gmul(q,w);tetpil=avma;
      return gerepile(av,tetpil,gsub(v,p1));
    }
  else return v;
}

GEN mtran(v,w,q,m)
     GEN v,w,q,m;

{
  long k;
  
  if (signe(q))
    {
      for(k=0;k<lg(v)-1;k++)
	{
	  v[k+1]=(long)rrmdr(subii(v[k+1],modii(mulii(q,w[k+1]),m)),m);
	}
    }
  return v;
}


GEN matinv(x,d)
     GEN x,d;
/*=======================================================================
    Calcule d/x  ou  d est entier et x matrice triangulaire inferieure
  entiere dont les coeff diagonaux divisent d ( resultat entier).
========================================================================*/
{
  long n,h,i,j,k,av,av1;
  GEN y;

  av=avma;
  y=idmat(n=lg(x)-1);
  for(i=1;i<=n;i++)
    coeff(y,i,i)=ldivii(d,coeff(x,i,i));
  for(i=2;i<=n;i++)
    for(j=i-1;j;j--)
      {
	for(h=zero,k=j+1;k<=i;k++)
	  h=ladd(h,mulii(coeff(y,i,k),coeff(x,k,j)));
	coeff(y,i,j)=ldivii(negi(h),coeff(x,j,j));
      }
  av1=avma;
  return gerepile(av,av1,gcopy(y));
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~									~*/
/*~			HERMITE NORMAL FORM REDUCTION			~*/
/*~									~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

GEN hnf(x)
     GEN x;
{
  long li,co,av,tetpil,i,j,k,def,ldef,lim;
  GEN p1,p2,y,z,u,v,d;

  if(typ(x)!=19) err(hnfer1);
/* matbrute(x); */
  lim=(avma+bot)>>1;
  av=avma;co=lg(x);li=lg(x[1]);y=gcopy(x);
  def=co;ldef=(li>co)?li-co+1:1;
  for(i=li-1;i>=ldef;i--)
    {
      def--;j=def-1;while(j&&(!signe(coeff(y,i,j)))) j--;
      while(j>1)
	{
	  d=bezout(coeff(y,i,j),coeff(y,i,j-1),&u,&v);
	  p1=gadd(gmul(u,y[j]),gmul(v,y[j-1]));
	  y[j]=lsub(gmul(divii(coeff(y,i,j),d),y[j-1]),gmul(divii(coeff(y,i,j-1),d),y[j]));
	  y[j-1]=(long)p1;
	  j--;while(j&&(!signe(coeff(y,i,j)))) j--;
	}
      if(j==1)
	{
	  d=bezout(coeff(y,i,1),coeff(y,i,def),&u,&v);
	  p1=gadd(gmul(u,y[1]),gmul(v,y[def]));
	  y[1]=lsub(gmul(divii(coeff(y,i,1),d),y[def]),gmul(divii(coeff(y,i,def),d),y[1]));
	  y[def]=(long)p1;
	}
      p1=(GEN)coeff(y,i,def);
      if(signe(p1)<0) {y[def]=lneg(y[def]);p1=(GEN)coeff(y,i,def);}
      if(signe(p1))
	{
	  for(j=def+1;j<co;j++)
	    {
	      p2=gdivent(coeff(y,i,j),p1);
	      y[j]=lsub(y[j],gmul(p2,y[def]));
	    }
	}
      else def++;
      if(avma<lim) {tetpil=avma;y=gerepile(av,tetpil,gcopy(y));}
    }
  for(i=0,j=1;j<co;j++) if(!gcmp0(y[j])) i++;
  tetpil=avma;z=cgetg(i+1,19);
  for(k=0,j=1;j<co;j++) if(!gcmp0(y[j])) z[++k]=lcopy(y[j]);
  return gerepile(av,tetpil,z);
}

GEN fasthnf(x)
     GEN x;
{
  long li,co,av,tetpil,i,j,k,ii,jj,def,ldef,lim;
  GEN p1,p2,y,z,u,v,d;

/* usage interne pas de verification. */
  lim=(avma+bot)>>1;
  av=avma;co=lg(x);li=lg(x[1]);y=x;
  def=co;
  for(i=li-1;i>=1;i--)
    {
      def--;j=co-li;while(j&&(!signe(coeff(y,i,j)))) j--;
      if(j)
	{
	  ii=i-1;while(ii&&(!signe(coeff(y,ii,def)))) ii--;
	  if(!ii)
	    {
	      p1=(GEN)coeff(y,i,def);
	      if(gcmp1(p1)) 
		{
		  for(jj=j;jj;jj--) coeff(y,i,jj)=zero;
		  j=0;
		}
	      else
		{
		  for(jj=j;jj;jj--) coeff(y,i,jj)=(long)modii(coeff(y,i,jj),p1);
		  while(j&&(!signe(coeff(y,i,j)))) j--;
		}
	    }
	}
      while(j>1)
	{
	  d=bezout(coeff(y,i,j),coeff(y,i,j-1),&u,&v);
	  if(signe(u))
	    {
	      if(signe(v)) p1=gadd(gmul(u,y[j]),gmul(v,y[j-1]));
	      else p1=gmul(u,y[j]);
	    }
	  else p1=gmul(v,y[j-1]);
	  y[j]=lsub(gmul(divii(coeff(y,i,j),d),y[j-1]),gmul(divii(coeff(y,i,j-1),d),y[j]));
	  y[j-1]=(long)p1;
	  j--;while(j&&(!signe(coeff(y,i,j)))) j--;
	}
      if(j==1)
	{
	  d=bezout(coeff(y,i,1),coeff(y,i,def),&u,&v);
	  if(signe(u))
	    {
	      if(signe(v)) p1=gadd(gmul(u,y[1]),gmul(v,y[def]));
	      else p1=gmul(u,y[1]);
	    }
	  else p1=gmul(v,y[def]);
	  y[1]=lsub(gmul(divii(coeff(y,i,1),d),y[def]),gmul(divii(coeff(y,i,def),d),y[1]));
	  y[def]=(long)p1;
	}
      p1=(GEN)coeff(y,i,def);
      if(signe(p1)<0) {y[def]=lneg(y[def]);p1=(GEN)coeff(y,i,def);}
      for(j=def+1;j<co;j++)
	{
	  p2=gdivent(coeff(y,i,j),p1);
	  y[j]=lsub(y[j],gmul(p2,y[def]));
	}
      if(avma<lim) {tetpil=avma;y=gerepile(av,tetpil,gcopy(y));}
    }
  tetpil=avma;z=cgetg(li,19);
  for(j=1;j<li;j++) z[j]=lcopy(y[j+co-li]);
  return gerepile(av,tetpil,z);
}


/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~									~*/
/*~			SMITH NORMAL FORM REDUCTION			~*/
/*~									~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

GEN smith(x)
     GEN x;
{
  long li,av,tetpil,i,j,k,l,lim,c,fl,n;
  GEN p1,p2,p3,p4,y,z,b,u,v,d;

  if(typ(x)!=19) err(hnfer1);
  lim=(avma+bot)>>1;
  av=avma;n=lg(x)-1;if(!n) return cgetg(1,17);
  li=lg(x[1])-1;y=gcopy(x);
  if(li!=n) err(hnfer2);
  for(i=n;i>=2;i--)
    {
      do
	{
	  c=0;
	  for(j=i-1;j>=1;j--)
	    {
	      p1=(GEN)coeff(y,i,j);
	      if(signe(p1))
		{
		  p2=(GEN)coeff(y,i,i);
		  if(gegal(p1,p2)) {d=p1;u=gun;v=gzero;p3=gun;p4=gun;}
		  else if(!signe(addii(p1,p2))) 
		    {
		      d=absi(p1);u=(signe(p2)>0)?gun:gneg(un);
		      v=gzero;p3=u;p4=gneg(u);
		    }
		  else {d=bezout(p2,p1,&u,&v);p3=divii(p2,d);p4=divii(p1,d);}
		  for(k=1;k<=i;k++)
		    {
		      b=addii(mulii(u,coeff(y,k,i)),mulii(v,coeff(y,k,j)));
		      coeff(y,k,j)=lsubii(mulii(p3,coeff(y,k,j)),mulii(p4,coeff(y,k,i)));
		      coeff(y,k,i)=(long)b;
		    }
		}
	    }
	  for(j=i-1;j>=1;j--)
	    {
	      p1=(GEN)coeff(y,j,i);
	      if(signe(p1))
		{
		  p2=(GEN)coeff(y,i,i);
		  if(gegal(p1,p2)) {d=p1;u=gun;v=gzero;p3=gun;p4=gun;}
		  else if(!signe(addii(p1,p2))) 
		    {
		      d=absi(p1);u=(signe(p2)>0)?gun:gneg(un);
		      v=gzero;p3=u;p4=gneg(u);
		    }
		  else {d=bezout(p2,p1,&u,&v);p3=divii(p2,d);p4=divii(p1,d);}
		  for(k=1;k<=i;k++)
		    {
		      b=addii(mulii(u,coeff(y,i,k)),mulii(v,coeff(y,j,k)));
		      coeff(y,j,k)=lsubii(mulii(p3,coeff(y,j,k)),mulii(p4,coeff(y,i,k)));
		      coeff(y,i,k)=(long)b;
		    }
		  c++;
		}
	    }
	  if(!c)
	    {
	      b=(GEN)coeff(y,i,i);fl=1;
	      if(signe(b))
		{
		  for(k=1;(k<i)&&fl;k++)
		    for(l=1;(l<i)&&fl;l++)
		      fl= !signe(modii(coeff(y,k,l),b));
		  if(!fl)
		    {
		      k--;
		      for(l=1;l<=i;l++)
			coeff(y,i,l)=laddii(coeff(y,i,l),coeff(y,k,l));
		    }
		}
	    }
	  if(avma<lim) {tetpil=avma;y=gerepile(av,tetpil,gcopy(y));}
	}
      while(c||(!fl));
    }
  tetpil=avma;z=cgetg(n+1,17);
  for(j=0,k=1;k<=n;k++) if(!signe(coeff(y,k,k))) z[++j]=zero;
  for(k=1;k<=n;k++) if(signe(coeff(y,k,k))) z[++j]=labs(coeff(y,k,k));
  return gerepile(av,tetpil,z);
}

GEN smith2(x)
     GEN x;
{
  long li,av,tetpil,i,j,k,l,lim,c,fl,n,dec;
  GEN p1,p2,p3,p4,y,z,b,u,v,d,ml,mr;

  if(typ(x)!=19) err(hnfer1);
  lim=(avma+bot)>>1;
  av=avma;n=lg(x)-1;if(!n) return cgetg(1,17);
  li=lg(x[1])-1;y=gcopy(x);
  if(li!=n) err(hnfer2);
  ml=idmat(n);mr=idmat(n);
  for(i=n;i>=2;i--)
    {
      do
	{
	  c=0;
	  for(j=i-1;j>=1;j--)
	    {
	      p1=(GEN)coeff(y,i,j);
	      if(signe(p1))
		{
		  p2=(GEN)coeff(y,i,i);
		  if(gegal(p1,p2)) {d=p1;u=gun;v=gzero;p3=gun;p4=gun;}
		  else if(!signe(addii(p1,p2))) 
		    {
		      d=absi(p1);u=(signe(p2)>0)?gun:gneg(un);
		      v=gzero;p3=u;p4=gneg(u);
		    }
		  else {d=bezout(p2,p1,&u,&v);p3=divii(p2,d);p4=divii(p1,d);}
		  for(k=1;k<=i;k++)
		    {
		      b=addii(mulii(u,coeff(y,k,i)),mulii(v,coeff(y,k,j)));
		      coeff(y,k,j)=lsubii(mulii(p3,coeff(y,k,j)),mulii(p4,coeff(y,k,i)));
		      coeff(y,k,i)=(long)b;
		    }
		  b=gadd(gmul(u,mr[i]),gmul(v,mr[j]));
		  mr[j]=lsub(gmul(p3,mr[j]),gmul(p4,mr[i]));
		  mr[i]=(long)b;
		}
	    }
	  for(j=i-1;j>=1;j--)
	    {
	      p1=(GEN)coeff(y,j,i);
	      if(signe(p1))
		{
		  p2=(GEN)coeff(y,i,i);
		  if(gegal(p1,p2)) {d=p1;u=gun;v=gzero;p3=gun;p4=gun;}
		  else if(!signe(addii(p1,p2))) 
		    {
		      d=absi(p1);u=(signe(p2)>0)?gun:gneg(un);
		      v=gzero;p3=u;p4=gneg(u);
		    }
		  else {d=bezout(p2,p1,&u,&v);p3=divii(p2,d);p4=divii(p1,d);}
		  for(k=1;k<=i;k++)
		    {
		      b=addii(mulii(u,coeff(y,i,k)),mulii(v,coeff(y,j,k)));
		      coeff(y,j,k)=lsubii(mulii(p3,coeff(y,j,k)),mulii(p4,coeff(y,i,k)));
		      coeff(y,i,k)=(long)b;
		    }
		  b=gadd(gmul(u,ml[i]),gmul(v,ml[j]));
		  ml[j]=lsub(gmul(p3,ml[j]),gmul(p4,ml[i]));
		  ml[i]=(long)b;
		  c++;
		}
	    }
	  if(!c)
	    {
	      b=(GEN)coeff(y,i,i);fl=1;
	      if(signe(b))
		{
		  for(k=1;(k<i)&&fl;k++)
		    for(l=1;(l<i)&&fl;l++)
		      fl= !signe(modii(coeff(y,k,l),b));
		  if(!fl)
		    {
		      k--;
		      for(l=1;l<=i;l++)
			coeff(y,i,l)=laddii(coeff(y,i,l),coeff(y,k,l));
		      ml[i]=ladd(ml[i],ml[k]);
		    }
		}
	    }
	  if(avma<lim) 
	    {
	      tetpil=avma;y=gcopy(y);ml=gcopy(ml);mr=gcopy(mr);
	      dec=lpile(av,tetpil,0)>>2;y+=dec;ml+=dec;mr+=dec;
	    }
	}
      while(c||(!fl));
    }
  for(k=1;k<=n;k++) if(signe(coeff(y,k,k))<0) mr[k]=lneg(mr[k]);
  ml=gtrans(ml);tetpil=avma;z=cgetg(3,17);
  z[1]=lcopy(ml);z[2]=lcopy(mr);
  return gerepile(av,tetpil,z);
}

GEN transroot(x,i,j)
     GEN x;
     int i,j;
{
  long n=lg(x),k;
  GEN y;

  y=cgetg(n,18);
  for(k=1;k<n;k++) y[k]=((k==i)||(k==j))?x[i+j-k]:x[k];
  return y;
}

GEN tschirnhaus(x)
     GEN x;
{
  long av=avma,tetpil,v,n,a,b,c;
  GEN u;

  if(typ(x)!=10) err(galer1);
  n=lgef(x)-3;if(n<=0) err(galer1);v=varn(x);
  if(v) {u=gcopy(x);setvarn(u,0);x=u;}
  do
    {
      a=rand()&3;if(!a) a=1;b=rand()&7;if(b>=4) b-=8;
      c=rand()&7;if(c>=4) c-=8;
      u=caract(gmodulcp(gaddsg(c,gmul(polx[0],gaddsg(b,gmulsg(a,polx[0])))),x),v);
    }
  while(lgef(polgcd(u,deriv(u,v)))>=4);
  tetpil=avma;return gerepile(av,tetpil,gcopy(u));
}

int gpolcomp(p1,p2)
     GEN p1,p2;
{
  int d,j;

  d=lgef(p1)-3;if((lgef(p2)-3)!=d) err(gpolcompbug1);
  j=d+1;while((j>=2)&&gegal(absi(p1[j]),absi(p2[j]))) j--;
  if(j==1) return 0;
  return gcmp(absi(p1[j]),absi(p2[j]));
}

GEN galois(x,prec)
     GEN x;
     long prec;
{

  long av=avma,av1,i,j,k,n,f,l,l2,e,e1;
  GEN x1,p1,p2,p3,p4,p5,p6,y,z;
  static int ind5[20]={2,5,3,4,1,3,4,5,1,5,2,4,1,2,3,5,1,4,2,3};
  static int ind6[60]={3,5,4,6,2,6,4,5,2,3,5,6,2,4,3,6,2,5,3,4,1,4,5,6,1,5,3,6,1,6,3,4,1,3,4,5,1,6,2,5,1,2,4,6,1,5,2,4,1,3,2,6,1,2,3,5,1,4,2,3};

  if(typ(x)!=10) err(galer1);
  n=lgef(x)-3;if(n<=0) err(galer1);
  if(n>7) err(impl,"galois of degree higher than 7");
  x=gdiv(x,content(x));
  for(i=2;i<=n+2;i++) if(typ(x[i])!=1) err(galer2);
  p1=(GEN)x[n+2];
  if(!gcmp1(p1))
    {
      x1=cgetg(n+3,10);x1[1]=x[1];x1[n+2]=un;p2=gun;
      for(i=n+1;i>=2;i--) {x1[i]=lmul(x[i],p2);if(i>2) p2=gmul(p1,p2);}
      x=x1;
    }
  p1=factor(x);
  if((lg(p1[1])>2)||(!gcmp1(coeff(p1,1,2)))) err(impl,"galois of reducible polynomial");
  x1=gcopy(x);av1=avma;
  for(;;)
    {
      switch(n)
	{
	case 1: avma=av;y=cgetg(4,17);y[1]=y[3]=un;y[2]=lneg(gun);return y;
	case 2: avma=av;y=cgetg(4,17);y[1]=deux;y[3]=un;y[2]=lneg(gun);return y;
	case 3: f=carreparfait(discsr(x));avma=av;y=cgetg(4,17);y[3]=un;
	  if(f) {y[2]=un;y[1]=lstoi(3);return y;}
	  else {y[2]=lneg(gun);y[1]=lstoi(6);return y;}
	case 4: 
	  do
	    {
	      p1=rootslong(x,prec);p2=p1;
	      p3=gzero;for(i=1;i<=4;i++) p3=gadd(p3,gmul(p2[i],gsqr(p2[(i&3)+1])));
	      p4=gsub(polx[0],p3);p2=transroot(p1,1,2);
	      p3=gzero;for(i=1;i<=4;i++) p3=gadd(p3,gmul(p2[i],gsqr(p2[(i&3)+1])));
	      p4=gmul(p4,gsub(polx[0],p3));p2=transroot(p1,1,3);
	      p3=gzero;for(i=1;i<=4;i++) p3=gadd(p3,gmul(p2[i],gsqr(p2[(i&3)+1])));
	      p4=gmul(p4,gsub(polx[0],p3));p2=transroot(p1,1,4);
	      p3=gzero;for(i=1;i<=4;i++) p3=gadd(p3,gmul(p2[i],gsqr(p2[(i&3)+1])));
	      p4=gmul(p4,gsub(polx[0],p3));p2=transroot(p1,2,3);
	      p3=gzero;for(i=1;i<=4;i++) p3=gadd(p3,gmul(p2[i],gsqr(p2[(i&3)+1])));
	      p4=gmul(p4,gsub(polx[0],p3));p2=transroot(p1,3,4);
	      p3=gzero;for(i=1;i<=4;i++) p3=gadd(p3,gmul(p2[i],gsqr(p2[(i&3)+1])));
	      p4=gmul(p4,gsub(polx[0],p3));p5=grndtoi(greal(p4),&e);
	      e=max(e,gexpo(gimag(p4)));
	      if(e> -10) prec=(prec<<2)-2;
	    }
	  while(e> -10);
	  p6=ggcd(p5,deriv(p5,0));
	  f=(typ(p6)==10)&&(lgef(p6)>3);
	  if(f) goto tchi;
	  p1=factor(p5);p2=(GEN)p1[1];l=lg(p2)-1;
	  switch(l)
	    {
	    case 1: f=carreparfait(discsr(x));avma=av;y=cgetg(4,17);y[3]=un;
	      if(f) {y[2]=un;y[1]=lstoi(12);return y;}
	      else {y[2]=lneg(gun);y[1]=lstoi(24);return y;}
	    case 2: avma=av;y=cgetg(4,17);y[3]=un;y[2]=lneg(gun);y[1]=lstoi(8);return y;
	    case 3: l2=lgef(p2[1])-3;
	      if(l2==2) {avma=av;y=cgetg(4,17);y[3]=y[2]=un;y[1]=lstoi(4);return y;}
	      else {avma=av;y=cgetg(4,17);y[3]=un;y[2]=lneg(gun);y[1]=lstoi(4);return y;}
	    default: err(galbug1);
	    }
	case 5:
	  do
	    {
	      do
		{
		  p1=rootslong(x,prec);z=cgetg(7,17);
		  for(l=1;l<=5;l++)
		    {
		      p2=(l==1)?p1:transroot(p1,1,l);
		      p3=gzero;k=0;for(i=1;i<=5;i++)
			{
			  p5=gadd(gmul(p2[ind5[k]],p2[ind5[k+1]]),gmul(p2[ind5[k+2]],p2[ind5[k+3]]));
			  p3=gadd(p3,gmul(gsqr(p2[i]),p5));k+=4;
			}
		      z[l]=lrndtoi(greal(p3),&e);
		      p4=(l==1)?gsub(polx[0],p3):gmul(p4,gsub(polx[0],p3));
		    }
		  p2=transroot(p1,2,5);
		  p3=gzero;k=0;for(i=1;i<=5;i++)
		    {
		      p5=gadd(gmul(p2[ind5[k]],p2[ind5[k+1]]),gmul(p2[ind5[k+2]],p2[ind5[k+3]]));
		      p3=gadd(p3,gmul(gsqr(p2[i]),p5));k+=4;
		    }
		  z[6]=lrndtoi(greal(p3),&e);
		  p4=gmul(p4,gsub(polx[0],p3));
		  p5=grndtoi(greal(p4),&e);
		  e=max(e,gexpo(gimag(p4)));
		  if(e> -10) prec=(prec<<2)-2;
		}
	      while(e> -10);
	      p6=ggcd(p5,deriv(p5,0));
	      f=(typ(p6)==10)&&(lgef(p6)>3);
	      if(f) goto tchi;
	      p3=factor(p5);l=lg(p3[1])-1;
	      f=carreparfait(discsr(x));
	      if(l==1)
		{
		  avma=av;y=cgetg(4,17);y[3]=un;
		  if(f) {y[2]=un;y[1]=lstoi(60);return y;}
		  else {y[2]=lneg(gun);y[1]=lstoi(120);return y;}
		}
	      else
		{
		  if(f) 
		    {
		      l=1;while((l<=6)&&(!gcmp0(poleval(p5,z[l])))) l++;
		      if(l>6) err(galbug4);
		      p2=(l==6)?transroot(p1,2,5):transroot(p1,1,l);
		      p3=gzero;
		      for(i=1;i<=5;i++)
			{
			  j=(i%5)+1;
			  p3=gadd(p3,gmul(gmul(p2[i],p2[j]),gsub(p2[j],p2[i])));
			}
		      p5=gmul(p3,p3);p4=grndtoi(greal(p5),&e1);
		      e1=max(e1,gexpo(gimag(p5)));
		      if(e1<= -10)
			{
			  if(gcmp0(p4)) goto tchi;
			  f=carreparfait(p4);
			  avma=av;y=cgetg(4,17);y[3]=y[2]=un;y[1]=lstoi(f?5:10);return y;
			}
		      else prec=(prec<<2)-2;
		    }
		  else
		    {
		      avma=av;y=cgetg(4,17);y[3]=un;y[2]=lneg(gun);y[1]=lstoi(20);return y;
		    }
		}
	    }
	  while(e1> -10);
	case 6: 
	  do
	    {
	      do
		{
		  p1=rootslong(x,prec);
		  for(l=1;l<=6;l++)
		    {
		      p2=(l==1)?p1:transroot(p1,1,l);
		      p3=gzero;k=0;for(i=1;i<=5;i++) for(j=i+1;j<=6;j++)
			{
			  p5=gadd(gmul(p2[ind6[k]],p2[ind6[k+1]]),gmul(p2[ind6[k+2]],p2[ind6[k+3]]));
			  p3=gadd(p3,gmul(gsqr(gmul(p2[i],p2[j])),p5));k+=4;
			}
		      p4=(l==1)?gsub(polx[0],p3):gmul(p4,gsub(polx[0],p3));
		    }
		  p5=grndtoi(greal(p4),&e);
		  e=max(e,gexpo(gimag(p4)));
		  if(e> -10) prec=(prec<<2)-2;
		}
	      while(e> -10);
	      p6=ggcd(p5,deriv(p5,0));
	      f=(typ(p6)==10)&&(lgef(p6)>3);
	      if(f) goto tchi;
	      p3=factor(p5);p2=(GEN)p3[1];l=lg(p2)-1;
	      switch(l)
		{
		case 1:	p3=gadd(gmul(gmul(p1[1],p1[2]),p1[3]),gmul(gmul(p1[4],p1[5]),p1[6]));
		  p4=gsub(polx[0],p3);
		  for(i=1;i<=3;i++)
		    for(j=4;j<=6;j++)
		      {
			p2=transroot(p1,i,j);
			p3=gadd(gmul(gmul(p2[1],p2[2]),p2[3]),gmul(gmul(p2[4],p2[5]),p2[6]));
			p4=gmul(p4,gsub(polx[0],p3));
		      }
		  p5=grndtoi(greal(p4),&e1);
		  e1=max(e1,gexpo(gimag(p4)));
		  if(e1<= 10)
		    {
		      p6=ggcd(p5,deriv(p5,0));
		      f=(typ(p6)==10)&&(lgef(p6)>3);
		      if(f) goto tchi;
		      p3=factor(p5);p2=(GEN)p3[1];l=lg(p2)-1;f=carreparfait(discsr(x));
		      avma=av;y=cgetg(4,17);y[3]=un;
		      if(l==1)
			{
			  if(f) {y[2]=un;y[1]=lstoi(360);return y;}
			  else {y[2]=lneg(un);y[1]=lstoi(720);return y;}
			}
		      else
			{
			  if(f) {y[2]=un;y[1]=lstoi(36);return y;}
			  else {y[2]=lneg(un);y[1]=lstoi(72);return y;}
			}
		    }
		  else prec=(prec<<2)-2;
		  break;
		  
		case 2: l2=lgef(p2[1])-3;if(l2>3) l2=6-l2;
		  switch(l2)
		    {
		    case 1: f=carreparfait(discsr(x));avma=av;y=cgetg(4,17);y[3]=un;
		      if(f) {y[2]=un;y[1]=lstoi(60);return y;}
		      else {y[2]=lneg(un);y[1]=lstoi(120);return y;}
		    case 2: f=carreparfait(discsr(x));
		      if(f) {avma=av;y=cgetg(4,17);y[3]=y[2]=un;y[1]=lstoi(24);return y;}
		      else
			{
			  p3=(lgef(p2[1])==5)?(GEN)p2[2]:(GEN)p2[1];
			  f=carreparfait(discsr(p3));avma=av;y=cgetg(4,17);y[2]=lneg(gun);
			  if(f) {y[1]=lstoi(24);y[3]=deux;return y;}
			  else {y[1]=lstoi(48);y[3]=un;return y;}
			}
		    case 3: f=carreparfait(discsr(p2[1]))||carreparfait(discsr(p2[2]));
		      avma=av;y=cgetg(4,17);y[3]=un;y[2]=lneg(gun);y[1]=lstoi(f?18:36);
		      return y;
		    }
		case 3: for(l2=1;l2<=3;l2++) if(lgef(p2[l2])>=6) p3=(GEN)p2[l2];
		  if(lgef(p3)==6)
		    {
		      f=carreparfait(discsr(p3));avma=av;y=cgetg(4,17);y[2]=lneg(gun);
		      y[3]=un;y[1]=f?lstoi(6):lstoi(12);return y;
		    }
		  else
		    {
		      f=carreparfait(discsr(x));avma=av;y=cgetg(4,17);y[3]=un;
		      if(f) {y[2]=un;y[1]=lstoi(12);return y;}
		      else {y[2]=lneg(un);y[1]=lstoi(24);return y;}
		    }
		case 4: avma=av;y=cgetg(4,17);y[1]=lstoi(6);y[2]=lneg(gun);
		  y[3]=deux;return y;
		default: err(galbug3);
		}
	    }
	  while(e1> -10);
	  
	case 7: 
	  do
	    {
	      p1=rootslong(x,prec);p4=gun;
	      for(i=1;i<=5;i++)
		for(j=i+1;j<=6;j++)
		  for(k=j+1;k<=7;k++)
		    p4=gmul(p4,gsub(polx[0],gadd(gadd(p1[i],p1[j]),p1[k])));
	      p5=grndtoi(greal(p4),&e);e=max(e,gexpo(gimag(p4)));
	      if(e> -10) prec=(prec<<2)-2;
	    }
	  while(e> -10);
	  p6=ggcd(p5,deriv(p5,0));
	  f=(typ(p6)==10)&&(lgef(p6)>3);
	  if(f) goto tchi;
	  p1=factor(p5);p2=(GEN)p1[1];l=lg(p2)-1;
	  switch(l)
	    {
	    case 1: f=carreparfait(discsr(x));avma=av;y=cgetg(4,17);y[3]=un;
	      if(f) {y[2]=un;y[1]=lstoi(2520);return y;}
	      else {y[2]=lneg(gun);y[1]=lstoi(5040);return y;}
	    case 2: f=lgef(p2[1])-3;avma=av;y=cgetg(4,17);y[3]=un;
	      if((f==7)||(f==28)) {y[2]=un;y[1]=lstoi(168);return y;}
	      else {y[2]=lneg(gun);y[1]=lstoi(42);return y;}
	    case 3: avma=av;y=cgetg(4,17);y[3]=y[2]=un;y[1]=lstoi(21);return y;
	    case 4: avma=av;y=cgetg(4,17);y[3]=un;y[2]=lneg(gun);y[1]=lstoi(14);return y;
	    case 5: avma=av;y=cgetg(4,17);y[3]=y[2]=un;y[1]=lstoi(7);return y;
	    default: err(galbug2);
	    }
	}
    tchi:
      avma=av1;x=tschirnhaus(x1);
    }
}

GEN initalg(x,prec)
     GEN x;
     long prec;
{
  GEN y,p1,p2,p3,p4,p5,p6,p7,fieldd,polr,ptrace,dx,adx,polmax,s,a,dxn,adxn,sn,phimax,ind;
  long tx=typ(x),n=lgef(x)-3,i,j,av=avma,av1,av2,av3,v,k,r1,r2,ru,imax,numb,flc,tetpil;

  if((tx!=10)||(n<=0)) err(poltyper);
  p1=content(x);p1=gcmp1(p1) ? x: gdiv(x,content(x));
  for(k=2;k<=n+2;k++) if(typ(p1[k])!=1) err(impl,"general algebraic extension");
  if(gcmp1(p2=(GEN)p1[n+2])) x=p1;
  else
    {
      x=cgetg(n+3,10);x[1]=p1[1];x[n+2]=un;x[n+1]=p1[n+1];p3=p2;
      for(k=n;k>=2;k--)
	{
	  x[k]=lmulii(p3,p1[k]);
	  if(k>2) p3=mulii(p2,p3);
	}
    }
  p1=factor(x);
  if(lgef(coeff(p1,1,1))!=n+3) err(redper1);
  r1=sturm(x);p4=allbase(x,0,&fieldd);
  if(r1<n)
    {
      polr=roots(x,prec);p3=cgetg(n+1,19);
      for(i=1;i<=n;i++)
	{
	  p1=cgetg(n+1,18);p3[i]=(long)p1;
	  for(j=1;j<=n;j++)
	    p1[j]=lsubst(p4[i],varn(p4[i]),polr[j]);
	}
      p2=greal(gmul(gconj(gtrans(p3)),p3));
    }
  else
    {
      ptrace=cgetg(n+1,17);ptrace[1]=lstoi(n);
      for(k=1;k<n;k++) 
	{
	  p3=gmulsg(k,x[n-k+2]);
	  for(i=1;i<k;i++) p3=gadd(p3,gmul(x[n-i+2],ptrace[k-i+1]));
	  ptrace[k+1]=lneg(p3);
	}
      p2=cgetg(n+1,19);
      for(i=1;i<=n;i++)
	{
	  p1=cgetg(n+1,18);p2[i]=(long)p1;
	  for(j=1;j<i;j++) p1[j]=lcopy(coeff(p2,i,j));
	  for(j=i;j<=n;j++)
	    {
	      p5=gres(gmul(p4[i],p4[j]),x);p6=gzero;
	      for(k=0;k<=lgef(p5)-3;k++) p6=gadd(p6,gmul(p5[k+2],ptrace[k+1]));
	      p1[j]=(long)p6;
	    }
	}
    }
  p1=lllgram(p2,prec);v=varn(x);dx=discsr(x);adx=absi(dx);polmax=x;imax=0;
  if(r1<n) for(s=gzero,i=1;i<=n;i++) s=gadd(s,gnorm(polr[i]));
  else s=gsub(gsqr(x[n+1]),gmul2n(x[n],1));
  a=cgetg(n+1,18);for(i=1;i<=n;i++) a[i]=lmul(p4,p1[i]);
  for(numb=0,i=1;i<=n;i++)
    {
      av1=avma;p3=gmodulcp(a[i],x);p7=content(p3[2]);
      if(gcmp1(p7)) p3=caract(p3,v);
      else
	{
	  p3=caract(gdiv(p3,p7),v);
	  p3=gmul(gpuigs(p7,lgef(p3)-3),gsubst(p3,v,gdiv(polx[v],p7)));
	}
      p5=ggcd(deriv(p3,v),p3);
      if(lgef(p5)==3)
	{
	  dxn=discsr(p3);adxn=absi(dxn);flc=gcmp(adxn,adx);numb++;
	  if(flc<=0)
	    {
	      if(r1<n) for(sn=gzero,j=1;j<=n;j++) sn=gadd(sn,gnorm(poleval(a[i],polr[j])));
	      else sn=gsub(gsqr(p3[n+1]),gmul2n(p3[n],1));
	      if(flc<0) {dx=dxn;adx=adxn;s=sn;polmax=p3;imax=i;}
	      else 
		{
		  flc=gcmp(sn,s);
		  if((flc<0)||((!flc)&&(gpolcomp(p3,polmax)<0)))
		    {dx=dxn;adx=adxn;s=sn;polmax=p3;imax=i;}
		}
	    }
	}
    }
  if(!numb) err(polreder1);
  phimax=imax?(GEN)a[imax]:polx[v];
  j=n+1;
  while((j>=2)&&(!signe(polmax[j]))) j-=2;
  if((j>=2)&&(signe(polmax[j])>0))
    {
      for(;j>=2;j-=2) setsigne(polmax[j],-signe(polmax[j]));
      phimax=gneg(phimax);
    }
  p2=lift(gsubst(p4,v,polymodrecip(gmodulcp(phimax,x))));
  p3=cgetg(n+1,19);
  for(j=1;j<=n;j++)
    {
      p4=cgetg(n+1,18);p3[j]=(long)p4;
      for(i=1;i<=n;i++) p4[i]=(long)truecoeff(p2[j],i-1);
    }
  p4=denom(p3);
  p2=gdiv(hnf(gmul(p4,p3)),p4);p3=cgetg(n+1,17);
  for(j=1;j<=n;j++) 
    {
      p1=gzero;for(i=n;i;i--) p1=gadd(coeff(p2,i,j),gmul(p1,polx[v]));
      p3[j]=(long)p1;
    }
  if(!carrecomplet(divii(dx,fieldd),&ind)) err(initalgbug1);
  p1=cgetg(n+1,19);
  for(j=1;j<=n;j++)
    {
      p2=cgetg(n+1,18);p1[j]=(long)p2;
      for(i=1;i<=n;i++) p2[i]=(long)truecoeff(p3[j],i-1);
    }
  p5=cgetg(n*n+1,19);
  for(j=1;j<=n*n;j++) p5[j]=lgetg(n+1,18);
  for(j=1;j<=n*n;j++) 
    for(i=1;i<=n;i++) 
      coeff(p5,i,j)=(long)truecoeff(gmod(gmul(p3[(j-1)%n+1],p3[((j-1)/n)+1]),polmax),i-1);
  p2=roots(polmax,prec);
  for(i=1;i<=r1;i++) p2[i]=lreal((GEN)p2[i]);
  tetpil=avma;y=cgetg(10,17);y[1]=lcopy(polmax);y[8]=(long)ginv(p1);
  y[9]=lmul((GEN)y[8],p5);p1=cgetg(3,17);
  p1[1]=lstoi(r1);p1[2]=lstoi(r2=(n-r1)>>1);y[2]=(long)p1;ru=r1+r2;
  y[3]=lcopy(fieldd);y[4]=lcopy(ind);
  p4=cgetg(n+1,19);
  for(j=1;j<=n;j++)
    {
      p6=cgetg(ru+1,18);p4[j]=(long)p6;
      for(i=1;i<=ru;i++) p6[i]=(long)gsubst((GEN)p3[j],0,(GEN)p2[max(i,(i<<1)-r1)]);
    }
  av2=avma;p7=cgetg(4,17);p7[1]=(long)p4;
  p5=cgetg(ru+1,19);
  for(j=1;j<=ru;j++)
    {
      p6=cgetg(n+1,18);p5[j]=(long)p6;
      for(i=1;i<=n;i++) 
	p6[i]=(j<=r1)?lconj(coeff(p4,j,i)):lmul2n(gconj(coeff(p4,j,i)),1);
    }
  p7[2]=(long)p5;p7[3]=(long)greal(gmul(p5,p4));av3=avma;
  y[5]=lpile(av2,av3,gcopy(p7));p4=cgetg(ru+1,17);y[6]=(long)p4;
  for(i=1;i<=ru;i++) p4[i]=lcopy((GEN)p2[max(i,(i<<1)-r1)]);
  y[7]=lcopy(p3);return gerepile(av,tetpil,y);
}

GEN initalg2(x,prec)
     GEN x;
     long prec;
{
  GEN y,p1,p2,p3,p4,p5,p6,p7,fieldd,polr,ptrace,dx,adx,polmax,s,a,dxn,adxn,sn,phimax,ind;
  long tx=typ(x),n=lgef(x)-3,i,j,av=avma,av1,v,k,r1,imax,numb,flc,tetpil;

  if((tx!=10)||(n<=0)) err(poltyper);
  p1=content(x);p1=gcmp1(p1) ? x: gdiv(x,content(x));
  for(k=2;k<=n+2;k++) if(typ(p1[k])!=1) err(impl,"general algebraic extension");
  if(gcmp1(p2=(GEN)p1[n+2])) x=p1;
  else
    {
      x=cgetg(n+3,10);x[1]=p1[1];x[n+2]=un;x[n+1]=p1[n+1];p3=p2;
      for(k=n;k>=2;k--)
	{
	  x[k]=lmulii(p3,p1[k]);
	  if(k>2) p3=mulii(p2,p3);
	}
    }
  p1=factor(x);
  if(lgef(coeff(p1,1,1))!=n+3) err(redper1);
  r1=sturm(x);p4=allbase(x,0,&fieldd);
  if(r1<n)
    {
      polr=roots(x,prec);p3=cgetg(n+1,19);
      for(i=1;i<=n;i++)
	{
	  p1=cgetg(n+1,18);p3[i]=(long)p1;
	  for(j=1;j<=n;j++)
	    p1[j]=lsubst(p4[i],varn(p4[i]),polr[j]);
	}
      p2=greal(gmul(gconj(gtrans(p3)),p3));
    }
  else
    {
      ptrace=cgetg(n+1,17);ptrace[1]=lstoi(n);
      for(k=1;k<n;k++) 
	{
	  p3=gmulsg(k,x[n-k+2]);
	  for(i=1;i<k;i++) p3=gadd(p3,gmul(x[n-i+2],ptrace[k-i+1]));
	  ptrace[k+1]=lneg(p3);
	}
      p2=cgetg(n+1,19);
      for(i=1;i<=n;i++)
	{
	  p1=cgetg(n+1,18);p2[i]=(long)p1;
	  for(j=1;j<i;j++) p1[j]=lcopy(coeff(p2,i,j));
	  for(j=i;j<=n;j++)
	    {
	      p5=gres(gmul(p4[i],p4[j]),x);p6=gzero;
	      for(k=0;k<=lgef(p5)-3;k++) p6=gadd(p6,gmul(p5[k+2],ptrace[k+1]));
	      p1[j]=(long)p6;
	    }
	}
    }
  p1=lllgram(p2,prec);v=varn(x);dx=discsr(x);adx=absi(dx);polmax=x;imax=0;
  if(r1<n) for(s=gzero,i=1;i<=n;i++) s=gadd(s,gnorm(polr[i]));
  else s=gsub(gsqr(x[n+1]),gmul2n(x[n],1));
  a=cgetg(n+1,18);for(i=1;i<=n;i++) a[i]=lmul(p4,p1[i]);
  for(numb=0,i=1;i<=n;i++)
    {
      av1=avma;p3=gmodulcp(a[i],x);p7=content(p3[2]);
      if(gcmp1(p7)) p3=caract(p3,v);
      else
	{
	  p3=caract(gdiv(p3,p7),v);
	  p3=gmul(gpuigs(p7,lgef(p3)-3),gsubst(p3,v,gdiv(polx[v],p7)));
	}
      p5=ggcd(deriv(p3,v),p3);
      if(lgef(p5)==3)
	{
	  dxn=discsr(p3);adxn=absi(dxn);flc=gcmp(adxn,adx);numb++;
	  if(flc<=0)
	    {
	      if(r1<n) for(sn=gzero,j=1;j<=n;j++) sn=gadd(sn,gnorm(poleval(a[i],polr[j])));
	      else sn=gsub(gsqr(p3[n+1]),gmul2n(p3[n],1));
	      if(flc<0) {dx=dxn;adx=adxn;s=sn;polmax=p3;imax=i;}
	      else 
		{
		  flc=gcmp(sn,s);
		  if((flc<0)||((!flc)&&(gpolcomp(p3,polmax)<0)))
		    {dx=dxn;adx=adxn;s=sn;polmax=p3;imax=i;}
		}
	    }
	}
    }
  if(!numb) err(polreder1);
  phimax=imax?(GEN)a[imax]:polx[v];
  j=n+1;
  while((j>=2)&&(!signe(polmax[j]))) j-=2;
  if((j>=2)&&(signe(polmax[j])>0))
    {
      for(;j>=2;j-=2) setsigne(polmax[j],-signe(polmax[j]));
      phimax=gneg(phimax);
    }
  p2=gmodulcp(phimax,x);
  tetpil=avma;return gerepile(av,tetpil,polymodrecip(p2));
}

GEN galoisconj2(x,prec)
     GEN x;
     long prec;
{
  long av=avma,tetpil,i,j,n,v;
  GEN y,w,polr,p1,p2,b,di;

  if(typ(x)!=10) err(galer1);
  n=lgef(x)-3;if(n<=0) err(galer1);
  v=varn(x);p1=factor(x);
  if((lg(p1[1])>2)||(!gcmp1(coeff(p1,1,2)))) err(galcer1);
  polr=roots(x,prec);p1=(GEN)polr[1];b=allbase(x,0,&di);
  w=cgetg(n+1,17);w[1]=un;for(i=2;i<=n;i++) w[i]=(long)gsubst(b[i],v,p1);
  y=cgetg(n+1,17);y[1]=(long)polx[v];
  for(i=2;i<=n;i++)
    {
      p1=lindep(concat(w,polr[i]),prec);
      if(gcmp0(p1[n+1])) y[i]=zero;
      else
	{
	  p2=gzero;
	  for(j=1;j<=n;j++) p2=gadd(p2,gmul(p1[j],b[j]));
	  p2=gdiv(p2,gneg(p1[n+1]));
	  if(gcmp0(gmod(gsubst(x,v,p2),x))) y[i]=(long)p2;else y[i]=zero;
	}
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN galoisconj(x,prec)
     GEN x;
     long prec;
{
  long av=avma,tetpil,i,j,n,v;
  GEN y,w,polr,p1,p2;

  if(typ(x)!=10) err(galer1);
  n=lgef(x)-3;if(n<=0) err(galer1);
  v=varn(x);p1=factor(x);
  if((lg(p1[1])>2)||(!gcmp1(coeff(p1,1,2)))) err(galcer1);
  polr=roots(x,prec);p1=(GEN)polr[1];
  w=cgetg(n+1,17);w[1]=un;for(i=2;i<=n;i++) w[i]=lmul(p1,w[i-1]);
  y=cgetg(n+1,17);y[1]=(long)polx[v];
  for(i=2;i<=n;i++)
    {
      p1=lindep(concat(w,polr[i]),prec);
      if(gcmp0(p1[n+1])) y[i]=zero;
      else
	{
	  p2=gzero;
	  for(j=n;j;j--) p2=gadd(p1[j],gmul(p2,polx[v]));
	  p2=gdiv(p2,gneg(p1[n+1]));
	  if(gcmp0(gmod(gsubst(x,v,p2),x))) y[i]=(long)p2;else y[i]=zero;
	}
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

/*******************************************************************

Operations sur les elements et ideaux de corps de nombres.
Un element sera represente par un vecteur colonne dans la base d'entiers nf[7].
Un ideal premier est represente par [p,a,e,f,b] ou l'ideal est p.Z_K+a.Z_K, ou
a est un element de Z_K, e l'indice de ramification, f le degre residuel et b
l'element de Z_K "constante de Lenstra".
Un ideal sera represente par un couple [M,V] ou M est une HNF de l'ideal dans
la base d'entiers, et V un vecteur ligne a r1+r2 composantes complexes
representant la "partie archimedienne" de l'ideal (considere alors comme
idele). Par exemple, si l'ideal est principal
engendre par a, V contiendra le vecteur des log complexes des r1+r2 premiers
conjugues de a (ceci depend bien sur de a et pas seulement de l'ideal).
Les programmes marchent aussi si seulement M est fourni. 

********************************************************************/

GEN rootsof1(nf)
     GEN nf;
{
  long av=avma,tetpil,N,ld,fl,k,i,j;
  GEN algun,p1,y,R1,d,list,w;

  if((typ(nf)!=17)||(lg(nf)<10)) err(rootofer1);
  N=lgef(nf[1])-3;R1=(GEN)((GEN)nf[2])[1];
  algun=(GEN)((GEN)nf[8])[1];
  if(signe(R1)) 
    {
      avma=av;y=cgetg(3,17);y[1]=deux;y[2]=lneg(algun);
      return y;
    }
  y=minim((GEN)((GEN)nf[5])[3],N,1000);
  if(itos((GEN)y[2])!=N) err(rootofer2);
  w=(GEN)y[1];
  if(!cmpii(w,gdeux)) 
    {
      avma=av;y=cgetg(3,17);y[1]=deux;y[2]=lneg(algun);
      return y;
    }
  d=divisors(w);ld=lg(d)-1;
  list=(GEN)y[3];k=lg(list);fl=1;
  for(i=1;(i<k)&&fl;i++)
    {
      p1=(GEN)list[i];j=1;
      while((j<ld-1)&&(!gegal(element_pow(nf,p1,d[j]),algun))) j++;
      if(j<ld-1) p1=gneg(p1);j=1;
      while((j<ld-1)&&(!gegal(element_pow(nf,p1,d[j]),algun))) j++;
      fl=(j<ld-1);
    }
  if(fl) err(talker,"bug2 in rootsof1, please report");
  tetpil=avma;y=cgetg(3,17);y[1]=lcopy(w);y[2]=lcopy(p1);
  return gerepile(av,tetpil,y);
}

GEN primedec(nf,p)
     GEN nf,p;
/* Recoit un corps de nombres nf et un premier p,ressort une liste 
 des ideaux premiers au dessus de p dans le format vu plus haut*/

{
  long av=avma,tetpil,i,j,k,kbar,l3,l,np,c,i1,i2,indice,N;
  GEN f,list,list2,klist,jlist,hlist,ip,elementh,hensemble;
  GEN algebre,algebre1,b,b2,mat1,mat2,identmodp;
  GEN alpha,beta1,beta2,p1,p2,p3,unmodp,zmodp,vecteur,pol,gpol;
  GEN T=(GEN)nf[1],pidmat;

  if((typ(nf)!=17)||(lg(nf)<10)) err(talker,"not a number field in primedec");
  N=lgef(T)-3;
  if(signe(modii((GEN)nf[4],p)))
    {
      f=centerlift(factmod(T,p));np=lg(f[1]);
      list=cgetg(np,17);
      for(i=1;i<np;i++)
	{
	  p1=(GEN)list[i]=cgetg(6,17);
	  p1[1]=(long)p;p3=(GEN)coeff(f,i,1);l3=lgef(p3)-1;
	  p2=cgetg(N+1,18);
	  if(l3==(N+2)) 
	    {
	      p1[2]=(long)p2;p1[3]=un;p1[4]=lstoi(N);
	      p3=cgetg(N+1,18);p1[5]=(long)p3;p3[1]=un;
	      p2[1]=zero;for(j=2;j<=N;j++) p3[j]=p2[j]=zero;
	    }
	  else
	    {
	      for(j=1;j<l3;j++) p2[j]=p3[j+1];
	      for(j=l3;j<=N;j++) p2[j]=zero;
	      p1[2]=lmul((GEN)nf[8],p2);
	      p1[3]=coeff(f,i,2);
	      p1[4]=lstoi(l3-2);p1[5]=(long)lens(nf,p,(GEN)p1[2]);
	    }
	}
      tetpil=avma;return gerepile(av,tetpil,gcopy(list));
    }
  else 
    {
      list=cgetg(N+1,17);for(i=1;i<=N;i++) list[i]=lgetg(6,17);
      ip=pradical(nf,p);
      unmodp=gmodulcp(gun,p);zmodp=gmodulo(gzero,p);
      identmodp=gmul(unmodp,idmat(N));pidmat=gscalmat(p,N);
      c=0;indice=0;
      vecteur=(GEN)(identmodp[1]);
      hensemble=cgetg(N+1,17); 
      if(lg(ip)<N+1) {c=1;hensemble[1]=(long)ip;}
      while(c!=0)
        {  
           elementh=(GEN)(hensemble[c]);k=lg(elementh)-1;kbar=N-k;
           algebre=gmul(unmodp,suppl(concat(elementh,vecteur)));
           algebre1=cgetg(kbar+1,19);
           for(i1=1;i1<=kbar;i1++) algebre1[i1]=algebre[i1+k];
           b=cgetg(kbar+1,19);
           for(i1=1;i1<=kbar;i1++)
             b[i1]=(long)(gsub(element_pow(nf,algebre1[i1],p),algebre1[i1]));
           b2=inverseimage(algebre,b);
           mat1=cgetg(kbar+1,19);
           for(i1=1;i1<=kbar;i1++) mat1[i1]=lgetg(kbar+1,18);
           for(i1=1;i1<=kbar;i1++)
             for(i2=1;i2<=kbar;i2++)
               coeff(mat1,i2,i1)=coeff(b2,k+i2,i1);
           mat1=gmul(unmodp,ker(mat1));
           if(lg(mat1)>2)
             {
                alpha=gmul(algebre1,mat1[2]);
                pol=pol_min(alpha,nf,p,algebre,algebre1);
                setvarn(pol,0);
                for(i1=0;!gegal(gsubst(pol,0,stoi(i1)),zmodp);i1++); 
                p1=gmul(unmodp,gaddgs(polx[0],-i1));p2=gdiv(pol,p1);
                beta1=eval_pol(nf,p1,alpha,p,algebre,algebre1);
                beta2=eval_pol(nf,p2,alpha,p,algebre,algebre1);
                mat1=cgetg(k+N+1,19);mat2=cgetg(k+N+1,19);
                for(i1=1;i1<=k;i1++)
                  {
                     mat1[i1]=elementh[i1];
                     mat2[i1]=elementh[i1];
                  }
                for(i1=1;i1<=N;i1++)
                  {
                     mat1[k+i1]=(long)(element_mul(nf,identmodp[i1],beta1));
                     mat2[k+i1]=(long)(element_mul(nf,identmodp[i1],beta2));
                  }
                hensemble[c]=(long)(image(mat1));
                c++;hensemble[c]=(long)(image(mat2));
             }
           else
             {
                indice++;p1=(GEN)list[indice];
                p1[1]=(long)p;p1[4]=lstoi(kbar);
                p1[2]=(long)two_elt(nf,p,elementh);
                p1[5]=(long)lens(nf,p,(GEN)p1[2]);
		p1[3]=lstoi(idealval(nf,pidmat,p1));
                c--;
	     }
        }
      tetpil=avma;list2=cgetg(indice+1,17);
      for(i=1;i<=indice;i++) list2[i]=lcopy(list[i]);
      return gerepile(av,tetpil,list2);
    }
}

GEN element_mul(nf,x,y)
     GEN nf,x,y;
/* Recoit deux vecteurs de longueur N representant x et y dans la base 
 d'entiers (peut etre modulo p) et ressort leur produit sous forme d'un
 vecteur */

{
  long av=avma,tetpil,i,j,k,N=lgef((GEN)nf[1])-3;
  GEN s,v,c;

  v=cgetg(N+1,18);
  for(k=1;k<=N;k++)
    {
      s=gzero;
      for(i=1;i<=N;i++)
	{
	  c=(GEN)coeff((GEN)nf[9],k,(i-1)*N+i);
	  if(signe(c))
	    {
	      if(gcmp1(c)) s=gadd(s,gmul(x[i],y[i]));
	      else s=gadd(s,gmul(gmul(x[i],y[i]),c));
	    }
	  for(j=i+1;j<=N;j++)
	    s=gadd(s,gmul(gadd(gmul(x[i],y[j]),gmul(x[j],y[i])),coeff((GEN)nf[9],k,(i-1)*N+j)));
	}
      v[k]=(long)s;
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(v));
}

GEN element_muli(nf,x,y)
     GEN nf,x,y;
/* Recoit deux vecteurs de longueur N representant x et y dans la base 
 d'entiers (uniquement coeff entiers) et ressort leur produit sous forme d'un
 vecteur */

{
  long av=avma,tetpil,i,j,k,N=lgef((GEN)nf[1])-3;
  GEN s,v,c;

  v=cgetg(N+1,18);
  for(k=1;k<=N;k++)
    {
      s=gzero;
      for(i=1;i<=N;i++)
	{
	  c=(GEN)coeff((GEN)nf[9],k,(i-1)*N+i);
	  if(signe(c))
	    {
	      if(gcmp1(c)) s=addii(s,mulii(x[i],y[i]));
	      else s=addii(s,mulii(mulii(x[i],y[i]),c));
	    }
	  for(j=i+1;j<=N;j++)
	    {
	      c=(GEN)coeff((GEN)nf[9],k,(i-1)*N+j);
	      if(signe(c))
		{
		  if(gcmp1(c)) s=addii(s,addii(mulii(x[i],y[j]),mulii(x[j],y[i])));
		  else s=addii(s,mulii(addii(mulii(x[i],y[j]),mulii(x[j],y[i])),c));
		}
	    }
	}
      v[k]=(long)s;
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(v));
}

GEN element_mulh(nf,limi,limj,x,y)
     GEN nf,x,y;
     long limi,limj;

/* Recoit deux vecteurs de longueur N representant x et y dans la base 
 d'entiers (uniquement coeff entiers) et ressort leur produit sous forme d'un
 vecteur */

{
  long av=avma,tetpil,i,j,k,N=lgef((GEN)nf[1])-3;
  GEN s,v,c;

  if(limi<limj) {i=limi;limi=limj;limj=i;s=x;x=y;y=s;}
  v=cgetg(N+1,18);
  for(k=1;k<=N;k++)
    {
      s=gzero;
      for(i=1;i<=limj;i++)
	{
	  c=(GEN)coeff((GEN)nf[9],k,(i-1)*N+i);
	  if(signe(c))
	    {
	      if(gcmp1(c)) s=addii(s,mulii(x[i],y[i]));
	      else s=addii(s,mulii(mulii(x[i],y[i]),c));
	    }
	  for(j=i+1;j<=limj;j++)
	    {
	      c=(GEN)coeff((GEN)nf[9],k,(i-1)*N+j);
	      if(signe(c))
		{
		  if(gcmp1(c)) s=addii(s,addii(mulii(x[i],y[j]),mulii(x[j],y[i])));
		  else s=addii(s,mulii(addii(mulii(x[i],y[j]),mulii(x[j],y[i])),c));
		}
	    }
	}
      for(i=limj+1;i<=limi;i++)
	{
	  for(j=1;j<=limj;j++)
	    {
	      c=(GEN)coeff((GEN)nf[9],k,(i-1)*N+j);
	      if(signe(c))
		{
		  if(gcmp1(c)) s=addii(s,mulii(x[i],y[j]));
		  else s=addii(s,mulii(mulii(x[i],y[j]),c));
		}
	    }
	}
      v[k]=(long)s;
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(v));
}

GEN element_sqr(nf,x)
     GEN nf,x;
/* Recoit un vecteurs de longueur N representant x dans la base 
 d'entiers et ressort son carre sous forme d'un
 vecteur */

{
  long av=avma,tetpil,i,j,k,N=lgef((GEN)nf[1])-3;
  GEN s,v,c;

  v=cgetg(N+1,18);
  for(k=1;k<=N;k++)
    {
      s=gzero;
      for(i=1;i<=N;i++)
	{
	  c=(GEN)coeff((GEN)nf[9],k,(i-1)*N+i);
	  if(signe(c))
	    {
	      if(gcmp1(c)) s=gadd(s,gmul(x[i],x[i]));
	      else s=gadd(s,gmul(gmul(x[i],x[i]),c));
	    }
	  for(j=i+1;j<=N;j++)
	    {
	      c=(GEN)coeff((GEN)nf[9],k,(i-1)*N+j);
	      if(signe(c))
		{
		  if(gcmp1(c)) s=gadd(s,gmul2n(gmul(x[i],x[j]),1));
		  else s=gadd(s,gmul(gmul(x[i],x[j]),shifti(c,1)));
		}
	    }
	}
      v[k]=(long)s;
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(v));
}

GEN element_pow(nf,x,k)
     GEN nf,x,k;
/* Calcule x^k dans le corps de nombres nf */

{
  long i,f,av=avma,tetpil,N=lgef((GEN)nf[1])-3;
  GEN k1,y,z;

  k1=k;z=x;f=1;y=cgetg(N+1,18);
  for(i=2;i<=N;i++) y[i]=zero;
  y[1]=un;
  while(f)
    {
      if(mpodd(k1)) y=element_mul(nf,z,y);
      k1=shifti(k1,-1);f=signe(k1);
      if(f) z=element_sqr(nf,z);
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN pradical(nf,p)
     GEN nf,p;
/* Calcule une F_p base du p-radical de Z_K,i.e une
 matrice N fois r (r=dimension sur F_p du p-radical) */

{
  long av=avma,tetpil,j,f,k,N=lgef((GEN)nf[1])-3;
  GEN p1,unmodp,zmodp,x,m;

  p1=p;while(cmpis(p1,N)<0) p1=mulii(p1,p);
  m=cgetg(N+1,19);
  unmodp=gmodulcp(gun,p);zmodp=gmul(gzero,unmodp);
  for(k=1;k<=N;k++)
    {
      x=cgetg(N+1,18);
      for(j=1;j<=N;j++) x[j]=(long)zmodp;
      x[k]=(long)unmodp;
      m[k]=(long)element_pow(nf,x,p1);
    }
  tetpil=avma;return gerepile(av,tetpil,gmul(unmodp,ker(m)));
}

      
GEN pol_min(alpha,nf,p,algebre,algebre1)
     GEN alpha,nf,p,algebre,algebre1;
/* Calcule le polynome minimal de alpha dans algebre (polynome a
 coefficients dans F_p) */

{
   long av=avma,tetpil,i,j,N=lgef((GEN)nf[1])-3,k=N-lg(algebre1)+1;
   GEN puiss,puiss2,noyau,unmodp,zmodp,vecteur;

   unmodp=gmodulcp(gun,p);zmodp=gmul(unmodp,gzero);
   vecteur=gmul(unmodp,idmat(N)[k+1]);
   puiss=cgetg(N+2,19);puiss[1]=(long)vecteur;
   for(i=1;i<=N;i++)
     puiss[i+1]=(long)(inverseimage(algebre,element_pow(nf,alpha,stoi(i))));
   puiss2=cgetg(N+2,19);
   for(i=1;i<=N+1;i++)
     {
       puiss2[i]=lgetg(N-k+1,18);
       for(j=1;j<=N-k;j++)
         coeff(puiss2,j,i)=coeff(puiss,k+j,i);
     }
   noyau=gmul(ker(puiss2),unmodp);
   tetpil=avma;return gerepile(av,tetpil,gtopolyrev(noyau[1],0));
}

GEN eval_pol(nf,pol,alpha,p,algebre,algebre1)
     GEN nf,pol,alpha,algebre,algebre1;
/* Evalue le polynome pol en alpha,element de nf */

{
   long av=avma,tetpil,i,N=lgef((GEN)nf[1])-3,k=N-lg(algebre1)+1;
   GEN res,valeur,unmodp,zmodp;

   res=cgetg(N+1,18);
   unmodp=gmodulcp(gun,p);zmodp=gmul(unmodp,gzero);
   for(i=2;i<=N;i++) res[i]=(long)zmodp;
   res[1]=(long)unmodp;
   res=gmul(res,(GEN)pol[2]);
   for(i=1;i<=lgef(pol)-3;i++)
     res=gadd(res,gmul((GEN)pol[i+2],element_pow(nf,alpha,stoi(i))));
   res=inverseimage(algebre,res);
   valeur=cgetg(N-k+1,18);
   for(i=1;i<=N-k;i++) valeur[i]=res[k+i];
   tetpil=avma;return gerepile(av,tetpil,gmul(algebre1,valeur));
}


GEN    kerlensold(x)     
     GEN  x;
     
{
  GEN c,d,y,mun,p;
  long i,j,k,r,t,n,n1,m,av,av1;
  
  n1=lg(x);n=n1-1;
  av=avma;mun=gneg(un);r=0;
  c=cgeti(n1);for(k=1;k<=n;k++) c[k]=0;
  d=cgeti(n1);
  for(k=1;(k<=n)&&(!r);k++)
    {
      j=1;
      while((j<=n)&&(c[j]||gcmp0(coeff(x,j,k)))) j++;
      if (j<=n)
	{
	  p=gdivsg(-1,coeff(x,j,k));
	  coeff(x,j,k)=(long)mun;
	  for(i=k+1;i<=n;i++) coeff(x,j,i)=lmul(p,coeff(x,j,i));
	  for(t=1;t<=n;t++)
	    if(t!=j)
	      {
		p=(GEN)coeff(x,t,k);
		for(i=k+1;i<=n;i++) coeff(x,t,i)=ladd(coeff(x,t,i),gmul(p,coeff(x,j,i)));
		coeff(x,t,k)=zero;
	      }
	  c[j]=k;d[k]=j;
	}		  
      else {r++;d[k]=0;}
    }
  av1=avma;
  p=cgetg(n1,18);j=k=1;
  while(d[k]) k++;
  for(i=1;i<k;i++) p[i]=d[i]? (long)lift(coeff(x,d[i],k)):zero;
  p[k]=un;for(i=k+1;i<=n;i++) p[i]=zero;
  return gerepile(av,av1,p);
}

GEN kerlens(x,pgen) GEN x,pgen;
{
  long i,j,k,t,nbc,nbl,p,q,*c,*l,*d,**a;
  GEN y;

  p=itos(pgen);
  nbl=nbc=lg(x)-1;
  a=(long**)malloc((nbc+1)<<2);
  for(j=1;j<=nbc;j++)
    {
      c=a[j]=(long*)malloc((nbl+1)<<2);
      for(i=1;i<=nbl;i++) c[i]=itos(modis(coeff(x,i,j),p));
    }
  c=(long*)malloc((nbl+1)<<2);
  l=(long*)malloc((nbc+1)<<2);
  d=(long*)malloc((nbc+1)<<2);
  for(i=1;i<=nbl;i++) c[i]=0;
  k=1;t=1;
  while((t<=nbl)&&(k<=nbc))
    {
      for(j=1;j<k;j++)
	for(i=1;i<=nbl;i++)
	  if(i!=l[j]) a[k][i]=(d[j]*a[k][i]-a[j][i]*a[k][l[j]]) % p;
      t=1;while((t<=nbl)&&((c[t])||(!a[k][t]))) t++;
      if (t<=nbl) {d[k]=a[k][t];c[t]=k;l[k++]=t;}
    }
  if(k>nbc) err(talker,"bug in kerlens, please report");
  y=cgetg(nbc+1,18);
  t=a[k][l[1]];y[1]=(t>0)? lstoi(t):lstoi(t+p);
  for(q=1,j=2;j<k;j++)
    {
      q=q*d[j-1];
      t=(a[k][l[j]]*q)%p;
      y[j]=(t>0)? lstoi(t):lstoi(t+p);
    }
  t=(q*d[k-1]) %p;
  y[k]=(t>0)? lstoi(p-t):lstoi(-t);
  for(j=k+1;j<=nbc;j++) y[j]=zero;
  free(c);free(l);free(d);
  for(j=1;j<=nbc;j++) free(a[j]);free(a);
  return y;
}

GEN lens(nf,p,a)
     GEN nf,p,a;
/* Calcule la constante de lenstra de l'ideal p.Z_K+a.Z_K ou a est un
vecteur sur la base d'entiers */

{
   long av=avma,tetpil,N=lgef((GEN)nf[1])-3,j;
   GEN id,mat,unmodp,y;

   id=idmat(N);unmodp=gmodulcp(gun,p);
   mat=cgetg(N+1,19);for(j=1;j<=N;j++) mat[j]=(long)element_muli(nf,id[j],a);
/*   y=gmul(unmodp,mat);tetpil=avma;
   return gerepile(av,tetpil,kerlens(y));  */
   y=kerlens(mat,p);
   tetpil=avma;
   return gerepile(av,tetpil,gcopy(y));
}

GEN two_elt(nf,p,ideal)
     GEN nf,p,ideal;
/* Recoit un ideal (mod p) et calcule une representation a deux
 elements (ideal non egal a Z_K) */

{
   long av=avma,tetpil,N=lgef((GEN)nf[1])-3,m,r,i,j,k;
   GEN beta,alpha,lambda,norme,pf;
      
   k=lg(ideal)-1;pf=gpuigs(p,N-k);r=1;
   alpha=cgetg(N+1,18);
   beta=concat(gscalmat(p,N),lift(ideal));
   m=lg(beta)-1;lambda=cgeti(m+1);
   for(i=1;i<=m;i++) lambda[i]=r;
   do
     {
        for(i=1;i<=N;i++) alpha[i]=zero;
        for(i=1;i<=m;i++) alpha=gadd(alpha,gmulsg(lambda[i],beta[i]));
        norme=gnorm(gmodulcp(gmul((GEN)nf[7],alpha),(GEN)nf[1]));
        if(gcmp0(gmod(gdiv(norme,pf),p)))
          {
             for(j=m;(lambda[j]+r)==0;j--);
             lambda[j]--;
             for(i=j+1;i<=m;i++) lambda[i]=r;
             for(j=1;(j<m)&&(!lambda[j]);j++);
             if(!lambda[j]) {r++;for(i=1;i<=m;i++) lambda[i]=r;}
	  }
     }
   while(gcmp0(gmod(gdiv(norme,pf),p)));
   tetpil=avma;return gerepile(av,tetpil,gcopy(alpha));
}

GEN idealmul(nf,ix,iy)
     GEN nf,ix,iy;
/* recoit deux ideaux ix et iy comme ci-dessus avec ou sans leur composante
archimedienne et ressort leur produit sans le reduire */

{
  long av=avma,f,tetpil,rx,ry,i,j;
  GEN m,x,y;

  if((typ(nf)!=17)||(lg(nf)<10)) err(talker,"not a number field in idealmul");
  if((typ(ix)==17)&&(typ(iy)==17))
    {
      if((lg(ix)!=3)||(lg(iy)!=3)) err(talker,"not ideals in idealmul");
      else {f=1;x=(GEN)ix[1];y=(GEN)iy[1];}
    }
  else {f=0;x=ix;y=iy;}
  if((typ(x)!=19)||(typ(y)!=19)) err(talker,"not ideals in idealmul");
  rx=lg(x)-1;ry=lg(y)-1;
  m=cgetg(rx*ry+1,19);
  for(i=1;i<=rx;i++)
    for(j=1;j<=ry;j++)
      m[(i-1)*ry+j]=(long)element_muli(nf,x[i],y[j]);
  tetpil=avma;
  if(f) {y=cgetg(3,17);y[1]=(long)hnf(m);y[2]=ladd((GEN)ix[2],(GEN)iy[2]);}
  else y=hnf(m);
  return gerepile(av,tetpil,y);
}

GEN idealmulh(nf,ix,iy)
     GEN nf,ix,iy;
/* recoit deux ideaux ix et iy comme ci-dessus avec ou sans leur composante
archimedienne et ressort leur produit sans le reduire. On suppose les ideaux
sous forme HNF et de meme taille. A usage interne donc aucune verification. */

{
  long av=avma,f,tetpil,N,i,j;
  GEN m,x,y;

  if((typ(ix)==17)&&(typ(iy)==17)) {f=1;x=(GEN)ix[1];y=(GEN)iy[1];}
  else {f=0;x=ix;y=iy;}
  N=lg(x)-1;m=cgetg(N*N+1,19);
  for(i=1;i<=N;i++)
    for(j=1;j<=N;j++)
      m[(N-i)*N+j]=(long)element_mulh(nf,i,j,x[i],y[j]);
  tetpil=avma;
  if(f) {y=cgetg(3,17);y[1]=(long)fasthnf(m);y[2]=ladd((GEN)ix[2],(GEN)iy[2]);}
  else y=fasthnf(m);
  return gerepile(av,tetpil,y);
}

GEN idealmulprime(nf,ix,vp)
     GEN nf,ix,vp;
/* recoit un ideal ix et un ideal premier vp en format
primedec et ressort leur produit */

{
  long av=avma,tetpil,rx,i,f;
  GEN m,x,y;

  if((typ(nf)!=17)||(lg(nf)<10)) err(talker,"not a number field in idealmulprime");
  if((typ(vp)!=17)||(lg(vp)!=6)) err(talker,"not a prime ideal in idealmulprime");
  if((typ(ix)==17)&&(lg(ix)==3)) {f=1;x=(GEN)ix[1];} else {f=0;x=ix;}
  if(typ(x)!=19) err(talker,"not an ideal in idealmulprime");
  rx=lg(x)-1;
  m=cgetg((rx<<1)+1,19);
  for(i=1;i<=rx;i++) m[i]=(long)element_muli(nf,vp[2],x[i]);
  for(i=rx+1;i<=(rx<<1);i++) m[i]=lmul((GEN)vp[1],(GEN)x[i-rx]);
  tetpil=avma;
  if(f) {y=cgetg(3,17);y[1]=(long)fasthnf(m);y[2]=lcopy(ix[2]);}
  else y=fasthnf(m);
  return gerepile(av,tetpil,y);
}

long idealval(nf,ix,vp)
     GEN nf,ix,vp;
/* recoit un ideal entier ix et un ideal premier vp dans le format
donne par primedec et calcule la valuation de ix en vp */

{
  long N,v,w,av=avma,i,j,bo;
  GEN mat,x,d,bp,p=(GEN)vp[1],p1,r;

  if((typ(nf)!=17)||(lg(nf)<10)) err(talker,"not a number field in idealval");
  if((typ(vp)!=17)||(lg(vp)!=6)) err(talker,"not a prime ideal in idealval");
  if((typ(ix)==17)&&(lg(ix)==3)) x=(GEN)ix[1]; else x=ix;
  if(typ(x)!=19) err(talker,"not an ideal in idealval");
  N=lg(x[1])-1;for(d=gun,i=1;i<=N;i++) d=mulii(d,(GEN)coeff(x,i,i));
  v=ggval(d,p);if(!v) return 0;
  bo=0;w=0;bp=(GEN)vp[5];
  do
    {
      if(w) {for(i=1;i<=N;i++) mat[i]=(long)element_muli(nf,mat[i],bp);}
      else 
	{
	  mat=cgetg(N+1,19);
	  for(i=1;i<=N;i++) mat[i]=(long)element_mulh(nf,i,N,x[i],bp);
	}
      if(divise(coeff(mat,N,N),p))
	{
	  for(j=1;j<=N;j++)
	    for(i=1;i<=N;i++)
	      {
		p1=dvmdii(coeff(mat,i,j),p,&r);
		if(signe(r)) goto labeliv; else coeff(mat,i,j)=(long)p1;
	      }
	  w++;
	}
      else bo=1;
    }
  while((bo==0)&&(w<v));
 labeliv:
  avma=av;return w;
}

GEN ideallllred(nf,ix,vdir,prec)
     GEN nf,ix,vdir;
     long prec;
{
  long N=lgef((GEN)nf[1])-3,av=avma,tetpil,i,j,f,r1,r2,ru;
  GEN T,p1,p2,p3,y,alpha,beta,x,x2,r,v,z;

  if((typ(nf)!=17)||(lg(nf)<10)) err(talker,"not a number field in ideallllred");
  if((!gcmp0(vdir))&&(typ(vdir)!=17)) err(talker,"not a vector in ideallllred");
  if((typ(ix)==17)&&(lg(ix)==3)) {f=1;x=(GEN)ix[1];} else {f=0;x=ix;}
  if(typ(x)!=19) err(talker,"not an ideal in ideallllred");
  p1=(GEN)coeff(x,N,N);
  if(!gcmp1(p1)) {p1=content(x);if(!gcmp1(p1)) x=gdiv(x,p1);}
  p1=(GEN)nf[2];r2=itos((GEN)p1[2]);ru=N-r2;r1=ru-r2;p1=(GEN)nf[5];
  if(!gcmp0(vdir))
    {
      p3=(GEN)p1[2];p2=cgetg(ru+1,19);
      for(j=1;j<=ru;j++) p2[j]=lmul2n((GEN)p3[j],itos((GEN)vdir[j])<<1);
      p1=greal(gmul(p2,(GEN)p1[1]));
    }
  else p1=(GEN)p1[3];
  y=gmul(x,(GEN)(lllgram(gmul(gtrans(x),gmul(p1,x)),2*prec)[1]));
  for(i=2;(i<=N)&&gcmp0((GEN)y[i]);i++);
  if(i>N) 
    {
      tetpil=avma;
      if(f) {y=cgetg(3,17);y[1]=lcopy(x);y[2]=lcopy((GEN)ix[2]);}
      else y=gcopy(x);
      return gerepile(av,tetpil,y);
    }
  T=(GEN)nf[1];alpha=gmodulcp(gmul((GEN)nf[7],y),T);
  beta=lift(gdiv(gnorm(alpha),alpha));
/*  output(factor(gnorm(alpha)));fflush(stdout); */
  z=gmul(((GEN)(nf[5]))[1],y);
  p1=cgetg(N+1,18);for(i=1;i<=N;i++) p1[i]=(long)truecoeff(beta,i-1);
  p1=gmul((GEN)nf[8],p1);p2=cgetg(N+1,19);
  for(i=1;i<=N;i++) p2[i]=(long)element_muli(nf,p1,(GEN)x[i]);
  p1=content(p2);if(!gcmp1(p1)) p2=gdiv(p2,p1);
  if(f)
    {
      r=(GEN)nf[6];x2=(GEN)ix[2];v=cgetg(ru+1,17);
      for(i=1;i<=r1;i++) v[i]=(long)glog(z[i],prec);
      for(i=r1+1;i<=ru;i++) v[i]=lmul2n(glog(z[i],prec),1);
      tetpil=avma;y=cgetg(3,17);y[1]=(long)hnf(p2);p1=cgetg(ru+1,17);
      y[2]=(long)p1;for(i=1;i<=ru;i++) p1[i]=lsub((GEN)x2[i],(GEN)v[i]);
    }
  else {tetpil=avma;y=hnf(p2);}
  return gerepile(av,tetpil,y);
}

GEN minideal(nf,ix,vdir,prec)
     GEN nf,ix,vdir;
     long prec;
{
  long N=lgef((GEN)nf[1])-3,av=avma,tetpil,i,j,f,r1,r2,ru;
  GEN T,p1,p2,p3,y,alpha,beta,x,x2,r,v,z;

  if((typ(nf)!=17)||(lg(nf)<10)) err(talker,"not a number field in minideal");
  if((!gcmp0(vdir))&&(typ(vdir)!=17)) err(talker,"not a vector in minideal");
  if((typ(ix)==17)&&(lg(ix)==3)) {f=1;x=(GEN)ix[1];} else {f=0;x=ix;}
  if(typ(x)!=19) err(talker,"not an ideal in minideal");
  p1=(GEN)nf[2];r2=itos((GEN)p1[2]);ru=N-r2;r1=ru-r2;p1=(GEN)nf[5];
  if(!gcmp0(vdir))
    {
      p3=(GEN)p1[2];p2=cgetg(ru+1,19);
      for(j=1;j<=ru;j++) p2[j]=lmul2n((GEN)p3[j],itos((GEN)vdir[j])<<1);
      p1=greal(gmul(p2,(GEN)p1[1]));
    }
  else p1=(GEN)p1[3];
  y=gmul(x,(GEN)(lllgram(gmul(gtrans(x),gmul(p1,x)),prec)[1]));
  z=gmul(((GEN)(nf[5]))[1],y);
  tetpil=avma;p2=cgetg(3,17);p2[1]=(long)gtomat(y);v=cgetg(ru+1,17);
  for(i=1;i<=r1;i++) v[i]=(long)glog(z[i],prec);
  for(i=r1+1;i<=ru;i++) v[i]=lmul2n(glog(z[i],prec),1);
  p2[2]=(long)v;
  return gerepile(av,tetpil,p2);
}


