#    Copyright (C) 1990, 1992, 1993 Aladdin Enterprises.  All rights reserved.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# Partial makefile for Ghostscript, common to all OS/2 configurations.

# This is the last part of the makefile for OS/2 configurations.
# Since IBMs NMAKE doesn't like the BGI part in devs.mak, we concatenate
# the various parts of the makefile together and filter out the relevant
# part with sed (in makecat.cmd).

# The following prevents GNU make from constructing argument lists that
# include all environment variables, which can easily be longer than
# brain-damaged system V allows.

.NOEXPORT:

# -------------------------------- Library -------------------------------- #

## The OS/2 platform

os2__=gp_nofb.$(OBJ) gp_os2.$(OBJ) gdevpipe.$(OBJ)
os2_.dev: $(os2__)
	$(SHP)gssetmod os2_ $(os2__)
	$(SHP)gsaddmod os2_ -fdev pipe
gp_os2.$(OBJ): gp_os2.c $(AK) $(memory__h) $(string__h) $(gx_h) $(gp_h) $(stat__h) $(time__h)
	$(CCC) gp_os2.c


gdevpipe.$(OBJ): gdevpipe.c $(AK) $(stdio__h) $(gstypes_h) $(filedev_h) $(stream_h)

# -------------------------- Auxiliary programs --------------------------- #

genarch$(XE): genarch.c
	$(CC) -o genarch$(XE) genarch.c

echogs$(XE): echogs.c
	$(CC) -o echogs$(XE) $(CFLAGS) echogs.c

genconf$(XE): genconf.c
	$(CC) -o genconf$(XE) genconf.c

# ----------------------------- Main program ------------------------------ #

BEGINFILES=
CCBEGIN=$(CCC) *.c

# Interpreter main program

GSOS2=gs.$(OBJ) gsmain.$(OBJ) $(INT) $(LIBGS)

$(GS)$(XE): $(GSOS2) ld.tr echogs$(XE) $(ALL_DEVS)
	if exist _temp_ del _temp_
	cat ld.tr | sed -n -e "/^ *$$/d" -e "s/\\ *//" -e "w _temp_"
	$(CC) $(LDFLAGS) $(XLIBDIRS) -o $(GS)$(XE) $(GSOS2) @_temp_ $(EXTRALIBS) -lm
	del /Q _temp_

# Emacs tags

TAGS:
	etags -t *.c *.h

# Installation

docdir=$(gsdatadir)\doc
exdir=$(gsdatadir)\examples
sysdir=$(gsdatadir)\system

install: $(GS)$(XE)
	-mkdir $(bindir)
	$(INSTALL_PROGRAM) $(GS)$(XE) $(bindir)
	$(INSTALL_PROGRAM) gsbj$(SCR) $(bindir)
	$(INSTALL_PROGRAM) gsdj$(SCR) $(bindir)
	$(INSTALL_PROGRAM) gslj$(SCR) $(bindir)
	$(INSTALL_PROGRAM) gslp$(SCR) $(bindir)
	$(INSTALL_PROGRAM) gsnd$(SCR) $(bindir)
	$(INSTALL_PROGRAM) bdftops$(SCR) $(bindir)
	$(INSTALL_PROGRAM) font2c$(SCR) $(bindir)
	$(INSTALL_PROGRAM) ps2ascii$(SCR) $(bindir)
	$(INSTALL_PROGRAM) ps2epsi$(SCR) $(bindir)
	$(INSTALL_PROGRAM) gscript.ico $(bindir)
	$(INSTALL_PROGRAM) gsgraph.ico $(bindir)
	$(INSTALL_PROGRAM) gstext.ico $(bindir)
	-mkdir $(gsdatadir)
	$(INSTALL_DATA) README $(gsdatadir)
	$(INSTALL_DATA) gslp.ps $(gsdatadir)
	$(INSTALL_DATA) gs_init.ps $(gsdatadir)
	$(INSTALL_DATA) gs_dps1.ps $(gsdatadir)
	$(INSTALL_DATA) gs_fonts.ps $(gsdatadir)
	$(INSTALL_DATA) gs_lev2.ps $(gsdatadir)
	$(INSTALL_DATA) gs_statd.ps $(gsdatadir)
	$(INSTALL_DATA) gs_type0.ps $(gsdatadir)
	$(INSTALL_DATA) gs_sym_e.ps $(gsdatadir)
	$(INSTALL_DATA) quit.ps $(gsdatadir)
        $(INSTALL_DATA) Fontmap $(gsdatadir)
	$(INSTALL_DATA) Fontmap.OS2 $(gsdatadir)
	$(INSTALL_DATA) uglyr.gsf $(gsdatadir)
	$(INSTALL_DATA) bdftops.ps $(gsdatadir)
	$(INSTALL_DATA) decrypt.ps $(gsdatadir)
	$(INSTALL_DATA) font2c.ps $(gsdatadir)
	$(INSTALL_DATA) impath.ps $(gsdatadir)
	$(INSTALL_DATA) landscap.ps $(gsdatadir)
	$(INSTALL_DATA) level1.ps $(gsdatadir)
	$(INSTALL_DATA) prfont.ps $(gsdatadir)
	$(INSTALL_DATA) ps2ascii.ps $(gsdatadir)
        $(INSTALL_DATA) ps2epsi.ps $(gsdatadir)
	$(INSTALL_DATA) ps2image.ps $(gsdatadir)
	$(INSTALL_DATA) pstoppm.ps $(gsdatadir)
	$(INSTALL_DATA) showpage.ps $(gsdatadir)
	$(INSTALL_DATA) type1ops.ps $(gsdatadir)
	$(INSTALL_DATA) wrfont.ps $(gsdatadir)

	$(INSTALL_DATA) alphabet.ps $(gsdatadir)
	$(INSTALL_DATA) bench.ps $(gsdatadir)
	$(INSTALL_DATA) empty.ps $(gsdatadir)
	$(INSTALL_DATA) gs_dbt_e.ps $(gsdatadir)
        $(INSTALL_DATA) lines.ps $(gsdatadir)
	$(INSTALL_DATA) markpath.ps $(gsdatadir)
	$(INSTALL_DATA) mergeini.ps $(gsdatadir)
	$(INSTALL_DATA) pcharstr.ps $(gsdatadir)
	$(INSTALL_DATA) ppath.ps $(gsdatadir)
	$(INSTALL_DATA) save.ps $(gsdatadir)
	$(INSTALL_DATA) screen.ps $(gsdatadir)
	$(INSTALL_DATA) showchar.ps $(gsdatadir)
	$(INSTALL_DATA) traceop.ps $(gsdatadir)
        $(INSTALL_DATA) unprot.ps $(gsdatadir)
	$(INSTALL_DATA) winmaps.ps $(gsdatadir)
        -mkdir $(docdir)
	$(INSTALL_DATA) COPYING $(docdir)
	$(INSTALL_DATA) NEWS $(docdir)
	$(INSTALL_DATA) ansi2knr.1 $(docdir)
	$(INSTALL_DATA) commprod.doc $(docdir)
	$(INSTALL_DATA) devices.doc $(docdir)
	$(INSTALL_DATA) drivers.doc $(docdir)
	$(INSTALL_DATA) fonts.doc $(docdir)
	$(INSTALL_DATA) gs.1 $(docdir)
        $(INSTALL_DATA) helpers.doc $(docdir)
	$(INSTALL_DATA) hershey.doc $(docdir)
	$(INSTALL_DATA) history.doc $(docdir)
	$(INSTALL_DATA) humor.doc $(docdir)
	$(INSTALL_DATA) language.doc $(docdir)
	$(INSTALL_DATA) lib.doc $(docdir)
	$(INSTALL_DATA) make.doc $(docdir)
	$(INSTALL_DATA) ps2epsi.doc $(docdir)
	$(INSTALL_DATA) psfiles.doc $(docdir)
	$(INSTALL_DATA) readme.doc $(docdir)
	$(INSTALL_DATA) use.doc $(docdir)
	$(INSTALL_DATA) xfonts.doc $(docdir)
	-mkdir $(exdir)
	$(INSTALL_DATA) chess.ps $(exdir)
	$(INSTALL_DATA) cheq.ps $(exdir)
	$(INSTALL_DATA) colorcir.ps $(exdir)
	$(INSTALL_DATA) golfer.ps $(exdir)
	$(INSTALL_DATA) escher.ps $(exdir)
	$(INSTALL_DATA) snowflak.ps $(exdir)
	$(INSTALL_DATA) tiger.ps $(exdir)
	$(INSTALL_DATA) waterfal.ps $(exdir)
