#    Copyright (C) 1989, 1992, 1993 Aladdin Enterprises.  All rights reserved.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# makefile for Ghostscript,OS2/gcc/emx/nmake2 configuration.
# Note: this makefile assumes you are using gcc in ANSI mode.

# ------------------------------- Options ------------------------------- #

####### The following are the only parts of the file you should need to edit.

# ------ Generic options ------ #

# Define the installation commands and target directories for
# executables and files.  Only relevant to `make install'.

INSTALL = copy
INSTALL_PROGRAM = $(INSTALL)
INSTALL_DATA = $(INSTALL)

prefix = e:\\gs
exec_prefix = $(prefix)
bindir = $(exec_prefix)
datadir = $(prefix)
gsdatadir = $(datadir)


# Define the default directory/ies for the runtime
# initialization and font files.  Separate multiple directories with a ;.

GS_LIB_DEFAULT=$(gsdatadir);$(gsdatadir)\\fonts;c:\\psfonts;d:\\psfonts;e:\\psfonts

# Define the name of the Ghostscript initialization file.
# (There is no reason to change this.)

GS_INIT=gs_init.ps

# Choose generic configuration options.

# -DDEBUG
#	includes debugging features (-Z switch) in the code.
#	  Code runs substantially slower even if no debugging switches
#	  are set.
# -DNOPRIVATE
#	makes private (static) procedures and variables public,
#	  so they are visible to the debugger and profiler.
#	  No execution time or space penalty.

GENOPT=

# Define the name of the executable file.

GS=gs

# ------ Platform-specific options ------ #

# Define the name of the C compiler.

CC=gcc

# Define the other compilation flags.
# Add -s for stripping the symbol table.
# Add -O2 for full optimazion.
# Add -Zmt if you want to use the dynamic C runtime library to save space.
# XCFLAGS can be set from the command line.
# We don't include -ansi, because this gets in the way of the platform-
#   specific stuff that <math.h> typically needs; nevertheless, we expect
#   gcc to accept ANSI-style function prototypes and function definitions.

CFLAGS=-s -O2 -Zmt $(XCFLAGS)

# Define platform flags for ld.
# Add -Zmt if you want to use the dynamic C runtime library to save space.
# XLDFLAGS can be set from the command line.

LDFLAGS=-Zmt $(XLDFLAGS)

# Define any extra libraries to link into the executable.
# (Libraries required by individual drivers are handled automatically.)

EXTRALIBS=


# ------ Devices and features ------ #

# Choose the language feature(s) to include.  See gs.mak for details.

FEATURE_DEVS=filter.dev dps.dev level2.dev

# Choose the device(s) to include.  See devs.mak for details.

DEVICE_DEVS=deskjet.dev djet500.dev djet500c.dev cdeskjet.dev cdjcolor.dev cdjmono.dev cdj500.dev cdj550.dev paintjet.dev pj.dev pjxl.dev pjxl300.dev

DEVICE_DEVS1=laserjet.dev ljet2p.dev ljet3.dev ljetplus.dev 

DEVICE_DEVS2=bj10e.dev bj200.dev lbp8.dev declj250.dev la50.dev la75.dev ln03.dev lj250.dev 

DEVICE_DEVS3=epson.dev eps9high.dev epsonc.dev escp2.dev necp6.dev dfaxlow.dev dfaxhigh.dev

DEVICE_DEVS4=ibmpro.dev jetp3852.dev m8510.dev r4081.dev oki182.dev

DEVICE_DEVS5=t4693d2.dev t4693d4.dev t4693d8.dev tek4696.dev

DEVICE_DEVS6=appledmp.dev

DEVICE_DEVS9=bit.dev bmpmono.dev bmp16.dev bmp256.dev bmp16m.dev gifmono.dev gif8.dev pcxmono.dev pcx16.dev pcx256.dev pbm.dev pbmraw.dev pgm.dev pgmraw.dev ppm.dev ppmraw.dev tiffg3.dev

# ---------------------------- End of options --------------------------- #

# Define the name of the makefile -- used in dependencies.

# MAKEFILE=makefile

# Define the ANSI-to-K&R dependency.  (gcc accepts ANSI syntax.)

# AK=

# Define the compilation rules and flags.

CCC=$(CC) $(CCFLAGS) -c

# --------------------------- Generic makefile ---------------------------- #

# The remainder of the makefile (os2head.mak, gs.mak, devs.mak, os2tail.mak)
# is generic.

MAKEFILE=emx-head.mak os2head.mak gs.mak devs.mak os2tail.mak

include os2head.mak
include gs.mak
include devs.mak
include os2tail.mak
