/* System dependent declarations.  Requires sys/types.h.
   Copyright (C) 1992 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#if defined(USG) || defined(STDC_HEADERS)
#include <time.h>
#include <string.h>
#define index	strchr
#define rindex	strrchr
#define bcmp(s1, s2, n)	memcmp ((s1), (s2), (n))
#define bzero(s, n)	memset ((s), 0, (n))
#else
#include <sys/time.h>
#include <strings.h>
#endif

#ifdef STDC_HEADERS
#include <stdlib.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

#ifndef _POSIX_VERSION
long lseek ();
#endif

/* Since major is a function on SVR4, we can't use `ifndef major'.  */
#ifdef MAJOR_IN_MKDEV
#include <sys/mkdev.h>
#define HAVE_MAJOR
#endif

#ifdef MAJOR_IN_SYSMACROS
#include <sys/sysmacros.h>
#define HAVE_MAJOR
#endif

#ifdef major			/* Might be defined in sys/types.h.  */
#define HAVE_MAJOR
#endif

#ifndef HAVE_MAJOR
#define major(dev) (((dev) >> 8) & 0xff)
#define minor(dev) ((dev) & 0xff)
#define	makedev(ma, mi) (((ma) << 8) | (mi))
#endif
#undef HAVE_MAJOR

#if defined(__MSDOS__) || defined(_POSIX_VERSION) || defined(USG)
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#ifndef O_BINARY
#define O_BINARY 0
#endif

#include <errno.h>
#ifndef errno
extern int errno;
#endif
#ifdef __EMX__			/* gcc on OS/2.  */
#define ENXIO EIO
#endif

#ifdef HAVE_UTIME_H
#include <utime.h>
#else
struct utimbuf
{
  time_t actime;
  time_t modtime;
};
#endif

#ifdef TRUE
#undef TRUE
#endif
#define TRUE 1
#ifdef FALSE
#undef FALSE
#endif
#define FALSE 0

#ifndef __MSDOS__
#define CONSOLE "/dev/tty"
#else
#define CONSOLE "con"
#define mkdir(p, m) mkdir(p)
#endif

#ifdef __MSDOS__
#ifndef __EMX__
typedef int uid_t;
typedef int gid_t;
#endif
#endif
