/* TameInst - Install / UnInstall for Tame/2 */

PARSE ARG action
IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL SysCls
action = TRANSLATE(LEFT(action,1))
SELECT
    WHEN action = 'I' THEN CALL InstallMe
    WHEN action = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL WhatAction
END
Exit /* End of TameInst.cmd */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY 'Please enter installation parameter (I=Install, U=UnInstall, other=Exit):'
PARSE PULL action
SELECT
    WHEN TRANSLATE(LEFT(action,1)) = 'I' THEN CALL InstallMe
    WHEN TRANSLATE(LEFT(action,1)) = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL NoAction 'Installation failed.'
END
RETURN /* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

CALL SysCls
PARSE ARG noinstmsg
SAY noinstmsg
SAY 'Press Enter to exit ...'
PULL answer
CALL SysCls
Exit /* End of NoAction */

/* InstallMe - install Tame/2 */

InstallMe:  PROCEDURE

prgname = 'Tame/2 0.9.4'
reqfiles = 'Tame.exe SCANNER.DAT Tamebmp.dll'
IF RIGHT(Directory(),2) = ':\' THEN DO
    SAY 'Problem! '||prgname||' can not be installed in root directory.'
    SAY 'Create directory for '||prgname||', copy files: '||reqfiles||' there and start this procedure again.'
    SAY 'Press Enter to exit ...'
    PULL answer
    Exit
END

CALL SysCls
SAY 'Welcome to '||prgname||' Installation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will:'
SAY '- Create Folder "Tame/2" on your Desktop,'
SAY '- Create Program objects for '||prgname||','
SAY 'Press "Y" (and Enter) to start Installation, Enter to exit...'
PARSE PULL answer

IF TRANSLATE(LEFT(answer,1)) <> "Y" THEN DO
    CALL NoAction 'Installation aborted'
END

SAY ' '
SAY 'Checking files:'
DO i = 1 TO WORDS(reqfiles)
    CALL SysFiletree Directory()||'\'||WORD(reqfiles,i), 'chkfile', 'FO'
    SELECT
    WHEN chkfile.0 = 1 THEN SAY '- '||LEFT(WORD(reqfiles,i),12)||' - OK'
    OTHERWISE CALL NoAction LEFT(WORD(reqfiles,i),12)||' - Missing file. Installation failed!'
    END
END

CALL SysIni 'TAME.INI', 'Language', 'ENGLISH', 'Tame.inf'

SAY ' '
InstallDir = Directory()
WorkDir = Directory()

FoldTitle='Tame/2'
Icon1=Directory()||'\Folder1.ico'
Icon2=Directory()||'\Folder2.ico'
Icon='ICONFILE='Icon1||';ICONNFILE=1,'||Icon2
Setup='OBJECTID=<TAME2_FOLDER>;'||Icon||''
Action = 'U'
dummy = SysCreateObject('WPFolder',FoldTitle,'<WP_DESKTOP>',Setup,Action)
SAY 'Creating '||FoldTitle||' Folder - '||Rc2(dummy)

ProgTitle = prgname
EXE = 'Tame.exe'
ICO = 'Tame.ico'
Setup = 'OBJECTID=<TAME2_PROGRAM>;EXENAME='InstallDir'\'EXE';ICONFILE='InstallDir'\'ICO';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<TAME2_FOLDER>',Setup,Action)
SAY 'Creating '||prgname||' Program object - '||Rc2(dummy)

ProgTitle = prgname||'^English manual'
EXE = 'View.exe'
INF = 'Tame.inf'
Setup = 'OBJECTID=<TAME2_HENG>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<TAME2_FOLDER>',Setup,Action)
SAY 'Creating '||prgname||' English manual - '||Rc2(dummy)

SAY ' '
SAY 'Installation finished! Press Enter to exit ...'
PULL answer
CALL SysCls
RETURN /* End of InstallMe */

/* UnInstallMe - uninstall Tame/2 */

UnInstallMe: PROCEDURE

prgname = 'Tame/2 0.9.4'
CALL SysCls
SAY 'This is '||prgname||' UnInstallation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will:'
SAY '- Remove '||prgname||' specific entries in OS2.INI file, App ToolsByGoran.'
SAY '- Destroy '||prgname||' Program object'
SAY 'Press "Y" (and Enter) to start UnInstall, any other key to exit...'
PULL answer
IF answer <> "Y" THEN DO
    CALL NoAction 'UnInstall terminated.'
END
SAY ' '
SAY 'Destroying Program object'
CALL SysDestroyObject '<TAME2_HENG>'
CALL SysDestroyObject '<TAMECONFIGTOOL_HSWE>'
CALL SysDestroyObject '<TAME2_PROGRAM>'
CALL SysDestroyObject '<TAME2_FOLDER>'
SAY ' '
SAY 'UnInstallation complete.'
SAY 'You can delete files in directory '||Directory()
SAY 'To install '||prgname||' again, start TameInst I. Press Enter to exit...'
PULL answer
RETURN /* End of UnInstallMe */

/* Rc1 - return code - SysIni */

Rc1:        PROCEDURE

PARSE ARG rcSysIni
SELECT
    WHEN rcSysIni = 'ERROR:' THEN rc1 = 'Error writing to INI file!'
    OTHERWISE rc1 = 'OK'
END
RETURN rc1 /* End of Rc1 */

/* Rc2 - return code - SysCreateObject */

Rc2:        PROCEDURE

PARSE ARG rcSysCreateObject
SELECT
    WHEN rcSysIni = 0 THEN rc2 = 'Error'
    OTHERWISE rc2 = 'OK'
END
RETURN rc2 /* End of Rc2 */
