.TH sane-hp 5 "23 July 1997"
.IX sane-hp
.SH NAME
sane-hp - SANE backend for HP ScanJet scanners
.SH DESCRIPTION
The
.B sane-hp
library implements a SANE (Scanner Access Now Easy) backend that
provides access to HP ScanJet scanners.  At present, the following
scanners are known positively to work with this backend:
.PP
.RS
Model:        Product id:
.br
----------    -----------
.br
ScanJet 3C    C2520A 3503
.br
ScanJet 4C    C2520A
.br
ScanJet 5P    C5110A
.RE
.PP
If you own a ScanJet scanner other than the ones listed above, please
let us know if your model works with this backend.  To do this, send a
mail with the relevant information for your scanner to
.IR sane-devel@listserv.azstarnet.com .

.B Note:
at present, the ScanJet 5P is know
.IR not
to work with this backend.  This is because the 5P does not support
two Scanner Control Language (SCL) commands used by the HP backend.
It is not difficult to fix this by somebody with such a scanner (or
with any HP scanner, for that matter) and skilled in C.  If
interested, please contact the mailing list mentioned above.

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.IR special
.RE
.PP
Where
.I special
is the UNIX path-name for the special device that corresponds to the
scanner.  The special device name must be a generic SCSI device or a
symlink to such a device.  Under Linux, such a device name could be
.IR /dev/sga
or
.IR /dev/sge ,
for example.
.SH CONFIGURATION
The configuration file for this backend resides in
.IR @CONFIGDIR@/hp.conf .
Its contents is a list of device names that correspond to HP ScanJet
scanners.  Empty lines and lines starting with a hash mark (#) are
ignored.  A sample configuration file is shown below:
.PP
.RS
/dev/scanner
.br
# this is a comment
.br
/dev/sge
.RE
.SH FILES
.TP
.I @CONFIGDIR@/hp.conf
The backend configuration file.
.TP
.I @LIBDIR@/libsane-hp.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-hp.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_HP
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.
.SH "SEE ALSO"
sane-scsi(5)
.SH AUTHOR
David Mosberger
.PP
The backend is derived from
.BR hpscanpbm (1)
(see sources for copyright).
.SH BUGS
This is a minimal backend.  E.g., at present there is no support for
down-loadable tone maps.
