/* ------------------------------------------------------------------------- */

/* umax-struct.h: definition of umax_struct for driver for UMAX scanners.
  
   Copyright (C) 1996-1997 Michael K. Johnson
   Copyright (C) 1997 Oliver Rauch

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an executable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
  
 */

/* ------------------------------------------------------------------------- */

#ifndef UMAX_STRUCT_H
#define UMAX_STRUCT_H

typedef struct umax_scanner
{
  unsigned char * buffer;            /* buffer used for scsi-transfer */
  unsigned int bufsize;
  unsigned int row_bufsize;
  unsigned char *arena;               /* used to mmap files into for writing */
  int    arena_offset;     /* used to indicate arena offset for graphic data */

  char   *devicename;                          /* name of the scanner device */
  int    ofd;                   /* output file descriptor, stdout by default */
  FILE   *ofile;	           /* output file stream for three pass scan */
  int    sfd;                      /* output file descriptor, scanner device */

  char   vendor[9];                                          /* will be UMAX */
  char   product[17];                         /* e.g. "SuperVista_S12" or so */
  char   version[5];                                            /* e.g. V1.3 */

  int    cont;                       /* continue although scanner is unknown */
  int    verbose;                                 /* 1,2=output informations */
  int    three_pass;                      /* used in RGB-mode if 3-pass => 1 */
  int    three_pass_color;        /* select color for scanning in 3pass mode */
  int    row_len;                           /* len of one scan-line in bytes */
  unsigned int max_value;                               /* used for pnm-file */

  int    inquiry_len;                      /* length of inquiry return block */
  int    inquiry_wdb_len;               /* length of window descriptor block */
  int    inquiry_optical_res;        /* optical resolution form read_inquiry */
  int    inquiry_x_res;                    /* x-resolution form read_inquiry */
  int    inquiry_y_res;                    /* y-resolution form read_inquiry */
  double inquiry_fb_width;                        /* flatbed width in inches */
  double inquiry_fb_length;                      /* flatbed length in inches */
  double inquiry_uta_width;                  /* transparency width in inches */
  double inquiry_uta_length;                /* transparency length in inches */
  double inquiry_dor_width;             /* double resolution width in inches */
  double inquiry_dor_length;           /* double resolution length in inches */

  int    inquiry_exposure_adj;          /* 1 if exposure adjust is supported */
  int    inquiry_exposure_time_step_unit; /* exposure time unit in micro sec */ 
  int    inquiry_exposure_time_max;                 /* exposure time maximum */
  int    inquiry_exposure_time_l_min;               /* exposure tine minimum */
  int    inquiry_exposure_time_l_fb_def;            /* exposure time default */
  int    inquiry_exposure_time_l_uta_def;           /* exposure time default */
  int    inquiry_exposure_time_h_min;               /* exposure tine minimum */
  int    inquiry_exposure_time_h_fb_def;            /* exposure time default */
  int    inquiry_exposure_time_h_uta_def;           /* exposure time default */
  int    inquiry_exposure_time_g_min;               /* exposure tine minimum */
  int    inquiry_exposure_time_g_fb_def;            /* exposure time default */
  int    inquiry_exposure_time_g_uta_def;           /* exposure time default */
  int    inquiry_exposure_time_c_min;               /* exposure tine minimum */
  int    inquiry_exposure_time_c_fb_def_r;          /* exposure time default */
  int    inquiry_exposure_time_c_fb_def_g;          /* exposure time default */
  int    inquiry_exposure_time_c_fb_def_b;          /* exposure time default */
  int    inquiry_exposure_time_c_uta_def_r;         /* exposure time default */
  int    inquiry_exposure_time_c_uta_def_g;         /* exposure time default */
  int    inquiry_exposure_time_c_uta_def_b;         /* exposure time default */
  int    inquiry_max_warmup_time;                /* maximum lamp warmup time */
  int    inquiry_cbhs;                              /* 50, 255, 255+autoexp. */
  int    inquiry_cbhs_min;                         /* minimum value for cbhs */
  int    inquiry_cbhs_max;                         /* maximum value for cbhs */
  int    inquiry_quality_ctrl;                              /* 1 = supported */
  int    inquiry_preview;                                   /* 1 = supported */
  int    inquiry_lamp_ctrl;                                 /* 1 = supported */
  int    inquiry_transavail;                            /* 1 0 uta available */
  int    inquiry_adfmode;                               /* 1 = adf available */
  int    inquiry_uta;                                       /* 1 = supported */
  int    inquiry_adf;                                       /* 1 = supported */
  int    inquiry_dor;                                       /* 1 = supported */
  int    inquiry_reverse;                                   /* 1 = supported */
  int    inquiry_reverse_multi;                             /* 1 = supported */
  int    inquiry_analog_gamma;                              /* 1 = supported */
  int    inquiry_gamma_dwload;                              /* 1 = supported */
  int    inquiry_one_pass_color;                            /* 1 = supported */
  int    inquiry_three_pass_color;                          /* 1 = supported */
  int    inquiry_color;                                     /* 1 = supported */
  int    inquiry_grey;                                      /* 1 = supported */
  int    inquiry_halftone;                                  /* 1 = supported */
  int    inquiry_lineart;                                   /* 1 = supported */
  int    inquiry_calibration;         /* 1 = calibration by driver supported */
  int    inquiry_highlight;                                 /* 1 = supported */
  int    inquiry_shadow;                                    /* 1 = supported */
  int    inquiry_GIB;                                    /* gamma input bits */
  int    inquiry_GOB;                                   /* gamma output bits */

  int    use_exposure_time_min;                    /*  exposure tine minimum */
  int    use_exposure_time_def_r;                   /* exposure time default */
  int    use_exposure_time_def_g;                   /* exposure time default */
  int    use_exposure_time_def_b;                   /* exposure time default */

  int    wdb_len;                                  /* use this length of WDB */
  double width;                               /* use this width of scan-area */
  double length;                             /* use this length of scan-area */
  int    width_in_pixels;                /* thats the wanted width in pixels */
  int    height_in_pixels;              /* thats the wanted length in pixels */
  int    phys_width;             /* thats the width in pixels at 1200pt/inch */
  int    phys_height;           /* thats the length in pixels at 1200pt/inch */

  int    x_resolution;                       /* scan-resolution for x in dpi */
  int    y_resolution;                       /* scan-resolution for y in dpi */
  int    upper_left_x;       /* thats the left edge in points at 1200pt/inch */
  int    upper_left_y;        /* thats the top edge in points at 1200pt/inch */

  int    x_coordinate_base;           /* x base in pixels/inch, normaly 1200 */
  int    y_coordinate_base;           /* y base in pixels/inch, normaly 1200 */

  int    bits_per_pixel;                            /* 1 = 24bpp, 4 = 30 bpp */
  int    gamma_input_bits;                          /* 1 = 24bpp, 4 = 30 bpp */
  int    set_auto;                          /* 0 or 1, don't know what it is */
  int    preview;                                            /* 1 if preview */
  int    quality;                           /* 1=quality_calibration, 0=fast */
  int    reverse;                             /* 1: exchange black and white */
  int    reverse_multi;                            /* 1: invert color values */
  int    WD_speed;                     /* is a combination of slow and smear */
  int    slow;                                         /* 1: slow scan speed */
  int    smear;                /* 1: don't care about image smearing problem */
  int    dor;                                           /* double resolution */
  int    cbhs_range;                           /* 50,255 or 255+autoexposure */
  int    warmup;                                         /* 1=set warmup-bit */
  int    module;                                  /* flatbed or transparency */
  int    adf;                                          /* 1 if ADF turned on */
  int    uta;                                          /* 1 if UTA turned on */
  int    calibration;         /* calibration :0=ignore, 1=driver, 2=by image */
  int    colormode;                  /* LINEART, HALFTONE, GREYSCALE or RGB  */
#  define LINEART             1
#  define HALFTONE            2
#  define GREYSCALE           3
#  define RGB_LINEART         4
#  define RGB_HALFTONE        5
#  define RGB                 6

  int    exposure_time_calibration_r;                 /* use for calibration */
  int    exposure_time_calibration_g;                 /* use for calibration */
  int    exposure_time_calibration_b;                 /* use for calibration */
  int    exposure_time_scan_r;                               /* use for scan */
  int    exposure_time_scan_g;                               /* use for scan */
  int    exposure_time_scan_b;                               /* use for scan */

  int    c_density;                         /* next calibration lamp density */
  int    s_density;                                /* next scan lamp density */

  int    threshold;                            /* (128) 0-255, lineart mode  */
  int    brightness;                /* (128) cbhs_range 0-255, halftone mode */
  int    contrast;                  /* (128) cbhs_range 0-255, halftone-mode */
  int    highlight_r;                   /* (255) cbhs_range 1-255, each mode */
  int    highlight_g;                   /* (255) cbhs_range 1-255, each mode */
  int    highlight_b;                   /* (255) cbhs_range 1-255, each mode */
  int    shadow_r;                        /* (0) cbhs_range 0-254, each mode */
  int    shadow_g;                        /* (0) cbhs_range 0-254, each mode */
  int    shadow_b;                        /* (0) cbhs_range 0-254, each mode */
  int    halftone;                                /* halftone pattern select */

  int    digital_gamma_r;                   /* gamma-select for red and grey */
  int    digital_gamma_g;                    /* gamma-select value for green */
  int    digital_gamma_b;                     /* gamma-select value for blue */
  double gamma_r;                            /* gamma value for red and grey */
  double gamma_g;                                   /* gamma value for green */
  double gamma_b;                                    /* gamma value for blue */
  char   *gamma_file_r;                           /* file for gamma download */
  char   *gamma_file_g;                           /* file for gamma download */
  char   *gamma_file_b;                           /* file for gamma download */

  int    analog_gamma_r;                        /* analog gamma red and grey */
  int    analog_gamma_g;                               /* analog gamma green */
  int    analog_gamma_b;                                /* analog gamma blue */

  int    RGB_PREVIEW_PATCH;
  int    START_SCAN_PATCH;
} US;

#endif /* UMAX_STRUCT_H */

