/****************************************/
/* POV-Panel/2 1.1 Installation Program */
/* Copyright 1995 Carsten Whimster	 */
/****************************************/

Call RxFuncAdd 'SysCls',           'RexxUtil', 'SysCls'
Call RxFuncAdd 'SysDestroyObject', 'RexxUtil', 'SysDestroyObject'
Call RxFuncAdd 'SysCreateObject',  'RexxUtil', 'SysCreateObject'

/* clear screen */
Call SysCls

/* startup message */
Say "Welcome to the POV-Panel/2 1.1 installation"
Say ""
Say "This script should be run only after placing the contents of"
Say "the zip file in the destination directory."
Say ""
Say "Would you like to continue the installation program (y/N) ?"
Parse Pull Answer
If Translate( Answer ) <> "Y" Then Do
   Say "Exiting..."
   Exit
End

/* desktop icon */
Say "Would you like a POV-Panel/2 1.1 folder (y/N)?"
Parse Pull Answer
If  Translate( Answer ) = "Y" Then Do

   /* set up folder */
   Say "Creating the POV-Panel/2 1.1 folder..."
   rc = SysDestroyObject( "<POVPANEL_FOLDER>" )
   rc = SysCreateObject( "WPFolder", ,
			  "POV-Panel/2 1.1", ,
			  "<WP_DESKTOP>", ,
			  "OBJECTID=<POVPANEL_FOLDER>", ,
			  "REPLACE" )
   If rc <> 1 Then Do
      Say "Could not create folder. Exit code" rc "."
      Say "Exiting..."
      Exit
   End

   /* set up icon parameters */
   Exename = "EXENAME=" || Directory() || "\PP2.EXE" || ";"
   Parms = "PARAMETERS=-i PP2.INI" || ";"
   StartupDir = "STARTUPDIR=" || Directory() || ";"
   AssocFilter = "ASSOCFILTER=*.pov" || ";"
   ExeSetup = Exename || Parms || StartupDir || AssocFilter

   /* crating program icon */
   Say "Creating program icon..."
   rc = SysCreateObject( "WPProgram", ,
			  "POV-Panel/2 1.1", ,
			  "<POVPANEL_FOLDER>", ,
			  ExeSetup, ,
			  "REPLACE" )
   If rc <> 1 Then Do
      Say "Could not create program icon"
      Say "Exiting..."
      Exit
   End
   Say "An association has been created to this icon for all *.pov files"
End
Else Do
   Say "No folder will be created"
End

/* done */
Say ""
Say "Installation successful"
