#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <iostream.h>
#define INCL_DOS
#include <os2.h>

/***********************************************************************************************
*     LEN:  21.05.97                 SINUS.CPP                                                 *
*     (letzte nderung: 22.09.99)                                                              *
*                                                                                              *
*     Beispielprogramm zur Illustration des Datentransfers zwischen externen Programmen        *
*     und PM_PLOT.                                                                             *
*                                                                                              *
*     Bei Angabe eines positiven Schreibintervalls wird eine Sinusfunktion mit                 *
*     im angegebenen Wiederholungsintervall jeweils in die ASCII-Datei SINUS.ASC geschrieben.  *
*                                                                                              *
*     Bei Angabe eines negativen Schreibintervalls wird eine Sinusfunktion in den Named        *
*     Shared Memory Bereich \\SHAREMEM\\PM_PLOT_SHM geschrieben. Die ersten beiden "Spalten"   *
*     enthalten dabei jeweils 8192 Werte (float).                                              *
*                                                                                              *
*     Der Datentransfer ber Shared Memory ist so organisiert, das im ersten Wert des          *
*     gemeinsamen Speichers die Anzahl der vorhandenen "Spalten" steht. Jede Spalte enthlt    *
*     wiederum als ersten Wert die Anzahl der in ihr enthaltenen Werte. Shared Memory Transfer *
*     zu PM_PLOT funktioniert ausschlielich mit dem Datentyp <float>.                         *
*                                                                                              *
*     Vorliegendes Datenfeld:  data[0] = 2     ->  2 Spalten                                   *
*                              data[1] = 8192  ->  8192 Werte in Spalte 1                      *
*                        data[2] - data[8193]  ->  Datensatz in Spalte 1                       *
*                           data[8194] = 8192  ->  8192 Werte in Spalte 2                      *  
*                     data[8195] - data[16386] ->  Datensatz in Spalte 2                       *
*                                                                                              *
*     Der Datentransfer kann ber Sempahore getriggert werden, so da PM_PLOT z.B. bei neuen   *
*     Daten sofort ein neues Bild erstellt. Dies geschieht wahlweise ber die Semaphore        *
*     \\SEM32\\PM_PLOT_TRIGGER1 - \\SEM32\\PM_PLOT_TRIGGER9. Die Auswahl des zu verwendenden   *
*     Semaphors funktioniert ber die PM_PLOT-Kommadozeilenparameter -dm -INT. Die bergabe    *
*     eines negativen Zeitintervalls schaltet die externe Triggerung ein, der Wert INT         *
*     (Wertebereich -1 bis -9) whlt das zu verwendenden Semaphor aus.                         *
*                                                                                              *
*     PM_PLOT postet das Sempahor nach Fertigstellung der Zeichnung wieder, so da man eine    *
*     Rckmeldung bekommt. In diesem Beispiel werden die Semaphore 1 & 2 genutzt.              *
*     Nach Beendigung der angegebenen Wiederholungsanzahl stoppt das Programm SINUS.           *          
*                                                                                              *
*     Aufruf: Sinus [Schreibintervall in sec] [Anzahl Wiederholungen]                          *
*             Ein Schreibintervall von -1 sec startet den Shared Memory                        *    
*             Datentransfer + Triggern ber die Semaphore Nr. 1 & 2.                           *
*                                                                                              *
***********************************************************************************************/

int main( int argc, char *argv[] )
{
   long i, j = 0, ivall = 0L, anz, time;
   unsigned long flattr = 0, ldummy;      // flattr hat keinen Einflu auf Named Semaphore 
   const pi2 = 6.283185307;
   PVOID pshm;                            // Shared Memory Zeiger (Typ void)
   HEV hev, hev1;                         // Semaphor-Handles 
   APIRET rc;
   BOOL32 fstate = 0;                     // Anfangsstatus der Semaphore: gepostet
   float* data;
   FILE* fk;

   if ( argc != 3 ) 
   {
      cout << "Usage: sinus [Schreibintervall in sec] [Anzahl Wiederholungen] " << endl;
      cout << "       Ein Schreibintervall -1 sec startet den Shared Memory\n" 
	     << "       Datentransfer + Triggern ber die Semaphore Nr. 1 & 2." << endl;
      return( 1 );
   }    
   else cout << "Ende mit einer beliebigen <Taste>";
   time = atol( argv[1] );
   anz = atol( argv[2] );

// ***  Schreibe in die ASCII-Datei SINUS.ASC zwei Spalten Daten  ***

   if ( time > 0 ) 
   {
      time *= 1000L;
      while ( j < anz && !kbhit() )  //  Schleifenende bei ANZ Wiederholungen oder Tastendruck
      {
         fk = fopen( "sinus.asc", "w" );
         for ( i = 0; i < 8192; i++ ) 
            fprintf( fk, "%d %f\n", i, sin(pi2*double(i+ivall)/4096.) );
         fclose( fk );
         ivall += 64;
         DosSleep( time );
         j++; 
      }
   }
   else if ( time == -1L )   
   {
//    ***  Shared Memory allokieren  ***

      if ( (rc = DosAllocSharedMem( &pshm, "\\SHAREMEM\\PM_PLOT_SHM", (ULONG) (16387L*sizeof(float)), PAG_COMMIT| PAG_READ | PAG_WRITE | OBJ_TILE )) != 0 )
      {
         cout << endl << "DosAllocSharedMem Error: " << rc;
         return( 0 );
      }      
      data = (float*) pshm;
      data[0] = 2.f;     //  zwei Spalten ...
      data[1] = 8192.f;  //  ... mit jeweils 8192 Werten
      data[8194] = 8192.f;
      for ( i = 0; i < 8192; i++ ) 
      {
         data[i+2] = i;
         data[i+8195] = sin(pi2*double(i)/4096.);
      }

//    ***  Semaphor 1 erstellen  ***
    
      if ( (rc = DosCreateEventSem( "\\SEM32\\PM_PLOT_TRIGGER1", &hev, flattr, fstate )) != 0 )
      {
         cout << endl << "DosCreateEventSem 1 Error: " << rc;
         return( 0 );
      }     

//    ***  Semaphor 2 erstellen  ***

      if ( (rc = DosCreateEventSem( "\\SEM32\\PM_PLOT_TRIGGER2", &hev1, flattr, fstate )) != 0 )
      {
         cout << endl << "DosCreateEventSem 2 Error: " << rc;
         return( 0 );
      }    

//    ***  Hauptschleife  ***

      while ( j < anz && !kbhit() )  //  Schleifenende bei ANZ Wiederholungen oder Tastendruck
      {
         for ( i = 0; i < 8192; i++ ) 
            data[i+8195] = sin(pi2*double(i+ivall)/4096.);
         ivall += 32;

//       ***  Reset der beiden Semaphore -> Triggerung des Neuzeichnens  ***   

         DosResetEventSem( hev, &ldummy );   
         DosResetEventSem( hev1, &ldummy );   

//       ***  Warte, bis eins der beiden Sempahore gepostet wurde -> Zeichnen beendet  ***   

         while ( DosWaitEventSem( hev, 20L ) != 0 && DosWaitEventSem( hev1, 20L ) != 0 )
         {
            if ( kbhit() ) 
            {
               DosFreeMem( pshm );       // Shared Memory freigeben
               DosCloseEventSem( hev );  // Semaphor schlieen
               return( 0 );
            }
         }
         j++;      
      }
      DosFreeMem( pshm );       // Shared Memory freigeben
      DosCloseEventSem( hev );  // Semaphor schlieen
   }          
   return( 0 );
}
