/* mkwpsobj.cmd */
signal on error

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

actdir = DIRECTORY()

if SysSearchPath( actdir, "PM_PLOT.EXE" ) = "" then
   do 
      say 'I cannot find the file PM_PLOT.EXE.'
      say 'The current directory is not the installation directory.'
      say 'Please change the directory.'
   end	   
else

/* Create the desktop folder. */

if SysCreateObject( "WPFolder", "PM PLOT", "<WP_DESKTOP>", "OBJECTID=<PM PLOT>", 'R' ) then
  say 'PM PLOT folder was created on desktop.'
else 
  say 'Failed to create PM PLOT folder on desktop.' 

/* Create the examples folder. */

if SysCreateObject( "WPFolder", "Examples", "<PM PLOT>", "OBJECTID=<EXAMPLES>", 'R' ) then
  say 'Examples folder was created.'
else 
  say 'Failed to create examples folder.' 

if SysCreateObject( "WPShadow", "Templates", "<PM PLOT>", "SHADOWID="actDir"\template;OBJECTID=<TEMPLATES>", 'R' ) then
   say 'Shadow for template folder was created.'
else
   say 'Failed to create shadow for template folder'

if SysCreateObject( "WPShadow", "Filme", "<PM PLOT>", "SHADOWID="actDir"\filme;OBJECTID=<MOVIES>", 'R' ) then
   say 'Shadow for movies folder was created.'
else
   say 'Failed to create shadow for movies folder'

/* Create program reference for PM PLOT */

progSettings = 'PROGTYPE=PM;ASSOCFILTER=*.prt,*.bpr,*.3dp;EXENAME='actDir'/pm_plot.exe;STARTUPDIR='actDir';OBJECTID=<PM_PLOT>'

if SysCreateObject( "WPProgram", "PM PLOT 1.2", "<PM PLOT>", progSettings, 'R' ) then
   say 'Program object for pm_plot.exe was created.'
else
   say 'Failed to create program object for pm_plot.exe'

/* Create program reference for the JAVA FLI-Player */

progSettings = 'PROGTYPE=PM;ASSOCFILTER=*.fli;EXENAME=javapm.exe;STARTUPDIR='actDir'\jplay;PARAMETERS=jplay;OBJECTID=<JPLAY>'

if SysCreateObject( "WPProgram", "JAVA FLI-Player", "<PM PLOT>", progSettings, 'R' ) then
   say 'Program object for jplay.class was created.'
else
   say 'Failed to create program object for jplay.class'

/* Create shadows for the 11 examples */

if SysCreateObject( "WPShadow", "Example 10", "<EXAMPLES>", "SHADOWID="actDir"\examples\exam10.3dp;OBJECTID=<PM_PLOT_EXAMP10>", 'R' ) then
   say 'Shadow for example 10 was created.'
else
   say 'Failed to create shadow for example 10.'
if SysCreateObject( "WPShadow", "Example 9", "<EXAMPLES>", "SHADOWID="actDir"\examples\exam9.3dp;OBJECTID=<PM_PLOT_EXAMP9>", 'R' ) then
   say 'Shadow for example 9 was created.'
else
   say 'Failed to create shadow for example 9.'
if SysCreateObject( "WPShadow", "Example 8", "<EXAMPLES>", "SHADOWID="actDir"\examples\exam8.3dp;OBJECTID=<PM_PLOT_EXAMP8>", 'R' ) then
   say 'Shadow for example 8 was created.'
else
   say 'Failed to create shadow for example 8.'
if SysCreateObject( "WPShadow", "Example 7", "<EXAMPLES>", "SHADOWID="actDir"\examples\exam7.bpr;OBJECTID=<PM_PLOT_EXAMP7>", 'R' ) then
   say 'Shadow for example 7 was created.'
else
   say 'Failed to create shadow for example 7.'
if SysCreateObject( "WPShadow", "Example 6", "<EXAMPLES>", "SHADOWID="actDir"\examples\exam6.cmd;OBJECTID=<PM_PLOT_EXAMP6>", 'R' ) then
   say 'Shadow for example 6 was created.'
else
   say 'Failed to create shadow for example 6.'
if SysCreateObject( "WPShadow", "Example 5", "<EXAMPLES>", "SHADOWID="actDir"\examples\exam5.cmd;OBJECTID=<PM_PLOT_EXAMP5>", 'R' ) then
   say 'Shadow for example 5 was created.'
else
   say 'Failed to create shadow for example 5.'
if SysCreateObject( "WPShadow", "Example 4", "<EXAMPLES>", "SHADOWID="actDir"\examples\exam4.bpr;OBJECTID=<PM_PLOT_EXAMP4>", 'R' ) then
   say 'Shadow for example 4 was created.'
else
   say 'Failed to create shadow for example 4.'
if SysCreateObject( "WPShadow", "Example 3", "<EXAMPLES>", "SHADOWID="actDir"\examples\exam3.bpr;OBJECTID=<PM_PLOT_EXAMP3>", 'R' ) then
   say 'Shadow for example 3 was created.'
else
   say 'Failed to create shadow for example 3.'
if SysCreateObject( "WPShadow", "Example 2", "<EXAMPLES>", "SHADOWID="actDir"\examples\exam2.bpr;OBJECTID=<PM_PLOT_EXAMP2>", 'R' ) then
   say 'Shadow for example 2 was created.'
else
   say 'Failed to create shadow for example 2.'
if SysCreateObject( "WPShadow", "Example 1", "<EXAMPLES>", "SHADOWID="actDir"\examples\exam1.bpr;OBJECTID=<PM_PLOT_EXAMP1>", 'R' ) then
   say 'Shadow for example 1 was created.'
else
   say 'Failed to create shadow for example 1.'
if SysCreateObject( "WPShadow", "Styles", "<EXAMPLES>", "SHADOWID="actDir"\examples\styles.bpr;OBJECTID=<PM_PLOT_STYLES>", 'R' ) then
   say 'Shadow for styles was created.'
else
   say 'Failed to create shadow for styles.'

/* Create shadows for readme.txt, manual.txt, manual.html, manual.ps, news.txt and history.txt */

if SysCreateObject( "WPShadow", "PM PLOT History", "<PM PLOT>", "SHADOWID="actDir"\history.txt;OBJECTID=<PM_PLOT_HISTORY>", 'R' ) then
   say 'Shadow for history.txt file was created.'
else
   say 'Failed to create shadow for history.txt file.'

if SysCreateObject( "WPShadow", "Manual (Text)", "<PM PLOT>", "SHADOWID="actDir"\manual.txt;OBJECTID=<PM_PLOT_MANUAL_TEXT>", 'R' ) then
   say 'Shadow for manual.txt file was created.'
else
   say 'Failed to create shadow for manual.html file.'

if SysCreateObject( "WPShadow", "Manual (HTML)", "<PM PLOT>", "SHADOWID="actDir"\htmldoc\manual.html;OBJECTID=<PM_PLOT_MANUAL_HTML>", 'R' ) then
   say 'Shadow for manual.html file was created.'
else
   say 'Failed to create shadow for manual.html file.'

if SysCreateObject( "WPShadow", "Manual (Postscript)", "<PM PLOT>", "SHADOWID="actDir"\manual.ps;OBJECTID=<PM_PLOT_MANUAL_PS>", 'R' ) then
   say 'Shadow for manual.ps file was created.'
else
   say 'Failed to create shadow for manual.ps file.'

if SysCreateObject( "WPShadow", "PM PLOT Readme", "<PM PLOT>", "SHADOWID="actDir"\readme.txt;OBJECTID=<PM_PLOT_README>", 'R' ) then
   say 'Shadow for readme.txt file was created.'
else
   say 'Failed to create shadow for readme.txt file.'

if SysCreateObject( "WPShadow", "PM PLOT News", "<PM PLOT>", "SHADOWID="actDir"\news.txt;OBJECTID=<PM_PLOT_NEWS>", 'R' ) then
   say 'Shadow for news.txt file was created.'
else
   say 'Failed to create shadow for news.txt file.'
