/*********************************************************************/
/*                                                                   */
/* Installation program for PM_PLOT package, Ver. 1.5                */
/*                                                                   */
/*      Author: Lars Enghardt, Email: lars.enghardt@dlr.de           */
/*        Date: 16.11.99                                             */
/* Last change: 09.08.2000                                           */
/*                                                                   */
/*********************************************************************/

/*------------------- Init Rexxutil-----------------------------------*/

If RXFUNCQUERY('SysLoadFuncs') Then Do
   Call rxfuncadd 'SysLoadFuncs', 'REXXUTIL', 'SYSLOADFUNCS'
   Call sysloadfuncs
End

call head
say 'Whlen Sie <j> zum Installieren/Aktualisieren oder <n>, um abzubrechen.'
say ''
say 'Install>'
parse value SysCurPos() with aktzeile aktspalte
newposition=SysCurPos(aktzeile-1,8)
pull antwort .
if antwort = 'J' | antwort = 'j' then do 
   call init_prog
   call update_inst
   say ''
   say '<Enter> zum Fortsetzen der Installation/Aktualisierung.'
   say ''
   say 'Install>'
   parse value SysCurPos() with aktzeile aktspalte
   newposition=SysCurPos(aktzeile-1,8)
   pull antwort . 
   call update_config
   if changed = 1 then do
      say ''
      say '<Enter> zum Fortsetzen der Installation/Aktualisierung.'
      say ''
      say 'Install>'
      parse value SysCurPos() with aktzeile aktspalte
      newposition=SysCurPos(aktzeile-1,8)
      pull antwort . 
      'call rmwpsobj.cmd' 
      'call mkwpsobj.cmd' 
      end
   else do
      call head
      say 'Whlen Sie <j> zum Aktualisieren der Desktop-Icons.'
      say ''
      say 'Install>'
      parse value SysCurPos() with aktzeile aktspalte
      newposition=SysCurPos(aktzeile-1,8)
      pull antwort .
      if antwort = 'J' | antwort = 'j' then do 
         'call rmwpsobj.cmd' 
         'call mkwpsobj.cmd'           
      end /* do */
   end       
   call head
   if changed = 1 then do
      say 'Die Installation von PM_PLOT wurde erfolgreich durchgefhrt.'
      say ''
      say 'Bitte fhren Sie einen Systemabschlu+Neustart durch,'
      say 'um die Installation abzuschlieen.'
   end
   else do
      say 'Die Installation von PM_PLOT wurde erfolgreich aktualisiert.'
      if changed = 2 then do
         say ''
         say 'Der JAVA-Classpath wurde aktualisiert.'
         say 'PM_PLOT ist lauffhig, der JAVA-Filmabspieler lt sich allerdings erst'
         say 'nach dem nchsten Neustart des Rechners direkt von PM_PLOT aufrufen.'                
      end /* do */ 
   end
end   
else say 'Installation/Aktualisierung abgebrochen.'
exit

init_prog:

parse source . . progname .
x = pos( filespec('n', progname), progname) - 2
rundir = substr(progname, 1, x)

call head 

/* Query bootdrive */

bootdrv = 'C:'
parse upper value VALUE('PATH',,'OS2ENVIRONMENT') with '\OS2\INSTALL' -2 bootdrv +2
parse upper value VALUE('PATH',,'OS2ENVIRONMENT') with '\OS2\SYSTEM' -2 bootdrv2 +2
if bootdrv=bootdrv2 then say 'Das Bootlaufwerk scheint' bootdrv 'zu sein'
say ' '
say 'Whlen Sie <j> zur Besttigung oder geben'
say 'Sie den korrekten Laufwerksbuchstaben ein.'
say ''
say 'Install>'
parse value SysCurPos() with aktzeile aktspalte
newposition=SysCurPos(aktzeile-1,8)
parse pull in

if in='j'|in='J'  then bootdrv=bootdrv
else bootdrv=in':'

configsys = bootdrv'\config.sys'
configbak = bootdrv'\config.pmp'
count = 1
do while stream( configbak, 'c', 'query exists' ) <> '' 
   configbak = bootdrv'\config.pm'count
   count = count + 1
end

in = 'N'
gst = bootdrv'\gstools'

/*  Query path to GS-Tools  */

do while in <> 'j' & in <> 'J'
   call head
   say 'Der Pfad zu den GS-Tools (Programm Ghostscript/Ghostview) ist momentan auf'
   say translate(gst)
   say 'eingestellt.'
   say ' '
   say 'Whlen Sie <j> zur Besttigung oder geben'
   say 'Sie den korrekten kompletten Pfad ein.'
   say ''
   say 'Install>'
   parse value SysCurPos() with aktzeile aktspalte
   newposition=SysCurPos(aktzeile-1,8)
   parse pull in
   if in='j'|in='J' then nop
   else gst = in
end
gsv = gst||'\gsview'
in = 'N'

/*  Query path to Ghostview  */
 
do while in <> 'j' & in <> 'J'
   call head
   say 'Der Pfad zu dem Programm Ghostview (gvpm.exe) ist momentan auf'
   say translate(gsv)
   say 'eingestellt.'
   say ' '
   say 'Whlen Sie <j> zur Besttigung oder geben'
   say 'Sie den korrekten kompletten Pfad ein.'
   say ''
   say 'Install>'
   parse value SysCurPos() with aktzeile aktspalte
   newposition=SysCurPos(aktzeile-1,8)
   parse pull in
   if in='j'|in='J' then nop
   else gsv = in
end
gss = gst||'\gs6.01'  
gsv = gsv||'\gvpm.exe'
in = 'N'

/*  Query path to Ghostscript  */

do while in <> 'j' & in <> 'J'
   call head
   say 'Der Pfad zu dem Programm Ghostscript (gsos2.exe) ist momentan auf'
   say translate(gss)
   say 'eingestellt.'
   say ' '
   say 'Whlen Sie <j> zur Besttigung oder geben'
   say 'Sie den korrekten kompletten Pfad ein.'
   say ''
   say 'Install>'
   parse value SysCurPos() with aktzeile aktspalte
   newposition=SysCurPos(aktzeile-1,8)
   parse pull in
   if in='j'|in='J' then nop
   else gss = in
end 

return /* init_prog */

update_config:
   call head
   changed = 0
   plplotlib_found = 0
   i = 1
   say ''
   say 'nderungen in der Datei' configsys':'
   say ''
   do while lines(configsys) <> 0
      config.i = linein(configsys)
      line = translate(strip(config.i))
      select
         when substr(line, 1, 8) = 'SET PATH' then do
            if pos( translate(rundir), line) = 0 then do
               changed = 1
               if substr(config.i, length(config.i)) = ';' then
                  config.i = config.i || translate(rundir)';'
               else
                  config.i = config.i || ';' || translate(rundir)';'
               say 'Pfad' translate(rundir) 'an Path-Variable angehngt.'
            end
         end
         when substr(line, 1, 13) = 'SET CLASSPATH' then do
            if pos( translate(rundir), line) = 0 then do
               changed = 2
               if substr(config.i, length(config.i)) = ';' then
                  config.i = config.i || translate(rundir)'\JPLAY\JPLAY.ZIP;'
               else
                  config.i = config.i || ';' || translate(rundir)'\JPLAY\JPLAY.ZIP;'
               say 'Pfad' translate(rundir)'\JPLAY\JPLAY.ZIP an CLASSPATH-Variable angehngt.'
            end
         end
         when substr(line, 1, 7) = 'LIBPATH' then do
            if pos( '.;', line ) = 0 then do
		   changed = 1
		   config.i = 'LIBPATH=.;' || substr(13,length(config.i)-13) 
               say ''.' zum LIBPATH hinzugefgt.' 
		end
            if pos( translate(rundir), line ) = 0 then do  
               changed = 1 
               if substr(config.i, length(config.i)) = ';' then
                  config.i = config.i || translate(rundir)';'
               else
                  config.i = config.i || ';' || translate(rundir)';'
               say 'Pfad' translate(rundir) 'an den LIBPATH angehngt.'
		end
         end 
         when substr(line, 1, 14) = 'SET PLPLOT_LIB' then do
            if line = 'SET PLPLOT_LIB='translate(rundir) then nop
            else do
               config.i = 'SET PLPLOT_LIB='translate(rundir)
               say 'Zeile:' config.i 'aktualisiert.'
               changed = 1
            end
            plplotlib_found = 1
         end
         otherwise nop
      end
      i = i + 1
   end
   call stream configsys, 'c', 'close'
   if plplotlib_found = 0 then do
      changed = 1
      config.i = 'SET PLPLOT_LIB='translate(rundir)
      config.0 = i
      say 'Zeile:' config.i 'angehngt'
   end
   else config.0 = i-1
   if changed > 0 then do
      '@COPY' configsys configbak '>nul 2>nul'
      if rc <> 0 then do
         say 'Konnte das Backup-File' configsys 'nicht erstellen'
         say 'Programm wurde angehalten.'
         exit
      end
      else do
         say ''
	   say 'Das Original-File' configsys 'wurde als' configbak 'gespeichert.' 
	end
      ret = sysfiledelete(configsys)
      if ret <> 0 then do
         say 'Konnte das File' configsys 'nicht ersetzen'
         say 'Programm wurde angehalten.'
         exit
      end
      do i = 1 to config.0
         call lineout configsys, config.i
      end
      call stream configsys, 'c', 'close'
   end
   else do
      say ''
      say 'Es wurden keine nderungen an der Datei'  configsys 'durchgefhrt.'
   end
   
return /* update_config */

update_inst:
   call head
   file = 'pm_plot.ini'
   i = 1
   say 'nderungen in der Datei' file':'
   do while lines(file) <> 0
      lfile.i = linein(file)
      if i=11 then do
         lfile.i = gsv
         say 'Zeile:' lfile.i 'aktualisiert.'
      end               
      i = i + 1
   end
   call stream file, 'c', 'close'
   lfile.0 = i - 1
   ret = sysfiledelete(file)
   do i = 1 to lfile.0
      call lineout file, lfile.i
   end
   call stream file, 'c', 'close'
   file = 'ps2jpeg.cmd'
   i = 1   
   say ''
   say 'nderungen in der Datei' file':'
   do while lines(file) <> 0
      lfile.i = linein(file)
      if i=4 then do
         lfile.i = 'set gsroot='gst
         say 'Zeile:' lfile.i 'aktualisiert.'
      end 
      if i=5 then do         
         lfile.i = 'set gspath='gss
         say 'Zeile:' lfile.i 'aktualisiert.'
      end
      if i=6 then do
         lfile.i = 'set boot='bootdrv
         say 'Zeile:' lfile.i 'aktualisiert.'
      end 
      i = i + 1
   end
   call stream file, 'c', 'close'
   lfile.0 = i - 1
   ret = sysfiledelete(file)
   do i = 1 to lfile.0
      call lineout file, lfile.i
   end
   call stream file, 'c', 'close'   
return /* update_inst */

head:
'cls'
say ''
say 'Installations-Programm fr PM_PLOT Ver. 1.2'
say '(c) Lars Enghardt, 09.08.2000'
say ''
return   
