/*                                                                          */
/* PM I-Cat                                                                */
/*                                                                          */
/* External Tool: FILE DELETE                                               */
/* Copyright BinK Enterprises 1994.                                         */
/*                                                                          */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

arg targetfilename .

if targetfilename = '' then do;
   say
   say 'PMIC-DEL will delete the file whose name is supplied as a command-line'
   say 'argument after prompting the user for confirmation.'
   say
   say 'Syntax: PMIC-DEL filename.ext'
   say

   exit 1;
end;

'@ECHO OFF'

say 'FILE DELETE PROGRAM'
say
say targetfilename
say
say 'Do you want to delete this file? (Y/N)'

pull yesnoresponse .

if yesnoresponse = 'Y' then do;
   'DEL' targetfilename '2>NUL';

   select
      when rc = 0 then do;
         say
         say 'The file was deleted successfully.'
      end;
      when rc = 1 then do;
         say
         say 'The file could not be found; it was not deleted.'
      end;
      otherwise do;
         say
         say 'The file could not be deleted, OS/2 return code =' rc'.'
      end;
   end;
end;
else do;
   say
   say 'The file was not deleted.'
end;

say
say 'Press the Enter key to close this window...'

pull .

exit 0;
