/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Paulo Nunes (IST / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	vm_vlc_dec_tab.h
 *
 * Author:	Paulo Nunes (IST) - Paulo.Nunes@it.ist.utl.pt
 * Created:	1-Mar-96
 *                                                                         
 * Description: This file contains the VLC tables for module which deals
 *		with VLC decoding. 
 *
 * Notes: 	This file was created based on tmndecode
 * 		Written by Karl Olav Lillevold <kol@nta.no>,
 *		1995 Telenor R&D.
 * 		Donated to the Momusys-project as background code by
 *		Telenor. 
 *
 *		based on mpeg2decode, (C) 1994, MPEG Software Simulation Group
 *		and mpeg2play, (C) 1994 Stefan Eckart
 *                         <stefan@lis.e-technik.tu-muenchen.de>
 *
 *
 * Modified:	 9-May-96 Paulo Nunes: Reformatted. New headers.
 *		14-May-96 Paulo Nunes: Changed TMNMVtabs according to VM2.1.
 *	04.11.96 Robert Danielsen: Added three new tables for coding
 *			of Intra luminance coefficients (VM 4.0)
 *      01.05.97 Luis Ducla-Soares: added VM7.0 Reversible VLC tables (RVLC).
 *      13.05.97 Minhua Zhou: added VlC tables for CBPYtab2 CBPYtab3,revised  CBPYtab
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#ifndef _VLC_TABS_DEC_H_
#define _VLC_TABS_DEC_H_

#define VLC_ERROR	(-1)

/*
  typedef struct {
  Int val, len;
} VLCtab;
*/

VLCtab TMNMVtab0[] = {
{3,4}, {-3,4}, {2,3}, {2,3}, {-2,3}, {-2,3}, {1,2}, {1,2}, {1,2}, {1,2},
{-1,2}, {-1,2}, {-1,2}, {-1,2}
};

VLCtab TMNMVtab1[] = {
{12,10}, {-12,10}, {11,10}, {-11,10}, {10,9}, {10,9}, {-10,9}, {-10,9},
{9,9}, {9,9}, {-9,9}, {-9,9}, {8,9}, {8,9}, {-8,9}, {-8,9}, {7,7}, {7,7},
{7,7}, {7,7}, {7,7}, {7,7}, {7,7}, {7,7}, {-7,7}, {-7,7}, {-7,7}, {-7,7},
{-7,7}, {-7,7}, {-7,7}, {-7,7}, {6,7}, {6,7}, {6,7}, {6,7}, {6,7}, {6,7},
{6,7}, {6,7}, {-6,7}, {-6,7}, {-6,7}, {-6,7}, {-6,7}, {-6,7}, {-6,7},
{-6,7}, {5,7}, {5,7}, {5,7}, {5,7}, {5,7}, {5,7}, {5,7}, {5,7}, {-5,7},
{-5,7}, {-5,7}, {-5,7}, {-5,7}, {-5,7}, {-5,7}, {-5,7}, {4,6}, {4,6}, {4,6},
{4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6},
{4,6}, {4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6},
{-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}
};

VLCtab TMNMVtab2[] = {
{32,12}, {-32,12}, {31,12}, {-31,12}, {30,11}, {30,11}, {-30,11}, {-30,11},
{29,11}, {29,11}, {-29,11}, {-29,11}, {28,11}, {28,11}, {-28,11}, {-28,11},
{27,11}, {27,11}, {-27,11}, {-27,11}, {26,11}, {26,11}, {-26,11}, {-26,11},
{25,11}, {25,11}, {-25,11}, {-25,11}, {24,10}, {24,10}, {24,10}, {24,10},
{-24,10}, {-24,10}, {-24,10}, {-24,10}, {23,10}, {23,10}, {23,10}, {23,10},
{-23,10}, {-23,10}, {-23,10}, {-23,10}, {22,10}, {22,10}, {22,10}, {22,10},
{-22,10}, {-22,10}, {-22,10}, {-22,10}, {21,10}, {21,10}, {21,10}, {21,10},
{-21,10}, {-21,10}, {-21,10}, {-21,10}, {20,10}, {20,10}, {20,10}, {20,10},
{-20,10}, {-20,10}, {-20,10}, {-20,10}, {19,10}, {19,10}, {19,10}, {19,10},
{-19,10}, {-19,10}, {-19,10}, {-19,10}, {18,10}, {18,10}, {18,10}, {18,10},
{-18,10}, {-18,10}, {-18,10}, {-18,10}, {17,10}, {17,10}, {17,10}, {17,10},
{-17,10}, {-17,10}, {-17,10}, {-17,10}, {16,10}, {16,10}, {16,10}, {16,10},
{-16,10}, {-16,10}, {-16,10}, {-16,10}, {15,10}, {15,10}, {15,10}, {15,10},
{-15,10}, {-15,10}, {-15,10}, {-15,10}, {14,10}, {14,10}, {14,10}, {14,10},
{-14,10}, {-14,10}, {-14,10}, {-14,10}, {13,10}, {13,10}, {13,10}, {13,10},
{-13,10}, {-13,10}, {-13,10}, {-13,10}
};


VLCtab MCBPCtab[] = {
{VLC_ERROR,0},
{255,9}, {52,9}, {36,9}, {20,9}, {49,9}, {35,8}, {35,8}, {19,8}, {19,8}, 
{50,8}, {50,8}, {51,7}, {51,7}, {51,7}, {51,7}, {34,7}, {34,7}, {34,7}, 
{34,7}, {18,7}, {18,7}, {18,7}, {18,7}, {33,7}, {33,7}, {33,7}, {33,7}, 
{17,7}, {17,7}, {17,7}, {17,7}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, 
{4,6}, {4,6}, {4,6}, {48,6}, {48,6}, {48,6}, {48,6}, {48,6}, {48,6}, 
{48,6}, {48,6}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, 
{3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, 
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, 
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, 
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, 
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
{16,4}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
{1,3}, {1,3}, {1,3}, 
};

VLCtab MCBPCspritetab[] = {
{VLC_ERROR,0},
{255,9}, {52,9}, {36,9}, {20,9}, {53,9}, {35,8}, {35,8}, {19,8}, {19,8}, 
{50,8}, {50,8}, {51,7}, {51,7}, {51,7}, {51,7}, {34,7}, {34,7}, {34,7}, 
{34,7}, {18,7}, {18,7}, {18,7}, {18,7}, {37,7}, {37,7}, {37,7}, {37,7}, 
{21,7}, {21,7}, {21,7}, {21,7}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, 
{4,6}, {4,6}, {4,6}, {48,6}, {48,6}, {48,6}, {48,6}, {48,6}, {48,6}, 
{48,6}, {48,6}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, 
{3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, 
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, 
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, 
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, 
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
{16,4}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
{2,3}, {2,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, 
{5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, 
{5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, 
{5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, 
{5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, 
{5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, 
{5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, {5,3}, 
{5,3}, {5,3}, {5,3},
{1,12}, {17,12}, {33,12}, {49,12},{6,12},{22,12},{38,12},{54,12} 
};


VLCtab MCBPCtabintra[] = {
{VLC_ERROR,0},
{20,6}, {36,6}, {52,6}, {4,4}, {4,4}, {4,4}, 
{4,4}, {19,3}, {19,3}, {19,3}, {19,3}, {19,3}, 
{19,3}, {19,3}, {19,3}, {35,3}, {35,3}, {35,3}, 
{35,3}, {35,3}, {35,3}, {35,3}, {35,3}, {51,3}, 
{51,3}, {51,3}, {51,3}, {51,3}, {51,3}, {51,3}, 
{51,3},
};

/* Table for separate mode MCBPC, for coding DQUANT-flag and CBPC */
/* Added by Robert Danielsen, 06.11.96 */

VLCtab MCBPCtab_sep[32] =
{
    {VLC_ERROR,0},
    {5,6}, {6,6}, {7,6}, {4,4}, {4,4}, {4,4}, 
    {4,4}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
    {1,3}, {1,3}, {1,3}, {2,3}, {2,3}, {2,3}, 
    {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {3,3},
    {3,3}, {3,3}, {3,3}, {3,3}, {3,3}, {3,3},
    {3,3}
};



VLCtab CBPYtab[48] =
{ {VLC_ERROR,0}, {VLC_ERROR,0}, {6,6}, {9,6}, {8,5}, {8,5}, {4,5}, {4,5},
  {2,5}, {2,5}, {1,5}, {1,5}, {0,4}, {0,4}, {0,4}, {0,4}, 
  {12,4}, {12,4}, {12,4}, {12,4}, {10,4},{10,4},{10,4},{10,4},
  {14,4}, {14,4}, {14,4}, {14,4}, {5,4}, {5,4}, {5,4}, {5,4},
  {13,4}, {13,4}, {13,4}, {13,4}, {3,4}, {3,4}, {3,4}, {3,4}, 
  {11,4}, {11,4}, {11,4}, {11,4}, {7,4}, {7,4}, {7,4}, {7,4}, 
};


VLCtab CBPYtab2[16] = 
 {
  {VLC_ERROR,0},
  {0, 4},
  {1, 3}, {1, 3},
  {2, 2}, {2, 2}, {2, 2}, {2, 2},
  {3,1},{3,1},{3,1},{3,1}, {3,1},{3,1},{3,1},{3,1}
  };

VLCtab CBPYtab3[64] = 
  {
  {VLC_ERROR,0},
  {1, 6},
  {2, 5}, {2, 5},
  {4, 5}, {4, 5},
  {5, 5}, {5, 5},  
  {6, 3}, {6, 3}, {6, 3}, {6, 3}, {6, 3}, {6, 3}, {6, 3}, {6, 3}, 
  {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, 
  {0 ,3}, {0 ,3}, {0 ,3}, {0 ,3}, {0 ,3}, {0 ,3}, {0 ,3}, {0 ,3}, 
  {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1},  
  {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1},  
  {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1},  
  {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}, {7, 1}  
 }; 
  

VLCtab DCT3Dtab0[] = {
{4225,7}, {4209,7}, {4193,7}, {4177,7}, {193,7}, {177,7}, 
{161,7}, {4,7}, {4161,6}, {4161,6}, {4145,6}, {4145,6}, 
{4129,6}, {4129,6}, {4113,6}, {4113,6}, {145,6}, {145,6}, 
{129,6}, {129,6}, {113,6}, {113,6}, {97,6}, {97,6}, 
{18,6}, {18,6}, {3,6}, {3,6}, {81,5}, {81,5}, 
{81,5}, {81,5}, {65,5}, {65,5}, {65,5}, {65,5}, 
{49,5}, {49,5}, {49,5}, {49,5}, {4097,4}, {4097,4}, 
{4097,4}, {4097,4}, {4097,4}, {4097,4}, {4097,4}, {4097,4}, 
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2}, 
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2}, 
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2}, 
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2}, 
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2}, 
{1,2}, {1,2}, {17,3}, {17,3}, {17,3}, {17,3}, 
{17,3}, {17,3}, {17,3}, {17,3}, {17,3}, {17,3}, 
{17,3}, {17,3}, {17,3}, {17,3}, {17,3}, {17,3}, 
{33,4}, {33,4}, {33,4}, {33,4}, {33,4}, {33,4}, 
{33,4}, {33,4}, {2,4}, {2,4},{2,4},{2,4},
{2,4}, {2,4},{2,4},{2,4},
};


VLCtab DCT3Dtab1[] = {
{9,10}, {8,10}, {4481,9}, {4481,9}, {4465,9}, {4465,9}, 
{4449,9}, {4449,9}, {4433,9}, {4433,9}, {4417,9}, {4417,9}, 
{4401,9}, {4401,9}, {4385,9}, {4385,9}, {4369,9}, {4369,9}, 
{4098,9}, {4098,9}, {353,9}, {353,9}, {337,9}, {337,9}, 
{321,9}, {321,9}, {305,9}, {305,9}, {289,9}, {289,9}, 
{273,9}, {273,9}, {257,9}, {257,9}, {241,9}, {241,9}, 
{66,9}, {66,9}, {50,9}, {50,9}, {7,9}, {7,9}, 
{6,9}, {6,9}, {4353,8}, {4353,8}, {4353,8}, {4353,8}, 
{4337,8}, {4337,8}, {4337,8}, {4337,8}, {4321,8}, {4321,8}, 
{4321,8}, {4321,8}, {4305,8}, {4305,8}, {4305,8}, {4305,8}, 
{4289,8}, {4289,8}, {4289,8}, {4289,8}, {4273,8}, {4273,8}, 
{4273,8}, {4273,8}, {4257,8}, {4257,8}, {4257,8}, {4257,8}, 
{4241,8}, {4241,8}, {4241,8}, {4241,8}, {225,8}, {225,8}, 
{225,8}, {225,8}, {209,8}, {209,8}, {209,8}, {209,8}, 
{34,8}, {34,8}, {34,8}, {34,8}, {19,8}, {19,8}, 
{19,8}, {19,8}, {5,8}, {5,8}, {5,8}, {5,8}, 
};

VLCtab DCT3Dtab2[] = {
{4114,11}, {4114,11}, {4099,11}, {4099,11}, {11,11}, {11,11}, 
{10,11}, {10,11}, {4545,10}, {4545,10}, {4545,10}, {4545,10}, 
{4529,10}, {4529,10}, {4529,10}, {4529,10}, {4513,10}, {4513,10}, 
{4513,10}, {4513,10}, {4497,10}, {4497,10}, {4497,10}, {4497,10}, 
{146,10}, {146,10}, {146,10}, {146,10}, {130,10}, {130,10}, 
{130,10}, {130,10}, {114,10}, {114,10}, {114,10}, {114,10}, 
{98,10}, {98,10}, {98,10}, {98,10}, {82,10}, {82,10}, 
{82,10}, {82,10}, {51,10}, {51,10}, {51,10}, {51,10}, 
{35,10}, {35,10}, {35,10}, {35,10}, {20,10}, {20,10}, 
{20,10}, {20,10}, {12,11}, {12,11}, {21,11}, {21,11}, 
{369,11}, {369,11}, {385,11}, {385,11}, {4561,11}, {4561,11}, 
{4577,11}, {4577,11}, {4593,11}, {4593,11}, {4609,11}, {4609,11}, 
{22,12}, {36,12}, {67,12}, {83,12}, {99,12}, {162,12}, 
{401,12}, {417,12}, {4625,12}, {4641,12}, {4657,12}, {4673,12}, 
{4689,12}, {4705,12}, {4721,12}, {4737,12}, {7167,7}, 
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, 
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, 
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, 
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, 
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, 
{7167,7}, };

/* New tables for Intra luminance blocks */

VLCtab DCT3Dtab3[] = {
    {0x10401, 7}, {0x10301, 7}, {0x00601, 7}, {0x10501, 7},
    {0x00701, 7}, {0x00202, 7}, {0x00103, 7}, {0x00009, 7},
    {0x10002, 6}, {0x10002, 6}, {0x00501, 6}, {0x00501, 6}, 
    {0x10201, 6}, {0x10201, 6}, {0x10101, 6}, {0x10101, 6},
    {0x00401, 6}, {0x00401, 6}, {0x00301, 6}, {0x00301, 6},
    {0x00008, 6}, {0x00008, 6}, {0x00007, 6}, {0x00007, 6}, 
    {0x00102, 6}, {0x00102, 6}, {0x00006, 6}, {0x00006, 6},
    {0x00201, 5}, {0x00201, 5}, {0x00201, 5}, {0x00201, 5},
    {0x00005, 5}, {0x00005, 5}, {0x00005, 5}, {0x00005, 5}, 
    {0x00004, 5}, {0x00004, 5}, {0x00004, 5}, {0x00004, 5}, 
    {0x10001, 4}, {0x10001, 4}, {0x10001, 4}, {0x10001, 4},
    {0x10001, 4}, {0x10001, 4}, {0x10001, 4}, {0x10001, 4},
    {0x00001, 2}, {0x00001, 2}, {0x00001, 2}, {0x00001, 2},
    {0x00001, 2}, {0x00001, 2}, {0x00001, 2}, {0x00001, 2},
    {0x00001, 2}, {0x00001, 2}, {0x00001, 2}, {0x00001, 2}, 
    {0x00001, 2}, {0x00001, 2}, {0x00001, 2}, {0x00001, 2},
    {0x00001, 2}, {0x00001, 2}, {0x00001, 2}, {0x00001, 2},
    {0x00001, 2}, {0x00001, 2}, {0x00001, 2}, {0x00001, 2}, 
    {0x00001, 2}, {0x00001, 2}, {0x00001, 2}, {0x00001, 2},
    {0x00001, 2}, {0x00001, 2}, {0x00001, 2}, {0x00001, 2},
    {0x00002, 3}, {0x00002, 3}, {0x00002, 3}, {0x00002, 3}, 
    {0x00002, 3}, {0x00002, 3}, {0x00002, 3}, {0x00002, 3},
    {0x00002, 3}, {0x00002, 3}, {0x00002, 3}, {0x00002, 3},
    {0x00002, 3}, {0x00002, 3}, {0x00002, 3}, {0x00002, 3}, 
    {0x00101, 4}, {0x00101, 4}, {0x00101, 4}, {0x00101, 4},
    {0x00101, 4}, {0x00101, 4}, {0x00101, 4}, {0x00101, 4},
    {0x00003, 4}, {0x00003, 4}, {0x00003, 4}, {0x00003, 4},
    {0x00003, 4}, {0x00003, 4}, {0x00003, 4}, {0x00003, 4},
};


VLCtab DCT3Dtab4[] = {
    {0x00012,10}, {0x00011,10}, {0x10e01, 9}, {0x10e01, 9},
    {0x10d01, 9}, {0x10d01, 9}, {0x10c01, 9}, {0x10c01, 9},
    {0x10b01, 9}, {0x10b01, 9}, {0x10a01, 9}, {0x10a01, 9}, 
    {0x10102, 9}, {0x10102, 9}, {0x10004, 9}, {0x10004, 9},
    {0x00c01, 9}, {0x00c01, 9}, {0x00b01, 9}, {0x00b01, 9},
    {0x00702, 9}, {0x00702, 9}, {0x00602, 9}, {0x00602, 9}, 
    {0x00502, 9}, {0x00502, 9}, {0x00303, 9}, {0x00303, 9},
    {0x00203, 9}, {0x00203, 9}, {0x00106, 9}, {0x00106, 9},
    {0x00105, 9}, {0x00105, 9}, {0x00010, 9}, {0x00010, 9}, 
    {0x00402, 9}, {0x00402, 9}, {0x0000f, 9}, {0x0000f, 9},
    {0x0000e, 9}, {0x0000e, 9}, {0x0000d, 9}, {0x0000d, 9},
    {0x10801, 8}, {0x10801, 8}, {0x10801, 8}, {0x10801, 8}, 
    {0x10701, 8}, {0x10701, 8}, {0x10701, 8}, {0x10701, 8},
    {0x10601, 8}, {0x10601, 8}, {0x10601, 8}, {0x10601, 8},
    {0x10003, 8}, {0x10003, 8}, {0x10003, 8}, {0x10003, 8},  
    {0x00a01, 8}, {0x00a01, 8}, {0x00a01, 8}, {0x00a01, 8},
    {0x00901, 8}, {0x00901, 8}, {0x00901, 8}, {0x00901, 8},
    {0x00801, 8}, {0x00801, 8}, {0x00801, 8}, {0x00801, 8},  
    {0x10901, 8}, {0x10901, 8}, {0x10901, 8}, {0x10901, 8},
    {0x00302, 8}, {0x00302, 8}, {0x00302, 8}, {0x00302, 8},
    {0x00104, 8}, {0x00104, 8}, {0x00104, 8}, {0x00104, 8},  
    {0x0000c, 8}, {0x0000c, 8}, {0x0000c, 8}, {0x0000c, 8},
    {0x0000b, 8}, {0x0000b, 8}, {0x0000b, 8}, {0x0000b, 8},
    {0x0000a, 8}, {0x0000a, 8}, {0x0000a, 8}, {0x0000a, 8}, 
};

VLCtab DCT3Dtab5[] = {
    {0x10007,11}, {0x10007,11}, {0x10006,11}, {0x10006,11},
    {0x00016,11}, {0x00016,11}, {0x00015,11}, {0x00015,11},
    {0x10202,10}, {0x10202,10}, {0x10202,10}, {0x10202,10},  
    {0x10103,10}, {0x10103,10}, {0x10103,10}, {0x10103,10},
    {0x10005,10}, {0x10005,10}, {0x10005,10}, {0x10005,10},
    {0x00d01,10}, {0x00d01,10}, {0x00d01,10}, {0x00d01,10},  
    {0x00503,10}, {0x00503,10}, {0x00503,10}, {0x00503,10},
    {0x00802,10}, {0x00802,10}, {0x00802,10}, {0x00802,10},
    {0x00403,10}, {0x00403,10}, {0x00403,10}, {0x00403,10},  
    {0x00304,10}, {0x00304,10}, {0x00304,10}, {0x00304,10},
    {0x00204,10}, {0x00204,10}, {0x00204,10}, {0x00204,10},
    {0x00107,10}, {0x00107,10}, {0x00107,10}, {0x00107,10}, 
    {0x00014,10}, {0x00014,10}, {0x00014,10}, {0x00014,10},
    {0x00013,10}, {0x00013,10}, {0x00013,10}, {0x00013,10},
    {0x00017,11}, {0x00017,11}, {0x00018,11}, {0x00018,11}, 
    {0x00108,11}, {0x00108,11}, {0x00902,11}, {0x00902,11},
    {0x10302,11}, {0x10302,11}, {0x10402,11}, {0x10402,11},
    {0x10f01,11}, {0x10f01,11}, {0x11001,11}, {0x11001,11}, 
    {0x00019,12}, {0x0001a,12}, {0x0001b,12}, {0x00109,12},
    {0x00603,12}, {0x0010a,12}, {0x00205,12}, {0x00703,12},
    {0x00e01,12}, {0x10008,12}, {0x10502,12}, {0x10602,12}, 
    {0x11101,12}, {0x11201,12}, {0x11301,12}, {0x11401,12},
    {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7},
    {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7},
    {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7},
    {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7},
    {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7},
    {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7},
    {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7},
    {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7}, {0x01bff, 7},
};



/* RVLC tables */

VLCtab RvlcDCT3Dtab0[] = {

  {1,3},
  {2,3},
  {3,4},
  {4,5},
  {5,6},
  {6,6},
  {7,7},
  {8,8},
  {9,8},
  {10,9},
  {11,9},
  {12,10},
  {13,10},
  {14,10},
  {15,11},
  {16,11},
  {17,11},
  {18,12},
  {19,12},
  {20,13},
  {21,13},
  {22,12},
  {23,13},
  {24,14},
  {25,14},
  {26,14},
  {27,15},
  {257,4},
  {258,5},
  {259,7},
  {260,8},
  {261,8},
  {262,9},
  {263,10},
  {264,11},
  {265,11},
  {266,12},
  {267,13},
  {268,14},
  {269,14},
  {513,5},
  {514,7},
  {515,9},
  {516,10},
  {517,11},
  {518,11},
  {519,13},
  {520,13},
  {521,13},
  {522,14},
  {523,14},
  {769,5},
  {770,8},
  {771,9},
  {772,11},
  {773,12},
  {774,13},
  {775,14},
  {776,14},
  {777,15},
  {1025,6},
  {1026,8},
  {1027,10},
  {1028,12},
  {1029,12},
  {1030,14},
  {1281,6},
  {1282,9},
  {1283,11},
  {1284,12},
  {1285,14},
  {1286,14},
  {1537,7},
  {1538,10},
  {1539,11},
  {1540,12},
  {1541,15},
  {1793,7},
  {1794,10},
  {1795,11},
  {1796,13},
  {1797,15},
  {2049,8},
  {2050,10},
  {2051,13},
  {2052,14},
  {2305,8},
  {2306,11},
  {2307,13},
  {2308,15},
  {2561,9},
  {2562,12},
  {2817,10},
  {2818,13},
  {3073,10},
  {3074,15},
  {3329,11},
  {3585,13},
  {3841,13},
  {4097,14},
  {4353,14},
  {4609,14},
  {4865,15},
  {65537,4},
  {65538,8},
  {65539,11},
  {65540,13},
  {65541,14},
  {65793,5},
  {65794,9},
  {65795,12},
  {65796,14},
  {65797,15},
  {66049,5},
  {66050,11},
  {66051,15},
  {66305,6},
  {66306,12},
  {66561,6},
  {66562,12},
  {66817,6},
  {66818,13},
  {67073,6},
  {67074,13},
  {67329,7},
  {67330,13},
  {67585,7},
  {67586,13},
  {67841,7},
  {67842,13},
  {68097,7},
  {68098,14},
  {68353,7},
  {68354,14},
  {68609,8},
  {68610,14},
  {68865,8},
  {68866,15},
  {69121,8},
  {69377,9},
  {69633,9},
  {69889,9},
  {70145,9},
  {70401,9},
  {70657,9},
  {70913,10},
  {71169,10},
  {71425,10},
  {71681,10},
  {71937,10},
  {72193,11},
  {72449,11},
  {72705,11},
  {72961,12},
  {73217,12},
  {73473,12},
  {73729,12},
  {73985,12},
  {74241,12},
  {74497,12},
  {74753,13},
  {75009,13},
  {75265,14},
  {75521,14},
  {75777,14},
  {76033,15},
  {76289,15},
  {76545,15},
  {76801,15},
  {7167,4}   /* last entry: escape code */
  
};



VLCtab RvlcDCT3Dtab1[] = {

  {1,3},
  {2,4},
  {3,5},
  {4,7},
  {5,8},
  {6,8},
  {7,9},
  {8,10},
  {9,10},
  {10,11},
  {11,11},
  {12,12},
  {13,13},
  {14,13},
  {15,13},
  {16,13},
  {17,14},
  {18,14},
  {19,15},
  {257,3},
  {258,6},
  {259,8},
  {260,9},
  {261,10},
  {262,11},
  {263,12},
  {264,13},
  {265,14},
  {266,14},
  {513,4},
  {514,7},
  {515,9},
  {516,11},
  {517,12},
  {518,14},
  {519,14},
  {769,5},
  {770,8},
  {771,10},
  {772,12},
  {773,13},
  {774,14},
  {775,15},
  {1025,5},
  {1026,8},
  {1027,11},
  {1028,13},
  {1029,15},
  {1281,5},
  {1282,9},
  {1283,11},
  {1284,13},
  {1537,6},
  {1538,10},
  {1539,12},
  {1540,14},
  {1793,6},
  {1794,10},
  {1795,12},
  {1796,15},
  {2049,6},
  {2050,10},
  {2051,13},
  {2305,7},
  {2306,10},
  {2307,14},
  {2561,7},
  {2562,11},
  {2817,7},
  {2818,12},
  {3073,8},
  {3074,13},
  {3329,8},
  {3330,14},
  {3585,8},
  {3586,14},
  {3841,9},
  {3842,14},
  {4097,9},
  {4098,14},
  {4353,9},
  {4354,15},
  {4609,10},
  {4865,10},
  {5121,10},
  {5377,11},
  {5633,11},
  {5889,11},
  {6145,11},
  {6401,11},
  {6657,11},
  {6913,12},
  {7169,12},
  {7425,12},
  {7681,13},
  {7937,13},
  {8193,13},
  {8449,13},
  {8705,14},
  {8961,14},
  {9217,14},
  {9473,15},
  {9729,15},
  {65537,4},
  {65538,8},
  {65539,11},
  {65540,13},
  {65541,14},
  {65793,5},
  {65794,9},
  {65795,12},
  {65796,14},
  {65797,15},
  {66049,5},
  {66050,11},
  {66051,15},
  {66305,6},
  {66306,12},
  {66561,6},
  {66562,12},
  {66817,6},
  {66818,13},
  {67073,6},
  {67074,13},
  {67329,7},
  {67330,13},
  {67585,7},
  {67586,13},
  {67841,7},
  {67842,13},
  {68097,7},
  {68098,14},
  {68353,7},
  {68354,14},
  {68609,8},
  {68610,14},
  {68865,8},
  {68866,15},
  {69121,8},
  {69377,9},
  {69633,9},
  {69889,9},
  {70145,9},
  {70401,9},
  {70657,9},
  {70913,10},
  {71169,10},
  {71425,10},
  {71681,10},
  {71937,10},
  {72193,11},
  {72449,11},
  {72705,11},
  {72961,12},
  {73217,12},
  {73473,12},
  {73729,12},
  {73985,12},
  {74241,12},
  {74497,12},
  {74753,13},
  {75009,13},
  {75265,14},
  {75521,14},
  {75777,14},
  {76033,15},
  {76289,15},
  {76545,15},
  {76801,15},
  {7167,4}          /* last entry: escape code */
  
};
  


#endif /* _VLC_TABS_DEC_H_ */
