/* $Id: stats.c,v 1.5 1998/03/06 20:02:53 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#include <stdio.h>
#include <math.h>
#include "dataStruct.h"
#include "globals.h"
#include "bitpack.h"
#include "states.h"

Void writeStats()
{
  static Int layerColorBits[3], totalColorBits[3];
  Int totalBits;

  /* Write 'header' info */
  if (layerColorBits[mzte_codec.curColor]==0)
  {
    noteStat("\n----- DC Band: Color %3d -----\n\n", mzte_codec.curColor);
    noteStat("Width = %5d, Height = %5d\n\n", 
	     mzte_codec.dcWidth, 
	     mzte_codec.dcHeight);    
  }
  else
  {
    noteStat("\n----- AC Band: Spatial Layer %3d, SNR Layer %3d, Color %3d " \
	     "-----\n\n",
	     mzte_codec.curSpatialLev, mzte_codec.curSNRLev, 
	     mzte_codec.curColor);
    noteStat("Width = %5d, Height = %5d\n\n", 
	     mzte_codec.SPlayer[mzte_codec.curColor].width, 
	     mzte_codec.SPlayer[mzte_codec.curColor].height);    
  }

  totalBits  = get_total_bit_rate();

  if (mzte_codec.curColor==0)
  {
    layerColorBits[0] = totalBits-totalColorBits[2]-totalColorBits[1]
      -totalColorBits[0];
    totalColorBits[0] += layerColorBits[0];
  }
  else if (mzte_codec.curColor==1)
  {
    layerColorBits[1] = totalBits-totalColorBits[0]-totalColorBits[2]
      -totalColorBits[1];
    totalColorBits[1] += layerColorBits[1];
  }
  else /* if (mzte_codec.curColor==2) */
  {
    layerColorBits[2] = totalBits-totalColorBits[1]-totalColorBits[0]
      -totalColorBits[2];
    totalColorBits[2] += layerColorBits[2];
  }

  noteStat("Layer Bitstream Length = %d bits (%d bytes).\n",
	   layerColorBits[mzte_codec.curColor],
	   layerColorBits[mzte_codec.curColor]/8);
  noteStat("Total                  = %d bits (%d bytes).\n",
	   totalColorBits[mzte_codec.curColor],
	   totalColorBits[mzte_codec.curColor]/8);

}
