/* $Id: download_filter.c,v 1.13 1998/03/03 20:59:55 bchai Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

/************************************************************/
/*  Filename: download_filter.c                             */
/*  Author: Bing-Bing Chai                                  */
/*  Date: Jan. 30, 1998                                     */
/*                                                          */
/*  Descriptions:                                           */
/*    This file contains the routines to up/download        */
/*    wavelet filters when desired. Proper conversions from */
/*    floating point to int are taken care of whenever      */
/*    needed.                                               */
/*                                                          */
/*    It is assumed that short and float                    */
/*    are 2 bytes, and 4 bytes respectively.                */
/*                                                          */
/************************************************************/
#define DOWN_DEBUG 0


#if DOWN_DEBUG

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "momusys.h"
#include "startcode.h"
#include "dwt.h"
#include "default.h"
#include "errorHandler.h"
#include "msg.c"
#include "bitpack.h"
#include "download_filter.h"

#else /*DOWN_DEBUG*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "startcode.h"
#include "momusys.h"
#include "dwt.h"
#include "errorHandler.h"
#include "msg.h"
#include "bitpack.h"
#include "download_filter.h"
#include <malloc.h>

#endif /*DOWN_DEBUG*/

static Void check_marker(Int marker_bit)
{
  if(marker_bit != MARKER_BIT)
    errorHandler("Error in download wavelet filters\n");
}


static Void check_symmetry(FILTER *filter)
{
  Int i,half;

  /* -------- check lowpass filter --------- */
  half=filter->LPLength>>1;
  if(half<<1==filter->LPLength) 
    filter->Class=EVEN_SYMMETRIC;      /* even filter */
  else
    filter->Class=ODD_SYMMETRIC;      /* odd filter */

  for(i=0;i<half;i++)
    if(filter->Type == 0){
      if(((Short*)filter->LPCoeff)[i] !=
	 ((Short*)filter->LPCoeff)[filter->LPLength-i-1]) 
	errorHandler("Lowpass filter is not symmetric.\n");
    }
    else
      if(((Double*)filter->LPCoeff)[i] !=
	 ((Double*)filter->LPCoeff)[filter->LPLength-i-1]) 
	errorHandler("Lowpass filter is not symmetric.\n");


  /* -------- check highpass filter ---------- */
  half=filter->HPLength>>1;
  /* check for error */
  if(half<<1==filter->HPLength && filter->Class==ODD_SYMMETRIC)
    errorHandler("Lowpass filter has odd taps, while highpass filter has even"\
               " taps->\n");
  if(half<<1!=filter->HPLength && filter->Class==EVEN_SYMMETRIC) 
    errorHandler("Lowpass filter has even taps, while highpass filter has odd"\
               " taps.\n");

  if(filter->Class==ODD_SYMMETRIC){  /* ODD_SYMMETRIC, symmetric */
     for(i=0;i<half;i++)
      if(filter->Type == 0){
        if(((Short*)filter->HPCoeff)[i] !=
	   ((Short*)filter->HPCoeff)[filter->HPLength-i-1]) 
	  errorHandler("Highpass filter is not symmetric.\n");
      }
      else
	if(((Double*)filter->HPCoeff)[i] !=
	   ((Double*)filter->HPCoeff)[filter->HPLength-i-1]) 
	  errorHandler("Highpass filter is not symmetric.\n");
  }
  else{  /* EVEN_SYMMETRIC, antisymmetric */
     for(i=0;i<half;i++)
      if(filter->Type == 0){
        if(((Short*)filter->HPCoeff)[i] !=-
	   ((Short*)filter->HPCoeff)[filter->HPLength-i-1]) 
	  errorHandler("Highpass filter is not antisymmetric.\n");
      }
      else
	if(((Double*)filter->HPCoeff)[i] !=-
	   ((Double*)filter->HPCoeff)[filter->HPLength-i-1]) 
	  errorHandler("Highpass filter is not antisymmetric.\n");
  }

} 



Void upload_wavelet_filters(FILTER *filter)
{
  Int i;
  Float f;
  Short s;
  UShort *usptr;
  U_Int *uintptr;

  /* pointers to filter taps */
  usptr=(UShort *)&s;
  uintptr=(U_Int *)&f;

  /* filter lengths */
  emit_bits((UShort)filter->LPLength,4);
  emit_bits((UShort)filter->HPLength,4);

  /* upload lowpass filter */
  for(i=0;i<filter->LPLength;i++)
    if(filter->Type == INT_TYPE){
      s=((Short*)(filter->LPCoeff))[i];
      emit_bits(*usptr,16);
      emit_bits(MARKER_BIT,1);
    }
    else{
      f=(Float)((Double *)filter->LPCoeff)[i];
      emit_bits((UShort)((*uintptr)>>16),16);
      emit_bits(MARKER_BIT,1);
      emit_bits((UShort)(*uintptr),16);
      emit_bits(MARKER_BIT,1);
    }

  /* upload highpass filter */
  for(i=0;i<filter->HPLength;i++)
    if(filter->Type == INT_TYPE){
      s=((Short*)(filter->HPCoeff))[i];
      emit_bits(*usptr,16);
      emit_bits(MARKER_BIT,1);
    }
    else{
      f=(Float)((Double *)filter->HPCoeff)[i];
      emit_bits((UShort)((*uintptr)>>16),16);
      emit_bits(MARKER_BIT,1);
      emit_bits((UShort)(*uintptr),16);
      emit_bits(MARKER_BIT,1);
    }

  if(filter->Type == INT_TYPE){
    emit_bits((UShort)filter->Scale,16);
    emit_bits(MARKER_BIT,1);  /* needed to prevent start code emulation. */
                              /* this is not presented in the current syntax */
  }
}



Void download_wavelet_filters(FILTER *filter)
{
  Int i,marker_bit;
  Double *LPD=NULL, *HPD=NULL;
  Short *LPS=NULL, *HPS=NULL,s;
  UShort *usptr;
  U_Int *uintptr;
  Float f;

  usptr=(UShort *)&s;
  uintptr=(U_Int *)&f;

  /* get filter lengths */
  filter->LPLength=get_X_bits(4);
  filter->HPLength=get_X_bits(4);

  /* allocate memory for filters*/
  if(filter->Type==INT_TYPE){
    LPS=(Short *)malloc(sizeof(Short)*filter->LPLength);
    HPS=(Short *)malloc(sizeof(Short)*filter->HPLength);
    if(LPS==NULL || HPS==NULL)
      errorHandler("Cannot allocate memory to download wavelet filters\n");
    filter->LPCoeff=LPS;
    filter->HPCoeff=HPS;
  }
  else{
    LPD=(Double *)malloc(sizeof(Double)*filter->LPLength);
    HPD=(Double *)malloc(sizeof(Double)*filter->HPLength);
    if(LPD==NULL || HPD==NULL)
      errorHandler("Cannot allocate memory to download wavelet filters\n");
    filter->LPCoeff=LPD;
    filter->HPCoeff=HPD;
  }

  /* get lowpass filter */
  for(i=0;i<filter->LPLength;i++)
    if(filter->Type==INT_TYPE){
      *usptr=get_X_bits(16);
      LPS[i]=s;
      marker_bit=get_X_bits(1);
      check_marker(marker_bit);
    }
    else{
      *uintptr=get_X_bits(16);
      marker_bit=get_X_bits(1);
      check_marker(marker_bit);
      *uintptr=((*uintptr)<<16)+get_X_bits(16);
      marker_bit=get_X_bits(1);
      check_marker(marker_bit);
      LPD[i]=f;
    }      


   /* get highpass filter */
  for(i=0;i<filter->HPLength;i++)
    if(filter->Type==INT_TYPE){
      *usptr=get_X_bits(16);
      HPS[i]=s;
      marker_bit=get_X_bits(1);
      check_marker(marker_bit);
    }
    else{
      *uintptr=get_X_bits(16);
      marker_bit=get_X_bits(1);
      check_marker(marker_bit);
      *uintptr=((*uintptr)<<16)+get_X_bits(16);
      marker_bit=get_X_bits(1);
      check_marker(marker_bit);
      HPD[i]=f;
    }      


  check_symmetry(filter);

  if(filter->Type==INT_TYPE){
    filter->Scale=get_X_bits(16);
    marker_bit=get_X_bits(1);
    check_marker(marker_bit);
  }
}













