/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 *   J.Ignacio Ronda (UPM-GTI / ACTS-MoMuSys)
 *   Angel Pacheco (UPM-GTI / ACTS-MoMuSys)
 *
 * and edited by 
 *
 *   Robert Danielsen (Telenor / ACTS-MoMuSys)
 *   Bruno Loret (CNET / ACTS-MoMuSys)
 *   Ferran Marques (UPC / ACTS-MoMuSys)
 *   Angel Pacheco (UPM-GTI / ACTS-MoMuSys)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:        mot_padding.h
 *
 * Author:      J.Ignacio Ronda / Angel Pachecos (UPM-GTI)
 * Created:     02.02.96
 *                                                                         
 * Description: Functions to perform padding for motion estimation and texture
 *              coding.
 *
 * Notes:  
 *
 * Modified: 
 *      ver 1.1: changes in the interface in order to allow one
 *               Vop as input, and to develop the padding over YUV
 *               values or only over Y, depending on the lumi filed
 *                       lumi==1 only pad Y field
 *                       lumi!=1 pad YUV fields
 *
 *      ver 1.2: fixed a bug in that produced incorrect accesses in
 *               *_FinalVerticalPadding
 *
 *      21.04.96 Robert Danielsen (Telenor): New header.
 *      23.04.96 Bruno Loret (CNET): Non reentrant ifndef
 *      23.10.96 A. Pacheco (UPM-GTI): defines for direction
 *      28.08.96 Ferran Marques (UPC): introduce changes from (23.10.96)
 *      13.11.97 Angel Pacheco (UPM-GTI): formating and new header.
 *
 ***********************************************************HeaderEnd*********/

#ifndef _MOT_PADDING_H_
#define _MOT_PADDING_H_

#include <stdio.h>
#include <stdlib.h>

#include "mom_structs.h"
#include "vm_common_defs.h"
#include "mom_access.h"
#include "mot_padding.p"

/* status of the y value in the overall padding proccess */
#define NO_PAD       0
#define HOR_PAD      1
#define VER_PAD      2
#define HOR_ZERO_PAD 3
#define VER_ZERO_PAD 4
#define INSIDE       5

/* status of the line padding */
#define FIRST_PAD    6
#define MIDDLE_PAD   7

/* direcction for the repetitive padding of transparent MB
 * (VM 4.0 section 3.3.1)
*/
#define LEFT_REFERENCE   0
#define RIGHT_REFERENCE  1
#define UPPER_REFERENCE  2
#define LOWER_REFERENCE  3

/* values to count the number of MB/B used in the repetitive padding process */
#define MB_NOT_PADDED  0
#define MB_PADDED      1

#endif /* _MOT_PADDING_H_ */
