/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Bruno Loret (CNET / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	io_generic.h
 *
 * Author:	
 * Created:	
 *                                                                         
 * Description: 
 *
 * Notes: 	
 *
 * Modified:	21.04.96 Robert Danielsen: New header.
 *              23.04.96 Bruno Loret: Non reentrant ifndef
 *              30.01.97 Luis Ducla-Soares: changed istio.h to io_ist.h
 *              30.07.97 Fernando Jaureguizar: included io_debug.p (SpSc)
 *
 ***********************************************************HeaderEnd*********/

#ifndef _IO_GENERIC_H_
#define _IO_GENERIC_H_


#include "momusys.h"
#include "io_generic.p"
#include "io_debug.p" /*SpSc*/

#define IO_FORMAT 	" "
#define IO_OVERWRITE 	"OVERWRITE"
#define IO_APPEND	"APPEND"	

#ifdef _RAWIO_
#include "io_raw.h"
#endif

#ifdef _DCUIO_
#include "dcuio.h"
#endif

#ifdef _GTIIO_
#include "io_gti.h"
#endif

#ifdef _KPNIO_
#include "kpnio.h"
#endif

#ifdef _UPCIO_
#include "io_upc.h"
#endif

#ifdef _LEPIO_
#include "lepio.h"
#endif

#ifdef _TUHIO_
#include "io_tuh.h"
#endif

#ifdef _HHIIO_
#include "hhiio.h"
#endif

#ifdef _DTAGIO_
#include "dtagio.h"
#endif

#ifdef _ISTIO_
#include "io_ist.h"
#endif

#ifdef _TELENORIO_
#include "telenorio.h"
#endif

#ifdef _TELENORIO_
#include "telenorio.h"
#endif


#endif /* _IO_GENERIC_H_ */

