/******************************************************************************
This software module was originally developed by

Zhixiong Wu			(sgo@hlabs.oki.co.jp),		Oki Electric Industry Co., Ltd.
Yoshihiro Ueda		(yueda@hlabs.oki.co.jp),	Oki Electric Industry Co., Ltd.
Toshifumi Kanamaru	(kanamaru@hlabs.oki.co.jp),	Oki Electric Industry Co., Ltd.

in the course of development of the MPEG-4 Visual (ISO/IEC 14496-2).This 
software module is an implementation of a part of one or more MPEG-4 Visual 
(ISO/IEC 14496-2) tools as specified by the MPEG-4 Visual (ISO/IEC 14496-2). 
ISO/IEC gives users of the MPEG-4 Visual (ISO/IEC 14496-2) free license to this
software module or modifications thereof for use in hardware or software products
claiming conformance to the MPEG-4 Visual (ISO/IEC 14496-2). Those intending to
use this software module in hardware or software products are advised that its
use may infringe existing patents. The original developer of this software module
and his/her company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof in an 
implementation. Copyright is not released for non MPEG-4 Visual (ISO/IEC 14496-2)
conforming products. OKI retains full right to use the code for his/her own
purpose, assign or donate the code to a third party and to inhibit third parties
from using the code for non MPEG-4 Visual (ISO/IEC 14496-2) conforming products.
This copyright notice must be included in all copies or derivative works.

Copyright (c) 1997-1998 Oki Electric Industry Co., Ltd.

******************************************************************************/
/*
 *	  Binary Arithmetic Corder Function Header  (BinArCodec.h)
 */
/* This code was obtained from Lehigh University/Vector Vision, Inc.. 
It was originally developed by OKI. 
Dr. Hongqiao Sun/Weiping integrated it to the Lehigh/VVI software. 

The copyrights or credits should belong to the following people and companies:

Zhixiong Wu and Yoshihiro Ueda of OKI,
Hongqiao Sun of Vector Vision,
Weiping Li of Lehigh University,

Minor modifications was made by Shipeng Li to integrated it to Sarnoff's SOL
software.
*/
#ifndef _BINARCODEC_H_
#define _BINARCODEC_H_

#include "momusys.h"

#define		CODE_BITS		32
#define 	HALF			((U_Int) 1 << (CODE_BITS-1))
#define 	QUARTER			((U_Int) 1 << (CODE_BITS-2))
#define		BSBUFSIZE		512

#define		MAXHEADING		8
#define		MAXMIDDLE		16
#define		MAXTRAILING		8

struct arcodec {
    U_Int L; /* lower bound */
    U_Int R; /* code range */
    U_Int V; /* current code value */
    U_Int arpipe;
    Int	bits_to_follow; /* follow bit count */
    Int	first_bit;
    Int	nzeros;
    Int	nonzero;
    Int	nzerosf;
    Int	extrabits;
};

struct armodel {
    Int	type;
    Int	ctx_num;
    Int	adapt;
    U_Int *table;
    U_Int *c0;
    U_Int *cnt;
};

typedef	struct arcodec ArCoder;	
typedef	struct arcodec ArDecoder;
typedef	struct armodel ArModel;


#include "BinArCodec.p"

#endif /* _BINARCODEC_H_  */ 

