/*--------------------------------------------------------------*/
/*      VT100 Driver 1.0 , for GLE V3.0         */
/*---------------------------------------------------------------------------*/
#include "all.h"
#include <math.h>
#include "core.h"
#include "mygraph.h"
#include "mydev.h"
#define GS 29
#define FF 12
#define MAXX (130)
#define MAXY (23)
int screenbit[MAXX+4][MAXY+4];
int ingraphmode;
extern struct gmodel g;
/*---------------------------------------------------------------------------*/
#define pi 3.141592653
#define true (!false)
#define BLACKANDWHITE 1
#define ESC 27
#define false 0
#define dbg if ((gle_debug & 64)>0)
#define stop if ((gle_debug & 128)>0) return
extern int gle_debug;
int incap=true;
int getch(void);
/*---------------------------------------------------------------------------*/
/* The global variables for the PC screen driver */
/*-----------------------------------------------*/

int i,l,j,ix,iy;
double f;
double devxcm=23,devycm=15.5;
FILE *hpfile;

#define gerr() i = graphresult(); if (i!=0) printf("Graph error: %s \n",grapherrormsg(i));
#define sx(v) ( ((v) * d_xscale))
#define sy(v) ( (((v) * d_yscale)))
#define rx(v) ( ((v) * d_xscale))
#define ry(v) ( (((v) * d_yscale)))

double d_scale, d_xscale, d_yscale;
int d_graphmode;
int d_fillstyle=1,d_fillcolor;
int d_lstyle,d_lwidth;
char outstr[400];

d_devcmd(char *s)
{}
/*---------------------------------------------------------------------------*/
d_dfont(char *c)
{
	/* only used for the DFONT driver which builds fonts */
}
/*---------------------------------------------------------------------------*/
static char lastline[80];
d_message(char *s)
{
	static int single_step;
	int oldcolor,oldx,oldy;
	w_message(s);
}
/*---------------------------------------------------------------------------*/
d_source(char *s)
{
	s=s;
}
/*---------------------------------------------------------------------------*/
d_get_type(char *t)
{
	strcpy(t,"INTERACTIVE, VT100, VAX");
}
/*---------------------------------------------------------------------------*/
d_set_path(int onoff)
{}
/*---------------------------------------------------------------------------*/
d_newpath()
{
}
/*---------------------------------------------------------------------------*/
extern char output_file[];
d_open(double width, double height)
{
	/* Get largest rectangle we can fit on the screen */
	d_scale = devxcm / width;
	f = devycm / height;
	if (f<d_scale) d_scale = f;
	d_xscale = d_scale * MAXX / devxcm; /* Device Scale X, Device Scale y */
	d_yscale = d_scale * MAXY / devycm;
}
/*---------------------------------------------------------------------------*/
d_tidyup()
{
}
d_close()
{
	int x,y;
	char oneline[200];
	int lastinv=false;
	g_flush();

	scr_refresh();
	printf("%c[?3h",27);
	for (y = MAXY-1;y>= 0;y--) {
	  oneline[0] = 0;
	  for (x=0;x<=MAXX;x++) {
		if (screenbit[x][y]==0) strcat(oneline," ");
		else strcat(oneline,"#");
/*              if (screenbit[x][y]==0) {
			if (lastinv) strcat(oneline,"\x1b[0m ");
			else strcat(oneline," ");
			lastinv = false;
		} else {
			if (!lastinv) strcat(oneline,"\x1b[7m ");
			else strcat(oneline," ");
			lastinv = true;
		}*/
	  }
	  printf("%s\n",oneline);
	}
	printf("\x1b[7m");
	text_inkey();
	printf("\x1b[0m");
	printf("%c[?3l",27);
}
/*---------------------------------------------------------------------------*/
d_set_line_cap(int i)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_join(int i)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_miterlimit(double d)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_width(double w)
{
}
/*---------------------------------------------------------------------------*/
d_set_line_styled(double dd)
{}
d_set_line_style(char *s)
{
	d_lstyle = 2;
	if (strcmp(s,"")==0) d_lstyle = 1;
	if (strcmp(s,"1")==0) d_lstyle = 1;
}
/*---------------------------------------------------------------------------*/
d_fill()
{
}
/*---------------------------------------------------------------------------*/
d_fill_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;
/*      fprintf(psfile,"%g %g moveto \n",(*wkx)[0],(*wky)[0]);
	for (i=1;i<nwk;i++)
		fprintf(psfile,"%g %g l \n",(*wkx)[i],(*wky)[i]);
*/
}
d_line_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;
/*
	g_dev( (*wkx)[0], (*wky)[0], &ix, &iy);
	moveto(ix,iy);
	for (i=1;i<nwk;i++) {
		g_dev( (*wkx)[i], (*wky)[i], &ix, &iy);
		lineto(ix,iy);
	}
*/
}
/*---------------------------------------------------------------------------*/
d_stroke()
{
}
/*---------------------------------------------------------------------------*/
d_clip()
{
}
/*---------------------------------------------------------------------------*/
d_set_matrix(double newmat[3][3])
{
}
/*---------------------------------------------------------------------------*/
d_move(double zx,double zy)
{
}
/*---------------------------------------------------------------------------*/
d_reverse()     /* reverse the order of stuff in the current path */
{
}
/*---------------------------------------------------------------------------*/
d_closepath()
{
	g_line(g.closex,g.closey);
}
/*---------------------------------------------------------------------------*/
int vt100line(int  x1, int  y1, int  x2, int  y2);
int hpglxy(double xx, double yy);
d_line(double zx,double zy)
{
	static double ix,iy,ux,uy;
	g_dev(g.curx,g.cury,&ux,&uy);
	g_dev(zx,zy,&ix,&iy);
	vt100line(sx(ux),sy(uy),sx(ix),sy(iy));
}
/*---------------------------------------------------------------------------*/
/* int screenbit[MAXX+1][MAXY+1]; */
xxvt100line(int  x1, int  y1, int  x2, int  y2)
{
#define sign(x) ((x) > 0 ? 1: ((x) == 0 ? 0: (-1)))
	int dx,dy,dxabs,dyabs,i,px,py,sdx,sdy,x,y;
	if (x1<0) x1 = 0;
	if (x1>MAXX) x1 = MAXX;
	if (y1<0) y1 = 0;
	if (y1>MAXY) y1 = MAXY;
	if (x2<0) x2 = 0;
	if (x2>MAXX) x2 = MAXX;
	if (y2<0) y2 = 0;
	if (y2>MAXY) y2 = MAXY;

	/* line algorithym begins */

	dx = x2 - x1;
	dy = y2 - y1;
	sdx = sign(dx);
	sdy = sign(dy);
	dxabs = abs(dx);
	dyabs = abs(dy);
	x = 0;
	y = 0;
	px = x1;
	py = y1;
	if (dxabs >= dyabs) {
		for (i=0; i<=dxabs; i++) {
			y += dyabs;
			if (y>=dxabs) {
				y -= dxabs;
				py += sdy;
			}
			screenbit[px][py] = '#';
			px += sdx;
		}
	} else {
		for (i=0; i<=dyabs; i++) {
			x += dxabs;
			if (x>=dyabs) {
				x -= dyabs;
				px += sdx;
			}
			screenbit[px][py] = '#';
			py += sdy;
		}
	}
}

uint32 PATTERN = 0xFFFFFFFF;
int LINEWIDTH=1;

vt100line(int  x1, int  y1, int  x2, int  y2)
{
#define sign(x) ((x) > 0 ? 1:  ((x) == 0 ? 0:  (-1)))
	int dx, dy, dxabs, dyabs, i, j, px, py, sdx, sdy, x, y;
	uint32 mask=0x80000000;

	if (x1<0) x1 = 0;
	if (x1>MAXX) x1 = MAXX;
	if (y1<0) y1 = 0;
	if (y1>MAXY) y1 = MAXY;
	if (x2<0) x2 = 0;
	if (x2>MAXX) x2 = MAXX;
	if (y2<0) y2 = 0;
	if (y2>MAXY) y2 = MAXY;

	dx = x2 - x1;
	dy = y2 - y1;
	sdx = sign(dx);
	sdy = sign(dy);
	dxabs = abs(dx);
	dyabs = abs(dy);
	x = 0;
	y = 0;
	px = x1;
	py = y1;


			mask = mask ? mask : 0x80000000;
			if (PATTERN & mask)
			{
				for (j= -LINEWIDTH/2; j<=LINEWIDTH/2; j++)
					screenbit[px][py+j] = '#';

			}
			mask >>= 1;


	if (dxabs >= dyabs)
	{
		for (i=0; i<dxabs; i++)
		{
			mask = mask ? mask : 0x80000000;
			y += dyabs;
			if (y>=dxabs)
			{
				y -= dxabs;
				py += sdy;
			}
			px += sdx;
			if (PATTERN & mask)
			{
				for (j= -LINEWIDTH/2; j<=LINEWIDTH/2; j++)
					screenbit[px][py+j] = '#';

			}
			mask >>= 1;
		}
	}
	else
	{
		for (i=0; i<dyabs; i++)
		{
			mask = mask ? mask : 0x80000000;
			x += dxabs;
			if (x>=dyabs)
			{
				x -= dyabs;
				px += sdx;
			}
			py += sdy;
			if (PATTERN & mask)
			{
				for (j= -LINEWIDTH/2; j<=LINEWIDTH/2; j++)
					screenbit[px+j][py] = '#';
			}
			mask >>= 1;
		}
	}
}
/*---------------------------------------------------------------------------*/
d_clear()
{
	int x,y;
	for (y=0;y<=MAXY;y++) {
	  for (x=0;x<=MAXX;x++) {
		screenbit[x][y] = 0;
	  }
	}
}
/*---------------------------------------------------------------------------*/
d_flush()
{
}
/*---------------------------------------------------------------------------*/
d_arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr)
{
	df_arcto(x1,y1,x2,y2,rrr);
}
/*---------------------------------------------------------------------------*/
d_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	df_arc(r,t1,t2,cx,cy);
}
/*---------------------------------------------------------------------------*/
d_narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	/*swap t1 t2*/
	df_arc(r,t2,t1,cx,cy);
}
/*---------------------------------------------------------------------------*/
d_box_fill(dbl x1, dbl y1, dbl x2, dbl y2)
{
	df_box_fill(x1,y1,x2,y2);
}
d_box_stroke(dbl x1, dbl y1, dbl x2, dbl y2)
{
	df_box_stroke(x1,y1,x2,y2);
}
/*---------------------------------------------------------------------------*/
d_circle_stroke(double zr)
{
	df_circle_stroke(zr);
}
d_circle_fill(double zr)
{
	df_circle_fill(zr);
}
/*---------------------------------------------------------------------------*/
d_bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3)
{
	double ax,bx,cx,ay,by,cy,dist;
	double xxx,yyy,i,t,nstep,x0,y0;
	g_get_xy(&x0,&y0);
	dist = fabs(x3-x0) + fabs(y3-y0);
	nstep = 10;
	if (dist>3) nstep = 20;
	if (dist<.5) nstep = 5;
	if (dist<.3) nstep = 3;
	if (dist<.1) {
		g_line(x3,y3);
		return;
	}
	cx = (x1-x0)*3;
	bx = (x2-x1)*3-cx;
	ax = x3-x0-cx-bx;
	cy = (y1-y0)*3;
	by = (y2-y1)*3-cy;
	ay = y3-y0-cy-by;
	for (i=0;i<=nstep;i++) {
		t = i/nstep;
		xxx = ax*pow(t,3.0) + bx*t*t + cx*t + x0;
		yyy = ay*pow(t,3.0) + by*t*t + cy*t + y0;
		g_line(xxx,yyy);
	}
}
/*---------------------------------------------------------------------------*/
d_set_color(int32 f)
{
}
d_set_fill(int32 f)
{
}
/*---------------------------------------------------------------------------*/
d_beginclip()
{
}
d_endclip()
{
}
struct char_data {float wx,wy,x1,y1,x2,y2; };
int font_get_chardata(struct char_data **cd, int ff, int cc);
/*---------------------------------------------------------------------------*/
d_char(int font, int cc)
{
	static struct char_data cd;
	static int ix,iy,ix1,ix2,iy1,iy2,fz,fzx;
	static int ux,uy;
	static int safnt;
	char ss[2];

	ss[0] = cc;
	ss[1] = 0;
	if (safnt==0) safnt = pass_font("PLSR");
	if (font>=2) {
		my_char(font,cc);
		return;
	}
	my_char(safnt,cc);
}



